/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.BooleanMatchingRule;
import com.unboundid.ldap.matchingrules.CaseExactStringMatchingRule;
import com.unboundid.ldap.matchingrules.CaseIgnoreListMatchingRule;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.GeneralizedTimeMatchingRule;
import com.unboundid.ldap.matchingrules.IntegerMatchingRule;
import com.unboundid.ldap.matchingrules.NumericStringMatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.matchingrules.TelephoneNumberMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class MatchingRule
implements Serializable {
    public static final byte SUBSTRING_TYPE_SUBINITIAL = -128;
    public static final byte SUBSTRING_TYPE_SUBANY = -127;
    public static final byte SUBSTRING_TYPE_SUBFINAL = -126;
    private static volatile MatchingRule jsonObjectExactMatchingRule = null;
    private static final long serialVersionUID = 6050276733546358513L;

    protected MatchingRule() {
    }

    public abstract String getEqualityMatchingRuleName();

    public abstract String getEqualityMatchingRuleOID();

    public String getEqualityMatchingRuleNameOrOID() {
        String string = this.getEqualityMatchingRuleName();
        if (string == null) {
            return this.getEqualityMatchingRuleOID();
        }
        return string;
    }

    public abstract String getOrderingMatchingRuleName();

    public abstract String getOrderingMatchingRuleOID();

    public String getOrderingMatchingRuleNameOrOID() {
        String string = this.getOrderingMatchingRuleName();
        if (string == null) {
            return this.getOrderingMatchingRuleOID();
        }
        return string;
    }

    public abstract String getSubstringMatchingRuleName();

    public abstract String getSubstringMatchingRuleOID();

    public String getSubstringMatchingRuleNameOrOID() {
        String string = this.getSubstringMatchingRuleName();
        if (string == null) {
            return this.getSubstringMatchingRuleOID();
        }
        return string;
    }

    public abstract boolean valuesMatch(ASN1OctetString var1, ASN1OctetString var2) throws LDAPException;

    public abstract boolean matchesSubstring(ASN1OctetString var1, ASN1OctetString var2, ASN1OctetString[] var3, ASN1OctetString var4) throws LDAPException;

    public abstract int compareValues(ASN1OctetString var1, ASN1OctetString var2) throws LDAPException;

    public abstract ASN1OctetString normalize(ASN1OctetString var1) throws LDAPException;

    public abstract ASN1OctetString normalizeSubstring(ASN1OctetString var1, byte var2) throws LDAPException;

    public static MatchingRule selectEqualityMatchingRule(String string, Schema schema) {
        return MatchingRule.selectEqualityMatchingRule(string, null, schema);
    }

    public static MatchingRule selectEqualityMatchingRule(String string, String string2, Schema schema) {
        if (string2 != null) {
            return MatchingRule.selectEqualityMatchingRule(string2);
        }
        if (string == null || schema == null) {
            return MatchingRule.getDefaultEqualityMatchingRule();
        }
        AttributeTypeDefinition attributeTypeDefinition = schema.getAttributeType(string);
        if (attributeTypeDefinition == null) {
            return MatchingRule.getDefaultEqualityMatchingRule();
        }
        String string3 = attributeTypeDefinition.getEqualityMatchingRule(schema);
        if (string3 != null) {
            return MatchingRule.selectEqualityMatchingRule(string3);
        }
        String string4 = attributeTypeDefinition.getBaseSyntaxOID(schema);
        if (string4 != null) {
            return MatchingRule.selectMatchingRuleForSyntax(string4);
        }
        return MatchingRule.getDefaultEqualityMatchingRule();
    }

    public static MatchingRule selectEqualityMatchingRule(String string) {
        if (string == null || string.length() == 0) {
            return MatchingRule.getDefaultEqualityMatchingRule();
        }
        String string2 = StaticUtils.toLowerCase(string);
        if (string2.equals(BooleanMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.13")) {
            return BooleanMatchingRule.getInstance();
        }
        if (string2.equals(CaseExactStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.5") || string2.equals("caseexactia5match") || string2.equals("1.3.6.1.4.1.1466.109.114.1")) {
            return CaseExactStringMatchingRule.getInstance();
        }
        if (string2.equals(CaseIgnoreListMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.11")) {
            return CaseIgnoreListMatchingRule.getInstance();
        }
        if (string2.equals(CaseIgnoreStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.2") || string2.equals("caseignoreia5match") || string2.equals("1.3.6.1.4.1.1466.109.114.2")) {
            return CaseIgnoreStringMatchingRule.getInstance();
        }
        if (string2.equals(DistinguishedNameMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.1") || string2.equals("uniquemembermatch") || string2.equals("2.5.13.23")) {
            return DistinguishedNameMatchingRule.getInstance();
        }
        if (string2.equals(GeneralizedTimeMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.27")) {
            return GeneralizedTimeMatchingRule.getInstance();
        }
        if (string2.equals(IntegerMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.14")) {
            return IntegerMatchingRule.getInstance();
        }
        if (string2.equals(NumericStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.8")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (string2.equals(OctetStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.17")) {
            return OctetStringMatchingRule.getInstance();
        }
        if (string2.equals(TelephoneNumberMatchingRule.LOWER_EQUALITY_RULE_NAME) || string2.equals("2.5.13.20")) {
            return TelephoneNumberMatchingRule.getInstance();
        }
        if (string2.equals("jsonobjectexactmatch") || string2.equals("1.3.6.1.4.1.30221.2.4.12")) {
            return MatchingRule.getJSONObjectExactMatchingRule();
        }
        return MatchingRule.getDefaultEqualityMatchingRule();
    }

    public static MatchingRule getDefaultEqualityMatchingRule() {
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    public static MatchingRule selectOrderingMatchingRule(String string, Schema schema) {
        return MatchingRule.selectOrderingMatchingRule(string, null, schema);
    }

    public static MatchingRule selectOrderingMatchingRule(String string, String string2, Schema schema) {
        if (string2 != null) {
            return MatchingRule.selectOrderingMatchingRule(string2);
        }
        if (string == null || schema == null) {
            return MatchingRule.getDefaultOrderingMatchingRule();
        }
        AttributeTypeDefinition attributeTypeDefinition = schema.getAttributeType(string);
        if (attributeTypeDefinition == null) {
            return MatchingRule.getDefaultOrderingMatchingRule();
        }
        String string3 = attributeTypeDefinition.getOrderingMatchingRule(schema);
        if (string3 != null) {
            return MatchingRule.selectOrderingMatchingRule(string3);
        }
        String string4 = attributeTypeDefinition.getBaseSyntaxOID(schema);
        if (string4 != null) {
            return MatchingRule.selectMatchingRuleForSyntax(string4);
        }
        return MatchingRule.getDefaultOrderingMatchingRule();
    }

    public static MatchingRule selectOrderingMatchingRule(String string) {
        if (string == null || string.length() == 0) {
            return MatchingRule.getDefaultOrderingMatchingRule();
        }
        String string2 = StaticUtils.toLowerCase(string);
        if (string2.equals(CaseExactStringMatchingRule.LOWER_ORDERING_RULE_NAME) || string2.equals("2.5.13.6")) {
            return CaseExactStringMatchingRule.getInstance();
        }
        if (string2.equals(CaseIgnoreStringMatchingRule.LOWER_ORDERING_RULE_NAME) || string2.equals("2.5.13.3")) {
            return CaseIgnoreStringMatchingRule.getInstance();
        }
        if (string2.equals(GeneralizedTimeMatchingRule.LOWER_ORDERING_RULE_NAME) || string2.equals("2.5.13.28")) {
            return GeneralizedTimeMatchingRule.getInstance();
        }
        if (string2.equals(IntegerMatchingRule.LOWER_ORDERING_RULE_NAME) || string2.equals("2.5.13.15")) {
            return IntegerMatchingRule.getInstance();
        }
        if (string2.equals(NumericStringMatchingRule.LOWER_ORDERING_RULE_NAME) || string2.equals("2.5.13.9")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (string2.equals(OctetStringMatchingRule.LOWER_ORDERING_RULE_NAME) || string2.equals("2.5.13.18")) {
            return OctetStringMatchingRule.getInstance();
        }
        return MatchingRule.getDefaultOrderingMatchingRule();
    }

    public static MatchingRule getDefaultOrderingMatchingRule() {
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    public static MatchingRule selectSubstringMatchingRule(String string, Schema schema) {
        return MatchingRule.selectSubstringMatchingRule(string, null, schema);
    }

    public static MatchingRule selectSubstringMatchingRule(String string, String string2, Schema schema) {
        if (string2 != null) {
            return MatchingRule.selectSubstringMatchingRule(string2);
        }
        if (string == null || schema == null) {
            return MatchingRule.getDefaultSubstringMatchingRule();
        }
        AttributeTypeDefinition attributeTypeDefinition = schema.getAttributeType(string);
        if (attributeTypeDefinition == null) {
            return MatchingRule.getDefaultSubstringMatchingRule();
        }
        String string3 = attributeTypeDefinition.getSubstringMatchingRule(schema);
        if (string3 != null) {
            return MatchingRule.selectSubstringMatchingRule(string3);
        }
        String string4 = attributeTypeDefinition.getBaseSyntaxOID(schema);
        if (string4 != null) {
            return MatchingRule.selectMatchingRuleForSyntax(string4);
        }
        return MatchingRule.getDefaultSubstringMatchingRule();
    }

    public static MatchingRule selectSubstringMatchingRule(String string) {
        if (string == null || string.length() == 0) {
            return MatchingRule.getDefaultSubstringMatchingRule();
        }
        String string2 = StaticUtils.toLowerCase(string);
        if (string2.equals(CaseExactStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || string2.equals("2.5.13.7") || string2.equals("caseexactia5substringsmatch")) {
            return CaseExactStringMatchingRule.getInstance();
        }
        if (string2.equals(CaseIgnoreListMatchingRule.LOWER_SUBSTRING_RULE_NAME) || string2.equals("2.5.13.12")) {
            return CaseIgnoreListMatchingRule.getInstance();
        }
        if (string2.equals(CaseIgnoreStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || string2.equals("2.5.13.4") || string2.equals("caseignoreia5substringsmatch") || string2.equals("1.3.6.1.4.1.1466.109.114.3")) {
            return CaseIgnoreStringMatchingRule.getInstance();
        }
        if (string2.equals(NumericStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || string2.equals("2.5.13.10")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (string2.equals(OctetStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || string2.equals("2.5.13.19")) {
            return OctetStringMatchingRule.getInstance();
        }
        if (string2.equals(TelephoneNumberMatchingRule.LOWER_SUBSTRING_RULE_NAME) || string2.equals("2.5.13.21")) {
            return TelephoneNumberMatchingRule.getInstance();
        }
        return MatchingRule.getDefaultSubstringMatchingRule();
    }

    public static MatchingRule getDefaultSubstringMatchingRule() {
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    public static MatchingRule selectMatchingRuleForSyntax(String string) {
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.7")) {
            return BooleanMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.41")) {
            return CaseIgnoreListMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.12") || string.equals("1.3.6.1.4.1.1466.115.121.1.34")) {
            return DistinguishedNameMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.24") || string.equals("1.3.6.1.4.1.1466.115.121.1.53")) {
            return GeneralizedTimeMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.27")) {
            return IntegerMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.36")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.4203.1.1.2") || string.equals("1.3.6.1.4.1.1466.115.121.1.5") || string.equals("1.3.6.1.4.1.1466.115.121.1.8") || string.equals("1.3.6.1.4.1.1466.115.121.1.9") || string.equals("1.3.6.1.4.1.1466.115.121.1.10") || string.equals("1.3.6.1.4.1.1466.115.121.1.28") || string.equals("1.3.6.1.4.1.1466.115.121.1.40")) {
            return OctetStringMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.1466.115.121.1.50")) {
            return TelephoneNumberMatchingRule.getInstance();
        }
        if (string.equals("1.3.6.1.4.1.30221.2.3.4")) {
            return MatchingRule.getJSONObjectExactMatchingRule();
        }
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    private static MatchingRule getJSONObjectExactMatchingRule() {
        if (jsonObjectExactMatchingRule == null) {
            try {
                Class<?> clazz = Class.forName("com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectExactMatchingRule");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                jsonObjectExactMatchingRule = (MatchingRule)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                jsonObjectExactMatchingRule = CaseIgnoreStringMatchingRule.getInstance();
            }
        }
        return jsonObjectExactMatchingRule;
    }
}

