/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;

public final class TelephoneNumberMatchingRule
extends SimpleMatchingRule {
    private static final TelephoneNumberMatchingRule INSTANCE = new TelephoneNumberMatchingRule();
    public static final String EQUALITY_RULE_NAME = "telephoneNumberMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("telephoneNumberMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.20";
    public static final String SUBSTRING_RULE_NAME = "telephoneNumberSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("telephoneNumberSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.21";
    private static final long serialVersionUID = -5463096544849211252L;

    public static TelephoneNumberMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return null;
    }

    public String getOrderingMatchingRuleOID() {
        return null;
    }

    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    public int compareValues(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        byte[] byArray = aSN1OctetString.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 32: 
                case 45: {
                    continue block4;
                }
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 46: 
                case 47: 
                case 58: 
                case 61: 
                case 63: {
                    stringBuilder.append((char)byArray[i]);
                    continue block4;
                }
                default: {
                    byte by = byArray[i];
                    if (by >= 48 && by <= 57 || by >= 97 && by <= 122 || by >= 65 && by <= 90) {
                        stringBuilder.append((char)byArray[i]);
                        continue block4;
                    }
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_INVALID_CHARACTER.get(i));
                }
            }
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        return this.normalize(aSN1OctetString);
    }
}

