/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;

@InternalUseOnly
public final class AbandonRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -7824390696388231825L;
    private final int idToAbandon;

    public AbandonRequestProtocolOp(int n) {
        this.idToAbandon = n;
    }

    AbandonRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            this.idToAbandon = aSN1StreamReader.readInteger();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ABANDON_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public int getIDToAbandon() {
        return this.idToAbandon;
    }

    public byte getProtocolOpType() {
        return 80;
    }

    public ASN1Element encodeProtocolOp() {
        return new ASN1Integer(80, this.idToAbandon);
    }

    public static AbandonRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            return new AbandonRequestProtocolOp(ASN1Integer.decodeAsInteger(aSN1Element).intValue());
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ABANDON_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        aSN1Buffer.addInteger((byte)80, this.idToAbandon);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("AbandonRequestProtocolOp(idToAbandon=");
        stringBuilder.append(this.idToAbandon);
        stringBuilder.append(')');
    }
}

