/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;

@InternalUseOnly
public final class DeleteRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = 1577020640104649789L;
    private final String dn;

    public DeleteRequestProtocolOp(String string) {
        this.dn = string;
    }

    public DeleteRequestProtocolOp(DeleteRequest deleteRequest) {
        this.dn = deleteRequest.getDN();
    }

    DeleteRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            this.dn = aSN1StreamReader.readString();
            Validator.ensureNotNull(this.dn);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_DELETE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public byte getProtocolOpType() {
        return 74;
    }

    public ASN1Element encodeProtocolOp() {
        return new ASN1OctetString(74, this.dn);
    }

    public static DeleteRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            return new DeleteRequestProtocolOp(ASN1OctetString.decodeAsOctetString(aSN1Element).stringValue());
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_DELETE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        aSN1Buffer.addOctetString((byte)74, this.dn);
    }

    public DeleteRequest toDeleteRequest(Control ... controlArray) {
        return new DeleteRequest(this.dn, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("DeleteRequestProtocolOp(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("')");
    }
}

