/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;

@InternalUseOnly
public final class ExtendedRequestProtocolOp
implements ProtocolOp {
    public static final byte TYPE_OID = -128;
    public static final byte TYPE_VALUE = -127;
    private static final long serialVersionUID = -5343424210200494377L;
    private final ASN1OctetString value;
    private final String oid;

    public ExtendedRequestProtocolOp(String string, ASN1OctetString aSN1OctetString) {
        this.oid = string;
        this.value = aSN1OctetString == null ? null : new ASN1OctetString(-127, aSN1OctetString.getValue());
    }

    public ExtendedRequestProtocolOp(ExtendedRequest extendedRequest) {
        this.oid = extendedRequest.getOID();
        this.value = extendedRequest.getValue();
    }

    ExtendedRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            this.oid = aSN1StreamReader.readString();
            Validator.ensureNotNull(this.oid);
            this.value = aSN1StreamReaderSequence.hasMoreElements() ? new ASN1OctetString(-127, aSN1StreamReader.readBytes()) : null;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_EXTENDED_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getOID() {
        return this.oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public byte getProtocolOpType() {
        return 119;
    }

    public ASN1Element encodeProtocolOp() {
        if (this.value == null) {
            return new ASN1Sequence(119, new ASN1OctetString(-128, this.oid));
        }
        return new ASN1Sequence(119, new ASN1OctetString(-128, this.oid), this.value);
    }

    public static ExtendedRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
            ASN1OctetString aSN1OctetString = aSN1ElementArray.length == 1 ? null : ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]);
            return new ExtendedRequestProtocolOp(string, aSN1OctetString);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_EXTENDED_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)119);
        aSN1Buffer.addOctetString((byte)-128, this.oid);
        if (this.value != null) {
            aSN1Buffer.addOctetString((byte)-127, this.value.getValue());
        }
        aSN1BufferSequence.end();
    }

    public ExtendedRequest toExtendedRequest(Control ... controlArray) {
        return new ExtendedRequest(this.oid, this.value, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ExtendedRequestProtocolOp(oid='");
        stringBuilder.append(this.oid);
        stringBuilder.append("')");
    }
}

