/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class LDAPMessage
implements Serializable {
    public static final byte PROTOCOL_OP_TYPE_BIND_REQUEST = 96;
    public static final byte PROTOCOL_OP_TYPE_BIND_RESPONSE = 97;
    public static final byte PROTOCOL_OP_TYPE_UNBIND_REQUEST = 66;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_REQUEST = 99;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_RESULT_ENTRY = 100;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_RESULT_REFERENCE = 115;
    public static final byte PROTOCOL_OP_TYPE_SEARCH_RESULT_DONE = 101;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_REQUEST = 102;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_RESPONSE = 103;
    public static final byte PROTOCOL_OP_TYPE_ADD_REQUEST = 104;
    public static final byte PROTOCOL_OP_TYPE_ADD_RESPONSE = 105;
    public static final byte PROTOCOL_OP_TYPE_DELETE_REQUEST = 74;
    public static final byte PROTOCOL_OP_TYPE_DELETE_RESPONSE = 107;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_DN_REQUEST = 108;
    public static final byte PROTOCOL_OP_TYPE_MODIFY_DN_RESPONSE = 109;
    public static final byte PROTOCOL_OP_TYPE_COMPARE_REQUEST = 110;
    public static final byte PROTOCOL_OP_TYPE_COMPARE_RESPONSE = 111;
    public static final byte PROTOCOL_OP_TYPE_ABANDON_REQUEST = 80;
    public static final byte PROTOCOL_OP_TYPE_EXTENDED_REQUEST = 119;
    public static final byte PROTOCOL_OP_TYPE_EXTENDED_RESPONSE = 120;
    public static final byte PROTOCOL_OP_TYPE_INTERMEDIATE_RESPONSE = 121;
    public static final byte MESSAGE_TYPE_CONTROLS = -96;
    private static final long serialVersionUID = 909272448857832592L;
    private final int messageID;
    private final ProtocolOp protocolOp;
    private final List<Control> controls;

    public LDAPMessage(int n, ProtocolOp protocolOp, Control ... controlArray) {
        this.messageID = n;
        this.protocolOp = protocolOp;
        this.controls = controlArray == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(controlArray));
    }

    public LDAPMessage(int n, ProtocolOp protocolOp, List<Control> list) {
        this.messageID = n;
        this.protocolOp = protocolOp;
        this.controls = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public int getMessageID() {
        return this.messageID;
    }

    public ProtocolOp getProtocolOp() {
        return this.protocolOp;
    }

    public byte getProtocolOpType() {
        return this.protocolOp.getProtocolOpType();
    }

    public AbandonRequestProtocolOp getAbandonRequestProtocolOp() throws ClassCastException {
        return (AbandonRequestProtocolOp)this.protocolOp;
    }

    public AddRequestProtocolOp getAddRequestProtocolOp() throws ClassCastException {
        return (AddRequestProtocolOp)this.protocolOp;
    }

    public AddResponseProtocolOp getAddResponseProtocolOp() throws ClassCastException {
        return (AddResponseProtocolOp)this.protocolOp;
    }

    public BindRequestProtocolOp getBindRequestProtocolOp() throws ClassCastException {
        return (BindRequestProtocolOp)this.protocolOp;
    }

    public BindResponseProtocolOp getBindResponseProtocolOp() throws ClassCastException {
        return (BindResponseProtocolOp)this.protocolOp;
    }

    public CompareRequestProtocolOp getCompareRequestProtocolOp() throws ClassCastException {
        return (CompareRequestProtocolOp)this.protocolOp;
    }

    public CompareResponseProtocolOp getCompareResponseProtocolOp() throws ClassCastException {
        return (CompareResponseProtocolOp)this.protocolOp;
    }

    public DeleteRequestProtocolOp getDeleteRequestProtocolOp() throws ClassCastException {
        return (DeleteRequestProtocolOp)this.protocolOp;
    }

    public DeleteResponseProtocolOp getDeleteResponseProtocolOp() throws ClassCastException {
        return (DeleteResponseProtocolOp)this.protocolOp;
    }

    public ExtendedRequestProtocolOp getExtendedRequestProtocolOp() throws ClassCastException {
        return (ExtendedRequestProtocolOp)this.protocolOp;
    }

    public ExtendedResponseProtocolOp getExtendedResponseProtocolOp() throws ClassCastException {
        return (ExtendedResponseProtocolOp)this.protocolOp;
    }

    public ModifyRequestProtocolOp getModifyRequestProtocolOp() throws ClassCastException {
        return (ModifyRequestProtocolOp)this.protocolOp;
    }

    public ModifyResponseProtocolOp getModifyResponseProtocolOp() throws ClassCastException {
        return (ModifyResponseProtocolOp)this.protocolOp;
    }

    public ModifyDNRequestProtocolOp getModifyDNRequestProtocolOp() throws ClassCastException {
        return (ModifyDNRequestProtocolOp)this.protocolOp;
    }

    public ModifyDNResponseProtocolOp getModifyDNResponseProtocolOp() throws ClassCastException {
        return (ModifyDNResponseProtocolOp)this.protocolOp;
    }

    public SearchRequestProtocolOp getSearchRequestProtocolOp() throws ClassCastException {
        return (SearchRequestProtocolOp)this.protocolOp;
    }

    public SearchResultEntryProtocolOp getSearchResultEntryProtocolOp() throws ClassCastException {
        return (SearchResultEntryProtocolOp)this.protocolOp;
    }

    public SearchResultReferenceProtocolOp getSearchResultReferenceProtocolOp() throws ClassCastException {
        return (SearchResultReferenceProtocolOp)this.protocolOp;
    }

    public SearchResultDoneProtocolOp getSearchResultDoneProtocolOp() throws ClassCastException {
        return (SearchResultDoneProtocolOp)this.protocolOp;
    }

    public UnbindRequestProtocolOp getUnbindRequestProtocolOp() throws ClassCastException {
        return (UnbindRequestProtocolOp)this.protocolOp;
    }

    public IntermediateResponseProtocolOp getIntermediateResponseProtocolOp() throws ClassCastException {
        return (IntermediateResponseProtocolOp)this.protocolOp;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public ASN1Element encode() {
        if (this.controls.isEmpty()) {
            return new ASN1Sequence(new ASN1Integer(this.messageID), this.protocolOp.encodeProtocolOp());
        }
        Control[] controlArray = new Control[this.controls.size()];
        this.controls.toArray(controlArray);
        return new ASN1Sequence(new ASN1Integer(this.messageID), this.protocolOp.encodeProtocolOp(), Control.encodeControls(controlArray));
    }

    public static LDAPMessage decode(ASN1Element aSN1Element) throws LDAPException {
        try {
            ProtocolOp protocolOp;
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            if (aSN1ElementArray.length < 2 || aSN1ElementArray.length > 3) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_DECODE_VALUE_SEQUENCE_INVALID_ELEMENT_COUNT.get(aSN1ElementArray.length));
            }
            int n = ASN1Integer.decodeAsInteger(aSN1ElementArray[0]).intValue();
            switch (aSN1ElementArray[1].getType()) {
                case 80: {
                    protocolOp = AbandonRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 104: {
                    protocolOp = AddRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 105: {
                    protocolOp = AddResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 96: {
                    protocolOp = BindRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 97: {
                    protocolOp = BindResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 110: {
                    protocolOp = CompareRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 111: {
                    protocolOp = CompareResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 74: {
                    protocolOp = DeleteRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 107: {
                    protocolOp = DeleteResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 119: {
                    protocolOp = ExtendedRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 120: {
                    protocolOp = ExtendedResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 121: {
                    protocolOp = IntermediateResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 102: {
                    protocolOp = ModifyRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 103: {
                    protocolOp = ModifyResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 108: {
                    protocolOp = ModifyDNRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 109: {
                    protocolOp = ModifyDNResponseProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 99: {
                    protocolOp = SearchRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 101: {
                    protocolOp = SearchResultDoneProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 100: {
                    protocolOp = SearchResultEntryProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 115: {
                    protocolOp = SearchResultReferenceProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                case 66: {
                    protocolOp = UnbindRequestProtocolOp.decodeProtocolOp(aSN1ElementArray[1]);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_DECODE_INVALID_PROTOCOL_OP_TYPE.get(StaticUtils.toHex(aSN1ElementArray[1].getType())));
                }
            }
            Control[] controlArray = aSN1ElementArray.length == 3 ? Control.decodeControls(ASN1Sequence.decodeAsSequence(aSN1ElementArray[2])) : null;
            return new LDAPMessage(n, protocolOp, controlArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_DECODE_ERROR.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence();
        aSN1Buffer.addInteger(this.messageID);
        this.protocolOp.writeTo(aSN1Buffer);
        if (!this.controls.isEmpty()) {
            ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence((byte)-96);
            for (Control control : this.controls) {
                control.writeTo(aSN1Buffer);
            }
            aSN1BufferSequence2.end();
        }
        aSN1BufferSequence.end();
    }

    public static LDAPMessage readFrom(ASN1StreamReader aSN1StreamReader, boolean bl) throws LDAPException {
        ASN1StreamReaderSequence aSN1StreamReaderSequence;
        try {
            aSN1StreamReader.setIgnoreSocketTimeout(false, bl);
            aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            if (aSN1StreamReaderSequence == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            if (!(iOException instanceof SocketTimeoutException) && !(iOException instanceof InterruptedIOException)) {
                Debug.debugException(iOException);
            }
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(iOException)), iOException);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
        try {
            ProtocolOp protocolOp;
            aSN1StreamReader.setIgnoreSocketTimeout(bl, bl);
            int n = aSN1StreamReader.readInteger();
            byte by = (byte)aSN1StreamReader.peek();
            switch (by) {
                case 96: {
                    protocolOp = new BindRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 97: {
                    protocolOp = new BindResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 66: {
                    protocolOp = new UnbindRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 99: {
                    protocolOp = new SearchRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 100: {
                    protocolOp = new SearchResultEntryProtocolOp(aSN1StreamReader);
                    break;
                }
                case 115: {
                    protocolOp = new SearchResultReferenceProtocolOp(aSN1StreamReader);
                    break;
                }
                case 101: {
                    protocolOp = new SearchResultDoneProtocolOp(aSN1StreamReader);
                    break;
                }
                case 102: {
                    protocolOp = new ModifyRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 103: {
                    protocolOp = new ModifyResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 104: {
                    protocolOp = new AddRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 105: {
                    protocolOp = new AddResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 74: {
                    protocolOp = new DeleteRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 107: {
                    protocolOp = new DeleteResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 108: {
                    protocolOp = new ModifyDNRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 109: {
                    protocolOp = new ModifyDNResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 110: {
                    protocolOp = new CompareRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 111: {
                    protocolOp = new CompareResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 80: {
                    protocolOp = new AbandonRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 119: {
                    protocolOp = new ExtendedRequestProtocolOp(aSN1StreamReader);
                    break;
                }
                case 120: {
                    protocolOp = new ExtendedResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                case 121: {
                    protocolOp = new IntermediateResponseProtocolOp(aSN1StreamReader);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_INVALID_PROTOCOL_OP_TYPE.get(StaticUtils.toHex(by)));
                }
            }
            ArrayList<Control> arrayList = new ArrayList<Control>(5);
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence2.hasMoreElements()) {
                    arrayList.add(Control.readFrom(aSN1StreamReader));
                }
            }
            return new LDAPMessage(n, protocolOp, arrayList);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (IOException iOException) {
            Debug.debugException(iOException);
            if (iOException instanceof SocketTimeoutException || iOException instanceof InterruptedIOException) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(iOException)));
            }
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(iOException)), iOException);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public static LDAPResponse readLDAPResponseFrom(ASN1StreamReader aSN1StreamReader, boolean bl) throws LDAPException {
        return LDAPMessage.readLDAPResponseFrom(aSN1StreamReader, bl, null);
    }

    public static LDAPResponse readLDAPResponseFrom(ASN1StreamReader aSN1StreamReader, boolean bl, Schema schema) throws LDAPException {
        ASN1StreamReaderSequence aSN1StreamReaderSequence;
        try {
            aSN1StreamReader.setIgnoreSocketTimeout(false, bl);
            aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            if (aSN1StreamReaderSequence == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            if (!(iOException instanceof SocketTimeoutException) && !(iOException instanceof InterruptedIOException)) {
                Debug.debugException(iOException);
            }
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(iOException)), iOException);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
        try {
            aSN1StreamReader.setIgnoreSocketTimeout(bl, bl);
            int n = aSN1StreamReader.readInteger();
            byte by = (byte)aSN1StreamReader.peek();
            switch (by) {
                case 103: 
                case 105: 
                case 107: 
                case 109: {
                    return InternalSDKHelper.readLDAPResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 97: {
                    return InternalSDKHelper.readBindResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 111: {
                    return InternalSDKHelper.readCompareResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 120: {
                    return InternalSDKHelper.readExtendedResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 100: {
                    return InternalSDKHelper.readSearchResultEntryFrom(n, aSN1StreamReaderSequence, aSN1StreamReader, schema);
                }
                case 115: {
                    return InternalSDKHelper.readSearchResultReferenceFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 101: {
                    return InternalSDKHelper.readSearchResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 121: {
                    return InternalSDKHelper.readIntermediateResponseFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
                }
                case 66: 
                case 74: 
                case 80: 
                case 96: 
                case 99: 
                case 102: 
                case 104: 
                case 108: 
                case 110: 
                case 119: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_PROTOCOL_OP_TYPE_NOT_RESPONSE.get(StaticUtils.toHex(by)));
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_INVALID_PROTOCOL_OP_TYPE.get(StaticUtils.toHex(by)));
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (IOException iOException) {
            Debug.debugException(iOException);
            if (iOException instanceof SocketTimeoutException || iOException instanceof InterruptedIOException) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(iOException)));
            }
            throw new LDAPException(ResultCode.SERVER_DOWN, ProtocolMessages.ERR_MESSAGE_IO_ERROR.get(StaticUtils.getExceptionMessage(iOException)), iOException);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MESSAGE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDAPMessage(msgID=");
        stringBuilder.append(this.messageID);
        stringBuilder.append(", protocolOp=");
        this.protocolOp.toString(stringBuilder);
        if (!this.controls.isEmpty()) {
            stringBuilder.append(", controls={");
            Iterator<Control> iterator = this.controls.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(stringBuilder);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

