/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;

@InternalUseOnly
public final class ModifyDNRequestProtocolOp
implements ProtocolOp {
    public static final byte TYPE_NEW_SUPERIOR = -128;
    private static final long serialVersionUID = 7514385089303489375L;
    private final boolean deleteOldRDN;
    private final String dn;
    private final String newRDN;
    private final String newSuperiorDN;

    public ModifyDNRequestProtocolOp(String string, String string2, boolean bl, String string3) {
        this.dn = string;
        this.newRDN = string2;
        this.deleteOldRDN = bl;
        this.newSuperiorDN = string3;
    }

    public ModifyDNRequestProtocolOp(ModifyDNRequest modifyDNRequest) {
        this.dn = modifyDNRequest.getDN();
        this.newRDN = modifyDNRequest.getNewRDN();
        this.deleteOldRDN = modifyDNRequest.deleteOldRDN();
        this.newSuperiorDN = modifyDNRequest.getNewSuperiorDN();
    }

    ModifyDNRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            this.dn = aSN1StreamReader.readString();
            this.newRDN = aSN1StreamReader.readString();
            this.deleteOldRDN = aSN1StreamReader.readBoolean();
            this.newSuperiorDN = aSN1StreamReaderSequence.hasMoreElements() ? aSN1StreamReader.readString() : null;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_DN_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public byte getProtocolOpType() {
        return 108;
    }

    public ASN1Element encodeProtocolOp() {
        if (this.newSuperiorDN == null) {
            return new ASN1Sequence(108, new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN));
        }
        return new ASN1Sequence(108, new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN), new ASN1OctetString(-128, this.newSuperiorDN));
    }

    public static ModifyDNRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
            String string2 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]).stringValue();
            boolean bl = ASN1Boolean.decodeAsBoolean(aSN1ElementArray[2]).booleanValue();
            String string3 = aSN1ElementArray.length > 3 ? ASN1OctetString.decodeAsOctetString(aSN1ElementArray[3]).stringValue() : null;
            return new ModifyDNRequestProtocolOp(string, string2, bl, string3);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_DN_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)108);
        aSN1Buffer.addOctetString(this.dn);
        aSN1Buffer.addOctetString(this.newRDN);
        aSN1Buffer.addBoolean(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            aSN1Buffer.addOctetString((byte)-128, this.newSuperiorDN);
        }
        aSN1BufferSequence.end();
    }

    public ModifyDNRequest toModifyDNRequest(Control ... controlArray) {
        return new ModifyDNRequest(this.dn, this.newRDN, this.deleteOldRDN, this.newSuperiorDN, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ModifyDNRequestProtocolOp(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', newRDN='");
        stringBuilder.append(this.newRDN);
        stringBuilder.append("', deleteOldRDN=");
        stringBuilder.append(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            stringBuilder.append(", newSuperiorDN='");
            stringBuilder.append(this.newSuperiorDN);
            stringBuilder.append('\'');
        }
        stringBuilder.append(')');
    }
}

