/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class ModifyRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -6294739625253826184L;
    private final List<Modification> modifications;
    private final String dn;

    public ModifyRequestProtocolOp(String string, List<Modification> list) {
        this.dn = string;
        this.modifications = Collections.unmodifiableList(list);
    }

    public ModifyRequestProtocolOp(ModifyRequest modifyRequest) {
        this.dn = modifyRequest.getDN();
        this.modifications = modifyRequest.getModifications();
    }

    ModifyRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            aSN1StreamReader.beginSequence();
            this.dn = aSN1StreamReader.readString();
            Validator.ensureNotNull(this.dn);
            ArrayList<Modification> arrayList = new ArrayList<Modification>(5);
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            while (aSN1StreamReaderSequence.hasMoreElements()) {
                arrayList.add(Modification.readFrom(aSN1StreamReader));
            }
            this.modifications = Collections.unmodifiableList(arrayList);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    @Override
    public byte getProtocolOpType() {
        return 102;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Sequence> arrayList = new ArrayList<ASN1Sequence>(this.modifications.size());
        for (Modification modification : this.modifications) {
            arrayList.add(modification.encode());
        }
        return new ASN1Sequence(102, new ASN1OctetString(this.dn), new ASN1Sequence(arrayList));
    }

    public static ModifyRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
            ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[1]).elements();
            ArrayList<Modification> arrayList = new ArrayList<Modification>(aSN1ElementArray2.length);
            for (ASN1Element aSN1Element2 : aSN1ElementArray2) {
                arrayList.add(Modification.decode(ASN1Sequence.decodeAsSequence(aSN1Element2)));
            }
            return new ModifyRequestProtocolOp(string, arrayList);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)102);
        aSN1Buffer.addOctetString(this.dn);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        for (Modification modification : this.modifications) {
            modification.writeTo(aSN1Buffer);
        }
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    public ModifyRequest toModifyRequest(Control ... controlArray) {
        return new ModifyRequest(this.dn, this.modifications, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ModifyRequestProtocolOp(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', mods={");
        Iterator<Modification> iterator = this.modifications.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("})");
    }
}

