/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class SearchRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -8521750809606744181L;
    private final boolean typesOnly;
    private final DereferencePolicy derefPolicy;
    private final Filter filter;
    private final int sizeLimit;
    private final int timeLimit;
    private final List<String> attributes;
    private final SearchScope scope;
    private final String baseDN;

    public SearchRequestProtocolOp(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, List<String> list) {
        this.scope = searchScope;
        this.derefPolicy = dereferencePolicy;
        this.typesOnly = bl;
        this.filter = filter;
        this.baseDN = string == null ? "" : string;
        this.sizeLimit = n > 0 ? n : 0;
        this.timeLimit = n2 > 0 ? n2 : 0;
        this.attributes = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public SearchRequestProtocolOp(SearchRequest searchRequest) {
        this.baseDN = searchRequest.getBaseDN();
        this.scope = searchRequest.getScope();
        this.derefPolicy = searchRequest.getDereferencePolicy();
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = searchRequest.getTimeLimitSeconds();
        this.typesOnly = searchRequest.typesOnly();
        this.filter = searchRequest.getFilter();
        this.attributes = searchRequest.getAttributeList();
    }

    SearchRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            aSN1StreamReader.beginSequence();
            this.baseDN = aSN1StreamReader.readString();
            this.scope = SearchScope.valueOf(aSN1StreamReader.readEnumerated());
            this.derefPolicy = DereferencePolicy.valueOf(aSN1StreamReader.readEnumerated());
            this.sizeLimit = aSN1StreamReader.readInteger();
            this.timeLimit = aSN1StreamReader.readInteger();
            this.typesOnly = aSN1StreamReader.readBoolean();
            this.filter = Filter.readFrom(aSN1StreamReader);
            ArrayList<String> arrayList = new ArrayList<String>(5);
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            while (aSN1StreamReaderSequence.hasMoreElements()) {
                arrayList.add(aSN1StreamReader.readString());
            }
            this.attributes = Collections.unmodifiableList(arrayList);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public DereferencePolicy getDerefPolicy() {
        return this.derefPolicy;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public boolean typesOnly() {
        return this.typesOnly;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getProtocolOpType() {
        return 99;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(this.attributes.size());
        for (String string : this.attributes) {
            arrayList.add(new ASN1OctetString(string));
        }
        return new ASN1Sequence(99, new ASN1OctetString(this.baseDN), new ASN1Enumerated(this.scope.intValue()), new ASN1Enumerated(this.derefPolicy.intValue()), new ASN1Integer(this.sizeLimit), new ASN1Integer(this.timeLimit), new ASN1Boolean(this.typesOnly), this.filter.encode(), new ASN1Sequence(arrayList));
    }

    public static SearchRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
            SearchScope searchScope = SearchScope.valueOf(ASN1Enumerated.decodeAsEnumerated(aSN1ElementArray[1]).intValue());
            DereferencePolicy dereferencePolicy = DereferencePolicy.valueOf(ASN1Enumerated.decodeAsEnumerated(aSN1ElementArray[2]).intValue());
            int n = ASN1Integer.decodeAsInteger(aSN1ElementArray[3]).intValue();
            int n2 = ASN1Integer.decodeAsInteger(aSN1ElementArray[4]).intValue();
            boolean bl = ASN1Boolean.decodeAsBoolean(aSN1ElementArray[5]).booleanValue();
            Filter filter = Filter.decode(aSN1ElementArray[6]);
            ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[7]).elements();
            ArrayList<String> arrayList = new ArrayList<String>(aSN1ElementArray2.length);
            for (ASN1Element aSN1Element2 : aSN1ElementArray2) {
                arrayList.add(ASN1OctetString.decodeAsOctetString(aSN1Element2).stringValue());
            }
            return new SearchRequestProtocolOp(string, searchScope, dereferencePolicy, n, n2, bl, filter, arrayList);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)99);
        aSN1Buffer.addOctetString(this.baseDN);
        aSN1Buffer.addEnumerated(this.scope.intValue());
        aSN1Buffer.addEnumerated(this.derefPolicy.intValue());
        aSN1Buffer.addInteger(this.sizeLimit);
        aSN1Buffer.addInteger(this.timeLimit);
        aSN1Buffer.addBoolean(this.typesOnly);
        this.filter.writeTo(aSN1Buffer);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        for (String string : this.attributes) {
            aSN1Buffer.addOctetString(string);
        }
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    public SearchRequest toSearchRequest(Control ... controlArray) {
        String[] stringArray = new String[this.attributes.size()];
        this.attributes.toArray(stringArray);
        return new SearchRequest(null, controlArray, this.baseDN, this.scope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, this.filter, stringArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("SearchRequestProtocolOp(baseDN='");
        stringBuilder.append(this.baseDN);
        stringBuilder.append("', scope='");
        stringBuilder.append(this.scope.toString());
        stringBuilder.append("', derefPolicy='");
        stringBuilder.append(this.derefPolicy.toString());
        stringBuilder.append("', sizeLimit=");
        stringBuilder.append(this.sizeLimit);
        stringBuilder.append(", timeLimit=");
        stringBuilder.append(this.timeLimit);
        stringBuilder.append(", typesOnly=");
        stringBuilder.append(this.typesOnly);
        stringBuilder.append(", filter='");
        this.filter.toString(stringBuilder);
        stringBuilder.append("', attributes={");
        Iterator<String> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("})");
    }
}

