/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class SearchResultReferenceProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -1526778443581862609L;
    private final List<String> referralURLs;

    public SearchResultReferenceProtocolOp(List<String> list) {
        this.referralURLs = Collections.unmodifiableList(list);
    }

    public SearchResultReferenceProtocolOp(SearchResultReference searchResultReference) {
        this.referralURLs = StaticUtils.toList(searchResultReference.getReferralURLs());
    }

    SearchResultReferenceProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            while (aSN1StreamReaderSequence.hasMoreElements()) {
                arrayList.add(aSN1StreamReader.readString());
            }
            this.referralURLs = Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_REFERENCE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public byte getProtocolOpType() {
        return 115;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(this.referralURLs.size());
        for (String string : this.referralURLs) {
            arrayList.add(new ASN1OctetString(string));
        }
        return new ASN1Sequence(115, arrayList);
    }

    public static SearchResultReferenceProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            ArrayList<String> arrayList = new ArrayList<String>(aSN1ElementArray.length);
            for (ASN1Element aSN1Element2 : aSN1ElementArray) {
                arrayList.add(ASN1OctetString.decodeAsOctetString(aSN1Element2).stringValue());
            }
            return new SearchResultReferenceProtocolOp(arrayList);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_REFERENCE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)115);
        for (String string : this.referralURLs) {
            aSN1Buffer.addOctetString(string);
        }
        aSN1BufferSequence.end();
    }

    public SearchResultReference toSearchResultReference(Control ... controlArray) {
        String[] stringArray = new String[this.referralURLs.size()];
        this.referralURLs.toArray(stringArray);
        return new SearchResultReference(stringArray, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("SearchResultReferenceProtocolOp(referralURLs={");
        Iterator<String> iterator = this.referralURLs.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append('\'');
            stringBuilder.append(iterator.next());
            stringBuilder.append('\'');
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("})");
    }
}

