/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 7186731025240177443L;
    private final AsyncRequestID asyncRequestID;
    private final AsyncResultListener resultListener;
    private final AtomicBoolean responseReturned;
    private final OperationType operationType;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncHelper(LDAPConnection lDAPConnection, OperationType operationType, int n, AsyncResultListener asyncResultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = lDAPConnection;
        this.operationType = operationType;
        this.resultListener = asyncResultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.asyncRequestID = new AsyncRequestID(n, lDAPConnection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    public LDAPConnection getConnection() {
        return this.connection;
    }

    public long getCreateTimeNanos() {
        return this.createTime;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        ConnectionClosedResponse connectionClosedResponse;
        String string;
        if (!this.responseReturned.compareAndSet(false, true)) {
            return;
        }
        long l = System.nanoTime() - this.createTime;
        LDAPResult lDAPResult = lDAPResponse instanceof ConnectionClosedResponse ? ((string = (connectionClosedResponse = (ConnectionClosedResponse)lDAPResponse).getMessage()) == null ? new LDAPResult(this.asyncRequestID.getMessageID(), connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new LDAPResult(this.asyncRequestID.getMessageID(), connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(string), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS)) : (LDAPResult)lDAPResponse;
        switch (this.operationType) {
            case ADD: {
                this.connection.getConnectionStatistics().incrementNumAddResponses(l);
                break;
            }
            case DELETE: {
                this.connection.getConnectionStatistics().incrementNumDeleteResponses(l);
                break;
            }
            case MODIFY: {
                this.connection.getConnectionStatistics().incrementNumModifyResponses(l);
                break;
            }
            case MODIFY_DN: {
                this.connection.getConnectionStatistics().incrementNumModifyDNResponses(l);
            }
        }
        this.resultListener.ldapResultReceived(this.asyncRequestID, lDAPResult);
        this.asyncRequestID.setResult(lDAPResult);
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

