/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncSearchHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 1006163445423767824L;
    private final AsyncRequestID asyncRequestID;
    private final AsyncSearchResultListener resultListener;
    private final AtomicBoolean responseReturned;
    private int numEntries;
    private int numReferences;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncSearchHelper(LDAPConnection lDAPConnection, int n, AsyncSearchResultListener asyncSearchResultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = lDAPConnection;
        this.resultListener = asyncSearchResultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.numEntries = 0;
        this.numReferences = 0;
        this.asyncRequestID = new AsyncRequestID(n, lDAPConnection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    public LDAPConnection getConnection() {
        return this.connection;
    }

    public long getCreateTimeNanos() {
        return this.createTime;
    }

    public OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    int getNumEntries() {
        return this.numEntries;
    }

    int getNumReferences() {
        return this.numReferences;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        if (this.responseReturned.get()) {
            return;
        }
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            if (!this.responseReturned.compareAndSet(false, true)) {
                return;
            }
            ConnectionClosedResponse connectionClosedResponse = (ConnectionClosedResponse)lDAPResponse;
            String string = connectionClosedResponse.getMessage();
            String string2 = string == null ? LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get() : LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(string);
            this.connection.getConnectionStatistics().incrementNumSearchResponses(this.numEntries, this.numReferences, System.nanoTime() - this.createTime);
            SearchResult searchResult = new SearchResult(this.asyncRequestID.getMessageID(), connectionClosedResponse.getResultCode(), string2, null, StaticUtils.NO_STRINGS, this.numEntries, this.numReferences, StaticUtils.NO_CONTROLS);
            this.resultListener.searchResultReceived(this.asyncRequestID, searchResult);
            this.asyncRequestID.setResult(searchResult);
        } else if (lDAPResponse instanceof SearchResultEntry) {
            ++this.numEntries;
            this.resultListener.searchEntryReturned((SearchResultEntry)lDAPResponse);
        } else if (lDAPResponse instanceof SearchResultReference) {
            ++this.numReferences;
            this.resultListener.searchReferenceReturned((SearchResultReference)lDAPResponse);
        } else {
            if (!this.responseReturned.compareAndSet(false, true)) {
                return;
            }
            this.connection.getConnectionStatistics().incrementNumSearchResponses(this.numEntries, this.numReferences, System.nanoTime() - this.createTime);
            SearchResult searchResult = (SearchResult)lDAPResponse;
            searchResult.setCounts(this.numEntries, null, this.numReferences, null);
            this.resultListener.searchResultReceived(this.asyncRequestID, searchResult);
            this.asyncRequestID.setResult(searchResult);
        }
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

