/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AsyncSearchHelper;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.TimerTask;

final class AsyncTimeoutTimerTask
extends TimerTask {
    private final CommonAsyncHelper helper;

    AsyncTimeoutTimerTask(CommonAsyncHelper commonAsyncHelper) {
        this.helper = commonAsyncHelper;
    }

    public void run() {
        Object object;
        LDAPResult lDAPResult;
        long l = System.nanoTime() - this.helper.getCreateTimeNanos();
        long l2 = l / 1000000L;
        LDAPConnection lDAPConnection = this.helper.getConnection();
        boolean bl = lDAPConnection.getConnectionOptions().abandonOnTimeout();
        String string = bl ? LDAPMessages.INFO_ASYNC_OPERATION_TIMEOUT_WITH_ABANDON.get(l2) : LDAPMessages.INFO_ASYNC_OPERATION_TIMEOUT_WITHOUT_ABANDON.get(l2);
        int n = this.helper.getAsyncRequestID().getMessageID();
        switch (this.helper.getOperationType()) {
            case ADD: 
            case DELETE: 
            case MODIFY: 
            case MODIFY_DN: {
                lDAPResult = new LDAPResult(n, ResultCode.TIMEOUT, string, null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                break;
            }
            case COMPARE: {
                lDAPResult = new CompareResult(n, ResultCode.TIMEOUT, string, null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                break;
            }
            case SEARCH: {
                object = (AsyncSearchHelper)this.helper;
                lDAPResult = new SearchResult(n, ResultCode.TIMEOUT, string, null, StaticUtils.NO_STRINGS, ((AsyncSearchHelper)object).getNumEntries(), ((AsyncSearchHelper)object).getNumReferences(), StaticUtils.NO_CONTROLS);
                break;
            }
            default: {
                return;
            }
        }
        try {
            try {
                object = lDAPConnection.getConnectionInternals(true).getConnectionReader();
                ((LDAPConnectionReader)object).deregisterResponseAcceptor(n);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            this.helper.responseReceived(lDAPResult);
            if (bl) {
                lDAPConnection.abandon(this.helper.getAsyncRequestID());
            }
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
        }
    }
}

