/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSet;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Attribute
implements Serializable {
    private static final ASN1OctetString[] NO_VALUES = new ASN1OctetString[0];
    private static final byte[][] NO_BYTE_VALUES = new byte[0][];
    private static final long serialVersionUID = 5867076498293567612L;
    private final ASN1OctetString[] values;
    private int hashCode = -1;
    private final MatchingRule matchingRule;
    private final String name;

    public Attribute(String string) {
        Validator.ensureNotNull(string);
        this.name = string;
        this.values = NO_VALUES;
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        this.name = string;
        this.values = new ASN1OctetString[]{new ASN1OctetString(string2)};
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        this.name = string;
        this.values = new ASN1OctetString[]{new ASN1OctetString(byArray)};
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        this.name = string;
        this.values = new ASN1OctetString[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.values[i] = new ASN1OctetString(stringArray[i]);
        }
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        this.name = string;
        this.values = new ASN1OctetString[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.values[i] = new ASN1OctetString(byArray[i]);
        }
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, ASN1OctetString ... aSN1OctetStringArray) {
        Validator.ensureNotNull(string, aSN1OctetStringArray);
        this.name = string;
        this.values = aSN1OctetStringArray;
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, Collection<String> collection) {
        Validator.ensureNotNull(string, collection);
        this.name = string;
        this.values = new ASN1OctetString[collection.size()];
        int n = 0;
        for (String string2 : collection) {
            this.values[n++] = new ASN1OctetString(string2);
        }
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(String string, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, matchingRule);
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = NO_VALUES;
    }

    public Attribute(String string, MatchingRule matchingRule, String string2) {
        Validator.ensureNotNull(string, matchingRule, string2);
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[]{new ASN1OctetString(string2)};
    }

    public Attribute(String string, MatchingRule matchingRule, byte[] byArray) {
        Validator.ensureNotNull(string, matchingRule, byArray);
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[]{new ASN1OctetString(byArray)};
    }

    public Attribute(String string, MatchingRule matchingRule, String ... stringArray) {
        Validator.ensureNotNull(string, matchingRule, stringArray);
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.values[i] = new ASN1OctetString(stringArray[i]);
        }
    }

    public Attribute(String string, MatchingRule matchingRule, byte[] ... byArray) {
        Validator.ensureNotNull(string, matchingRule, byArray);
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.values[i] = new ASN1OctetString(byArray[i]);
        }
    }

    public Attribute(String string, MatchingRule matchingRule, Collection<String> collection) {
        Validator.ensureNotNull(string, matchingRule, collection);
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[collection.size()];
        int n = 0;
        for (String string2 : collection) {
            this.values[n++] = new ASN1OctetString(string2);
        }
    }

    public Attribute(String string, MatchingRule matchingRule, ASN1OctetString[] aSN1OctetStringArray) {
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = aSN1OctetStringArray;
    }

    public Attribute(String string, Schema schema, String ... stringArray) {
        this(string, MatchingRule.selectEqualityMatchingRule(string, schema), stringArray);
    }

    public Attribute(String string, Schema schema, byte[] ... byArray) {
        this(string, MatchingRule.selectEqualityMatchingRule(string, schema), byArray);
    }

    public Attribute(String string, Schema schema, Collection<String> collection) {
        this(string, MatchingRule.selectEqualityMatchingRule(string, schema), collection);
    }

    public Attribute(String string, Schema schema, ASN1OctetString[] aSN1OctetStringArray) {
        this(string, MatchingRule.selectEqualityMatchingRule(string, schema), aSN1OctetStringArray);
    }

    public static Attribute mergeAttributes(Attribute attribute, Attribute attribute2) {
        Validator.ensureNotNull(attribute, attribute2);
        String string = attribute.name;
        Validator.ensureTrue(string.equalsIgnoreCase(attribute2.name));
        MatchingRule matchingRule = attribute.matchingRule;
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[attribute.values.length + attribute2.values.length];
        System.arraycopy(attribute.values, 0, aSN1OctetStringArray, 0, attribute.values.length);
        int n = attribute.values.length;
        for (ASN1OctetString aSN1OctetString : attribute2.values) {
            boolean bl = false;
            for (ASN1OctetString aSN1OctetString2 : attribute.values) {
                try {
                    if (!matchingRule.valuesMatch(aSN1OctetString2, aSN1OctetString)) continue;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                }
            }
            if (bl) continue;
            aSN1OctetStringArray[n++] = aSN1OctetString;
        }
        if (n != aSN1OctetStringArray.length) {
            ASN1OctetString[] aSN1OctetStringArray2 = new ASN1OctetString[n];
            System.arraycopy(aSN1OctetStringArray, 0, aSN1OctetStringArray2, 0, n);
            aSN1OctetStringArray = aSN1OctetStringArray2;
        }
        return new Attribute(string, matchingRule, aSN1OctetStringArray);
    }

    public static Attribute removeValues(Attribute attribute, Attribute attribute2) {
        return Attribute.removeValues(attribute, attribute2, attribute.matchingRule);
    }

    public static Attribute removeValues(Attribute attribute, Attribute attribute2, MatchingRule matchingRule) {
        Validator.ensureNotNull(attribute, attribute2);
        String string = attribute.name;
        Validator.ensureTrue(string.equalsIgnoreCase(attribute2.name));
        MatchingRule matchingRule2 = matchingRule == null ? attribute.matchingRule : matchingRule;
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(Arrays.asList(attribute.values));
        Iterator<ASN1OctetString> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!attribute2.hasValue(iterator.next(), matchingRule2)) continue;
            iterator.remove();
        }
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[arrayList.size()];
        arrayList.toArray(aSN1OctetStringArray);
        return new Attribute(string, matchingRule2, aSN1OctetStringArray);
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return Attribute.getBaseName(this.name);
    }

    public static String getBaseName(String string) {
        int n = string.indexOf(59);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public boolean nameIsValid() {
        return Attribute.nameIsValid(this.name, true);
    }

    public static boolean nameIsValid(String string) {
        return Attribute.nameIsValid(string, true);
    }

    public static boolean nameIsValid(String string, boolean bl) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        boolean bl2 = false;
        for (int i = 1; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                bl2 = false;
                continue;
            }
            if (c2 >= '0' && c2 <= '9' || c2 == '-') {
                if (bl2) {
                    return false;
                }
                bl2 = false;
                continue;
            }
            if (c2 == ';') {
                if (bl2 || !bl) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            return false;
        }
        return !bl2;
    }

    public boolean hasOptions() {
        return Attribute.hasOptions(this.name);
    }

    public static boolean hasOptions(String string) {
        return string.indexOf(59) > 0;
    }

    public boolean hasOption(String string) {
        return Attribute.hasOption(this.name, string);
    }

    public static boolean hasOption(String string, String string2) {
        Set<String> set = Attribute.getOptions(string);
        for (String string3 : set) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getOptions() {
        return Attribute.getOptions(this.name);
    }

    public static Set<String> getOptions(String string) {
        int n = string.indexOf(59);
        if (n > 0) {
            int n2;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            while ((n2 = string.indexOf(59, n + 1)) > 0) {
                linkedHashSet.add(string.substring(n + 1, n2));
                n = n2;
            }
            linkedHashSet.add(string.substring(n + 1));
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return Collections.emptySet();
    }

    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    public String getValue() {
        if (this.values.length == 0) {
            return null;
        }
        return this.values[0].stringValue();
    }

    public byte[] getValueByteArray() {
        if (this.values.length == 0) {
            return null;
        }
        return this.values[0].getValue();
    }

    public Boolean getValueAsBoolean() {
        if (this.values.length == 0) {
            return null;
        }
        String string = StaticUtils.toLowerCase(this.values[0].stringValue());
        if (string.equals("true") || string.equals("t") || string.equals("yes") || string.equals("y") || string.equals("on") || string.equals("1")) {
            return Boolean.TRUE;
        }
        if (string.equals("false") || string.equals("f") || string.equals("no") || string.equals("n") || string.equals("off") || string.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Date getValueAsDate() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime(this.values[0].stringValue());
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return null;
        }
    }

    public DN getValueAsDN() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return new DN(this.values[0].stringValue());
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return null;
        }
    }

    public Integer getValueAsInteger() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return Integer.valueOf(this.values[0].stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            Debug.debugException(numberFormatException);
            return null;
        }
    }

    public Long getValueAsLong() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return Long.valueOf(this.values[0].stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            Debug.debugException(numberFormatException);
            return null;
        }
    }

    public String[] getValues() {
        if (this.values.length == 0) {
            return StaticUtils.NO_STRINGS;
        }
        String[] stringArray = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringArray[i] = this.values[i].stringValue();
        }
        return stringArray;
    }

    public byte[][] getValueByteArrays() {
        if (this.values.length == 0) {
            return NO_BYTE_VALUES;
        }
        byte[][] byArrayArray = new byte[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            byArrayArray[i] = this.values[i].getValue();
        }
        return byArrayArray;
    }

    public ASN1OctetString[] getRawValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.values.length > 0;
    }

    public boolean hasValue(String string) {
        Validator.ensureNotNull(string);
        return this.hasValue(new ASN1OctetString(string), this.matchingRule);
    }

    public boolean hasValue(String string, MatchingRule matchingRule) {
        Validator.ensureNotNull(string);
        return this.hasValue(new ASN1OctetString(string), matchingRule);
    }

    public boolean hasValue(byte[] byArray) {
        Validator.ensureNotNull(byArray);
        return this.hasValue(new ASN1OctetString(byArray), this.matchingRule);
    }

    public boolean hasValue(byte[] byArray, MatchingRule matchingRule) {
        Validator.ensureNotNull(byArray);
        return this.hasValue(new ASN1OctetString(byArray), matchingRule);
    }

    boolean hasValue(ASN1OctetString aSN1OctetString) {
        return this.hasValue(aSN1OctetString, this.matchingRule);
    }

    boolean hasValue(ASN1OctetString aSN1OctetString, MatchingRule matchingRule) {
        for (ASN1OctetString aSN1OctetString2 : this.values) {
            try {
                if (!matchingRule.valuesMatch(aSN1OctetString2, aSN1OctetString)) continue;
                return true;
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                if (!aSN1OctetString2.equals(aSN1OctetString)) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.values.length;
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence();
        aSN1Buffer.addOctetString(this.name);
        ASN1BufferSet aSN1BufferSet = aSN1Buffer.beginSet();
        for (ASN1OctetString aSN1OctetString : this.values) {
            aSN1Buffer.addElement(aSN1OctetString);
        }
        aSN1BufferSet.end();
        aSN1BufferSequence.end();
    }

    public ASN1Sequence encode() {
        ASN1Element[] aSN1ElementArray = new ASN1Element[]{new ASN1OctetString(this.name), new ASN1Set(this.values)};
        return new ASN1Sequence(aSN1ElementArray);
    }

    public static Attribute readFrom(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return Attribute.readFrom(aSN1StreamReader, null);
    }

    public static Attribute readFrom(ASN1StreamReader aSN1StreamReader, Schema schema) throws LDAPException {
        try {
            Validator.ensureNotNull(aSN1StreamReader.beginSequence());
            String string = aSN1StreamReader.readString();
            Validator.ensureNotNull(string);
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(string, schema);
            ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>();
            ASN1StreamReaderSet aSN1StreamReaderSet = aSN1StreamReader.beginSet();
            while (aSN1StreamReaderSet.hasMoreElements()) {
                arrayList.add(new ASN1OctetString(aSN1StreamReader.readBytes()));
            }
            ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[arrayList.size()];
            arrayList.toArray(aSN1OctetStringArray);
            return new Attribute(string, matchingRule, aSN1OctetStringArray);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_ATTR_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public static Attribute decode(ASN1Sequence aSN1Sequence) throws LDAPException {
        ASN1Set aSN1Set;
        Validator.ensureNotNull(aSN1Sequence);
        ASN1Element[] aSN1ElementArray = aSN1Sequence.elements();
        if (aSN1ElementArray.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_ATTR_DECODE_INVALID_COUNT.get(aSN1ElementArray.length));
        }
        String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
        try {
            aSN1Set = ASN1Set.decodeAsSet(aSN1ElementArray[1]);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_ATTR_DECODE_VALUE_SET.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
        }
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1Set.elements().length];
        for (int i = 0; i < aSN1OctetStringArray.length; ++i) {
            aSN1OctetStringArray[i] = ASN1OctetString.decodeAsOctetString(aSN1Set.elements()[i]);
        }
        return new Attribute(string, (MatchingRule)CaseIgnoreStringMatchingRule.getInstance(), aSN1OctetStringArray);
    }

    public boolean needsBase64Encoding() {
        for (ASN1OctetString aSN1OctetString : this.values) {
            if (!Attribute.needsBase64Encoding(aSN1OctetString.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean needsBase64Encoding(String string) {
        return Attribute.needsBase64Encoding(StaticUtils.getBytes(string));
    }

    public static boolean needsBase64Encoding(byte[] byArray) {
        if (byArray.length == 0) {
            return false;
        }
        switch (byArray[0] & 0xFF) {
            case 32: 
            case 58: 
            case 60: {
                return true;
            }
        }
        if ((byArray[byArray.length - 1] & 0xFF) == 32) {
            return true;
        }
        for (byte by : byArray) {
            switch (by & 0xFF) {
                case 0: 
                case 10: 
                case 13: {
                    return true;
                }
            }
            if ((by & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n = StaticUtils.toLowerCase(this.name).hashCode();
            for (ASN1OctetString aSN1OctetString : this.values) {
                try {
                    n += this.matchingRule.normalize(aSN1OctetString).hashCode();
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    n += aSN1OctetString.hashCode();
                }
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        block14: {
            Attribute attribute;
            block13: {
                if (object == null) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Attribute)) {
                    return false;
                }
                attribute = (Attribute)object;
                if (!this.name.equalsIgnoreCase(attribute.name)) {
                    return false;
                }
                if (this.values.length != attribute.values.length) {
                    return false;
                }
                if (this.values.length <= 10) break block13;
                HashSet hashSet = new HashSet(this.values.length);
                Collections.addAll(hashSet, this.values);
                HashSet<ASN1OctetString> hashSet2 = null;
                for (ASN1OctetString aSN1OctetString : attribute.values) {
                    if (hashSet.remove(aSN1OctetString)) continue;
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<ASN1OctetString>(this.values.length);
                    }
                    try {
                        hashSet2.add(this.matchingRule.normalize(aSN1OctetString));
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        return false;
                    }
                }
                if (hashSet2 == null) break block14;
                for (ASN1OctetString aSN1OctetString : hashSet) {
                    try {
                        if (hashSet2.contains(this.matchingRule.normalize(aSN1OctetString))) continue;
                        return false;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        return false;
                    }
                }
                break block14;
            }
            for (ASN1OctetString aSN1OctetString : this.values) {
                if (attribute.hasValue(aSN1OctetString)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("Attribute(name=");
        stringBuilder.append(this.name);
        if (this.values.length == 0) {
            stringBuilder.append(", values={");
        } else if (this.needsBase64Encoding()) {
            stringBuilder.append(", base64Values={'");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuilder.append("', '");
                }
                stringBuilder.append(Base64.encode(this.values[i].getValue()));
            }
            stringBuilder.append('\'');
        } else {
            stringBuilder.append(", values={'");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuilder.append("', '");
                }
                stringBuilder.append(this.values[i].stringValue());
            }
            stringBuilder.append('\'');
        }
        stringBuilder.append("})");
    }
}

