/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncCompareHelper;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompareRequest
extends UpdatableLDAPRequest
implements ReadOnlyCompareRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = 6343453776330347024L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private ASN1OctetString assertionValue;
    private int messageID = -1;
    private String attributeName;
    private String dn;

    public CompareRequest(String string, String string2, String string3) {
        super(null);
        Validator.ensureNotNull(string, string2, string3);
        this.dn = string;
        this.attributeName = string2;
        this.assertionValue = new ASN1OctetString(string3);
    }

    public CompareRequest(String string, String string2, byte[] byArray) {
        super(null);
        Validator.ensureNotNull(string, string2, byArray);
        this.dn = string;
        this.attributeName = string2;
        this.assertionValue = new ASN1OctetString(byArray);
    }

    public CompareRequest(DN dN, String string, String string2) {
        super(null);
        Validator.ensureNotNull(dN, string, string2);
        this.dn = dN.toString();
        this.attributeName = string;
        this.assertionValue = new ASN1OctetString(string2);
    }

    public CompareRequest(DN dN, String string, byte[] byArray) {
        super(null);
        Validator.ensureNotNull(dN, string, byArray);
        this.dn = dN.toString();
        this.attributeName = string;
        this.assertionValue = new ASN1OctetString(byArray);
    }

    public CompareRequest(String string, String string2, String string3, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, string2, string3);
        this.dn = string;
        this.attributeName = string2;
        this.assertionValue = new ASN1OctetString(string3);
    }

    public CompareRequest(String string, String string2, byte[] byArray, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, string2, byArray);
        this.dn = string;
        this.attributeName = string2;
        this.assertionValue = new ASN1OctetString(byArray);
    }

    public CompareRequest(DN dN, String string, String string2, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, string, string2);
        this.dn = dN.toString();
        this.attributeName = string;
        this.assertionValue = new ASN1OctetString(string2);
    }

    public CompareRequest(DN dN, String string, ASN1OctetString aSN1OctetString, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, string, aSN1OctetString);
        this.dn = dN.toString();
        this.attributeName = string;
        this.assertionValue = aSN1OctetString;
    }

    public CompareRequest(DN dN, String string, byte[] byArray, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, string, byArray);
        this.dn = dN.toString();
        this.attributeName = string;
        this.assertionValue = new ASN1OctetString(byArray);
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String string) {
        Validator.ensureNotNull(string);
        this.dn = string;
    }

    public void setDN(DN dN) {
        Validator.ensureNotNull(dN);
        this.dn = dN.toString();
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String string) {
        Validator.ensureNotNull(string);
        this.attributeName = string;
    }

    @Override
    public String getAssertionValue() {
        return this.assertionValue.stringValue();
    }

    @Override
    public byte[] getAssertionValueBytes() {
        return this.assertionValue.getValue();
    }

    @Override
    public ASN1OctetString getRawAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(String string) {
        Validator.ensureNotNull(string);
        this.assertionValue = new ASN1OctetString(string);
    }

    public void setAssertionValue(byte[] byArray) {
        Validator.ensureNotNull(byArray);
        this.assertionValue = new ASN1OctetString(byArray);
    }

    public void setAssertionValue(ASN1OctetString aSN1OctetString) {
        this.assertionValue = aSN1OctetString;
    }

    @Override
    public byte getProtocolOpType() {
        return 110;
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)110);
        aSN1Buffer.addOctetString(this.dn);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        aSN1Buffer.addOctetString(this.attributeName);
        aSN1Buffer.addElement(this.assertionValue);
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] aSN1ElementArray = new ASN1Element[]{new ASN1OctetString(this.attributeName), this.assertionValue};
        ASN1Element[] aSN1ElementArray2 = new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1Sequence(aSN1ElementArray)};
        return new ASN1Sequence(110, aSN1ElementArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompareResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            boolean bl = lDAPConnection.getConnectionOptions().autoReconnect();
            return this.processSync(lDAPConnection, n, bl);
        }
        long l = System.nanoTime();
        this.processAsync(lDAPConnection, null);
        try {
            LDAPResponse lDAPResponse;
            try {
                long l2 = this.getResponseTimeoutMillis(lDAPConnection);
                lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_COMPARE_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            CompareResult compareResult = this.handleResponse(lDAPConnection, lDAPResponse, l, n, false);
            return compareResult;
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection lDAPConnection, AsyncCompareResultListener asyncCompareResultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (asyncCompareResultListener == null) {
            asyncRequestID = null;
            lDAPConnection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncCompareHelper asyncCompareHelper = new AsyncCompareHelper(lDAPConnection, this.messageID, asyncCompareResultListener, this.getIntermediateResponseListener());
            lDAPConnection.registerResponseAcceptor(this.messageID, asyncCompareHelper);
            asyncRequestID = asyncCompareHelper.getAsyncRequestID();
            long l = this.getResponseTimeoutMillis(lDAPConnection);
            if (l > 0L) {
                Timer timer = lDAPConnection.getTimer();
                AsyncTimeoutTimerTask asyncTimeoutTimerTask = new AsyncTimeoutTimerTask(asyncCompareHelper);
                timer.schedule((TimerTask)asyncTimeoutTimerTask, l);
                asyncRequestID.setTimerTask(asyncTimeoutTimerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(this);
            lDAPConnection.getConnectionStatistics().incrementNumCompareRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            return asyncRequestID;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            throw lDAPException;
        }
    }

    private CompareResult processSync(LDAPConnection lDAPConnection, int n, boolean bl) throws LDAPException {
        LDAPResponse lDAPResponse;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(lDAPConnection));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        long l = System.nanoTime();
        Debug.debugLDAPRequest(this);
        lDAPConnection.getConnectionStatistics().incrementNumCompareRequests();
        try {
            lDAPConnection.sendMessage(lDAPMessage);
        }
        catch (LDAPException lDAPException) {
            CompareResult compareResult;
            Debug.debugException(lDAPException);
            if (bl && (compareResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                return compareResult;
            }
            throw lDAPException;
        }
        while (true) {
            try {
                lDAPResponse = lDAPConnection.readResponse(this.messageID);
            }
            catch (LDAPException lDAPException) {
                CompareResult compareResult;
                Debug.debugException(lDAPException);
                if (lDAPException.getResultCode() == ResultCode.TIMEOUT && lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                if (bl && (compareResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                    return compareResult;
                }
                throw lDAPException;
            }
            if (!(lDAPResponse instanceof IntermediateResponse)) break;
            IntermediateResponseListener intermediateResponseListener = this.getIntermediateResponseListener();
            if (intermediateResponseListener == null) continue;
            intermediateResponseListener.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l, n, bl);
    }

    private CompareResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l, int n, boolean bl) throws LDAPException {
        CompareResult compareResult;
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                lDAPConnection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_COMPARE_CLIENT_TIMEOUT.get(l2, this.messageID, this.dn, lDAPConnection.getHostPort()));
        }
        lDAPConnection.getConnectionStatistics().incrementNumCompareResponses(System.nanoTime() - l);
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            Serializable serializable;
            if (bl && (serializable = this.reconnectAndRetry(lDAPConnection, n, ResultCode.SERVER_DOWN)) != null) {
                return serializable;
            }
            serializable = (ConnectionClosedResponse)lDAPResponse;
            String string = ((ConnectionClosedResponse)serializable).getMessage();
            if (string == null) {
                throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_COMPARE_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_COMPARE_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        CompareResult compareResult2 = lDAPResponse instanceof CompareResult ? (CompareResult)lDAPResponse : new CompareResult((LDAPResult)lDAPResponse);
        if (compareResult2.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(lDAPConnection)) {
            if (n >= lDAPConnection.getConnectionOptions().getReferralHopLimit()) {
                return new CompareResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), compareResult2.getMatchedDN(), compareResult2.getReferralURLs(), compareResult2.getResponseControls());
            }
            return this.followReferral(compareResult2, lDAPConnection, n);
        }
        if (bl && (compareResult = this.reconnectAndRetry(lDAPConnection, n, compareResult2.getResultCode())) != null) {
            return compareResult;
        }
        return compareResult2;
    }

    private CompareResult reconnectAndRetry(LDAPConnection lDAPConnection, int n, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    lDAPConnection.reconnect();
                    return this.processSync(lDAPConnection, n, false);
                }
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompareResult followReferral(CompareResult compareResult, LDAPConnection lDAPConnection, int n) throws LDAPException {
        for (String string : compareResult.getReferralURLs()) {
            LDAPURL lDAPURL = new LDAPURL(string);
            String string2 = lDAPURL.getHost();
            if (string2 == null) continue;
            CompareRequest compareRequest = lDAPURL.baseDNProvided() ? new CompareRequest(lDAPURL.getBaseDN(), this.attributeName, this.assertionValue, this.getControls()) : this;
            LDAPConnection lDAPConnection2 = lDAPConnection.getReferralConnector().getReferralConnection(lDAPURL, lDAPConnection);
            try {
                CompareResult compareResult2 = compareRequest.process(lDAPConnection2, n + 1);
                lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                lDAPConnection2.close();
                return compareResult2;
            }
            catch (Throwable throwable) {
                try {
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
        }
        return compareResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @Override
    public CompareRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public CompareRequest duplicate(Control[] controlArray) {
        CompareRequest compareRequest = new CompareRequest(this.dn, this.attributeName, this.assertionValue.getValue(), controlArray);
        if (this.followReferralsInternal() != null) {
            compareRequest.setFollowReferrals(this.followReferralsInternal());
        }
        compareRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return compareRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("CompareRequest(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', attr='");
        stringBuilder.append(this.attributeName);
        stringBuilder.append("', value='");
        stringBuilder.append(this.assertionValue.stringValue());
        stringBuilder.append('\'');
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(3);
        arrayList.add(ToCodeArgHelper.createString(this.dn, "Entry DN"));
        arrayList.add(ToCodeArgHelper.createString(this.attributeName, "Attribute Name"));
        if (StaticUtils.isSensitiveToCodeAttribute(this.attributeName)) {
            arrayList.add(ToCodeArgHelper.createString("---redacted-value", "Assertion Value (Redacted because " + this.attributeName + " is " + "configured as a sensitive attribute)"));
        } else if (StaticUtils.isPrintableString(this.assertionValue.getValue())) {
            arrayList.add(ToCodeArgHelper.createString(this.assertionValue.stringValue(), "Assertion Value"));
        } else {
            arrayList.add(ToCodeArgHelper.createByteArray(this.assertionValue.getValue(), true, "Assertion Value"));
        }
        ToCodeHelper.generateMethodCall(list, n, "CompareRequest", string + "Request", "new CompareRequest", arrayList);
        for (Control control : this.getControls()) {
            ToCodeHelper.generateMethodCall(list, n, null, null, string + "Request.addControl", ToCodeArgHelper.createControl(control, null));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string2 = stringBuilder.toString();
            list.add("");
            list.add(string2 + "try");
            list.add(string2 + '{');
            list.add(string2 + "  CompareResult " + string + "Result = connection.compare(" + string + "Request);");
            list.add(string2 + "  // The compare was processed successfully.");
            list.add(string2 + "  boolean compareMatched = " + string + "Result.compareMatched();");
            list.add(string2 + '}');
            list.add(string2 + "catch (LDAPException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The compare failed.  Maybe the following " + "will help explain why.");
            list.add(string2 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string2 + "  String message = e.getMessage();");
            list.add(string2 + "  String matchedDN = e.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string2 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string2 + '}');
        }
    }
}

