/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

final class ConnectThread
extends Thread {
    private final AtomicBoolean connected;
    private final AtomicReference<Socket> socket;
    private final AtomicReference<Thread> thread;
    private final AtomicReference<Throwable> exception;
    private final CountDownLatch startLatch;
    private final int connectTimeoutMillis;
    private final int port;
    private final SocketFactory socketFactory;
    private final InetAddress address;

    ConnectThread(SocketFactory socketFactory, InetAddress inetAddress, int n, int n2) {
        super("Background connect thread for " + inetAddress + ':' + n);
        this.setDaemon(true);
        this.socketFactory = socketFactory;
        this.address = inetAddress;
        this.port = n;
        this.connectTimeoutMillis = n2;
        this.connected = new AtomicBoolean(false);
        this.socket = new AtomicReference();
        this.thread = new AtomicReference();
        this.exception = new AtomicReference();
        this.startLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread.set(Thread.currentThread());
        this.startLatch.countDown();
        try {
            boolean bl;
            Socket socket;
            try {
                socket = this.socketFactory.createSocket();
                bl = true;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                socket = this.socketFactory.createSocket(this.address, this.port);
                bl = false;
            }
            this.socket.set(socket);
            if (bl) {
                socket.connect(new InetSocketAddress(this.address, this.port), this.connectTimeoutMillis);
            }
            this.connected.set(true);
        }
        catch (Throwable throwable) {
            Debug.debugException(throwable);
            this.exception.set(throwable);
        }
        finally {
            this.thread.set(null);
        }
    }

    Socket getConnectedSocket() throws LDAPException {
        Object object;
        Thread thread;
        if (this.startLatch.getCount() > 0L) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNECT_THREAD_INTERRUPTED.get(this.address.getHostAddress(), this.port, StaticUtils.getExceptionMessage(interruptedException)), interruptedException);
            }
        }
        if ((thread = this.thread.get()) != null) {
            try {
                thread.join(this.connectTimeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNECT_THREAD_INTERRUPTED.get(this.address.getHostAddress(), this.port, StaticUtils.getExceptionMessage(interruptedException)), interruptedException);
            }
        }
        if (this.connected.get()) {
            return this.socket.get();
        }
        try {
            if (thread != null) {
                thread.interrupt();
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        try {
            object = this.socket.get();
            if (object != null) {
                ((Socket)object).close();
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        object = this.exception.get();
        if (object == null) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_TIMEOUT.get(this.address, this.port, this.connectTimeoutMillis));
        }
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_EXCEPTION.get(this.address, this.port, StaticUtils.getExceptionMessage((Throwable)object)), (Throwable)object);
    }
}

