/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class Control
implements Serializable {
    private static final byte CONTROLS_TYPE = -96;
    private static final ConcurrentHashMap<String, DecodeableControl> decodeableControlMap;
    private static final long serialVersionUID = 4440956109070220054L;
    private final ASN1OctetString value;
    private final boolean isCritical;
    private final String oid;

    protected Control() {
        this.oid = null;
        this.isCritical = true;
        this.value = null;
    }

    protected Control(Control control) {
        this.oid = control.oid;
        this.isCritical = control.isCritical;
        this.value = control.value;
    }

    public Control(String string) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.isCritical = false;
        this.value = null;
    }

    public Control(String string, boolean bl) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.isCritical = bl;
        this.value = null;
    }

    public Control(String string, boolean bl, ASN1OctetString aSN1OctetString) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.isCritical = bl;
        this.value = aSN1OctetString;
    }

    public final String getOID() {
        return this.oid;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence();
        aSN1Buffer.addOctetString(this.oid);
        if (this.isCritical) {
            aSN1Buffer.addBoolean(true);
        }
        if (this.value != null) {
            aSN1Buffer.addOctetString(this.value.getValue());
        }
        aSN1BufferSequence.end();
    }

    public final ASN1Sequence encode() {
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
        arrayList.add(new ASN1OctetString(this.oid));
        if (this.isCritical) {
            arrayList.add(new ASN1Boolean(this.isCritical));
        }
        if (this.value != null) {
            arrayList.add(new ASN1OctetString(this.value.getValue()));
        }
        return new ASN1Sequence(arrayList);
    }

    public static Control readFrom(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            String string = aSN1StreamReader.readString();
            boolean bl = false;
            ASN1OctetString aSN1OctetString = null;
            block7: while (aSN1StreamReaderSequence.hasMoreElements()) {
                byte by = (byte)aSN1StreamReader.peek();
                switch (by) {
                    case 1: {
                        bl = aSN1StreamReader.readBoolean();
                        continue block7;
                    }
                    case 4: {
                        aSN1OctetString = new ASN1OctetString(aSN1StreamReader.readBytes());
                        continue block7;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_INVALID_TYPE.get(StaticUtils.toHex(by)));
            }
            return Control.decode(string, bl, aSN1OctetString);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public static Control decode(ASN1Sequence aSN1Sequence) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        boolean bl;
        String string;
        block10: {
            ASN1Element[] aSN1ElementArray;
            block11: {
                aSN1ElementArray = aSN1Sequence.elements();
                if (aSN1ElementArray.length < 1 || aSN1ElementArray.length > 3) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_DECODE_INVALID_ELEMENT_COUNT.get(aSN1ElementArray.length));
                }
                string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
                bl = false;
                aSN1OctetString = null;
                if (aSN1ElementArray.length != 2) break block11;
                switch (aSN1ElementArray[1].getType()) {
                    case 1: {
                        try {
                            bl = ASN1Boolean.decodeAsBoolean(aSN1ElementArray[1]).booleanValue();
                            break block10;
                        }
                        catch (ASN1Exception aSN1Exception) {
                            Debug.debugException(aSN1Exception);
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_DECODE_CRITICALITY.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                        }
                    }
                    case 4: {
                        aSN1OctetString = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]);
                        break block10;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_INVALID_TYPE.get(StaticUtils.toHex(aSN1ElementArray[1].getType())));
                    }
                }
            }
            if (aSN1ElementArray.length == 3) {
                try {
                    bl = ASN1Boolean.decodeAsBoolean(aSN1ElementArray[1]).booleanValue();
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_DECODE_CRITICALITY.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                aSN1OctetString = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[2]);
            }
        }
        return Control.decode(string, bl, aSN1OctetString);
    }

    public static Control decode(String string, boolean bl, ASN1OctetString aSN1OctetString) throws LDAPException {
        DecodeableControl decodeableControl = decodeableControlMap.get(string);
        if (decodeableControl == null) {
            return new Control(string, bl, aSN1OctetString);
        }
        try {
            return decodeableControl.decodeControl(string, bl, aSN1OctetString);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return new Control(string, bl, aSN1OctetString);
        }
    }

    public static ASN1Sequence encodeControls(Control[] controlArray) {
        ASN1Element[] aSN1ElementArray = new ASN1Sequence[controlArray.length];
        for (int i = 0; i < controlArray.length; ++i) {
            aSN1ElementArray[i] = controlArray[i].encode();
        }
        return new ASN1Sequence(-96, aSN1ElementArray);
    }

    public static Control[] decodeControls(ASN1Sequence aSN1Sequence) throws LDAPException {
        ASN1Element[] aSN1ElementArray = aSN1Sequence.elements();
        Control[] controlArray = new Control[aSN1ElementArray.length];
        for (int i = 0; i < aSN1ElementArray.length; ++i) {
            try {
                controlArray[i] = Control.decode(ASN1Sequence.decodeAsSequence(aSN1ElementArray[i]));
                continue;
            }
            catch (ASN1Exception aSN1Exception) {
                Debug.debugException(aSN1Exception);
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROLS_DECODE_ELEMENT_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
            }
        }
        return controlArray;
    }

    public static void registerDecodeableControl(String string, DecodeableControl decodeableControl) {
        decodeableControlMap.put(string, decodeableControl);
    }

    public static void deregisterDecodeableControl(String string) {
        decodeableControlMap.remove(string);
    }

    public final int hashCode() {
        int n = this.oid.hashCode();
        if (this.isCritical) {
            ++n;
        }
        if (this.value != null) {
            n += this.value.hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Control)) {
            return false;
        }
        Control control = (Control)object;
        if (!this.oid.equals(control.oid)) {
            return false;
        }
        if (this.isCritical != control.isCritical) {
            return false;
        }
        if (this.value == null) {
            if (control.value != null) {
                return false;
            }
        } else {
            if (control.value == null) {
                return false;
            }
            if (!this.value.equals(control.value)) {
                return false;
            }
        }
        return true;
    }

    public String getControlName() {
        return this.oid;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("Control(oid=");
        stringBuilder.append(this.oid);
        stringBuilder.append(", isCritical=");
        stringBuilder.append(this.isCritical);
        stringBuilder.append(", value=");
        if (this.value == null) {
            stringBuilder.append("{null}");
        } else {
            stringBuilder.append("{byte[");
            stringBuilder.append(this.value.getValue().length);
            stringBuilder.append("]}");
        }
        stringBuilder.append(')');
    }

    static {
        GenericDeclaration genericDeclaration;
        Class<?> clazz;
        decodeableControlMap = new ConcurrentHashMap();
        try {
            clazz = Class.forName("com.unboundid.ldap.sdk.controls.ControlHelper");
            genericDeclaration = clazz.getMethod("registerDefaultResponseControls", new Class[0]);
            ((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz = Class.forName("com.unboundid.ldap.sdk.experimental.ControlHelper");
            genericDeclaration = clazz.getMethod("registerDefaultResponseControls", new Class[0]);
            ((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz = Class.forName("com.unboundid.ldap.sdk.unboundidds.controls.ControlHelper");
            genericDeclaration = clazz.getMethod("registerDefaultResponseControls", new Class[0]);
            ((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            try {
                genericDeclaration = Class.forName("com.unboundid.ldap.sdk.experimental.ControlHelper");
                Method method = ((Class)genericDeclaration).getMethod("registerNonCommercialResponseControls", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

