/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DisconnectHandler;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.concurrent.atomic.AtomicBoolean;

final class DisconnectInfo {
    private final AtomicBoolean handlerNotified;
    private final DisconnectType type;
    private final int port;
    private final LDAPConnection connection;
    private final String host;
    private final String message;
    private final Throwable cause;

    DisconnectInfo(LDAPConnection lDAPConnection, DisconnectType disconnectType, String string, Throwable throwable) {
        Validator.ensureNotNull(lDAPConnection);
        Validator.ensureNotNull((Object)disconnectType);
        this.connection = lDAPConnection;
        this.type = disconnectType;
        this.message = string;
        this.cause = throwable;
        this.handlerNotified = new AtomicBoolean(false);
        this.host = lDAPConnection.getConnectedAddress();
        this.port = lDAPConnection.getConnectedPort();
    }

    DisconnectType getType() {
        return this.type;
    }

    String getMessage() {
        return this.message;
    }

    Throwable getCause() {
        return this.cause;
    }

    void notifyDisconnectHandler() {
        boolean bl = this.handlerNotified.getAndSet(true);
        if (bl) {
            return;
        }
        DisconnectHandler disconnectHandler = this.connection.getConnectionOptions().getDisconnectHandler();
        if (disconnectHandler != null) {
            disconnectHandler.handleDisconnect(this.connection, this.host, this.port, this.type, this.message, this.cause);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    void toString(StringBuilder stringBuilder) {
        stringBuilder.append("DisconnectInfo(type=");
        stringBuilder.append(this.type.name());
        if (this.message != null) {
            stringBuilder.append(", message='");
            stringBuilder.append(this.message);
            stringBuilder.append('\'');
        }
        if (this.cause != null) {
            stringBuilder.append(", cause=");
            stringBuilder.append(StaticUtils.getExceptionMessage(this.cause));
        }
        stringBuilder.append(')');
    }
}

