/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry
implements LDIFRecord {
    private static final long serialVersionUID = -4438809025903729197L;
    private volatile DN parsedDN;
    private final LinkedHashMap<String, Attribute> attributes;
    private final Schema schema;
    private String dn;

    protected Entry(Entry entry) {
        this.parsedDN = entry.parsedDN;
        this.attributes = entry.attributes;
        this.schema = entry.schema;
        this.dn = entry.dn;
    }

    public Entry(String string) {
        this(string, (Schema)null);
    }

    public Entry(String string, Schema schema) {
        Validator.ensureNotNull(string);
        this.dn = string;
        this.schema = schema;
        this.attributes = new LinkedHashMap();
    }

    public Entry(DN dN) {
        this(dN, (Schema)null);
    }

    public Entry(DN dN, Schema schema) {
        Validator.ensureNotNull(dN);
        this.parsedDN = dN;
        this.dn = this.parsedDN.toString();
        this.schema = schema;
        this.attributes = new LinkedHashMap();
    }

    public Entry(String string, Attribute ... attributeArray) {
        this(string, (Schema)null, attributeArray);
    }

    public Entry(String string, Schema schema, Attribute ... attributeArray) {
        Validator.ensureNotNull(string, attributeArray);
        this.dn = string;
        this.schema = schema;
        this.attributes = new LinkedHashMap(attributeArray.length);
        for (Attribute attribute : attributeArray) {
            String string2 = StaticUtils.toLowerCase(attribute.getName());
            Attribute attribute2 = this.attributes.get(string2);
            if (attribute2 == null) {
                this.attributes.put(string2, attribute);
                continue;
            }
            this.attributes.put(string2, Attribute.mergeAttributes(attribute2, attribute));
        }
    }

    public Entry(DN dN, Attribute ... attributeArray) {
        this(dN, (Schema)null, attributeArray);
    }

    public Entry(DN dN, Schema schema, Attribute ... attributeArray) {
        Validator.ensureNotNull(dN, attributeArray);
        this.parsedDN = dN;
        this.dn = this.parsedDN.toString();
        this.schema = schema;
        this.attributes = new LinkedHashMap(attributeArray.length);
        for (Attribute attribute : attributeArray) {
            String string = StaticUtils.toLowerCase(attribute.getName());
            Attribute attribute2 = this.attributes.get(string);
            if (attribute2 == null) {
                this.attributes.put(string, attribute);
                continue;
            }
            this.attributes.put(string, Attribute.mergeAttributes(attribute2, attribute));
        }
    }

    public Entry(String string, Collection<Attribute> collection) {
        this(string, null, collection);
    }

    public Entry(String string, Schema schema, Collection<Attribute> collection) {
        Validator.ensureNotNull(string, collection);
        this.dn = string;
        this.schema = schema;
        this.attributes = new LinkedHashMap(collection.size());
        for (Attribute attribute : collection) {
            String string2 = StaticUtils.toLowerCase(attribute.getName());
            Attribute attribute2 = this.attributes.get(string2);
            if (attribute2 == null) {
                this.attributes.put(string2, attribute);
                continue;
            }
            this.attributes.put(string2, Attribute.mergeAttributes(attribute2, attribute));
        }
    }

    public Entry(DN dN, Collection<Attribute> collection) {
        this(dN, null, collection);
    }

    public Entry(DN dN, Schema schema, Collection<Attribute> collection) {
        Validator.ensureNotNull(dN, collection);
        this.parsedDN = dN;
        this.dn = this.parsedDN.toString();
        this.schema = schema;
        this.attributes = new LinkedHashMap(collection.size());
        for (Attribute attribute : collection) {
            String string = StaticUtils.toLowerCase(attribute.getName());
            Attribute attribute2 = this.attributes.get(string);
            if (attribute2 == null) {
                this.attributes.put(string, attribute);
                continue;
            }
            this.attributes.put(string, Attribute.mergeAttributes(attribute2, attribute));
        }
    }

    public Entry(String ... stringArray) throws LDIFException {
        this((Schema)null, stringArray);
    }

    public Entry(Schema schema, String ... stringArray) throws LDIFException {
        Entry entry = LDIFReader.decodeEntry(false, schema, stringArray);
        this.schema = schema;
        this.dn = entry.dn;
        this.parsedDN = entry.parsedDN;
        this.attributes = entry.attributes;
    }

    @Override
    public final String getDN() {
        return this.dn;
    }

    public void setDN(String string) {
        Validator.ensureNotNull(string);
        this.dn = string;
        this.parsedDN = null;
    }

    public void setDN(DN dN) {
        Validator.ensureNotNull(dN);
        this.parsedDN = dN;
        this.dn = this.parsedDN.toString();
    }

    @Override
    public final DN getParsedDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn, this.schema);
        }
        return this.parsedDN;
    }

    public final RDN getRDN() throws LDAPException {
        return this.getParsedDN().getRDN();
    }

    public final DN getParentDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn, this.schema);
        }
        return this.parsedDN.getParent();
    }

    public final String getParentDNString() throws LDAPException {
        DN dN;
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn, this.schema);
        }
        if ((dN = this.parsedDN.getParent()) == null) {
            return null;
        }
        return dN.toString();
    }

    protected Schema getSchema() {
        return this.schema;
    }

    public final boolean hasAttribute(String string) {
        return this.hasAttribute(string, this.schema);
    }

    public final boolean hasAttribute(String string, Schema schema) {
        Validator.ensureNotNull(string);
        if (this.attributes.containsKey(StaticUtils.toLowerCase(string))) {
            return true;
        }
        if (schema != null) {
            String string2;
            String string3;
            int n = string.indexOf(59);
            if (n > 0) {
                string3 = string.substring(0, n);
                string2 = StaticUtils.toLowerCase(string.substring(n));
            } else {
                string3 = string;
                string2 = "";
            }
            AttributeTypeDefinition attributeTypeDefinition = schema.getAttributeType(string3);
            if (attributeTypeDefinition != null) {
                if (this.attributes.containsKey(StaticUtils.toLowerCase(attributeTypeDefinition.getOID()) + string2)) {
                    return true;
                }
                for (String string4 : attributeTypeDefinition.getNames()) {
                    if (!this.attributes.containsKey(StaticUtils.toLowerCase(string4) + string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean hasAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        String string = StaticUtils.toLowerCase(attribute.getName());
        Attribute attribute2 = this.attributes.get(string);
        return attribute2 != null && attribute2.equals(attribute);
    }

    public final boolean hasAttributeValue(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        return attribute != null && attribute.hasValue(string2);
    }

    public final boolean hasAttributeValue(String string, String string2, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, string2);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        return attribute != null && attribute.hasValue(string2, matchingRule);
    }

    public final boolean hasAttributeValue(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        return attribute != null && attribute.hasValue(byArray);
    }

    public final boolean hasAttributeValue(String string, byte[] byArray, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, byArray);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        return attribute != null && attribute.hasValue(byArray, matchingRule);
    }

    public final boolean hasObjectClass(String string) {
        return this.hasAttributeValue("objectClass", string);
    }

    public final Collection<Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public final Attribute getAttribute(String string) {
        return this.getAttribute(string, this.schema);
    }

    public final Attribute getAttribute(String string, Schema schema) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null && schema != null) {
            String string2;
            String string3;
            int n = string.indexOf(59);
            if (n > 0) {
                string3 = string.substring(0, n);
                string2 = StaticUtils.toLowerCase(string.substring(n));
            } else {
                string3 = string;
                string2 = "";
            }
            AttributeTypeDefinition attributeTypeDefinition = schema.getAttributeType(string3);
            if (attributeTypeDefinition == null) {
                return null;
            }
            attribute = this.attributes.get(StaticUtils.toLowerCase(attributeTypeDefinition.getOID() + string2));
            if (attribute == null) {
                for (String string4 : attributeTypeDefinition.getNames()) {
                    attribute = this.attributes.get(StaticUtils.toLowerCase(string4) + string2);
                    if (attribute == null) continue;
                    return attribute;
                }
            }
            return attribute;
        }
        return attribute;
    }

    public final List<Attribute> getAttributesWithOptions(String string, Set<String> set) {
        Validator.ensureNotNull(string);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(10);
        for (Attribute attribute : this.attributes.values()) {
            if (!attribute.getBaseName().equalsIgnoreCase(string)) continue;
            if (set == null || set.isEmpty()) {
                arrayList.add(attribute);
                continue;
            }
            boolean bl = true;
            for (String string2 : set) {
                if (attribute.hasOption(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(attribute);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String getAttributeValue(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public byte[] getAttributeValueBytes(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueByteArray();
    }

    public Boolean getAttributeValueAsBoolean(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsBoolean();
    }

    public Date getAttributeValueAsDate(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsDate();
    }

    public DN getAttributeValueAsDN(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsDN();
    }

    public Integer getAttributeValueAsInteger(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsInteger();
    }

    public Long getAttributeValueAsLong(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsLong();
    }

    public String[] getAttributeValues(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValues();
    }

    public byte[][] getAttributeValueByteArrays(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.attributes.get(StaticUtils.toLowerCase(string));
        if (attribute == null) {
            return null;
        }
        return attribute.getValueByteArrays();
    }

    public final Attribute getObjectClassAttribute() {
        return this.getAttribute("objectClass");
    }

    public final String[] getObjectClassValues() {
        return this.getAttributeValues("objectClass");
    }

    public boolean addAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        String string = StaticUtils.toLowerCase(attribute.getName());
        Attribute attribute2 = this.attributes.get(string);
        if (attribute2 == null) {
            this.attributes.put(string, attribute);
            return true;
        }
        Attribute attribute3 = Attribute.mergeAttributes(attribute2, attribute);
        this.attributes.put(string, attribute3);
        return attribute2.getRawValues().length != attribute3.getRawValues().length;
    }

    public boolean addAttribute(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        return this.addAttribute(new Attribute(string, this.schema, string2));
    }

    public boolean addAttribute(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        return this.addAttribute(new Attribute(string, this.schema, (byte[][])new byte[][]{byArray}));
    }

    public boolean addAttribute(String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        return this.addAttribute(new Attribute(string, this.schema, stringArray));
    }

    public boolean addAttribute(String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        return this.addAttribute(new Attribute(string, this.schema, byArray));
    }

    public boolean addAttribute(String string, Collection<String> collection) {
        Validator.ensureNotNull(string, collection);
        return this.addAttribute(new Attribute(string, this.schema, collection));
    }

    public boolean removeAttribute(String string) {
        Validator.ensureNotNull(string);
        if (this.schema == null) {
            return this.attributes.remove(StaticUtils.toLowerCase(string)) != null;
        }
        Attribute attribute = this.getAttribute(string, this.schema);
        if (attribute == null) {
            return false;
        }
        this.attributes.remove(StaticUtils.toLowerCase(attribute.getName()));
        return true;
    }

    public boolean removeAttributeValue(String string, String string2) {
        return this.removeAttributeValue(string, string2, null);
    }

    public boolean removeAttributeValue(String string, String string2, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, string2);
        Attribute attribute = this.getAttribute(string, this.schema);
        if (attribute == null) {
            return false;
        }
        String string3 = StaticUtils.toLowerCase(attribute.getName());
        Attribute attribute2 = Attribute.removeValues(attribute, new Attribute(string, string2), matchingRule);
        if (attribute2.hasValue()) {
            this.attributes.put(string3, attribute2);
        } else {
            this.attributes.remove(string3);
        }
        return attribute.getRawValues().length != attribute2.getRawValues().length;
    }

    public boolean removeAttributeValue(String string, byte[] byArray) {
        return this.removeAttributeValue(string, byArray, null);
    }

    public boolean removeAttributeValue(String string, byte[] byArray, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, byArray);
        Attribute attribute = this.getAttribute(string, this.schema);
        if (attribute == null) {
            return false;
        }
        String string2 = StaticUtils.toLowerCase(attribute.getName());
        Attribute attribute2 = Attribute.removeValues(attribute, new Attribute(string, byArray), matchingRule);
        if (attribute2.hasValue()) {
            this.attributes.put(string2, attribute2);
        } else {
            this.attributes.remove(string2);
        }
        return attribute.getRawValues().length != attribute2.getRawValues().length;
    }

    public boolean removeAttributeValues(String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        Attribute attribute = this.getAttribute(string, this.schema);
        if (attribute == null) {
            return false;
        }
        String string2 = StaticUtils.toLowerCase(attribute.getName());
        Attribute attribute2 = Attribute.removeValues(attribute, new Attribute(string, stringArray));
        if (attribute2.hasValue()) {
            this.attributes.put(string2, attribute2);
        } else {
            this.attributes.remove(string2);
        }
        return attribute.getRawValues().length != attribute2.getRawValues().length;
    }

    public boolean removeAttributeValues(String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        Attribute attribute = this.getAttribute(string, this.schema);
        if (attribute == null) {
            return false;
        }
        String string2 = StaticUtils.toLowerCase(attribute.getName());
        Attribute attribute2 = Attribute.removeValues(attribute, new Attribute(string, byArray));
        if (attribute2.hasValue()) {
            this.attributes.put(string2, attribute2);
        } else {
            this.attributes.remove(string2);
        }
        return attribute.getRawValues().length != attribute2.getRawValues().length;
    }

    public void setAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        Attribute attribute2 = this.getAttribute(attribute.getName(), this.schema);
        String string = attribute2 == null ? StaticUtils.toLowerCase(attribute.getName()) : StaticUtils.toLowerCase(attribute2.getName());
        this.attributes.put(string, attribute);
    }

    public void setAttribute(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        this.setAttribute(new Attribute(string, this.schema, string2));
    }

    public void setAttribute(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        this.setAttribute(new Attribute(string, this.schema, (byte[][])new byte[][]{byArray}));
    }

    public void setAttribute(String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        this.setAttribute(new Attribute(string, this.schema, stringArray));
    }

    public void setAttribute(String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        this.setAttribute(new Attribute(string, this.schema, byArray));
    }

    public void setAttribute(String string, Collection<String> collection) {
        Validator.ensureNotNull(string, collection);
        this.setAttribute(new Attribute(string, this.schema, collection));
    }

    public boolean matchesBaseAndScope(String string, SearchScope searchScope) throws LDAPException {
        return this.getParsedDN().matchesBaseAndScope(new DN(string), searchScope);
    }

    public boolean matchesBaseAndScope(DN dN, SearchScope searchScope) throws LDAPException {
        return this.getParsedDN().matchesBaseAndScope(dN, searchScope);
    }

    public static List<Modification> diff(Entry entry, Entry entry2, boolean bl, String ... stringArray) {
        return Entry.diff(entry, entry2, bl, true, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Modification> diff(Entry entry, Entry entry2, boolean bl, boolean bl2, String ... stringArray) {
        void var10_25;
        ASN1OctetString[] aSN1OctetStringArray;
        void var9_17;
        ASN1OctetString[] aSN1OctetStringArray2;
        Object object;
        HashSet<String> hashSet = null;
        if (stringArray != null && stringArray.length > 0) {
            hashSet = new HashSet<String>(stringArray.length);
            for (String object32 : stringArray) {
                hashSet.add(StaticUtils.toLowerCase(Attribute.getBaseName(object32)));
            }
        }
        String[] stringArray2 = new LinkedHashMap();
        LinkedHashMap<String, Attribute> linkedHashMap = new LinkedHashMap<String, Attribute>();
        LinkedHashMap<String, Attribute> linkedHashMap2 = new LinkedHashMap<String, Attribute>();
        for (Map.Entry<String, Attribute> entry3 : entry.attributes.entrySet()) {
            object = StaticUtils.toLowerCase(entry3.getKey());
            if (hashSet != null && !hashSet.contains(Attribute.getBaseName((String)object))) continue;
            stringArray2.put(object, entry3.getValue());
            linkedHashMap2.put((String)object, entry3.getValue());
        }
        for (Map.Entry<String, Attribute> entry4 : entry2.attributes.entrySet()) {
            object = StaticUtils.toLowerCase(entry4.getKey());
            if (hashSet != null && !hashSet.contains(Attribute.getBaseName((String)object)) || stringArray2.remove(object) != null) continue;
            linkedHashMap.put((String)object, entry4.getValue());
        }
        for (String string : stringArray2.keySet()) {
            linkedHashMap2.remove(string);
        }
        Object var9_15 = null;
        Object var10_23 = null;
        if (bl) {
            try {
                RDN rDN = entry.getRDN();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            try {
                RDN rDN = entry2.getRDN();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        object = new ArrayList(10);
        for (Attribute attribute : stringArray2.values()) {
            if (bl2) {
                aSN1OctetStringArray2 = attribute.getRawValues();
                if (var9_17 != null && var9_17.hasAttribute(attribute.getName())) {
                    aSN1OctetStringArray = new ArrayList(aSN1OctetStringArray2.length);
                    for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray2) {
                        if (var9_17.hasAttributeValue(attribute.getName(), aSN1OctetString.getValue())) continue;
                        aSN1OctetStringArray.add(aSN1OctetString);
                    }
                    if (aSN1OctetStringArray.isEmpty()) continue;
                    aSN1OctetStringArray2 = new ASN1OctetString[aSN1OctetStringArray.size()];
                    aSN1OctetStringArray.toArray(aSN1OctetStringArray2);
                }
                ((ArrayList)object).add(new Modification(ModificationType.DELETE, attribute.getName(), aSN1OctetStringArray2));
                continue;
            }
            ((ArrayList)object).add(new Modification(ModificationType.REPLACE, attribute.getName()));
        }
        for (Attribute attribute : linkedHashMap.values()) {
            aSN1OctetStringArray2 = attribute.getRawValues();
            if (var10_25 != null && var10_25.hasAttribute(attribute.getName())) {
                aSN1OctetStringArray = new ArrayList(aSN1OctetStringArray2.length);
                for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray2) {
                    if (var10_25.hasAttributeValue(attribute.getName(), aSN1OctetString.getValue())) continue;
                    aSN1OctetStringArray.add(aSN1OctetString);
                }
                if (aSN1OctetStringArray.isEmpty()) continue;
                aSN1OctetStringArray2 = new ASN1OctetString[aSN1OctetStringArray.size()];
                aSN1OctetStringArray.toArray(aSN1OctetStringArray2);
            }
            if (bl2) {
                ((ArrayList)object).add(new Modification(ModificationType.ADD, attribute.getName(), aSN1OctetStringArray2));
                continue;
            }
            ((ArrayList)object).add(new Modification(ModificationType.REPLACE, attribute.getName(), aSN1OctetStringArray2));
        }
        for (Attribute attribute : linkedHashMap2.values()) {
            if (attribute.equals(aSN1OctetStringArray2 = entry2.getAttribute(attribute.getName()))) continue;
            if (bl2 || var10_25 != null && var10_25.hasAttribute(aSN1OctetStringArray2.getName())) {
                ASN1OctetString[] aSN1OctetStringArray3;
                void var19_45;
                aSN1OctetStringArray = attribute.getRawValues();
                LinkedHashMap linkedHashMap3 = new LinkedHashMap(aSN1OctetStringArray.length);
                ASN1OctetString[] aSN1OctetStringArray4 = aSN1OctetStringArray;
                int n = aSN1OctetStringArray4.length;
                boolean bl3 = false;
                while (var19_45 < n) {
                    ASN1OctetString aSN1OctetString = aSN1OctetStringArray4[var19_45];
                    try {
                        linkedHashMap3.put(attribute.getMatchingRule().normalize(aSN1OctetString), aSN1OctetString);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        linkedHashMap3.put(aSN1OctetString, aSN1OctetString);
                    }
                    ++var19_45;
                }
                aSN1OctetStringArray4 = aSN1OctetStringArray2.getRawValues();
                LinkedHashMap<ASN1OctetString, ASN1OctetString> linkedHashMap4 = new LinkedHashMap<ASN1OctetString, ASN1OctetString>(aSN1OctetStringArray4.length);
                for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray4) {
                    try {
                        linkedHashMap4.put(attribute.getMatchingRule().normalize(aSN1OctetString), aSN1OctetString);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        linkedHashMap4.put(aSN1OctetString, aSN1OctetString);
                    }
                }
                Iterator iterator = linkedHashMap3.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry5 = iterator.next();
                    if (linkedHashMap4.remove(entry5.getKey()) != null) {
                        iterator.remove();
                        continue;
                    }
                    if (var9_17 == null || !var9_17.hasAttributeValue(attribute.getName(), ((ASN1OctetString)entry5.getValue()).getValue())) continue;
                    iterator.remove();
                }
                Iterator iterator2 = linkedHashMap4.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry6 = iterator2.next();
                    if (var10_25 == null || !var10_25.hasAttributeValue(aSN1OctetStringArray2.getName(), ((ASN1OctetString)entry6.getValue()).getValue())) continue;
                    iterator2.remove();
                }
                ArrayList arrayList = new ArrayList(linkedHashMap4.values());
                ArrayList arrayList2 = new ArrayList(linkedHashMap3.values());
                if (!arrayList.isEmpty()) {
                    aSN1OctetStringArray3 = new ASN1OctetString[arrayList.size()];
                    ((ArrayList)object).add(new Modification(ModificationType.ADD, aSN1OctetStringArray2.getName(), arrayList.toArray(aSN1OctetStringArray3)));
                }
                if (arrayList2.isEmpty()) continue;
                aSN1OctetStringArray3 = new ASN1OctetString[arrayList2.size()];
                ((ArrayList)object).add(new Modification(ModificationType.DELETE, attribute.getName(), arrayList2.toArray(aSN1OctetStringArray3)));
                continue;
            }
            ((ArrayList)object).add(new Modification(ModificationType.REPLACE, aSN1OctetStringArray2.getName(), aSN1OctetStringArray2.getRawValues()));
        }
        return object;
    }

    public static Entry mergeEntries(Entry ... entryArray) {
        Validator.ensureNotNull(entryArray);
        Validator.ensureTrue(entryArray.length > 0);
        Entry entry = entryArray[0].duplicate();
        for (int i = 1; i < entryArray.length; ++i) {
            for (Attribute attribute : entryArray[i].attributes.values()) {
                entry.addAttribute(attribute);
            }
        }
        return entry;
    }

    public static Entry intersectEntries(Entry ... entryArray) {
        Validator.ensureNotNull(entryArray);
        Validator.ensureTrue(entryArray.length > 0);
        Entry entry = entryArray[0].duplicate();
        for (Attribute attribute : entryArray[0].attributes.values()) {
            String string = attribute.getName();
            block1: for (byte[] byArray : attribute.getValueByteArrays()) {
                for (int i = 1; i < entryArray.length; ++i) {
                    if (entryArray[i].hasAttributeValue(string, byArray)) continue;
                    entry.removeAttributeValue(string, byArray);
                    continue block1;
                }
            }
        }
        return entry;
    }

    public static Entry applyModifications(Entry entry, boolean bl, Modification ... modificationArray) throws LDAPException {
        Validator.ensureNotNull(entry, modificationArray);
        Validator.ensureFalse(modificationArray.length == 0);
        return Entry.applyModifications(entry, bl, Arrays.asList(modificationArray));
    }

    public static Entry applyModifications(Entry entry, boolean bl, List<Modification> list) throws LDAPException {
        Validator.ensureNotNull(entry, list);
        Validator.ensureFalse(list.isEmpty());
        Entry entry2 = entry.duplicate();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        ResultCode resultCode = null;
        RDN rDN = null;
        try {
            rDN = entry.getRDN();
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
        }
        block12: for (Modification object : list) {
            String i = object.getAttributeName();
            byte[][] byArray = object.getValueByteArrays();
            switch (object.getModificationType().intValue()) {
                case 0: {
                    if (bl) {
                        entry2.addAttribute(object.getAttribute());
                        break;
                    }
                    if (byArray.length == 0) {
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_ADD_NO_VALUES.get(i));
                    }
                    for (int bl2 = 0; bl2 < byArray.length; ++bl2) {
                        if (entry2.addAttribute(i, byArray[bl2])) continue;
                        if (resultCode == null) {
                            resultCode = ResultCode.ATTRIBUTE_OR_VALUE_EXISTS;
                        }
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_ADD_EXISTING.get(object.getValues()[bl2], i));
                    }
                    continue block12;
                }
                case 1: {
                    if (byArray.length == 0) {
                        boolean i2 = entry2.removeAttribute(i);
                        if (bl || i2) continue block12;
                        if (resultCode == null) {
                            resultCode = ResultCode.NO_SUCH_ATTRIBUTE;
                        }
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_DELETE_NONEXISTENT_ATTR.get(i));
                        break;
                    }
                    for (int attribute = 0; attribute < byArray.length; ++attribute) {
                        boolean object2 = entry2.removeAttributeValue(i, byArray[attribute]);
                        if (bl || object2) continue;
                        if (resultCode == null) {
                            resultCode = ResultCode.NO_SUCH_ATTRIBUTE;
                        }
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_DELETE_NONEXISTENT_VALUE.get(object.getValues()[attribute], i));
                    }
                    continue block12;
                }
                case 2: {
                    if (byArray.length == 0) {
                        entry2.removeAttribute(i);
                        break;
                    }
                    entry2.setAttribute(object.getAttribute());
                    break;
                }
                case 3: {
                    BigInteger numberFormatException;
                    Object object2;
                    Attribute attribute = entry2.getAttribute(i);
                    if (attribute == null || !attribute.hasValue()) {
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_NO_SUCH_ATTR.get(i));
                        continue block12;
                    }
                    if (attribute.size() > 1) {
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_NOT_SINGLE_VALUED.get(i));
                        continue block12;
                    }
                    if (rDN != null && rDN.hasAttribute(i)) {
                        object2 = LDAPMessages.ERR_ENTRY_APPLY_MODS_TARGETS_RDN.get(entry.getDN());
                        if (!arrayList.contains(object2)) {
                            arrayList.add((String)object2);
                        }
                        if (resultCode != null) continue block12;
                        resultCode = ResultCode.NOT_ALLOWED_ON_RDN;
                        continue block12;
                    }
                    try {
                        object2 = new BigInteger(attribute.getValue());
                    }
                    catch (NumberFormatException numberFormatException2) {
                        Debug.debugException(numberFormatException2);
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_ENTRY_VALUE_NOT_INTEGER.get(i, attribute.getValue()));
                        continue block12;
                    }
                    if (byArray.length == 0) {
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_NO_MOD_VALUES.get(i));
                        continue block12;
                    }
                    if (byArray.length > 1) {
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_MULTIPLE_MOD_VALUES.get(i));
                        continue block12;
                    }
                    String string = object.getValues()[0];
                    try {
                        numberFormatException = new BigInteger(string);
                    }
                    catch (NumberFormatException numberFormatException3) {
                        Debug.debugException(numberFormatException3);
                        arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_MOD_VALUE_NOT_INTEGER.get(i, string));
                        continue block12;
                    }
                    numberFormatException = ((BigInteger)object2).add(numberFormatException);
                    entry2.setAttribute(i, numberFormatException.toString());
                    break;
                }
                default: {
                    arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_UNKNOWN_TYPE.get(String.valueOf(object.getModificationType())));
                }
            }
        }
        if (rDN != null) {
            String[] stringArray = rDN.getAttributeNames();
            byte[][] byArray = rDN.getByteArrayAttributeValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (entry2.hasAttributeValue(stringArray[i], byArray[i])) continue;
                arrayList.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_TARGETS_RDN.get(entry.getDN()));
                if (resultCode != null) break;
                resultCode = ResultCode.NOT_ALLOWED_ON_RDN;
                break;
            }
        }
        if (arrayList.isEmpty()) {
            return entry2;
        }
        if (resultCode == null) {
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
        }
        throw new LDAPException(resultCode, LDAPMessages.ERR_ENTRY_APPLY_MODS_FAILURE.get(entry2.getDN(), StaticUtils.concatenateStrings(arrayList)));
    }

    public static Entry applyModifyDN(Entry entry, String string, boolean bl) throws LDAPException {
        return Entry.applyModifyDN(entry, string, bl, null);
    }

    public static Entry applyModifyDN(Entry entry, String string, boolean bl, String string2) throws LDAPException {
        int n;
        byte[][] byArray;
        String[] stringArray;
        Validator.ensureNotNull(entry);
        Validator.ensureNotNull(string);
        DN dN = entry.getParsedDN();
        RDN rDN = dN.getRDN();
        DN dN2 = dN.getParent();
        RDN rDN2 = new RDN(string);
        DN dN3 = string2 == null ? dN2 : new DN(string2);
        Entry entry2 = entry.duplicate();
        if (dN3 == null) {
            entry2.setDN(new DN(rDN2));
        } else {
            entry2.setDN(new DN(rDN2, dN3));
        }
        if (bl && rDN != null) {
            stringArray = rDN.getAttributeNames();
            byArray = rDN.getByteArrayAttributeValues();
            for (n = 0; n < stringArray.length; ++n) {
                if (rDN2.hasAttributeValue(stringArray[n], byArray[n])) continue;
                entry2.removeAttributeValue(stringArray[n], byArray[n]);
            }
        }
        stringArray = rDN2.getAttributeNames();
        byArray = rDN2.getByteArrayAttributeValues();
        for (n = 0; n < stringArray.length; ++n) {
            if (rDN != null && rDN.hasAttributeValue(stringArray[n], byArray[n])) continue;
            entry2.addAttribute(stringArray[n], byArray[n]);
        }
        return entry2;
    }

    public int hashCode() {
        int n = 0;
        try {
            n += this.getParsedDN().hashCode();
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            n += this.dn.hashCode();
        }
        for (Attribute attribute : this.attributes.values()) {
            n += attribute.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        Entry entry;
        block8: {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            entry = (Entry)object;
            try {
                DN dN = this.getParsedDN();
                DN serializable = entry.getParsedDN();
                if (!dN.equals(serializable)) {
                    return false;
                }
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                if (this.dn.equals(entry.dn)) break block8;
                return false;
            }
        }
        if (this.attributes.size() != entry.attributes.size()) {
            return false;
        }
        for (Attribute attribute : this.attributes.values()) {
            if (entry.hasAttribute(attribute)) continue;
            return false;
        }
        return true;
    }

    public Entry duplicate() {
        return new Entry(this.dn, this.schema, this.attributes.values());
    }

    @Override
    public final String[] toLDIF() {
        return this.toLDIF(0);
    }

    @Override
    public final String[] toLDIF(int n) {
        List<String> list = new ArrayList<String>(2 * this.attributes.size());
        Entry.encodeNameAndValue("dn", new ASN1OctetString(this.dn), list);
        for (Attribute attribute : this.attributes.values()) {
            String string = attribute.getName();
            for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                Entry.encodeNameAndValue(string, aSN1OctetString, list);
            }
        }
        if (n > 2) {
            list = LDIFWriter.wrapLines(n, list);
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    private static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, List<String> list) {
        String string2 = LDIFWriter.encodeNameAndValue(string, aSN1OctetString);
        if (LDIFWriter.commentAboutBase64EncodedValues() && string2.startsWith(string + "::")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                list.add(stringTokenizer.nextToken());
            }
        } else {
            list.add(string2);
        }
    }

    @Override
    public final void toLDIF(ByteStringBuffer byteStringBuffer) {
        this.toLDIF(byteStringBuffer, 0);
    }

    @Override
    public final void toLDIF(ByteStringBuffer byteStringBuffer, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.dn), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        for (Attribute attribute : this.attributes.values()) {
            String string = attribute.getName();
            for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                LDIFWriter.encodeNameAndValue(string, aSN1OctetString, byteStringBuffer, n);
                byteStringBuffer.append(StaticUtils.EOL_BYTES);
            }
        }
    }

    @Override
    public final String toLDIFString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIFString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    @Override
    public final String toLDIFString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIFString(stringBuilder, n);
        return stringBuilder.toString();
    }

    @Override
    public final void toLDIFString(StringBuilder stringBuilder) {
        this.toLDIFString(stringBuilder, 0);
    }

    @Override
    public final void toLDIFString(StringBuilder stringBuilder, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.dn), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        for (Attribute attribute : this.attributes.values()) {
            String string = attribute.getName();
            for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder, n);
                stringBuilder.append(StaticUtils.EOL);
            }
        }
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("Entry(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', attributes={");
        Iterator<Attribute> iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("})");
    }
}

