/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericSASLBindRequest
extends SASLBindRequest {
    private static final long serialVersionUID = 7740968332104559230L;
    private final ASN1OctetString credentials;
    private final String bindDN;
    private final String mechanism;

    public GenericSASLBindRequest(String string, String string2, ASN1OctetString aSN1OctetString, Control ... controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string2);
        this.bindDN = string;
        this.mechanism = string2;
        this.credentials = aSN1OctetString;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    @Override
    public String getSASLMechanismName() {
        return this.mechanism;
    }

    public ASN1OctetString getCredentials() {
        return this.credentials;
    }

    @Override
    protected BindResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        return this.sendBindRequest(lDAPConnection, this.bindDN, this.credentials, this.getControls(), this.getResponseTimeoutMillis(lDAPConnection));
    }

    @Override
    public GenericSASLBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public GenericSASLBindRequest duplicate(Control[] controlArray) {
        return new GenericSASLBindRequest(this.bindDN, this.mechanism, this.credentials, controlArray);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        Control[] controlArray;
        stringBuilder.append("GenericSASLBindRequest(mechanism='");
        stringBuilder.append(this.mechanism);
        stringBuilder.append('\'');
        if (this.bindDN != null) {
            stringBuilder.append(", bindDN='");
            stringBuilder.append(this.bindDN);
            stringBuilder.append('\'');
        }
        if (this.credentials != null) {
            stringBuilder.append(", credentials=byte[");
            stringBuilder.append(this.credentials.getValueLength());
            stringBuilder.append(']');
        }
        if ((controlArray = this.getControls()).length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(4);
        arrayList.add(ToCodeArgHelper.createString(this.bindDN, "Bind DN"));
        arrayList.add(ToCodeArgHelper.createString(this.mechanism, "SASL Mechanism Name"));
        arrayList.add(ToCodeArgHelper.createByteArray("---redacted-SASL-credentials".getBytes(), true, "SASL Credentials"));
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            arrayList.add(ToCodeArgHelper.createControlArray(controlArray, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(list, n, "GenericSASLBindRequest", string + "Request", "new GenericSASLBindRequest", arrayList);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string2 = stringBuilder.toString();
            list.add("");
            list.add(string2 + '{');
            list.add(string2 + "  BindResult " + string + "Result = connection.bind(" + string + "Request);");
            list.add(string2 + "  // The bind was processed successfully.");
            list.add(string2 + '}');
            list.add(string2 + "catch (SASLBindInProgressException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The SASL bind requires multiple stages.  " + "Continue it here.");
            list.add(string2 + "  // Do not attempt to use the connection for " + "any other purpose until bind processing has completed.");
            list.add(string2 + '}');
            list.add(string2 + "catch (LDAPException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The bind failed.  Maybe the following will " + "help explain why.");
            list.add(string2 + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            list.add(string2 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string2 + "  String message = e.getMessage();");
            list.add(string2 + "  String matchedDN = e.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string2 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string2 + '}');
        }
    }
}

