/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.extensions.CancelExtendedRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.InternalUseOnly;
import javax.net.ssl.SSLSocketFactory;

@InternalUseOnly
public final class InternalSDKHelper {
    private InternalSDKHelper() {
    }

    @InternalUseOnly
    public static void setSoTimeout(LDAPConnection lDAPConnection, int n) throws LDAPException {
        LDAPConnectionReader lDAPConnectionReader = lDAPConnection.getConnectionInternals(true).getConnectionReader();
        if (lDAPConnectionReader != null) {
            lDAPConnectionReader.setSoTimeout(n);
        }
    }

    @InternalUseOnly
    public static void convertToTLS(LDAPConnection lDAPConnection, SSLSocketFactory sSLSocketFactory) throws LDAPException {
        lDAPConnection.convertToTLS(sSLSocketFactory);
    }

    @InternalUseOnly
    public static AsyncRequestID createAsyncRequestID(int n, LDAPConnection lDAPConnection) {
        return new AsyncRequestID(n, lDAPConnection);
    }

    @InternalUseOnly
    public static void cancel(LDAPConnection lDAPConnection, int n, Control ... controlArray) throws LDAPException {
        CancelExtendedRequest cancelExtendedRequest = new CancelExtendedRequest(n);
        lDAPConnection.sendMessage(new LDAPMessage(lDAPConnection.nextMessageID(), (ProtocolOp)new ExtendedRequest(cancelExtendedRequest), controlArray));
    }

    @InternalUseOnly
    public static LDAPResult readLDAPResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return LDAPResult.readLDAPResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static BindResult readBindResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return BindResult.readBindResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static CompareResult readCompareResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return CompareResult.readCompareResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static ExtendedResult readExtendedResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return ExtendedResult.readExtendedResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static SearchResultEntry readSearchResultEntryFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader, Schema schema) throws LDAPException {
        return SearchResultEntry.readSearchEntryFrom(n, aSN1StreamReaderSequence, aSN1StreamReader, schema);
    }

    @InternalUseOnly
    public static SearchResultReference readSearchResultReferenceFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return SearchResultReference.readSearchReferenceFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static SearchResult readSearchResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return SearchResult.readSearchResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static IntermediateResponse readIntermediateResponseFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        return IntermediateResponse.readFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
    }

    @InternalUseOnly
    public static Boolean followReferralsInternal(LDAPRequest lDAPRequest) {
        return lDAPRequest.followReferralsInternal();
    }

    @InternalUseOnly
    public static int nextMessageID(LDAPConnection lDAPConnection) {
        return lDAPConnection.nextMessageID();
    }

    @InternalUseOnly
    public static BindRequest getLastBindRequest(LDAPConnection lDAPConnection) {
        return lDAPConnection.getLastBindRequest();
    }

    @InternalUseOnly
    public static Schema getEntrySchema(Entry entry) {
        return entry.getSchema();
    }
}

