/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DiscardAsyncListener;
import com.unboundid.ldap.sdk.DisconnectInfo;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPConnectionStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SASLBindInProgressException;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.SynchronizedSSLSocketFactory;
import com.unboundid.util.SynchronizedSocketFactory;
import com.unboundid.util.Validator;
import com.unboundid.util.WeakHashSet;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPConnection
implements LDAPInterface,
ReferralConnector,
Closeable {
    private static final AtomicLong NEXT_CONNECTION_ID = new AtomicLong(0L);
    private static final SocketFactory DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    private static final WeakHashSet<Schema> SCHEMA_SET = new WeakHashSet();
    private AbstractConnectionPool connectionPool;
    private final AtomicBoolean needsReconnect = new AtomicBoolean(false);
    private final AtomicReference<DisconnectInfo> disconnectInfo = new AtomicReference();
    private volatile BindRequest lastBindRequest;
    private volatile boolean closeRequested;
    private volatile boolean unbindRequestSent;
    private volatile ExtendedRequest startTLSRequest;
    private int reconnectPort = -1;
    private volatile LDAPConnectionInternals connectionInternals;
    private LDAPConnectionOptions connectionOptions;
    private final LDAPConnectionStatistics connectionStatistics;
    private final long connectionID = NEXT_CONNECTION_ID.getAndIncrement();
    private long lastReconnectTime;
    private volatile long lastCommunicationTime = -1L;
    private Map<String, Object> attachments;
    private volatile ReferralConnector referralConnector;
    private volatile Schema cachedSchema;
    private SocketFactory lastUsedSocketFactory;
    private volatile SocketFactory socketFactory;
    private StackTraceElement[] connectStackTrace;
    private String connectionName;
    private String connectionPoolName;
    private String hostPort;
    private String reconnectAddress;
    private Timer timer;

    public LDAPConnection() {
        this(null, null);
    }

    public LDAPConnection(LDAPConnectionOptions lDAPConnectionOptions) {
        this(null, lDAPConnectionOptions);
    }

    public LDAPConnection(SocketFactory socketFactory) {
        this(socketFactory, null);
    }

    public LDAPConnection(SocketFactory socketFactory, LDAPConnectionOptions lDAPConnectionOptions) {
        this.connectionOptions = lDAPConnectionOptions == null ? new LDAPConnectionOptions() : lDAPConnectionOptions.duplicate();
        SocketFactory socketFactory2 = socketFactory == null ? DEFAULT_SOCKET_FACTORY : socketFactory;
        this.socketFactory = this.connectionOptions.allowConcurrentSocketFactoryUse() ? socketFactory2 : (socketFactory2 instanceof SSLSocketFactory ? new SynchronizedSSLSocketFactory((SSLSocketFactory)socketFactory2) : new SynchronizedSocketFactory(socketFactory2));
        this.attachments = null;
        this.connectionStatistics = new LDAPConnectionStatistics();
        this.connectionName = null;
        this.connectionPoolName = null;
        this.cachedSchema = null;
        this.timer = null;
        this.referralConnector = this.connectionOptions.getReferralConnector();
        if (this.referralConnector == null) {
            this.referralConnector = this;
        }
    }

    public LDAPConnection(String string, int n) throws LDAPException {
        this(null, null, string, n);
    }

    public LDAPConnection(LDAPConnectionOptions lDAPConnectionOptions, String string, int n) throws LDAPException {
        this(null, lDAPConnectionOptions, string, n);
    }

    public LDAPConnection(SocketFactory socketFactory, String string, int n) throws LDAPException {
        this(socketFactory, null, string, n);
    }

    public LDAPConnection(SocketFactory socketFactory, LDAPConnectionOptions lDAPConnectionOptions, String string, int n) throws LDAPException {
        this(socketFactory, lDAPConnectionOptions);
        this.connect(string, n);
    }

    public LDAPConnection(String string, int n, String string2, String string3) throws LDAPException {
        this(null, null, string, n, string2, string3);
    }

    public LDAPConnection(LDAPConnectionOptions lDAPConnectionOptions, String string, int n, String string2, String string3) throws LDAPException {
        this(null, lDAPConnectionOptions, string, n, string2, string3);
    }

    public LDAPConnection(SocketFactory socketFactory, String string, int n, String string2, String string3) throws LDAPException {
        this(socketFactory, null, string, n, string2, string3);
    }

    public LDAPConnection(SocketFactory socketFactory, LDAPConnectionOptions lDAPConnectionOptions, String string, int n, String string2, String string3) throws LDAPException {
        this(socketFactory, lDAPConnectionOptions, string, n);
        try {
            this.bind(new SimpleBindRequest(string2, string3));
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, lDAPException);
            this.close();
            throw lDAPException;
        }
    }

    public void connect(String string, int n) throws LDAPException {
        this.connect(string, n, this.connectionOptions.getConnectTimeoutMillis());
    }

    public void connect(String string, int n, int n2) throws LDAPException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_RESOLVE_ERROR.get(string, StaticUtils.getExceptionMessage(exception)), exception);
        }
        this.connect(string, inetAddress, n, n2);
    }

    public void connect(InetAddress inetAddress, int n, int n2) throws LDAPException {
        this.connect(inetAddress.getHostName(), inetAddress, n, n2);
    }

    public void connect(String string, InetAddress inetAddress, int n, int n2) throws LDAPException {
        Validator.ensureNotNull(string, inetAddress, n);
        this.needsReconnect.set(false);
        this.hostPort = string + ':' + n;
        this.lastCommunicationTime = -1L;
        this.startTLSRequest = null;
        if (this.isConnected()) {
            this.setDisconnectInfo(DisconnectType.RECONNECT, null, null);
            this.close();
        }
        this.lastUsedSocketFactory = this.socketFactory;
        this.reconnectAddress = string;
        this.reconnectPort = n;
        this.cachedSchema = null;
        this.unbindRequestSent = false;
        this.disconnectInfo.set(null);
        try {
            this.connectionStatistics.incrementNumConnects();
            this.connectionInternals = new LDAPConnectionInternals(this, this.connectionOptions, this.lastUsedSocketFactory, string, inetAddress, n, n2);
            this.connectionInternals.startConnectionReader();
            this.lastCommunicationTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            this.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, exception);
            this.connectionInternals = null;
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_CONNECT_ERROR.get(this.getHostPort(), String.valueOf(exception)), exception);
        }
        if (this.connectionOptions.useSchema()) {
            try {
                this.cachedSchema = LDAPConnection.getCachedSchema(this);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
    }

    public void reconnect() throws LDAPException {
        ExtendedRequest extendedRequest;
        BindRequest bindRequest;
        block11: {
            this.needsReconnect.set(false);
            if (System.currentTimeMillis() - this.lastReconnectTime < 1000L) {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_MULTIPLE_FAILURES.get());
            }
            bindRequest = null;
            if (this.lastBindRequest != null && (bindRequest = this.lastBindRequest.getRebindRequest(this.reconnectAddress, this.reconnectPort)) == null) {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_CANNOT_REAUTHENTICATE.get(this.getHostPort()));
            }
            extendedRequest = this.startTLSRequest;
            this.setDisconnectInfo(DisconnectType.RECONNECT, null, null);
            this.terminate(null);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                if (!(exception instanceof InterruptedException)) break block11;
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONN_INTERRUPTED_DURINGR_RECONNECT.get(), exception);
            }
        }
        this.connect(this.reconnectAddress, this.reconnectPort);
        if (extendedRequest != null) {
            try {
                ExtendedResult extendedResult = this.processExtendedOperation(extendedRequest);
                if (extendedResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPException(extendedResult);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                this.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, null, lDAPException);
                this.terminate(null);
                throw lDAPException;
            }
        }
        if (bindRequest != null) {
            try {
                this.bind(bindRequest);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, lDAPException);
                this.terminate(null);
                throw lDAPException;
            }
        }
        this.lastReconnectTime = System.currentTimeMillis();
    }

    void setNeedsReconnect() {
        this.needsReconnect.set(true);
    }

    public boolean isConnected() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return false;
        }
        if (!lDAPConnectionInternals.isConnected()) {
            this.setClosed();
            return false;
        }
        return !this.needsReconnect.get();
    }

    void convertToTLS(SSLSocketFactory sSLSocketFactory) throws LDAPException {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        lDAPConnectionInternals.convertToTLS(sSLSocketFactory);
    }

    void applySASLQoP(SaslClient saslClient) throws LDAPException {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        lDAPConnectionInternals.applySASLQoP(saslClient);
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(LDAPConnectionOptions lDAPConnectionOptions) {
        Object object;
        if (lDAPConnectionOptions == null) {
            this.connectionOptions = new LDAPConnectionOptions();
        } else {
            object = lDAPConnectionOptions.duplicate();
            if (Debug.debugEnabled(DebugType.LDAP) && ((LDAPConnectionOptions)object).useSynchronousMode() && !lDAPConnectionOptions.useSynchronousMode() && this.isConnected()) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "A call to LDAPConnection.setConnectionOptions() with useSynchronousMode=true will have no effect for this connection because it is already established.  The useSynchronousMode option must be set before the connection is established to have any effect.");
            }
            this.connectionOptions = object;
        }
        object = this.connectionOptions.getReferralConnector();
        this.referralConnector = object == null ? this : object;
    }

    public SocketFactory getLastUsedSocketFactory() {
        return this.lastUsedSocketFactory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory == null ? DEFAULT_SOCKET_FACTORY : socketFactory;
    }

    public SSLSession getSSLSession() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return null;
        }
        Socket socket = lDAPConnectionInternals.getSocket();
        if (socket != null && socket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            return sSLSocket.getSession();
        }
        return null;
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        if (this.connectionPool == null) {
            this.connectionName = string;
            if (this.connectionInternals != null) {
                LDAPConnectionReader lDAPConnectionReader = this.connectionInternals.getConnectionReader();
                lDAPConnectionReader.updateThreadName();
            }
        }
    }

    public AbstractConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    void setConnectionPoolName(String string) {
        this.connectionPoolName = string;
        if (this.connectionInternals != null) {
            LDAPConnectionReader lDAPConnectionReader = this.connectionInternals.getConnectionReader();
            lDAPConnectionReader.updateThreadName();
        }
    }

    public String getHostPort() {
        if (this.hostPort == null) {
            return "";
        }
        return this.hostPort;
    }

    public String getConnectedAddress() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return null;
        }
        return lDAPConnectionInternals.getHost();
    }

    public String getConnectedIPAddress() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return null;
        }
        return lDAPConnectionInternals.getInetAddress().getHostAddress();
    }

    public InetAddress getConnectedInetAddress() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return null;
        }
        return lDAPConnectionInternals.getInetAddress();
    }

    public int getConnectedPort() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return -1;
        }
        return lDAPConnectionInternals.getPort();
    }

    public StackTraceElement[] getConnectStackTrace() {
        return this.connectStackTrace;
    }

    void setConnectStackTrace(StackTraceElement[] stackTraceElementArray) {
        this.connectStackTrace = stackTraceElementArray;
    }

    @Override
    public void close() {
        this.close(StaticUtils.NO_CONTROLS);
    }

    public void close(Control[] controlArray) {
        this.closeRequested = true;
        this.setDisconnectInfo(DisconnectType.UNBIND, null, null);
        if (this.connectionPool == null) {
            this.terminate(controlArray);
        } else {
            this.connectionPool.releaseDefunctConnection(this);
        }
    }

    void terminate(Control[] controlArray) {
        if (this.isConnected() && !this.unbindRequestSent) {
            try {
                this.unbindRequestSent = true;
                this.setDisconnectInfo(DisconnectType.UNBIND, null, null);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.INFO, DebugType.LDAP, "Sending LDAP unbind request.");
                }
                this.connectionStatistics.incrementNumUnbindRequests();
                this.sendMessage(new LDAPMessage(this.nextMessageID(), (ProtocolOp)new UnbindRequestProtocolOp(), controlArray));
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        this.setClosed();
    }

    boolean closeRequested() {
        return this.closeRequested;
    }

    boolean unbindRequestSent() {
        return this.unbindRequestSent;
    }

    void setConnectionPool(AbstractConnectionPool abstractConnectionPool) {
        this.connectionPool = abstractConnectionPool;
    }

    @Override
    public RootDSE getRootDSE() throws LDAPException {
        return RootDSE.getRootDSE(this);
    }

    @Override
    public Schema getSchema() throws LDAPException {
        return Schema.getSchema(this, "");
    }

    @Override
    public Schema getSchema(String string) throws LDAPException {
        return Schema.getSchema(this, string);
    }

    @Override
    public SearchResultEntry getEntry(String string) throws LDAPException {
        return this.getEntry(string, null);
    }

    @Override
    public SearchResultEntry getEntry(String string, String ... stringArray) throws LDAPException {
        SearchResult searchResult;
        List<SearchResultEntry> list;
        Filter filter = Filter.createPresenceFilter("objectClass");
        try {
            list = new SearchRequest(string, SearchScope.BASE, DereferencePolicy.NEVER, 1, 0, false, filter, stringArray);
            searchResult = this.search((SearchRequest)((Object)list));
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getResultCode().equals(ResultCode.NO_SUCH_OBJECT)) {
                return null;
            }
            throw lDAPException;
        }
        if (!searchResult.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPException(searchResult);
        }
        list = searchResult.getSearchEntries();
        if (list.isEmpty()) {
            return null;
        }
        return (SearchResultEntry)list.get(0);
    }

    public void abandon(AsyncRequestID asyncRequestID) throws LDAPException {
        this.abandon(asyncRequestID, null);
    }

    public void abandon(AsyncRequestID asyncRequestID, Control[] controlArray) throws LDAPException {
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Sending LDAP abandon request for message ID " + asyncRequestID);
        }
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ABANDON_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        int n = asyncRequestID.getMessageID();
        try {
            this.connectionInternals.getConnectionReader().deregisterResponseAcceptor(n);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        this.connectionStatistics.incrementNumAbandonRequests();
        this.sendMessage(new LDAPMessage(this.nextMessageID(), (ProtocolOp)new AbandonRequestProtocolOp(n), controlArray));
    }

    void abandon(int n, Control ... controlArray) throws LDAPException {
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.INFO, DebugType.LDAP, "Sending LDAP abandon request for message ID " + n);
        }
        try {
            this.connectionInternals.getConnectionReader().deregisterResponseAcceptor(n);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        this.connectionStatistics.incrementNumAbandonRequests();
        this.sendMessage(new LDAPMessage(this.nextMessageID(), (ProtocolOp)new AbandonRequestProtocolOp(n), controlArray));
    }

    @Override
    public LDAPResult add(String string, Attribute ... attributeArray) throws LDAPException {
        Validator.ensureNotNull(string, attributeArray);
        return this.add(new AddRequest(string, attributeArray));
    }

    @Override
    public LDAPResult add(String string, Collection<Attribute> collection) throws LDAPException {
        Validator.ensureNotNull(string, collection);
        return this.add(new AddRequest(string, collection));
    }

    @Override
    public LDAPResult add(Entry entry) throws LDAPException {
        Validator.ensureNotNull(entry);
        return this.add(new AddRequest(entry));
    }

    @Override
    public LDAPResult add(String ... stringArray) throws LDIFException, LDAPException {
        return this.add(new AddRequest(stringArray));
    }

    @Override
    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        Validator.ensureNotNull(addRequest);
        LDAPResult lDAPResult = addRequest.process(this, 1);
        switch (lDAPResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return lDAPResult;
            }
        }
        throw new LDAPException(lDAPResult);
    }

    @Override
    public LDAPResult add(ReadOnlyAddRequest readOnlyAddRequest) throws LDAPException {
        return this.add((AddRequest)readOnlyAddRequest);
    }

    public AsyncRequestID asyncAdd(AddRequest addRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        Validator.ensureNotNull(addRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener asyncResultListener2 = asyncResultListener == null ? DiscardAsyncListener.getInstance() : asyncResultListener;
        return addRequest.processAsync(this, asyncResultListener2);
    }

    public AsyncRequestID asyncAdd(ReadOnlyAddRequest readOnlyAddRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncAdd((AddRequest)readOnlyAddRequest, asyncResultListener);
    }

    public BindResult bind(String string, String string2) throws LDAPException {
        return this.bind(new SimpleBindRequest(string, string2));
    }

    public BindResult bind(BindRequest bindRequest) throws LDAPException {
        Validator.ensureNotNull(bindRequest);
        boolean bl = false;
        Object object = bindRequest.getControls();
        int n = ((Control[])object).length;
        for (int i = 0; i < n; ++i) {
            Control control = object[i];
            if (!control.getOID().equals("1.3.6.1.4.1.30221.2.5.3")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.lastBindRequest = null;
        }
        if (((LDAPResult)(object = bindRequest.process(this, 1))).getResultCode().equals(ResultCode.SUCCESS)) {
            if (!bl) {
                this.lastBindRequest = bindRequest;
                if (this.connectionOptions.useSchema()) {
                    try {
                        this.cachedSchema = LDAPConnection.getCachedSchema(this);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                    }
                }
            }
            return object;
        }
        if (((LDAPResult)object).getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) {
            throw new SASLBindInProgressException((BindResult)object);
        }
        throw new LDAPBindException((BindResult)object);
    }

    @Override
    public CompareResult compare(String string, String string2, String string3) throws LDAPException {
        Validator.ensureNotNull(string, string2, string3);
        return this.compare(new CompareRequest(string, string2, string3));
    }

    @Override
    public CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        Validator.ensureNotNull(compareRequest);
        CompareResult compareResult = compareRequest.process(this, 1);
        switch (compareResult.getResultCode().intValue()) {
            case 5: 
            case 6: {
                return new CompareResult(compareResult);
            }
        }
        throw new LDAPException(compareResult);
    }

    @Override
    public CompareResult compare(ReadOnlyCompareRequest readOnlyCompareRequest) throws LDAPException {
        return this.compare((CompareRequest)readOnlyCompareRequest);
    }

    public AsyncRequestID asyncCompare(CompareRequest compareRequest, AsyncCompareResultListener asyncCompareResultListener) throws LDAPException {
        Validator.ensureNotNull(compareRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncCompareResultListener asyncCompareResultListener2 = asyncCompareResultListener == null ? DiscardAsyncListener.getInstance() : asyncCompareResultListener;
        return compareRequest.processAsync(this, asyncCompareResultListener2);
    }

    public AsyncRequestID asyncCompare(ReadOnlyCompareRequest readOnlyCompareRequest, AsyncCompareResultListener asyncCompareResultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncCompare((CompareRequest)readOnlyCompareRequest, asyncCompareResultListener);
    }

    @Override
    public LDAPResult delete(String string) throws LDAPException {
        return this.delete(new DeleteRequest(string));
    }

    @Override
    public LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        Validator.ensureNotNull(deleteRequest);
        LDAPResult lDAPResult = deleteRequest.process(this, 1);
        switch (lDAPResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return lDAPResult;
            }
        }
        throw new LDAPException(lDAPResult);
    }

    @Override
    public LDAPResult delete(ReadOnlyDeleteRequest readOnlyDeleteRequest) throws LDAPException {
        return this.delete((DeleteRequest)readOnlyDeleteRequest);
    }

    public AsyncRequestID asyncDelete(DeleteRequest deleteRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        Validator.ensureNotNull(deleteRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener asyncResultListener2 = asyncResultListener == null ? DiscardAsyncListener.getInstance() : asyncResultListener;
        return deleteRequest.processAsync(this, asyncResultListener2);
    }

    public AsyncRequestID asyncDelete(ReadOnlyDeleteRequest readOnlyDeleteRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncDelete((DeleteRequest)readOnlyDeleteRequest, asyncResultListener);
    }

    public ExtendedResult processExtendedOperation(String string) throws LDAPException {
        Validator.ensureNotNull(string);
        return this.processExtendedOperation(new ExtendedRequest(string));
    }

    public ExtendedResult processExtendedOperation(String string, ASN1OctetString aSN1OctetString) throws LDAPException {
        Validator.ensureNotNull(string);
        return this.processExtendedOperation(new ExtendedRequest(string, aSN1OctetString));
    }

    public ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        Validator.ensureNotNull(extendedRequest);
        ExtendedResult extendedResult = extendedRequest.process(this, 1);
        if (extendedResult.getOID() == null && extendedResult.getValue() == null) {
            switch (extendedResult.getResultCode().intValue()) {
                case 1: 
                case 2: 
                case 51: 
                case 52: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: 
                case 91: {
                    throw new LDAPException(extendedResult);
                }
            }
        }
        if (extendedResult.getResultCode() == ResultCode.SUCCESS && extendedRequest.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            this.startTLSRequest = extendedRequest.duplicate();
        }
        return extendedResult;
    }

    @Override
    public LDAPResult modify(String string, Modification modification) throws LDAPException {
        Validator.ensureNotNull(string, modification);
        return this.modify(new ModifyRequest(string, modification));
    }

    @Override
    public LDAPResult modify(String string, Modification ... modificationArray) throws LDAPException {
        Validator.ensureNotNull(string, modificationArray);
        return this.modify(new ModifyRequest(string, modificationArray));
    }

    @Override
    public LDAPResult modify(String string, List<Modification> list) throws LDAPException {
        Validator.ensureNotNull(string, list);
        return this.modify(new ModifyRequest(string, list));
    }

    @Override
    public LDAPResult modify(String ... stringArray) throws LDIFException, LDAPException {
        Validator.ensureNotNull(stringArray);
        return this.modify(new ModifyRequest(stringArray));
    }

    @Override
    public LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        Validator.ensureNotNull(modifyRequest);
        LDAPResult lDAPResult = modifyRequest.process(this, 1);
        switch (lDAPResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return lDAPResult;
            }
        }
        throw new LDAPException(lDAPResult);
    }

    @Override
    public LDAPResult modify(ReadOnlyModifyRequest readOnlyModifyRequest) throws LDAPException {
        return this.modify((ModifyRequest)readOnlyModifyRequest);
    }

    public AsyncRequestID asyncModify(ModifyRequest modifyRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        Validator.ensureNotNull(modifyRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener asyncResultListener2 = asyncResultListener == null ? DiscardAsyncListener.getInstance() : asyncResultListener;
        return modifyRequest.processAsync(this, asyncResultListener2);
    }

    public AsyncRequestID asyncModify(ReadOnlyModifyRequest readOnlyModifyRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncModify((ModifyRequest)readOnlyModifyRequest, asyncResultListener);
    }

    @Override
    public LDAPResult modifyDN(String string, String string2, boolean bl) throws LDAPException {
        Validator.ensureNotNull(string, string2);
        return this.modifyDN(new ModifyDNRequest(string, string2, bl));
    }

    @Override
    public LDAPResult modifyDN(String string, String string2, boolean bl, String string3) throws LDAPException {
        Validator.ensureNotNull(string, string2);
        return this.modifyDN(new ModifyDNRequest(string, string2, bl, string3));
    }

    @Override
    public LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        Validator.ensureNotNull(modifyDNRequest);
        LDAPResult lDAPResult = modifyDNRequest.process(this, 1);
        switch (lDAPResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return lDAPResult;
            }
        }
        throw new LDAPException(lDAPResult);
    }

    @Override
    public LDAPResult modifyDN(ReadOnlyModifyDNRequest readOnlyModifyDNRequest) throws LDAPException {
        return this.modifyDN((ModifyDNRequest)readOnlyModifyDNRequest);
    }

    public AsyncRequestID asyncModifyDN(ModifyDNRequest modifyDNRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        Validator.ensureNotNull(modifyDNRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener asyncResultListener2 = asyncResultListener == null ? DiscardAsyncListener.getInstance() : asyncResultListener;
        return modifyDNRequest.processAsync(this, asyncResultListener2);
    }

    public AsyncRequestID asyncModifyDN(ReadOnlyModifyDNRequest readOnlyModifyDNRequest, AsyncResultListener asyncResultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncModifyDN((ModifyDNRequest)readOnlyModifyDNRequest, asyncResultListener);
    }

    @Override
    public SearchResult search(String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, string2);
        try {
            return this.search(new SearchRequest(string, searchScope, string2, stringArray));
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            throw lDAPSearchException;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
    }

    @Override
    public SearchResult search(String string, SearchScope searchScope, Filter filter, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, filter);
        return this.search(new SearchRequest(string, searchScope, filter, stringArray));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, string2);
        try {
            return this.search(new SearchRequest(searchResultListener, string, searchScope, string2, stringArray));
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            throw lDAPSearchException;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, Filter filter, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, string, searchScope, filter, stringArray));
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            throw lDAPSearchException;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
    }

    @Override
    public SearchResult search(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, string2);
        try {
            return this.search(new SearchRequest(string, searchScope, dereferencePolicy, n, n2, bl, string2, stringArray));
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            throw lDAPSearchException;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
    }

    @Override
    public SearchResult search(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, filter);
        return this.search(new SearchRequest(string, searchScope, dereferencePolicy, n, n2, bl, filter, stringArray));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, string2);
        try {
            return this.search(new SearchRequest(searchResultListener, string, searchScope, dereferencePolicy, n, n2, bl, string2, stringArray));
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            throw lDAPSearchException;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) throws LDAPSearchException {
        Validator.ensureNotNull(string, filter);
        return this.search(new SearchRequest(searchResultListener, string, searchScope, dereferencePolicy, n, n2, bl, filter, stringArray));
    }

    @Override
    public SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult searchResult;
        Validator.ensureNotNull(searchRequest);
        try {
            searchResult = searchRequest.process(this, 1);
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            throw lDAPSearchException;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
        if (!searchResult.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPSearchException(searchResult);
        }
        return searchResult;
    }

    @Override
    public SearchResult search(ReadOnlySearchRequest readOnlySearchRequest) throws LDAPSearchException {
        return this.search((SearchRequest)readOnlySearchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPSearchException {
        SearchRequest searchRequest;
        try {
            searchRequest = new SearchRequest(string, searchScope, DereferencePolicy.NEVER, 1, 0, false, string2, stringArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
        return this.searchForEntry(searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String string, SearchScope searchScope, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(string, searchScope, DereferencePolicy.NEVER, 1, 0, false, filter, stringArray));
    }

    @Override
    public SearchResultEntry searchForEntry(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, boolean bl, String string2, String ... stringArray) throws LDAPSearchException {
        SearchRequest searchRequest;
        try {
            searchRequest = new SearchRequest(string, searchScope, dereferencePolicy, 1, n, bl, string2, stringArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
        return this.searchForEntry(searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, boolean bl, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(string, searchScope, dereferencePolicy, 1, n, bl, filter, stringArray));
    }

    @Override
    public SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult searchResult;
        SearchRequest searchRequest2;
        if (searchRequest.getSearchResultListener() != null || searchRequest.getSizeLimit() != 1) {
            searchRequest2 = new SearchRequest(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), 1, searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributes());
            searchRequest2.setFollowReferrals(searchRequest.followReferralsInternal());
            searchRequest2.setResponseTimeoutMillis(searchRequest.getResponseTimeoutMillis(null));
            if (searchRequest.hasControl()) {
                searchRequest2.setControlsInternal(searchRequest.getControls());
            }
        } else {
            searchRequest2 = searchRequest;
        }
        try {
            searchResult = this.search(searchRequest2);
        }
        catch (LDAPSearchException lDAPSearchException) {
            Debug.debugException(lDAPSearchException);
            if (lDAPSearchException.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return null;
            }
            throw lDAPSearchException;
        }
        if (searchResult.getEntryCount() == 0) {
            return null;
        }
        return searchResult.getSearchEntries().get(0);
    }

    @Override
    public SearchResultEntry searchForEntry(ReadOnlySearchRequest readOnlySearchRequest) throws LDAPSearchException {
        return this.searchForEntry((SearchRequest)readOnlySearchRequest);
    }

    public AsyncRequestID asyncSearch(SearchRequest searchRequest) throws LDAPException {
        Validator.ensureNotNull(searchRequest);
        SearchResultListener searchResultListener = searchRequest.getSearchResultListener();
        if (searchResultListener == null) {
            LDAPException lDAPException = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_ASYNC_SEARCH_NO_LISTENER.get());
            Debug.debugCodingError(lDAPException);
            throw lDAPException;
        }
        if (!(searchResultListener instanceof AsyncSearchResultListener)) {
            LDAPException lDAPException = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_ASYNC_SEARCH_INVALID_LISTENER.get());
            Debug.debugCodingError(lDAPException);
            throw lDAPException;
        }
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return searchRequest.processAsync(this, (AsyncSearchResultListener)searchResultListener);
    }

    public AsyncRequestID asyncSearch(ReadOnlySearchRequest readOnlySearchRequest) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncSearch((SearchRequest)readOnlySearchRequest);
    }

    public LDAPResult processOperation(LDAPRequest lDAPRequest) throws LDAPException {
        return lDAPRequest.process(this, 1);
    }

    public ReferralConnector getReferralConnector() {
        if (this.referralConnector == null) {
            return this;
        }
        return this.referralConnector;
    }

    public void setReferralConnector(ReferralConnector referralConnector) {
        this.referralConnector = referralConnector == null ? this : referralConnector;
    }

    void sendMessage(LDAPMessage lDAPMessage) throws LDAPException {
        LDAPConnectionInternals lDAPConnectionInternals;
        if (this.needsReconnect.compareAndSet(true, false)) {
            this.reconnect();
        }
        if ((lDAPConnectionInternals = this.connectionInternals) == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        boolean bl = this.connectionOptions.autoReconnect();
        lDAPConnectionInternals.sendMessage(lDAPMessage, bl);
        this.lastCommunicationTime = System.currentTimeMillis();
    }

    int nextMessageID() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return -1;
        }
        return lDAPConnectionInternals.nextMessageID();
    }

    DisconnectInfo getDisconnectInfo() {
        return this.disconnectInfo.get();
    }

    public void setDisconnectInfo(DisconnectType disconnectType, String string, Throwable throwable) {
        this.disconnectInfo.compareAndSet(null, new DisconnectInfo(this, disconnectType, string, throwable));
    }

    DisconnectInfo setDisconnectInfo(DisconnectInfo disconnectInfo) {
        this.disconnectInfo.compareAndSet(null, disconnectInfo);
        return this.disconnectInfo.get();
    }

    public DisconnectType getDisconnectType() {
        DisconnectInfo disconnectInfo = this.disconnectInfo.get();
        if (disconnectInfo == null) {
            return null;
        }
        return disconnectInfo.getType();
    }

    public String getDisconnectMessage() {
        DisconnectInfo disconnectInfo = this.disconnectInfo.get();
        if (disconnectInfo == null) {
            return null;
        }
        return disconnectInfo.getMessage();
    }

    public Throwable getDisconnectCause() {
        DisconnectInfo disconnectInfo = this.disconnectInfo.get();
        if (disconnectInfo == null) {
            return null;
        }
        return disconnectInfo.getCause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClosed() {
        StackTraceElement[] stackTraceElementArray;
        Object object;
        this.needsReconnect.set(false);
        if (this.disconnectInfo.get() == null) {
            try {
                object = Thread.currentThread().getStackTrace();
                stackTraceElementArray = new StackTraceElement[((StackTraceElement[])object).length - 1];
                System.arraycopy(object, 1, stackTraceElementArray, 0, stackTraceElementArray.length);
                this.setDisconnectInfo(DisconnectType.OTHER, LDAPMessages.ERR_CONN_CLOSED_BY_UNEXPECTED_CALL_PATH.get(StaticUtils.getStackTrace(stackTraceElementArray)), null);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        this.connectionStatistics.incrementNumDisconnects();
        object = this.connectionInternals;
        if (object != null) {
            ((LDAPConnectionInternals)object).close();
            this.connectionInternals = null;
        }
        this.cachedSchema = null;
        this.lastCommunicationTime = -1L;
        stackTraceElementArray = this;
        synchronized (stackTraceElementArray) {
            Timer timer = this.timer;
            this.timer = null;
            if (timer != null) {
                timer.cancel();
            }
        }
    }

    void registerResponseAcceptor(int n, ResponseAcceptor responseAcceptor) throws LDAPException {
        LDAPConnectionInternals lDAPConnectionInternals;
        if (this.needsReconnect.compareAndSet(true, false)) {
            this.reconnect();
        }
        if ((lDAPConnectionInternals = this.connectionInternals) == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        lDAPConnectionInternals.registerResponseAcceptor(n, responseAcceptor);
    }

    void deregisterResponseAcceptor(int n) {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals != null) {
            lDAPConnectionInternals.deregisterResponseAcceptor(n);
        }
    }

    synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("Timer thread for " + this.toString(), true);
        }
        return this.timer;
    }

    @Override
    public LDAPConnection getReferralConnection(LDAPURL lDAPURL, LDAPConnection lDAPConnection) throws LDAPException {
        String string = lDAPURL.getHost();
        int n = lDAPURL.getPort();
        BindRequest bindRequest = null;
        if (lDAPConnection.lastBindRequest != null && (bindRequest = lDAPConnection.lastBindRequest.getRebindRequest(string, n)) == null) {
            throw new LDAPException(ResultCode.REFERRAL, LDAPMessages.ERR_CONN_CANNOT_AUTHENTICATE_FOR_REFERRAL.get(string, n));
        }
        ExtendedRequest extendedRequest = lDAPConnection.startTLSRequest;
        LDAPConnection lDAPConnection2 = new LDAPConnection(lDAPConnection.socketFactory, lDAPConnection.connectionOptions, string, n);
        if (extendedRequest != null) {
            try {
                ExtendedResult extendedResult = lDAPConnection2.processExtendedOperation(extendedRequest);
                if (extendedResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPException(extendedResult);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                lDAPConnection2.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, null, lDAPException);
                lDAPConnection2.close();
                throw lDAPException;
            }
        }
        if (bindRequest != null) {
            try {
                lDAPConnection2.bind(bindRequest);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                lDAPConnection2.setDisconnectInfo(DisconnectType.BIND_FAILED, null, lDAPException);
                lDAPConnection2.close();
                throw lDAPException;
            }
        }
        return lDAPConnection2;
    }

    public BindRequest getLastBindRequest() {
        return this.lastBindRequest;
    }

    public ExtendedRequest getStartTLSRequest() {
        return this.startTLSRequest;
    }

    LDAPConnectionInternals getConnectionInternals(boolean bl) throws LDAPException {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null && bl) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        return lDAPConnectionInternals;
    }

    Schema getCachedSchema() {
        return this.cachedSchema;
    }

    void setCachedSchema(Schema schema) {
        this.cachedSchema = schema;
    }

    public boolean synchronousMode() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return false;
        }
        return lDAPConnectionInternals.synchronousMode();
    }

    LDAPResponse readResponse(int n) throws LDAPException {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals != null) {
            LDAPResponse lDAPResponse = lDAPConnectionInternals.getConnectionReader().readResponse(n);
            Debug.debugLDAPResult(lDAPResponse, this);
            return lDAPResponse;
        }
        DisconnectInfo disconnectInfo = this.disconnectInfo.get();
        if (disconnectInfo == null) {
            return new ConnectionClosedResponse(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_READ_RESPONSE_NOT_ESTABLISHED.get());
        }
        return new ConnectionClosedResponse(disconnectInfo.getType().getResultCode(), disconnectInfo.getMessage());
    }

    public long getConnectTime() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals != null) {
            return lDAPConnectionInternals.getConnectTime();
        }
        return -1L;
    }

    public long getLastCommunicationTime() {
        if (this.lastCommunicationTime > 0L) {
            return this.lastCommunicationTime;
        }
        return this.getConnectTime();
    }

    void setLastCommunicationTime() {
        this.lastCommunicationTime = System.currentTimeMillis();
    }

    public LDAPConnectionStatistics getConnectionStatistics() {
        return this.connectionStatistics;
    }

    public int getActiveOperationCount() {
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals == null) {
            return -1;
        }
        if (lDAPConnectionInternals.synchronousMode()) {
            return -1;
        }
        return lDAPConnectionInternals.getConnectionReader().getActiveOperationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema getCachedSchema(LDAPConnection lDAPConnection) throws LDAPException {
        Schema schema = lDAPConnection.getSchema();
        WeakHashSet<Schema> weakHashSet = SCHEMA_SET;
        synchronized (weakHashSet) {
            return SCHEMA_SET.addAndGet(schema);
        }
    }

    synchronized Object getAttachment(String string) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.get(string);
    }

    synchronized void setAttachment(String string, Object object) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>(10);
        }
        if (object == null) {
            this.attachments.remove(string);
        } else {
            this.attachments.put(string, object);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setDisconnectInfo(DisconnectType.CLOSED_BY_FINALIZER, null, null);
        this.setClosed();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDAPConnection(");
        String string = this.connectionName;
        String string2 = this.connectionPoolName;
        if (string != null) {
            stringBuilder.append("name='");
            stringBuilder.append(string);
            stringBuilder.append("', ");
        } else if (string2 != null) {
            stringBuilder.append("poolName='");
            stringBuilder.append(string2);
            stringBuilder.append("', ");
        }
        LDAPConnectionInternals lDAPConnectionInternals = this.connectionInternals;
        if (lDAPConnectionInternals != null && lDAPConnectionInternals.isConnected()) {
            stringBuilder.append("connected to ");
            stringBuilder.append(lDAPConnectionInternals.getHost());
            stringBuilder.append(':');
            stringBuilder.append(lDAPConnectionInternals.getPort());
        } else {
            stringBuilder.append("not connected");
        }
        stringBuilder.append(')');
    }
}

