/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.sdk.ConnectThread;
import com.unboundid.ldap.sdk.DisconnectInfo;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslClient;

@InternalUseOnly
final class LDAPConnectionInternals {
    private static final AtomicLong ACTIVE_CONNECTION_COUNT = new AtomicLong(0L);
    private static final AtomicReference<ThreadLocal<ASN1Buffer>> ASN1_BUFFERS = new AtomicReference(new ThreadLocal());
    private final AtomicInteger nextMessageID;
    private final boolean synchronousMode;
    private final InetAddress inetAddress;
    private final int port;
    private final long connectTime;
    private final LDAPConnection connection;
    private final LDAPConnectionReader connectionReader;
    private volatile OutputStream outputStream;
    private volatile SaslClient saslClient;
    private volatile Socket socket;
    private final String host;

    LDAPConnectionInternals(LDAPConnection lDAPConnection, LDAPConnectionOptions lDAPConnectionOptions, SocketFactory socketFactory, String string, InetAddress inetAddress, int n, int n2) throws IOException {
        this.connection = lDAPConnection;
        this.host = string;
        this.inetAddress = inetAddress;
        this.port = n;
        if (lDAPConnectionOptions.captureConnectStackTrace()) {
            lDAPConnection.setConnectStackTrace(Thread.currentThread().getStackTrace());
        }
        this.connectTime = System.currentTimeMillis();
        this.nextMessageID = new AtomicInteger(0);
        this.synchronousMode = lDAPConnectionOptions.useSynchronousMode();
        this.saslClient = null;
        try {
            ConnectThread connectThread = new ConnectThread(socketFactory, inetAddress, n, n2);
            connectThread.start();
            this.socket = connectThread.getConnectedSocket();
            if (this.socket instanceof SSLSocket) {
                SSLSocket sSLSocket = (SSLSocket)this.socket;
                lDAPConnectionOptions.getSSLSocketVerifier().verifySSLSocket(string, n, sSLSocket);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw StaticUtils.createIOExceptionWithCause(null, lDAPException);
        }
        if (lDAPConnectionOptions.getReceiveBufferSize() > 0) {
            this.socket.setReceiveBufferSize(lDAPConnectionOptions.getReceiveBufferSize());
        }
        if (lDAPConnectionOptions.getSendBufferSize() > 0) {
            this.socket.setSendBufferSize(lDAPConnectionOptions.getSendBufferSize());
        }
        try {
            Debug.debugConnect(string, n, lDAPConnection);
            this.socket.setKeepAlive(lDAPConnectionOptions.useKeepAlive());
            this.socket.setReuseAddress(lDAPConnectionOptions.useReuseAddress());
            this.socket.setSoLinger(lDAPConnectionOptions.useLinger(), lDAPConnectionOptions.getLingerTimeoutSeconds());
            this.socket.setTcpNoDelay(lDAPConnectionOptions.useTCPNoDelay());
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.connectionReader = new LDAPConnectionReader(lDAPConnection, this);
        }
        catch (IOException iOException) {
            Debug.debugException(iOException);
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            throw iOException;
        }
        ACTIVE_CONNECTION_COUNT.incrementAndGet();
    }

    void startConnectionReader() {
        if (!this.synchronousMode) {
            this.connectionReader.start();
        }
    }

    LDAPConnection getConnection() {
        return this.connection;
    }

    LDAPConnectionReader getConnectionReader() {
        return this.connectionReader;
    }

    InetAddress getInetAddress() {
        return this.inetAddress;
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    Socket getSocket() {
        return this.socket;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    OutputStream getOutputStream() {
        return this.outputStream;
    }

    boolean isConnected() {
        return this.socket.isConnected();
    }

    boolean synchronousMode() {
        return this.synchronousMode;
    }

    void convertToTLS(SSLSocketFactory sSLSocketFactory) throws LDAPException {
        this.outputStream = this.connectionReader.doStartTLS(sSLSocketFactory);
    }

    void applySASLQoP(SaslClient saslClient) throws LDAPException {
        this.saslClient = saslClient;
        this.connectionReader.applySASLQoP(saslClient);
    }

    int nextMessageID() {
        int n = this.nextMessageID.incrementAndGet();
        if (n > 0) {
            return n;
        }
        do {
            if (!this.nextMessageID.compareAndSet(n, 1)) continue;
            return 1;
        } while ((n = this.nextMessageID.incrementAndGet()) <= 0);
        return n;
    }

    void registerResponseAcceptor(int n, ResponseAcceptor responseAcceptor) throws LDAPException {
        if (!this.isConnected()) {
            LDAPConnectionOptions lDAPConnectionOptions = this.connection.getConnectionOptions();
            boolean bl = lDAPConnectionOptions.autoReconnect();
            boolean bl2 = this.connection.closeRequested();
            if (bl && !bl2) {
                this.connection.reconnect();
                this.connection.registerResponseAcceptor(n, responseAcceptor);
            } else {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
            }
        }
        this.connectionReader.registerResponseAcceptor(n, responseAcceptor);
    }

    void deregisterResponseAcceptor(int n) {
        this.connectionReader.deregisterResponseAcceptor(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendMessage(LDAPMessage lDAPMessage, boolean bl) throws LDAPException {
        if (!this.isConnected()) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        ASN1Buffer aSN1Buffer = ASN1_BUFFERS.get().get();
        if (aSN1Buffer == null) {
            aSN1Buffer = new ASN1Buffer();
            ASN1_BUFFERS.get().set(aSN1Buffer);
        }
        aSN1Buffer.clear();
        try {
            lDAPMessage.writeTo(aSN1Buffer);
        }
        catch (LDAPRuntimeException lDAPRuntimeException) {
            Debug.debugException(lDAPRuntimeException);
            lDAPRuntimeException.throwLDAPException();
        }
        try {
            OutputStream outputStream = this.outputStream;
            if (this.saslClient == null) {
                aSN1Buffer.writeTo(outputStream);
            } else {
                byte[] byArray = aSN1Buffer.toByteArray();
                byte[] byArray2 = this.saslClient.wrap(byArray, 0, byArray.length);
                byte[] byArray3 = new byte[]{(byte)(byArray2.length >> 24 & 0xFF), (byte)(byArray2.length >> 16 & 0xFF), (byte)(byArray2.length >> 8 & 0xFF), (byte)(byArray2.length & 0xFF)};
                outputStream.write(byArray3);
                outputStream.write(byArray2);
            }
            outputStream.flush();
            return;
        }
        catch (IOException iOException) {
            Debug.debugException(iOException);
            if (lDAPMessage.getProtocolOpType() == 66) {
                return;
            }
            boolean bl2 = this.connection.closeRequested();
            if (!bl || bl2 || this.connection.synchronousMode()) throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_SEND_ERROR.get(this.host + ':' + this.port, StaticUtils.getExceptionMessage(iOException)), iOException);
            this.connection.reconnect();
            try {
                this.sendMessage(lDAPMessage, false);
                return;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_SEND_ERROR.get(this.host + ':' + this.port, StaticUtils.getExceptionMessage(iOException)), iOException);
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONN_ENCODE_ERROR.get(this.host + ':' + this.port, StaticUtils.getExceptionMessage(exception)), exception);
        }
        finally {
            if (aSN1Buffer.zeroBufferOnClear()) {
                aSN1Buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        DisconnectInfo disconnectInfo = this.connection.getDisconnectInfo();
        if (disconnectInfo == null) {
            disconnectInfo = this.connection.setDisconnectInfo(new DisconnectInfo(this.connection, DisconnectType.UNKNOWN, null, null));
        }
        boolean bl = disconnectInfo.getType() == DisconnectType.CLOSED_BY_FINALIZER && this.socket.isConnected();
        try {
            this.connectionReader.close(false);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        if (this.saslClient != null) {
            try {
                this.saslClient.dispose();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            finally {
                this.saslClient = null;
            }
        }
        Debug.debugDisconnect(this.host, this.port, this.connection, disconnectInfo.getType(), disconnectInfo.getMessage(), disconnectInfo.getCause());
        if (bl && Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.WARNING, DebugType.LDAP, "Connection closed by LDAP SDK finalizer:  " + this.toString());
        }
        disconnectInfo.notifyDisconnectHandler();
        long l = ACTIVE_CONNECTION_COUNT.decrementAndGet();
        if (l <= 0L) {
            ASN1_BUFFERS.set(new ThreadLocal());
            if (l < 0L) {
                ACTIVE_CONNECTION_COUNT.compareAndSet(l, 0L);
            }
        }
    }

    public long getConnectTime() {
        if (this.isConnected()) {
            return this.connectTime;
        }
        return -1L;
    }

    static long getActiveConnectionCount() {
        return ACTIVE_CONNECTION_COUNT.get();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDAPConnectionInternals(host='");
        stringBuilder.append(this.host);
        stringBuilder.append("', port=");
        stringBuilder.append(this.port);
        stringBuilder.append(", connected=");
        stringBuilder.append(this.socket.isConnected());
        stringBuilder.append(", nextMessageID=");
        stringBuilder.append(this.nextMessageID.get());
        stringBuilder.append(')');
    }
}

