/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DisconnectHandler;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLSocketVerifier;
import com.unboundid.util.ssl.TrustAllSSLSocketVerifier;

public final class LDAPConnectionOptions {
    static final boolean DEFAULT_ABANDON_ON_TIMEOUT = false;
    static final boolean DEFAULT_AUTO_RECONNECT = false;
    static final boolean DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD = true;
    static final boolean DEFAULT_CAPTURE_CONNECT_STACK_TRACE = false;
    static final boolean DEFAULT_FOLLOW_REFERRALS = false;
    static final boolean DEFAULT_USE_POOLED_SCHEMA = false;
    static final boolean DEFAULT_USE_KEEPALIVE = true;
    static final boolean DEFAULT_USE_LINGER = true;
    static final boolean DEFAULT_USE_REUSE_ADDRESS = true;
    static final boolean DEFAULT_USE_SCHEMA = false;
    static final boolean DEFAULT_USE_SYNCHRONOUS_MODE = false;
    static final boolean DEFAULT_USE_TCP_NODELAY = true;
    static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 60000;
    static final int DEFAULT_LINGER_TIMEOUT_SECONDS = 5;
    static final int DEFAULT_MAX_MESSAGE_SIZE = 0x1400000;
    static final int DEFAULT_RECEIVE_BUFFER_SIZE = 0;
    static final int DEFAULT_REFERRAL_HOP_LIMIT = 5;
    static final int DEFAULT_SEND_BUFFER_SIZE = 0;
    static final long DEFAULT_POOLED_SCHEMA_TIMEOUT_MILLIS = 3600000L;
    static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS = 300000L;
    static final boolean DEFAULT_ALLOW_CONCURRENT_SOCKET_FACTORY_USE;
    static final SSLSocketVerifier DEFAULT_SSL_SOCKET_VERIFIER;
    private boolean abandonOnTimeout = false;
    private boolean allowConcurrentSocketFactoryUse;
    private boolean autoReconnect = false;
    private boolean bindWithDNRequiresPassword = true;
    private boolean captureConnectStackTrace = false;
    private boolean followReferrals = false;
    private boolean useKeepAlive = true;
    private boolean useLinger = true;
    private boolean useReuseAddress = true;
    private boolean usePooledSchema = false;
    private boolean useSchema = false;
    private boolean useSynchronousMode = false;
    private boolean useTCPNoDelay = true;
    private DisconnectHandler disconnectHandler = null;
    private int connectTimeout = 60000;
    private int lingerTimeout = 5;
    private int maxMessageSize = 0x1400000;
    private int receiveBufferSize = 0;
    private int referralHopLimit = 5;
    private int sendBufferSize = 0;
    private long pooledSchemaTimeout = 3600000L;
    private long responseTimeout = 300000L;
    private ReferralConnector referralConnector = null;
    private SSLSocketVerifier sslSocketVerifier = DEFAULT_SSL_SOCKET_VERIFIER;
    private UnsolicitedNotificationHandler unsolicitedNotificationHandler = null;

    public LDAPConnectionOptions() {
        this.allowConcurrentSocketFactoryUse = DEFAULT_ALLOW_CONCURRENT_SOCKET_FACTORY_USE;
    }

    public LDAPConnectionOptions duplicate() {
        LDAPConnectionOptions lDAPConnectionOptions = new LDAPConnectionOptions();
        lDAPConnectionOptions.abandonOnTimeout = this.abandonOnTimeout;
        lDAPConnectionOptions.allowConcurrentSocketFactoryUse = this.allowConcurrentSocketFactoryUse;
        lDAPConnectionOptions.autoReconnect = this.autoReconnect;
        lDAPConnectionOptions.bindWithDNRequiresPassword = this.bindWithDNRequiresPassword;
        lDAPConnectionOptions.captureConnectStackTrace = this.captureConnectStackTrace;
        lDAPConnectionOptions.followReferrals = this.followReferrals;
        lDAPConnectionOptions.useKeepAlive = this.useKeepAlive;
        lDAPConnectionOptions.useLinger = this.useLinger;
        lDAPConnectionOptions.useReuseAddress = this.useReuseAddress;
        lDAPConnectionOptions.usePooledSchema = this.usePooledSchema;
        lDAPConnectionOptions.useSchema = this.useSchema;
        lDAPConnectionOptions.useSynchronousMode = this.useSynchronousMode;
        lDAPConnectionOptions.useTCPNoDelay = this.useTCPNoDelay;
        lDAPConnectionOptions.connectTimeout = this.connectTimeout;
        lDAPConnectionOptions.lingerTimeout = this.lingerTimeout;
        lDAPConnectionOptions.maxMessageSize = this.maxMessageSize;
        lDAPConnectionOptions.pooledSchemaTimeout = this.pooledSchemaTimeout;
        lDAPConnectionOptions.responseTimeout = this.responseTimeout;
        lDAPConnectionOptions.referralConnector = this.referralConnector;
        lDAPConnectionOptions.referralHopLimit = this.referralHopLimit;
        lDAPConnectionOptions.disconnectHandler = this.disconnectHandler;
        lDAPConnectionOptions.unsolicitedNotificationHandler = this.unsolicitedNotificationHandler;
        lDAPConnectionOptions.receiveBufferSize = this.receiveBufferSize;
        lDAPConnectionOptions.sendBufferSize = this.sendBufferSize;
        lDAPConnectionOptions.sslSocketVerifier = this.sslSocketVerifier;
        return lDAPConnectionOptions;
    }

    @Deprecated
    public boolean autoReconnect() {
        return this.autoReconnect;
    }

    @Deprecated
    public void setAutoReconnect(boolean bl) {
        this.autoReconnect = bl;
    }

    public boolean bindWithDNRequiresPassword() {
        return this.bindWithDNRequiresPassword;
    }

    public void setBindWithDNRequiresPassword(boolean bl) {
        this.bindWithDNRequiresPassword = bl;
    }

    public boolean captureConnectStackTrace() {
        return this.captureConnectStackTrace;
    }

    public void setCaptureConnectStackTrace(boolean bl) {
        this.captureConnectStackTrace = bl;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeout;
    }

    public void setConnectTimeoutMillis(int n) {
        this.connectTimeout = n;
    }

    public long getResponseTimeoutMillis() {
        return this.responseTimeout;
    }

    public void setResponseTimeoutMillis(long l) {
        this.responseTimeout = l < 0L ? 0L : l;
    }

    public boolean abandonOnTimeout() {
        return this.abandonOnTimeout;
    }

    public void setAbandonOnTimeout(boolean bl) {
        this.abandonOnTimeout = bl;
    }

    public boolean useKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean bl) {
        this.useKeepAlive = bl;
    }

    public boolean useLinger() {
        return this.useLinger;
    }

    public int getLingerTimeoutSeconds() {
        return this.lingerTimeout;
    }

    public void setUseLinger(boolean bl, int n) {
        this.useLinger = bl;
        this.lingerTimeout = n;
    }

    public boolean useReuseAddress() {
        return this.useReuseAddress;
    }

    public void setUseReuseAddress(boolean bl) {
        this.useReuseAddress = bl;
    }

    public boolean useSchema() {
        return this.useSchema;
    }

    public void setUseSchema(boolean bl) {
        this.useSchema = bl;
        if (bl) {
            this.usePooledSchema = false;
        }
    }

    public boolean usePooledSchema() {
        return this.usePooledSchema;
    }

    public void setUsePooledSchema(boolean bl) {
        this.usePooledSchema = bl;
        if (bl) {
            this.useSchema = false;
        }
    }

    public long getPooledSchemaTimeoutMillis() {
        return this.pooledSchemaTimeout;
    }

    public void setPooledSchemaTimeoutMillis(long l) {
        this.pooledSchemaTimeout = l < 0L ? 0L : l;
    }

    public boolean useSynchronousMode() {
        return this.useSynchronousMode;
    }

    public void setUseSynchronousMode(boolean bl) {
        this.useSynchronousMode = bl;
    }

    public boolean useTCPNoDelay() {
        return this.useTCPNoDelay;
    }

    public void setUseTCPNoDelay(boolean bl) {
        this.useTCPNoDelay = bl;
    }

    public boolean followReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean bl) {
        this.followReferrals = bl;
    }

    public int getReferralHopLimit() {
        return this.referralHopLimit;
    }

    public void setReferralHopLimit(int n) {
        Validator.ensureTrue(n > 0, "LDAPConnectionOptions.referralHopLimit must be greater than 0.");
        this.referralHopLimit = n;
    }

    public ReferralConnector getReferralConnector() {
        return this.referralConnector;
    }

    public void setReferralConnector(ReferralConnector referralConnector) {
        this.referralConnector = referralConnector;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int n) {
        this.maxMessageSize = n > 0 ? n : 0;
    }

    public DisconnectHandler getDisconnectHandler() {
        return this.disconnectHandler;
    }

    public void setDisconnectHandler(DisconnectHandler disconnectHandler) {
        this.disconnectHandler = disconnectHandler;
    }

    public UnsolicitedNotificationHandler getUnsolicitedNotificationHandler() {
        return this.unsolicitedNotificationHandler;
    }

    public void setUnsolicitedNotificationHandler(UnsolicitedNotificationHandler unsolicitedNotificationHandler) {
        this.unsolicitedNotificationHandler = unsolicitedNotificationHandler;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n < 0 ? 0 : n;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int n) {
        this.sendBufferSize = n < 0 ? 0 : n;
    }

    public boolean allowConcurrentSocketFactoryUse() {
        return this.allowConcurrentSocketFactoryUse;
    }

    public void setAllowConcurrentSocketFactoryUse(boolean bl) {
        this.allowConcurrentSocketFactoryUse = bl;
    }

    public SSLSocketVerifier getSSLSocketVerifier() {
        return this.sslSocketVerifier;
    }

    public void setSSLSocketVerifier(SSLSocketVerifier sSLSocketVerifier) {
        this.sslSocketVerifier = sSLSocketVerifier == null ? DEFAULT_SSL_SOCKET_VERIFIER : sSLSocketVerifier;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDAPConnectionOptions(autoReconnect=");
        stringBuilder.append(this.autoReconnect);
        stringBuilder.append(", bindWithDNRequiresPassword=");
        stringBuilder.append(this.bindWithDNRequiresPassword);
        stringBuilder.append(", followReferrals=");
        stringBuilder.append(this.followReferrals);
        if (this.followReferrals) {
            stringBuilder.append(", referralHopLimit=");
            stringBuilder.append(this.referralHopLimit);
        }
        if (this.referralConnector != null) {
            stringBuilder.append(", referralConnectorClass=");
            stringBuilder.append(this.referralConnector.getClass().getName());
        }
        stringBuilder.append(", useKeepAlive=");
        stringBuilder.append(this.useKeepAlive);
        stringBuilder.append(", useLinger=");
        if (this.useLinger) {
            stringBuilder.append("true, lingerTimeoutSeconds=");
            stringBuilder.append(this.lingerTimeout);
        } else {
            stringBuilder.append("false");
        }
        stringBuilder.append(", useReuseAddress=");
        stringBuilder.append(this.useReuseAddress);
        stringBuilder.append(", useSchema=");
        stringBuilder.append(this.useSchema);
        stringBuilder.append(", usePooledSchema=");
        stringBuilder.append(this.usePooledSchema);
        stringBuilder.append(", pooledSchemaTimeoutMillis=");
        stringBuilder.append(this.pooledSchemaTimeout);
        stringBuilder.append(", useSynchronousMode=");
        stringBuilder.append(this.useSynchronousMode);
        stringBuilder.append(", useTCPNoDelay=");
        stringBuilder.append(this.useTCPNoDelay);
        stringBuilder.append(", captureConnectStackTrace=");
        stringBuilder.append(this.captureConnectStackTrace);
        stringBuilder.append(", connectTimeoutMillis=");
        stringBuilder.append(this.connectTimeout);
        stringBuilder.append(", responseTimeoutMillis=");
        stringBuilder.append(this.responseTimeout);
        stringBuilder.append(", abandonOnTimeout=");
        stringBuilder.append(this.abandonOnTimeout);
        stringBuilder.append(", maxMessageSize=");
        stringBuilder.append(this.maxMessageSize);
        stringBuilder.append(", receiveBufferSize=");
        stringBuilder.append(this.receiveBufferSize);
        stringBuilder.append(", sendBufferSize=");
        stringBuilder.append(this.sendBufferSize);
        stringBuilder.append(", allowConcurrentSocketFactoryUse=");
        stringBuilder.append(this.allowConcurrentSocketFactoryUse);
        if (this.disconnectHandler != null) {
            stringBuilder.append(", disconnectHandlerClass=");
            stringBuilder.append(this.disconnectHandler.getClass().getName());
        }
        if (this.unsolicitedNotificationHandler != null) {
            stringBuilder.append(", unsolicitedNotificationHandlerClass=");
            stringBuilder.append(this.unsolicitedNotificationHandler.getClass().getName());
        }
        stringBuilder.append(", sslSocketVerifierClass='");
        stringBuilder.append(this.sslSocketVerifier.getClass().getName());
        stringBuilder.append('\'');
        stringBuilder.append(')');
    }

    static {
        String string = StaticUtils.toLowerCase(System.getProperty("java.vm.vendor"));
        DEFAULT_ALLOW_CONCURRENT_SOCKET_FACTORY_USE = string != null && (string.contains("sun microsystems") || string.contains("oracle") || string.contains("apple") || string.contains("azul systems"));
        DEFAULT_SSL_SOCKET_VERIFIER = TrustAllSSLSocketVerifier.getInstance();
    }
}

