/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheckResult;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheckThread;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ParallelPoolCloser;
import com.unboundid.ldap.sdk.ParallelPoolConnector;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPConnectionPool
extends AbstractConnectionPool {
    private static final long DEFAULT_HEALTH_CHECK_INTERVAL = 60000L;
    static final String ATTACHMENT_NAME_MAX_CONNECTION_AGE = LDAPConnectionPool.class.getName() + ".maxConnectionAge";
    private final AtomicInteger failedReplaceCount;
    private final AtomicReference<Set<OperationType>> retryOperationTypes;
    private volatile boolean closed;
    private boolean createIfNecessary;
    private volatile boolean checkConnectionAgeOnRelease;
    private volatile boolean trySynchronousReadDuringHealthCheck;
    private final BindRequest bindRequest;
    private final int numConnections;
    private volatile int minConnectionGoal;
    private LDAPConnectionPoolHealthCheck healthCheck;
    private final LDAPConnectionPoolHealthCheckThread healthCheckThread;
    private final LDAPConnectionPoolStatistics poolStatistics;
    private final LinkedBlockingQueue<LDAPConnection> availableConnections;
    private volatile long healthCheckInterval;
    private volatile long lastExpiredDisconnectTime;
    private volatile long maxConnectionAge;
    private volatile Long maxDefunctReplacementConnectionAge;
    private long maxWaitTime;
    private volatile long minDisconnectInterval;
    private volatile ObjectPair<Long, Schema> pooledSchema;
    private final PostConnectProcessor postConnectProcessor;
    private final ServerSet serverSet;
    private String connectionPoolName;

    public LDAPConnectionPool(LDAPConnection lDAPConnection, int n) throws LDAPException {
        this(lDAPConnection, 1, n, null);
    }

    public LDAPConnectionPool(LDAPConnection lDAPConnection, int n, int n2) throws LDAPException {
        this(lDAPConnection, n, n2, null);
    }

    public LDAPConnectionPool(LDAPConnection lDAPConnection, int n, int n2, PostConnectProcessor postConnectProcessor) throws LDAPException {
        this(lDAPConnection, n, n2, postConnectProcessor, true);
    }

    public LDAPConnectionPool(LDAPConnection lDAPConnection, int n, int n2, PostConnectProcessor postConnectProcessor, boolean bl) throws LDAPException {
        this(lDAPConnection, n, n2, 1, postConnectProcessor, bl);
    }

    public LDAPConnectionPool(LDAPConnection lDAPConnection, int n, int n2, int n3, PostConnectProcessor postConnectProcessor, boolean bl) throws LDAPException {
        this(lDAPConnection, n, n2, n3, postConnectProcessor, bl, null);
    }

    public LDAPConnectionPool(LDAPConnection lDAPConnection, int n, int n2, int n3, PostConnectProcessor postConnectProcessor, boolean bl, LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) throws LDAPException {
        Object object;
        Validator.ensureNotNull(lDAPConnection);
        Validator.ensureTrue(n >= 1, "LDAPConnectionPool.initialConnections must be at least 1.");
        Validator.ensureTrue(n2 >= n, "LDAPConnectionPool.initialConnections must not be greater than maxConnections.");
        this.postConnectProcessor = postConnectProcessor;
        this.trySynchronousReadDuringHealthCheck = true;
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.pooledSchema = null;
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        this.numConnections = n2;
        this.minConnectionGoal = 0;
        this.availableConnections = new LinkedBlockingQueue(this.numConnections);
        if (!lDAPConnection.isConnected()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_CONN_NOT_ESTABLISHED.get());
        }
        this.healthCheck = lDAPConnectionPoolHealthCheck == null ? new LDAPConnectionPoolHealthCheck() : lDAPConnectionPoolHealthCheck;
        this.serverSet = new SingleServerSet(lDAPConnection.getConnectedAddress(), lDAPConnection.getConnectedPort(), lDAPConnection.getLastUsedSocketFactory(), lDAPConnection.getConnectionOptions());
        this.bindRequest = lDAPConnection.getLastBindRequest();
        LDAPConnectionOptions lDAPConnectionOptions = lDAPConnection.getConnectionOptions();
        if (lDAPConnectionOptions.usePooledSchema()) {
            try {
                object = lDAPConnection.getSchema();
                if (object != null) {
                    lDAPConnection.setCachedSchema((Schema)object);
                    long l = System.currentTimeMillis();
                    long l2 = lDAPConnectionOptions.getPooledSchemaTimeoutMillis();
                    this.pooledSchema = l2 <= 0L || l2 + l <= 0L ? new ObjectPair<Long, Object>(Long.MAX_VALUE, object) : new ObjectPair<Long, Object>(l2 + l, object);
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        if (n3 > 1) {
            object = Collections.synchronizedList(new ArrayList(n));
            ParallelPoolConnector parallelPoolConnector = new ParallelPoolConnector(this, (List<LDAPConnection>)object, n, n3, bl);
            parallelPoolConnector.establishConnections();
        } else {
            object = new ArrayList(n);
            lDAPConnection.setConnectionName(null);
            lDAPConnection.setConnectionPool(this);
            object.add(lDAPConnection);
            for (int i = 1; i < n; ++i) {
                try {
                    object.add(this.createConnection());
                    continue;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    if (!bl) continue;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        LDAPConnection lDAPConnection2 = (LDAPConnection)iterator.next();
                        try {
                            lDAPConnection2.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, lDAPException);
                            lDAPConnection2.terminate(null);
                        }
                        catch (Exception exception) {
                            Debug.debugException(exception);
                        }
                    }
                    throw lDAPException;
                }
            }
        }
        this.availableConnections.addAll((Collection<LDAPConnection>)object);
        this.failedReplaceCount = new AtomicInteger(n2 - this.availableConnections.size());
        this.createIfNecessary = true;
        this.checkConnectionAgeOnRelease = false;
        this.maxConnectionAge = 0L;
        this.maxDefunctReplacementConnectionAge = null;
        this.minDisconnectInterval = 0L;
        this.lastExpiredDisconnectTime = 0L;
        this.maxWaitTime = 0L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int n) throws LDAPException {
        this(serverSet, bindRequest, 1, n, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int n, int n2) throws LDAPException {
        this(serverSet, bindRequest, n, n2, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int n, int n2, PostConnectProcessor postConnectProcessor) throws LDAPException {
        this(serverSet, bindRequest, n, n2, postConnectProcessor, true);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int n, int n2, PostConnectProcessor postConnectProcessor, boolean bl) throws LDAPException {
        this(serverSet, bindRequest, n, n2, 1, postConnectProcessor, bl);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int n, int n2, int n3, PostConnectProcessor postConnectProcessor, boolean bl) throws LDAPException {
        this(serverSet, bindRequest, n, n2, n3, postConnectProcessor, bl, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int n, int n2, int n3, PostConnectProcessor postConnectProcessor, boolean bl, LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) throws LDAPException {
        ArrayList<LDAPConnection> arrayList;
        Validator.ensureNotNull(serverSet);
        Validator.ensureTrue(n >= 0, "LDAPConnectionPool.initialConnections must be greater than or equal to 0.");
        Validator.ensureTrue(n2 > 0, "LDAPConnectionPool.maxConnections must be greater than 0.");
        Validator.ensureTrue(n2 >= n, "LDAPConnectionPool.initialConnections must not be greater than maxConnections.");
        this.serverSet = serverSet;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.trySynchronousReadDuringHealthCheck = false;
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.pooledSchema = null;
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        this.minConnectionGoal = 0;
        this.healthCheck = lDAPConnectionPoolHealthCheck == null ? new LDAPConnectionPoolHealthCheck() : lDAPConnectionPoolHealthCheck;
        if (n3 > 1) {
            arrayList = Collections.synchronizedList(new ArrayList(n));
            ParallelPoolConnector parallelPoolConnector = new ParallelPoolConnector(this, arrayList, n, n3, bl);
            parallelPoolConnector.establishConnections();
        } else {
            arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                try {
                    arrayList.add(this.createConnection());
                    continue;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    if (!bl) continue;
                    for (LDAPConnection lDAPConnection : arrayList) {
                        try {
                            lDAPConnection.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, lDAPException);
                            lDAPConnection.terminate(null);
                        }
                        catch (Exception exception) {
                            Debug.debugException(exception);
                        }
                    }
                    throw lDAPException;
                }
            }
        }
        this.numConnections = n2;
        this.availableConnections = new LinkedBlockingQueue(this.numConnections);
        this.availableConnections.addAll(arrayList);
        this.failedReplaceCount = new AtomicInteger(n2 - this.availableConnections.size());
        this.createIfNecessary = true;
        this.checkConnectionAgeOnRelease = false;
        this.maxConnectionAge = 0L;
        this.maxDefunctReplacementConnectionAge = null;
        this.minDisconnectInterval = 0L;
        this.lastExpiredDisconnectTime = 0L;
        this.maxWaitTime = 0L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    LDAPConnection createConnection() throws LDAPException {
        return this.createConnection(this.healthCheck);
    }

    private LDAPConnection createConnection(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) throws LDAPException {
        LDAPConnection lDAPConnection;
        block31: {
            try {
                lDAPConnection = this.serverSet.getConnection(lDAPConnectionPoolHealthCheck);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                this.poolStatistics.incrementNumFailedConnectionAttempts();
                throw lDAPException;
            }
            lDAPConnection.setConnectionPool(this);
            LDAPConnectionOptions lDAPConnectionOptions = lDAPConnection.getConnectionOptions();
            if (lDAPConnectionOptions.autoReconnect()) {
                lDAPConnectionOptions = lDAPConnectionOptions.duplicate();
                lDAPConnectionOptions.setAutoReconnect(false);
                lDAPConnection.setConnectionOptions(lDAPConnectionOptions);
            }
            if (this.postConnectProcessor != null) {
                try {
                    this.postConnectProcessor.processPreAuthenticatedConnection(lDAPConnection);
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        lDAPConnection.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, exception);
                        lDAPConnection.terminate(null);
                    }
                    catch (Exception exception2) {
                        Debug.debugException(exception2);
                    }
                    if (exception instanceof LDAPException) {
                        throw (LDAPException)exception;
                    }
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(exception)), exception);
                }
            }
            BindResult bindResult = null;
            try {
                if (this.bindRequest != null) {
                    bindResult = lDAPConnection.bind(this.bindRequest.duplicate());
                }
            }
            catch (LDAPBindException lDAPBindException) {
                Debug.debugException(lDAPBindException);
                bindResult = lDAPBindException.getBindResult();
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                bindResult = new BindResult(lDAPException);
            }
            if (bindResult != null) {
                try {
                    lDAPConnectionPoolHealthCheck.ensureConnectionValidAfterAuthentication(lDAPConnection, bindResult);
                    if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                        throw new LDAPBindException(bindResult);
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        lDAPConnection.setDisconnectInfo(DisconnectType.BIND_FAILED, null, lDAPException);
                        lDAPConnection.terminate(null);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                    }
                    throw lDAPException;
                }
            }
            if (this.postConnectProcessor != null) {
                try {
                    this.postConnectProcessor.processPostAuthenticatedConnection(lDAPConnection);
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        lDAPConnection.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, exception);
                        lDAPConnection.terminate(null);
                    }
                    catch (Exception exception3) {
                        Debug.debugException(exception3);
                    }
                    if (exception instanceof LDAPException) {
                        throw (LDAPException)exception;
                    }
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(exception)), exception);
                }
            }
            if (lDAPConnectionOptions.usePooledSchema()) {
                long l = System.currentTimeMillis();
                if (this.pooledSchema == null || l > this.pooledSchema.getFirst()) {
                    try {
                        Schema schema = lDAPConnection.getSchema();
                        if (schema == null) break block31;
                        lDAPConnection.setCachedSchema(schema);
                        long l2 = lDAPConnectionOptions.getPooledSchemaTimeoutMillis();
                        if (l2 <= 0L || l + l2 <= 0L) {
                            this.pooledSchema = new ObjectPair<Long, Schema>(Long.MAX_VALUE, schema);
                            break block31;
                        }
                        this.pooledSchema = new ObjectPair<Long, Schema>(l + l2, schema);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        if (this.pooledSchema != null) {
                            lDAPConnection.setCachedSchema(this.pooledSchema.getSecond());
                        }
                        break block31;
                    }
                }
                lDAPConnection.setCachedSchema(this.pooledSchema.getSecond());
            }
        }
        lDAPConnection.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumSuccessfulConnectionAttempts();
        return lDAPConnection;
    }

    @Override
    public void close() {
        this.close(true, 1);
    }

    @Override
    public void close(boolean bl, int n) {
        this.closed = true;
        this.healthCheckThread.stopRunning();
        if (n > 1) {
            ArrayList<LDAPConnection> arrayList = new ArrayList<LDAPConnection>(this.availableConnections.size());
            this.availableConnections.drainTo(arrayList);
            if (!arrayList.isEmpty()) {
                ParallelPoolCloser parallelPoolCloser = new ParallelPoolCloser(arrayList, bl, n);
                parallelPoolCloser.closeConnections();
            }
        } else {
            while (true) {
                LDAPConnection lDAPConnection;
                if ((lDAPConnection = this.availableConnections.poll()) == null) {
                    return;
                }
                this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                lDAPConnection.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
                if (bl) {
                    lDAPConnection.terminate(null);
                    continue;
                }
                lDAPConnection.setClosed();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public BindResult bindAndRevertAuthentication(String string, String string2, Control ... controlArray) throws LDAPException {
        return this.bindAndRevertAuthentication(new SimpleBindRequest(string, string2, controlArray));
    }

    public BindResult bindAndRevertAuthentication(BindRequest bindRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            BindResult bindResult = lDAPConnection.bind(bindRequest);
            this.releaseAndReAuthenticateConnection(lDAPConnection);
            return bindResult;
        }
        catch (Throwable throwable) {
            LDAPException lDAPException;
            Debug.debugException(throwable);
            if (throwable instanceof LDAPException) {
                boolean bl;
                block13: {
                    lDAPException = (LDAPException)throwable;
                    try {
                        this.healthCheck.ensureConnectionValidAfterException(lDAPConnection, lDAPException);
                        this.releaseAndReAuthenticateConnection(lDAPConnection);
                        bl = true;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        if (!this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)OperationType.BIND)) {
                            this.releaseDefunctConnection(lDAPConnection);
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw lDAPException;
                }
            } else {
                this.releaseDefunctConnection(lDAPConnection);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(throwable)), throwable);
            }
            lDAPConnection = this.replaceDefunctConnection(lDAPConnection);
            try {
                BindResult bindResult = lDAPConnection.bind(bindRequest);
                this.releaseAndReAuthenticateConnection(lDAPConnection);
                return bindResult;
            }
            catch (Throwable throwable2) {
                Debug.debugException(throwable2);
                if (throwable2 instanceof LDAPException) {
                    lDAPException = (LDAPException)throwable2;
                    try {
                        this.healthCheck.ensureConnectionValidAfterException(lDAPConnection, lDAPException);
                        this.releaseAndReAuthenticateConnection(lDAPConnection);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        this.releaseDefunctConnection(lDAPConnection);
                    }
                    throw lDAPException;
                }
                this.releaseDefunctConnection(lDAPConnection);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(throwable2)), throwable2);
            }
        }
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        int n;
        if (this.closed) {
            this.poolStatistics.incrementNumFailedCheckouts();
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        LDAPConnection lDAPConnection = this.availableConnections.poll();
        if (lDAPConnection != null) {
            if (lDAPConnection.isConnected()) {
                try {
                    this.healthCheck.ensureConnectionValidForCheckout(lDAPConnection);
                    this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                    return lDAPConnection;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.poolStatistics.incrementNumConnectionsClosedDefunct();
            this.handleDefunctConnection(lDAPConnection);
            for (n = 0; n < this.numConnections && (lDAPConnection = this.availableConnections.poll()) != null; ++n) {
                if (lDAPConnection.isConnected()) {
                    try {
                        this.healthCheck.ensureConnectionValidForCheckout(lDAPConnection);
                        this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                        return lDAPConnection;
                    }
                    catch (LDAPException lDAPException) {
                        Debug.debugException(lDAPException);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        this.handleDefunctConnection(lDAPConnection);
                        continue;
                    }
                }
                this.poolStatistics.incrementNumConnectionsClosedDefunct();
                this.handleDefunctConnection(lDAPConnection);
            }
        }
        if (this.failedReplaceCount.get() > 0) {
            n = this.failedReplaceCount.getAndDecrement();
            if (n > 0) {
                try {
                    lDAPConnection = this.createConnection();
                    this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                    return lDAPConnection;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    this.failedReplaceCount.incrementAndGet();
                    this.poolStatistics.incrementNumFailedCheckouts();
                    throw lDAPException;
                }
            }
            this.failedReplaceCount.incrementAndGet();
            this.poolStatistics.incrementNumFailedCheckouts();
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_NO_CONNECTIONS.get());
        }
        if (this.maxWaitTime > 0L) {
            try {
                lDAPConnection = this.availableConnections.poll(this.maxWaitTime, TimeUnit.MILLISECONDS);
                if (lDAPConnection != null) {
                    try {
                        this.healthCheck.ensureConnectionValidForCheckout(lDAPConnection);
                        this.poolStatistics.incrementNumSuccessfulCheckoutsAfterWaiting();
                        return lDAPConnection;
                    }
                    catch (LDAPException lDAPException) {
                        Debug.debugException(lDAPException);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        this.handleDefunctConnection(lDAPConnection);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_CHECKOUT_INTERRUPTED.get(), interruptedException);
            }
        }
        if (this.createIfNecessary) {
            try {
                lDAPConnection = this.createConnection();
                this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                return lDAPConnection;
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                this.poolStatistics.incrementNumFailedCheckouts();
                throw lDAPException;
            }
        }
        this.poolStatistics.incrementNumFailedCheckouts();
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_NO_CONNECTIONS.get());
    }

    public LDAPConnection getConnection(String string, int n) {
        if (this.closed) {
            this.poolStatistics.incrementNumFailedCheckouts();
            return null;
        }
        HashSet<LDAPConnection> hashSet = new HashSet<LDAPConnection>(this.numConnections);
        while (true) {
            LDAPConnection lDAPConnection;
            if ((lDAPConnection = this.availableConnections.poll()) == null) {
                this.poolStatistics.incrementNumFailedCheckouts();
                return null;
            }
            if (hashSet.contains(lDAPConnection)) {
                this.availableConnections.offer(lDAPConnection);
                this.poolStatistics.incrementNumFailedCheckouts();
                return null;
            }
            if (lDAPConnection.getConnectedAddress().equals(string) && n == lDAPConnection.getConnectedPort()) {
                try {
                    this.healthCheck.ensureConnectionValidForCheckout(lDAPConnection);
                    this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                    return lDAPConnection;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    this.poolStatistics.incrementNumConnectionsClosedDefunct();
                    this.handleDefunctConnection(lDAPConnection);
                }
                continue;
            }
            if (!this.availableConnections.offer(lDAPConnection)) continue;
            hashSet.add(lDAPConnection);
        }
    }

    @Override
    public void releaseConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return;
        }
        lDAPConnection.setConnectionPoolName(this.connectionPoolName);
        if (this.checkConnectionAgeOnRelease && this.connectionIsExpired(lDAPConnection)) {
            try {
                LDAPConnection lDAPConnection2 = this.createConnection();
                if (this.availableConnections.offer(lDAPConnection2)) {
                    lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                    lDAPConnection.terminate(null);
                    this.poolStatistics.incrementNumConnectionsClosedExpired();
                    this.lastExpiredDisconnectTime = System.currentTimeMillis();
                } else {
                    lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    lDAPConnection2.terminate(null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                }
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
            }
            return;
        }
        try {
            this.healthCheck.ensureConnectionValidForRelease(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            this.releaseDefunctConnection(lDAPConnection);
            return;
        }
        if (!this.availableConnections.offer(lDAPConnection)) {
            lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
            this.poolStatistics.incrementNumConnectionsClosedUnneeded();
            lDAPConnection.terminate(null);
            return;
        }
        this.poolStatistics.incrementNumReleasedValid();
        if (this.closed) {
            this.close();
        }
    }

    public void discardConnection(LDAPConnection lDAPConnection) {
        int n;
        if (lDAPConnection == null) {
            return;
        }
        lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
        lDAPConnection.terminate(null);
        this.poolStatistics.incrementNumConnectionsClosedUnneeded();
        if (this.availableConnections.remainingCapacity() > 0 && (n = this.failedReplaceCount.incrementAndGet()) > this.numConnections) {
            this.failedReplaceCount.set(this.numConnections);
        }
    }

    public void releaseAndReAuthenticateConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return;
        }
        try {
            BindResult bindResult;
            try {
                bindResult = this.bindRequest == null ? lDAPConnection.bind("", "") : lDAPConnection.bind(this.bindRequest.duplicate());
            }
            catch (LDAPBindException lDAPBindException) {
                Debug.debugException(lDAPBindException);
                bindResult = lDAPBindException.getBindResult();
            }
            try {
                this.healthCheck.ensureConnectionValidAfterAuthentication(lDAPConnection, bindResult);
                if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPBindException(bindResult);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                try {
                    lDAPConnection.setDisconnectInfo(DisconnectType.BIND_FAILED, null, lDAPException);
                    lDAPConnection.terminate(null);
                    this.releaseDefunctConnection(lDAPConnection);
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                }
                throw lDAPException;
            }
            this.releaseConnection(lDAPConnection);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            this.releaseDefunctConnection(lDAPConnection);
        }
    }

    @Override
    public void releaseDefunctConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return;
        }
        lDAPConnection.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        this.handleDefunctConnection(lDAPConnection);
    }

    private LDAPConnection handleDefunctConnection(LDAPConnection lDAPConnection) {
        lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        lDAPConnection.terminate(null);
        if (this.closed) {
            return null;
        }
        if (this.createIfNecessary && this.availableConnections.remainingCapacity() <= 0) {
            return null;
        }
        try {
            LDAPConnection lDAPConnection2 = this.createConnection();
            if (this.maxDefunctReplacementConnectionAge != null && lDAPConnection2.getAttachment(ATTACHMENT_NAME_MAX_CONNECTION_AGE) == null) {
                lDAPConnection2.setAttachment(ATTACHMENT_NAME_MAX_CONNECTION_AGE, this.maxDefunctReplacementConnectionAge);
            }
            if (!this.availableConnections.offer(lDAPConnection2)) {
                lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                lDAPConnection2.terminate(null);
                return null;
            }
            return lDAPConnection2;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            int n = this.failedReplaceCount.incrementAndGet();
            if (n > this.numConnections) {
                this.failedReplaceCount.set(this.numConnections);
            }
            return null;
        }
    }

    @Override
    public LDAPConnection replaceDefunctConnection(LDAPConnection lDAPConnection) throws LDAPException {
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        lDAPConnection.terminate(null);
        if (this.closed) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        return this.createConnection();
    }

    @Override
    public Set<OperationType> getOperationTypesToRetryDueToInvalidConnections() {
        return this.retryOperationTypes.get();
    }

    @Override
    public void setRetryFailedOperationsDueToInvalidConnections(Set<OperationType> set) {
        if (set == null || set.isEmpty()) {
            this.retryOperationTypes.set(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        } else {
            EnumSet<OperationType> enumSet = EnumSet.noneOf(OperationType.class);
            enumSet.addAll(set);
            this.retryOperationTypes.set(Collections.unmodifiableSet(enumSet));
        }
    }

    private boolean connectionIsExpired(LDAPConnection lDAPConnection) {
        Object object = lDAPConnection.getAttachment(ATTACHMENT_NAME_MAX_CONNECTION_AGE);
        long l = object != null && object instanceof Long ? (Long)object : this.maxConnectionAge;
        if (l <= 0L) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastExpiredDisconnectTime < this.minDisconnectInterval) {
            return false;
        }
        long l3 = l2 - lDAPConnection.getConnectTime();
        return l3 > l;
    }

    @Override
    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    @Override
    public void setConnectionPoolName(String string) {
        this.connectionPoolName = string;
        for (LDAPConnection lDAPConnection : this.availableConnections) {
            lDAPConnection.setConnectionPoolName(string);
        }
    }

    public boolean getCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public void setCreateIfNecessary(boolean bl) {
        this.createIfNecessary = bl;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTimeMillis(long l) {
        this.maxWaitTime = l > 0L ? l : 0L;
    }

    public long getMaxConnectionAgeMillis() {
        return this.maxConnectionAge;
    }

    public void setMaxConnectionAgeMillis(long l) {
        this.maxConnectionAge = l > 0L ? l : 0L;
    }

    public Long getMaxDefunctReplacementConnectionAgeMillis() {
        return this.maxDefunctReplacementConnectionAge;
    }

    public void setMaxDefunctReplacementConnectionAgeMillis(Long l) {
        this.maxDefunctReplacementConnectionAge = l == null ? null : (l > 0L ? l : Long.valueOf(0L));
    }

    public boolean checkConnectionAgeOnRelease() {
        return this.checkConnectionAgeOnRelease;
    }

    public void setCheckConnectionAgeOnRelease(boolean bl) {
        this.checkConnectionAgeOnRelease = bl;
    }

    public long getMinDisconnectIntervalMillis() {
        return this.minDisconnectInterval;
    }

    public void setMinDisconnectIntervalMillis(long l) {
        this.minDisconnectInterval = l > 0L ? l : 0L;
    }

    @Override
    public LDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) {
        Validator.ensureNotNull(lDAPConnectionPoolHealthCheck);
        this.healthCheck = lDAPConnectionPoolHealthCheck;
    }

    @Override
    public long getHealthCheckIntervalMillis() {
        return this.healthCheckInterval;
    }

    @Override
    public void setHealthCheckIntervalMillis(long l) {
        Validator.ensureTrue(l > 0L, "LDAPConnectionPool.healthCheckInterval must be greater than 0.");
        this.healthCheckInterval = l;
        this.healthCheckThread.wakeUp();
    }

    public boolean trySynchronousReadDuringHealthCheck() {
        return this.trySynchronousReadDuringHealthCheck;
    }

    public void setTrySynchronousReadDuringHealthCheck(boolean bl) {
        this.trySynchronousReadDuringHealthCheck = bl;
    }

    @Override
    protected void doHealthCheck() {
        this.invokeHealthCheck(null, true);
    }

    public LDAPConnectionPoolHealthCheckResult invokeHealthCheck(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck, boolean bl) {
        return this.invokeHealthCheck(lDAPConnectionPoolHealthCheck, bl, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnectionPoolHealthCheckResult invokeHealthCheck(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck, boolean bl, boolean bl2) {
        LDAPConnection lDAPConnection;
        LDAPConnection lDAPConnection2;
        int n;
        LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck2 = lDAPConnectionPoolHealthCheck == null ? this.healthCheck : lDAPConnectionPoolHealthCheck;
        HashSet<LDAPConnection> hashSet = new HashSet<LDAPConnection>(this.numConnections);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.numConnections && (lDAPConnection2 = this.availableConnections.poll()) != null; ++n) {
            block44: {
                if (hashSet.contains(lDAPConnection2)) {
                    if (this.availableConnections.offer(lDAPConnection2)) break;
                    lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    lDAPConnection2.terminate(null);
                    break;
                }
                ++n2;
                if (!lDAPConnection2.isConnected()) {
                    ++n3;
                    this.poolStatistics.incrementNumConnectionsClosedDefunct();
                    lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                    if (lDAPConnection2 == null) continue;
                    hashSet.add(lDAPConnection2);
                    continue;
                }
                if (bl && this.connectionIsExpired(lDAPConnection2)) {
                    ++n4;
                    try {
                        lDAPConnection = this.createConnection();
                        if (this.availableConnections.offer(lDAPConnection)) {
                            hashSet.add(lDAPConnection);
                            lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                            lDAPConnection2.terminate(null);
                            this.poolStatistics.incrementNumConnectionsClosedExpired();
                            this.lastExpiredDisconnectTime = System.currentTimeMillis();
                            continue;
                        }
                        lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                        lDAPConnection.terminate(null);
                        this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    }
                    catch (LDAPException lDAPException) {
                        Debug.debugException(lDAPException);
                    }
                }
                if (this.trySynchronousReadDuringHealthCheck && lDAPConnection2.synchronousMode()) {
                    int n5 = Integer.MIN_VALUE;
                    Socket socket = null;
                    try {
                        Object object;
                        socket = lDAPConnection2.getConnectionInternals(true).getSocket();
                        n5 = socket.getSoTimeout();
                        socket.setSoTimeout(1);
                        LDAPResponse lDAPResponse = lDAPConnection2.readResponse(0);
                        if (lDAPResponse instanceof ConnectionClosedResponse) {
                            ++n3;
                            lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_CLOSED.get(), null);
                            this.poolStatistics.incrementNumConnectionsClosedDefunct();
                            lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                            if (lDAPConnection2 == null) continue;
                            hashSet.add(lDAPConnection2);
                            continue;
                        }
                        if (lDAPResponse instanceof ExtendedResult) {
                            object = lDAPConnection2.getConnectionOptions().getUnsolicitedNotificationHandler();
                            if (object != null) {
                                object.handleUnsolicitedNotification(lDAPConnection2, (ExtendedResult)lDAPResponse);
                            }
                        } else if (lDAPResponse instanceof LDAPResult && ((LDAPResult)(object = (LDAPResult)lDAPResponse)).getResultCode() == ResultCode.SERVER_DOWN) {
                            ++n3;
                            lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_CLOSED.get(), null);
                            this.poolStatistics.incrementNumConnectionsClosedDefunct();
                            lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                            if (lDAPConnection2 == null) continue;
                            hashSet.add(lDAPConnection2);
                            continue;
                        }
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getResultCode() == ResultCode.TIMEOUT) {
                            Debug.debugException(Level.FINEST, lDAPException);
                            break block44;
                        }
                        Debug.debugException(lDAPException);
                        ++n3;
                        lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_READ_FAILURE.get(StaticUtils.getExceptionMessage(lDAPException)), lDAPException);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                        if (lDAPConnection2 == null) continue;
                        hashSet.add(lDAPConnection2);
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        ++n3;
                        lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_READ_FAILURE.get(StaticUtils.getExceptionMessage(exception)), exception);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                        if (lDAPConnection2 == null) continue;
                        hashSet.add(lDAPConnection2);
                        continue;
                    }
                    finally {
                        block45: {
                            if (n5 != Integer.MIN_VALUE) {
                                try {
                                    if (socket == null) break block45;
                                    socket.setSoTimeout(n5);
                                }
                                catch (Exception exception) {
                                    Debug.debugException(exception);
                                    ++n3;
                                    lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, exception);
                                    this.poolStatistics.incrementNumConnectionsClosedDefunct();
                                    lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                                    if (lDAPConnection2 == null) continue;
                                    hashSet.add(lDAPConnection2);
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
            try {
                lDAPConnectionPoolHealthCheck2.ensureConnectionValidForContinuedUse(lDAPConnection2);
                if (this.availableConnections.offer(lDAPConnection2)) {
                    hashSet.add(lDAPConnection2);
                    continue;
                }
                lDAPConnection2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                lDAPConnection2.terminate(null);
                continue;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                ++n3;
                this.poolStatistics.incrementNumConnectionsClosedDefunct();
                lDAPConnection2 = this.handleDefunctConnection(lDAPConnection2);
                if (lDAPConnection2 == null) continue;
                hashSet.add(lDAPConnection2);
            }
        }
        if (bl2) {
            try {
                n = this.minConnectionGoal - this.availableConnections.size();
                for (int i = 0; i < n; ++i) {
                    lDAPConnection = this.createConnection(lDAPConnectionPoolHealthCheck2);
                    if (this.availableConnections.offer(lDAPConnection)) continue;
                    lDAPConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    lDAPConnection.terminate(null);
                    break;
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        return new LDAPConnectionPoolHealthCheckResult(n2, n4, n3);
    }

    @Override
    public int getCurrentAvailableConnections() {
        return this.availableConnections.size();
    }

    @Override
    public int getMaximumAvailableConnections() {
        return this.numConnections;
    }

    public int getMinimumAvailableConnectionGoal() {
        return this.minConnectionGoal;
    }

    public void setMinimumAvailableConnectionGoal(int n) {
        this.minConnectionGoal = n > this.numConnections ? this.numConnections : (n > 0 ? n : 0);
    }

    @Override
    public LDAPConnectionPoolStatistics getConnectionPoolStatistics() {
        return this.poolStatistics;
    }

    public void shrinkPool(int n) {
        while (this.availableConnections.size() > n) {
            LDAPConnection lDAPConnection;
            try {
                lDAPConnection = this.getConnection();
            }
            catch (LDAPException lDAPException) {
                return;
            }
            if (this.availableConnections.size() >= n) {
                this.discardConnection(lDAPConnection);
                continue;
            }
            this.releaseConnection(lDAPConnection);
            return;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDAPConnectionPool(");
        String string = this.connectionPoolName;
        if (string != null) {
            stringBuilder.append("name='");
            stringBuilder.append(string);
            stringBuilder.append("', ");
        }
        stringBuilder.append("serverSet=");
        this.serverSet.toString(stringBuilder);
        stringBuilder.append(", maxConnections=");
        stringBuilder.append(this.numConnections);
        stringBuilder.append(')');
    }
}

