/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public final class LDAPConnectionPoolStatistics
implements Serializable {
    private static final long serialVersionUID = 1493039391352814874L;
    private final AtomicLong numConnectionsClosedDefunct;
    private final AtomicLong numConnectionsClosedExpired;
    private final AtomicLong numConnectionsClosedUnneeded;
    private final AtomicLong numFailedCheckouts;
    private final AtomicLong numFailedConnectionAttempts;
    private final AtomicLong numReleasedValid;
    private final AtomicLong numSuccessfulCheckouts;
    private final AtomicLong numSuccessfulCheckoutsAfterWait;
    private final AtomicLong numSuccessfulCheckoutsNewConnection;
    private final AtomicLong numSuccessfulCheckoutsWithoutWait;
    private final AtomicLong numSuccessfulConnectionAttempts;
    private final AbstractConnectionPool pool;

    public LDAPConnectionPoolStatistics(AbstractConnectionPool abstractConnectionPool) {
        this.pool = abstractConnectionPool;
        this.numSuccessfulConnectionAttempts = new AtomicLong(0L);
        this.numFailedConnectionAttempts = new AtomicLong(0L);
        this.numConnectionsClosedDefunct = new AtomicLong(0L);
        this.numConnectionsClosedExpired = new AtomicLong(0L);
        this.numConnectionsClosedUnneeded = new AtomicLong(0L);
        this.numSuccessfulCheckouts = new AtomicLong(0L);
        this.numSuccessfulCheckoutsAfterWait = new AtomicLong(0L);
        this.numSuccessfulCheckoutsNewConnection = new AtomicLong(0L);
        this.numSuccessfulCheckoutsWithoutWait = new AtomicLong(0L);
        this.numFailedCheckouts = new AtomicLong(0L);
        this.numReleasedValid = new AtomicLong(0L);
    }

    public void reset() {
        this.numSuccessfulConnectionAttempts.set(0L);
        this.numFailedConnectionAttempts.set(0L);
        this.numConnectionsClosedDefunct.set(0L);
        this.numConnectionsClosedExpired.set(0L);
        this.numConnectionsClosedUnneeded.set(0L);
        this.numSuccessfulCheckouts.set(0L);
        this.numSuccessfulCheckoutsAfterWait.set(0L);
        this.numSuccessfulCheckoutsNewConnection.set(0L);
        this.numSuccessfulCheckoutsWithoutWait.set(0L);
        this.numFailedCheckouts.set(0L);
        this.numReleasedValid.set(0L);
    }

    public long getNumSuccessfulConnectionAttempts() {
        return this.numSuccessfulConnectionAttempts.get();
    }

    void incrementNumSuccessfulConnectionAttempts() {
        this.numSuccessfulConnectionAttempts.incrementAndGet();
    }

    public long getNumFailedConnectionAttempts() {
        return this.numFailedConnectionAttempts.get();
    }

    void incrementNumFailedConnectionAttempts() {
        this.numFailedConnectionAttempts.incrementAndGet();
    }

    public long getNumConnectionsClosedDefunct() {
        return this.numConnectionsClosedDefunct.get();
    }

    void incrementNumConnectionsClosedDefunct() {
        this.numConnectionsClosedDefunct.incrementAndGet();
    }

    public long getNumConnectionsClosedExpired() {
        return this.numConnectionsClosedExpired.get();
    }

    void incrementNumConnectionsClosedExpired() {
        this.numConnectionsClosedExpired.incrementAndGet();
    }

    public long getNumConnectionsClosedUnneeded() {
        return this.numConnectionsClosedUnneeded.get();
    }

    void incrementNumConnectionsClosedUnneeded() {
        this.numConnectionsClosedUnneeded.incrementAndGet();
    }

    public long getNumSuccessfulCheckouts() {
        return this.numSuccessfulCheckouts.get();
    }

    public long getNumSuccessfulCheckoutsWithoutWaiting() {
        return this.numSuccessfulCheckoutsWithoutWait.get();
    }

    public long getNumSuccessfulCheckoutsAfterWaiting() {
        return this.numSuccessfulCheckoutsAfterWait.get();
    }

    public long getNumSuccessfulCheckoutsNewConnection() {
        return this.numSuccessfulCheckoutsNewConnection.get();
    }

    void incrementNumSuccessfulCheckoutsWithoutWaiting() {
        this.numSuccessfulCheckouts.incrementAndGet();
        this.numSuccessfulCheckoutsWithoutWait.incrementAndGet();
    }

    void incrementNumSuccessfulCheckoutsAfterWaiting() {
        this.numSuccessfulCheckouts.incrementAndGet();
        this.numSuccessfulCheckoutsAfterWait.incrementAndGet();
    }

    void incrementNumSuccessfulCheckoutsNewConnection() {
        this.numSuccessfulCheckouts.incrementAndGet();
        this.numSuccessfulCheckoutsNewConnection.incrementAndGet();
    }

    public long getNumFailedCheckouts() {
        return this.numFailedCheckouts.get();
    }

    void incrementNumFailedCheckouts() {
        this.numFailedCheckouts.incrementAndGet();
    }

    public long getNumReleasedValid() {
        return this.numReleasedValid.get();
    }

    void incrementNumReleasedValid() {
        this.numReleasedValid.incrementAndGet();
    }

    public int getNumAvailableConnections() {
        return this.pool.getCurrentAvailableConnections();
    }

    public int getMaximumAvailableConnections() {
        return this.pool.getMaximumAvailableConnections();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        long l = this.pool.getCurrentAvailableConnections();
        long l2 = this.pool.getMaximumAvailableConnections();
        long l3 = this.numSuccessfulConnectionAttempts.get();
        long l4 = this.numFailedConnectionAttempts.get();
        long l5 = this.numConnectionsClosedDefunct.get();
        long l6 = this.numConnectionsClosedExpired.get();
        long l7 = this.numConnectionsClosedUnneeded.get();
        long l8 = this.numSuccessfulCheckouts.get();
        long l9 = this.numFailedCheckouts.get();
        long l10 = this.numReleasedValid.get();
        stringBuilder.append("LDAPConnectionPoolStatistics(numAvailableConnections=");
        stringBuilder.append(l);
        stringBuilder.append(", maxAvailableConnections=");
        stringBuilder.append(l2);
        stringBuilder.append(", numSuccessfulConnectionAttempts=");
        stringBuilder.append(l3);
        stringBuilder.append(", numFailedConnectionAttempts=");
        stringBuilder.append(l4);
        stringBuilder.append(", numConnectionsClosedDefunct=");
        stringBuilder.append(l5);
        stringBuilder.append(", numConnectionsClosedExpired=");
        stringBuilder.append(l6);
        stringBuilder.append(", numConnectionsClosedUnneeded=");
        stringBuilder.append(l7);
        stringBuilder.append(", numSuccessfulCheckouts=");
        stringBuilder.append(l8);
        stringBuilder.append(", numFailedCheckouts=");
        stringBuilder.append(l9);
        stringBuilder.append(", numReleasedValid=");
        stringBuilder.append(l10);
        stringBuilder.append(')');
    }
}

