/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyLDAPRequest;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LDAPRequest
implements ReadOnlyLDAPRequest {
    static final Control[] NO_CONTROLS = new Control[0];
    private static final long serialVersionUID = -2040756188243320117L;
    private Boolean followReferrals;
    private Control[] controls;
    private IntermediateResponseListener intermediateResponseListener;
    private long responseTimeout;

    protected LDAPRequest(Control[] controlArray) {
        this.controls = controlArray == null ? NO_CONTROLS : controlArray;
        this.followReferrals = null;
        this.responseTimeout = -1L;
        this.intermediateResponseListener = null;
    }

    public final Control[] getControls() {
        return this.controls;
    }

    @Override
    public final List<Control> getControlList() {
        return Collections.unmodifiableList(Arrays.asList(this.controls));
    }

    @Override
    public final boolean hasControl() {
        return this.controls.length > 0;
    }

    @Override
    public final boolean hasControl(String string) {
        Validator.ensureNotNull(string);
        for (Control control : this.controls) {
            if (!control.getOID().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Control getControl(String string) {
        Validator.ensureNotNull(string);
        for (Control control : this.controls) {
            if (!control.getOID().equals(string)) continue;
            return control;
        }
        return null;
    }

    final void setControlsInternal(Control[] controlArray) {
        this.controls = controlArray;
    }

    @Override
    public final long getResponseTimeoutMillis(LDAPConnection lDAPConnection) {
        if (this.responseTimeout < 0L && lDAPConnection != null) {
            return lDAPConnection.getConnectionOptions().getResponseTimeoutMillis();
        }
        return this.responseTimeout;
    }

    public final void setResponseTimeoutMillis(long l) {
        this.responseTimeout = l < 0L ? -1L : l;
    }

    @Override
    public final boolean followReferrals(LDAPConnection lDAPConnection) {
        if (this.followReferrals == null) {
            return lDAPConnection.getConnectionOptions().followReferrals();
        }
        return this.followReferrals;
    }

    final Boolean followReferralsInternal() {
        return this.followReferrals;
    }

    public final void setFollowReferrals(Boolean bl) {
        this.followReferrals = bl;
    }

    public final IntermediateResponseListener getIntermediateResponseListener() {
        return this.intermediateResponseListener;
    }

    public final void setIntermediateResponseListener(IntermediateResponseListener intermediateResponseListener) {
        this.intermediateResponseListener = intermediateResponseListener;
    }

    @InternalUseOnly
    protected abstract LDAPResult process(LDAPConnection var1, int var2) throws LDAPException;

    public abstract int getLastMessageID();

    public abstract OperationType getOperationType();

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public abstract void toString(StringBuilder var1);
}

