/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPResult
implements Serializable,
LDAPResponse {
    static final byte TYPE_REFERRAL_URLS = -93;
    private static final long serialVersionUID = 2215819095653175991L;
    private final Byte protocolOpType;
    private final Control[] responseControls;
    private final int messageID;
    private final ResultCode resultCode;
    private final String diagnosticMessage;
    private final String matchedDN;
    private final String[] referralURLs;

    protected LDAPResult(LDAPResult lDAPResult) {
        this.protocolOpType = lDAPResult.protocolOpType;
        this.messageID = lDAPResult.messageID;
        this.resultCode = lDAPResult.resultCode;
        this.diagnosticMessage = lDAPResult.diagnosticMessage;
        this.matchedDN = lDAPResult.matchedDN;
        this.referralURLs = lDAPResult.referralURLs;
        this.responseControls = lDAPResult.responseControls;
    }

    public LDAPResult(int n, ResultCode resultCode) {
        this(null, n, resultCode, null, null, StaticUtils.NO_STRINGS, NO_CONTROLS);
    }

    public LDAPResult(int n, ResultCode resultCode, String string, String string2, String[] stringArray, Control[] controlArray) {
        this(null, n, resultCode, string, string2, stringArray, controlArray);
    }

    public LDAPResult(int n, ResultCode resultCode, String string, String string2, List<String> list, List<Control> list2) {
        this(null, n, resultCode, string, string2, list, list2);
    }

    private LDAPResult(Byte by, int n, ResultCode resultCode, String string, String string2, String[] stringArray, Control[] controlArray) {
        this.protocolOpType = by;
        this.messageID = n;
        this.resultCode = resultCode;
        this.diagnosticMessage = string;
        this.matchedDN = string2;
        this.referralURLs = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.responseControls = controlArray == null ? NO_CONTROLS : controlArray;
    }

    private LDAPResult(Byte by, int n, ResultCode resultCode, String string, String string2, List<String> list, List<Control> list2) {
        this.protocolOpType = by;
        this.messageID = n;
        this.resultCode = resultCode;
        this.diagnosticMessage = string;
        this.matchedDN = string2;
        if (list == null || list.isEmpty()) {
            this.referralURLs = StaticUtils.NO_STRINGS;
        } else {
            this.referralURLs = new String[list.size()];
            list.toArray(this.referralURLs);
        }
        if (list2 == null || list2.isEmpty()) {
            this.responseControls = NO_CONTROLS;
        } else {
            this.responseControls = new Control[list2.size()];
            list2.toArray(this.responseControls);
        }
    }

    static LDAPResult readLDAPResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            Object object;
            Object object2;
            String string;
            ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
            byte by = aSN1StreamReaderSequence2.getType();
            ResultCode resultCode = ResultCode.valueOf(aSN1StreamReader.readEnumerated());
            String string2 = aSN1StreamReader.readString();
            if (string2.length() == 0) {
                string2 = null;
            }
            if ((string = aSN1StreamReader.readString()).length() == 0) {
                string = null;
            }
            String[] stringArray = StaticUtils.NO_STRINGS;
            if (aSN1StreamReaderSequence2.hasMoreElements()) {
                object2 = new ArrayList(1);
                object = aSN1StreamReader.beginSequence();
                while (((ASN1StreamReaderSequence)object).hasMoreElements()) {
                    ((ArrayList)object2).add(aSN1StreamReader.readString());
                }
                stringArray = new String[((ArrayList)object2).size()];
                ((ArrayList)object2).toArray(stringArray);
            }
            object2 = NO_CONTROLS;
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                object = new ArrayList(1);
                ASN1StreamReaderSequence aSN1StreamReaderSequence3 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence3.hasMoreElements()) {
                    ((ArrayList)object).add(Control.readFrom(aSN1StreamReader));
                }
                object2 = new Control[((ArrayList)object).size()];
                ((ArrayList)object).toArray((T[])object2);
            }
            return new LDAPResult((Byte)by, n, resultCode, string, string2, stringArray, (Control[])object2);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_RESULT_CANNOT_DECODE.get(aSN1Exception.getMessage()), aSN1Exception);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public final int getMessageID() {
        return this.messageID;
    }

    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public final String getMatchedDN() {
        return this.matchedDN;
    }

    public final String[] getReferralURLs() {
        return this.referralURLs;
    }

    public final Control[] getResponseControls() {
        return this.responseControls;
    }

    public final boolean hasResponseControl() {
        return this.responseControls.length > 0;
    }

    public final boolean hasResponseControl(String string) {
        for (Control control : this.responseControls) {
            if (!control.getOID().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final Control getResponseControl(String string) {
        for (Control control : this.responseControls) {
            if (!control.getOID().equals(string)) continue;
            return control;
        }
        return null;
    }

    public String getResultString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("result code='");
        stringBuilder.append(this.resultCode);
        stringBuilder.append('\'');
        if (this.diagnosticMessage != null && this.diagnosticMessage.length() > 0) {
            stringBuilder.append(" diagnostic message='");
            stringBuilder.append(this.diagnosticMessage);
            stringBuilder.append('\'');
        }
        if (this.matchedDN != null && this.matchedDN.length() > 0) {
            stringBuilder.append("  matched DN='");
            stringBuilder.append(this.matchedDN);
            stringBuilder.append('\'');
        }
        if (this.referralURLs != null && this.referralURLs.length > 0) {
            stringBuilder.append("  referral URLs={");
            for (int i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(this.referralURLs[i]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        int n;
        stringBuilder.append("LDAPResult(resultCode=");
        stringBuilder.append(this.resultCode);
        if (this.messageID >= 0) {
            stringBuilder.append(", messageID=");
            stringBuilder.append(this.messageID);
        }
        if (this.protocolOpType != null) {
            switch (this.protocolOpType) {
                case 105: {
                    stringBuilder.append(", opType='add'");
                    break;
                }
                case 97: {
                    stringBuilder.append(", opType='bind'");
                    break;
                }
                case 111: {
                    stringBuilder.append(", opType='compare'");
                    break;
                }
                case 107: {
                    stringBuilder.append(", opType='delete'");
                    break;
                }
                case 120: {
                    stringBuilder.append(", opType='extended'");
                    break;
                }
                case 103: {
                    stringBuilder.append(", opType='modify'");
                    break;
                }
                case 109: {
                    stringBuilder.append(", opType='modify DN'");
                    break;
                }
                case 101: {
                    stringBuilder.append(", opType='search'");
                }
            }
        }
        if (this.diagnosticMessage != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(this.diagnosticMessage);
            stringBuilder.append('\'');
        }
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(this.matchedDN);
            stringBuilder.append('\'');
        }
        if (this.referralURLs.length > 0) {
            stringBuilder.append(", referralURLs={");
            for (n = 0; n < this.referralURLs.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(this.referralURLs[n]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        if (this.responseControls.length > 0) {
            stringBuilder.append(", responseControls={");
            for (n = 0; n < this.responseControls.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.responseControls[n]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

