/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class LDAPURL
implements Serializable {
    private static final Filter DEFAULT_FILTER = Filter.createPresenceFilter("objectClass");
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final int DEFAULT_LDAPS_PORT = 636;
    public static final int DEFAULT_LDAPI_PORT = 0;
    private static final SearchScope DEFAULT_SCOPE = SearchScope.BASE;
    private static final DN DEFAULT_BASE_DN = DN.NULL_DN;
    private static final String[] DEFAULT_ATTRIBUTES = StaticUtils.NO_STRINGS;
    private static final long serialVersionUID = 3420786933570240493L;
    private final boolean attributesProvided;
    private final boolean baseDNProvided;
    private final boolean filterProvided;
    private final boolean portProvided;
    private final boolean scopeProvided;
    private final DN baseDN;
    private final Filter filter;
    private final int port;
    private final SearchScope scope;
    private final String host;
    private volatile String normalizedURLString;
    private final String scheme;
    private final String urlString;
    private final String[] attributes;

    public LDAPURL(String string) throws LDAPException {
        StringBuilder stringBuilder;
        int n;
        Validator.ensureNotNull(string);
        this.urlString = string;
        int n2 = string.indexOf("://");
        if (n2 < 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_NO_COLON_SLASHES.get());
        }
        this.scheme = StaticUtils.toLowerCase(string.substring(0, n2));
        if (this.scheme.equals("ldap")) {
            n = 389;
        } else if (this.scheme.equals("ldaps")) {
            n = 636;
        } else if (this.scheme.equals("ldapi")) {
            n = 0;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCHEME.get(this.scheme));
        }
        int n3 = string.indexOf(47, n2 + 3);
        if (n3 < 0) {
            StringBuilder stringBuilder2;
            this.baseDN = DEFAULT_BASE_DN;
            this.baseDNProvided = false;
            this.attributes = DEFAULT_ATTRIBUTES;
            this.attributesProvided = false;
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            String string2 = string.substring(n2 + 3);
            int n4 = LDAPURL.decodeHostPort(string2, stringBuilder2 = new StringBuilder(string2.length()));
            if (n4 < 0) {
                this.port = n;
                this.portProvided = false;
            } else {
                this.port = n4;
                this.portProvided = true;
            }
            this.host = stringBuilder2.length() == 0 ? null : stringBuilder2.toString();
            return;
        }
        String string3 = string.substring(n2 + 3, n3);
        int n5 = LDAPURL.decodeHostPort(string3, stringBuilder = new StringBuilder(string3.length()));
        if (n5 < 0) {
            this.port = n;
            this.portProvided = false;
        } else {
            this.port = n5;
            this.portProvided = true;
        }
        this.host = stringBuilder.length() == 0 ? null : stringBuilder.toString();
        int n6 = string.indexOf(63, n3 + 1);
        if (n6 < 0) {
            this.attributes = DEFAULT_ATTRIBUTES;
            this.attributesProvided = false;
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            this.baseDN = new DN(LDAPURL.percentDecode(string.substring(n3 + 1)));
            this.baseDNProvided = !this.baseDN.isNullDN();
            return;
        }
        this.baseDN = new DN(LDAPURL.percentDecode(string.substring(n3 + 1, n6)));
        this.baseDNProvided = !this.baseDN.isNullDN();
        int n7 = string.indexOf(63, n6 + 1);
        if (n7 < 0) {
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            this.attributes = LDAPURL.decodeAttributes(string.substring(n6 + 1));
            this.attributesProvided = this.attributes.length > 0;
            return;
        }
        this.attributes = LDAPURL.decodeAttributes(string.substring(n6 + 1, n7));
        this.attributesProvided = this.attributes.length > 0;
        int n8 = string.indexOf(63, n7 + 1);
        if (n8 < 0) {
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
            String string4 = StaticUtils.toLowerCase(string.substring(n7 + 1));
            if (string4.length() == 0) {
                this.scope = SearchScope.BASE;
                this.scopeProvided = false;
            } else if (string4.equals("base")) {
                this.scope = SearchScope.BASE;
                this.scopeProvided = true;
            } else if (string4.equals("one")) {
                this.scope = SearchScope.ONE;
                this.scopeProvided = true;
            } else if (string4.equals("sub")) {
                this.scope = SearchScope.SUB;
                this.scopeProvided = true;
            } else if (string4.equals("subord") || string4.equals("subordinates")) {
                this.scope = SearchScope.SUBORDINATE_SUBTREE;
                this.scopeProvided = true;
            } else {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCOPE.get(string4));
            }
            return;
        }
        String string5 = StaticUtils.toLowerCase(string.substring(n7 + 1, n8));
        if (string5.length() == 0) {
            this.scope = SearchScope.BASE;
            this.scopeProvided = false;
        } else if (string5.equals("base")) {
            this.scope = SearchScope.BASE;
            this.scopeProvided = true;
        } else if (string5.equals("one")) {
            this.scope = SearchScope.ONE;
            this.scopeProvided = true;
        } else if (string5.equals("sub")) {
            this.scope = SearchScope.SUB;
            this.scopeProvided = true;
        } else if (string5.equals("subord") || string5.equals("subordinates")) {
            this.scope = SearchScope.SUBORDINATE_SUBTREE;
            this.scopeProvided = true;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCOPE.get(string5));
        }
        String string6 = LDAPURL.percentDecode(string.substring(n8 + 1));
        if (string6.length() == 0) {
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
        } else {
            this.filter = Filter.create(string6);
            this.filterProvided = true;
        }
    }

    public LDAPURL(String string, String string2, Integer n, DN dN, String[] stringArray, SearchScope searchScope, Filter filter) throws LDAPException {
        int n2;
        Validator.ensureNotNull(string);
        StringBuilder stringBuilder = new StringBuilder();
        this.scheme = StaticUtils.toLowerCase(string);
        if (string.equals("ldap")) {
            n2 = 389;
        } else if (string.equals("ldaps")) {
            n2 = 636;
        } else if (string.equals("ldapi")) {
            n2 = 0;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCHEME.get(string));
        }
        stringBuilder.append(string);
        stringBuilder.append("://");
        if (string2 == null || string2.length() == 0) {
            this.host = null;
        } else {
            this.host = string2;
            stringBuilder.append(string2);
        }
        if (n == null) {
            this.port = n2;
            this.portProvided = false;
        } else {
            this.port = n;
            this.portProvided = true;
            stringBuilder.append(':');
            stringBuilder.append(n);
            if (n < 1 || n > 65535) {
                throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_PORT.get(n));
            }
        }
        stringBuilder.append('/');
        if (dN == null) {
            this.baseDN = DEFAULT_BASE_DN;
            this.baseDNProvided = false;
        } else {
            this.baseDN = dN;
            this.baseDNProvided = true;
            LDAPURL.percentEncode(dN.toString(), stringBuilder);
        }
        boolean bl = stringArray != null && stringArray.length != 0 || searchScope != null || filter != null;
        if (bl) {
            stringBuilder.append('?');
        }
        if (stringArray == null || stringArray.length == 0) {
            this.attributes = DEFAULT_ATTRIBUTES;
            this.attributesProvided = false;
        } else {
            this.attributes = stringArray;
            this.attributesProvided = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(stringArray[i]);
            }
        }
        if (bl) {
            stringBuilder.append('?');
        }
        if (searchScope == null) {
            this.scope = DEFAULT_SCOPE;
            this.scopeProvided = false;
        } else {
            switch (searchScope.intValue()) {
                case 0: {
                    this.scope = searchScope;
                    this.scopeProvided = true;
                    stringBuilder.append("base");
                    break;
                }
                case 1: {
                    this.scope = searchScope;
                    this.scopeProvided = true;
                    stringBuilder.append("one");
                    break;
                }
                case 2: {
                    this.scope = searchScope;
                    this.scopeProvided = true;
                    stringBuilder.append("sub");
                    break;
                }
                case 3: {
                    this.scope = searchScope;
                    this.scopeProvided = true;
                    stringBuilder.append("subordinates");
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_SCOPE_VALUE.get(searchScope));
                }
            }
        }
        if (bl) {
            stringBuilder.append('?');
        }
        if (filter == null) {
            this.filter = DEFAULT_FILTER;
            this.filterProvided = false;
        } else {
            this.filter = filter;
            this.filterProvided = true;
            LDAPURL.percentEncode(filter.toString(), stringBuilder);
        }
        this.urlString = stringBuilder.toString();
    }

    private static int decodeHostPort(String string, StringBuilder stringBuilder) throws LDAPException {
        int n = string.length();
        if (n == 0) {
            return -1;
        }
        if (string.charAt(0) == '[') {
            int n2 = string.indexOf(93);
            if (n2 < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_IPV6_HOST_MISSING_BRACKET.get());
            }
            stringBuilder.append(string.substring(1, n2).trim());
            if (stringBuilder.length() == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_IPV6_HOST_EMPTY.get());
            }
            if (n2 == n - 1) {
                return -1;
            }
            if (string.charAt(n2 + 1) != ':') {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_IPV6_HOST_UNEXPECTED_CHAR.get(Character.valueOf(string.charAt(n2 + 1))));
            }
            try {
                int n3 = Integer.parseInt(string.substring(n2 + 2));
                if (n3 >= 1 && n3 <= 65535) {
                    return n3;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_PORT.get(n3));
            }
            catch (NumberFormatException numberFormatException) {
                Debug.debugException(numberFormatException);
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_PORT_NOT_INT.get(string), numberFormatException);
            }
        }
        int n4 = string.indexOf(58);
        if (n4 < 0) {
            stringBuilder.append(string);
            return -1;
        }
        try {
            int n5 = Integer.parseInt(string.substring(n4 + 1));
            if (n5 >= 1 && n5 <= 65535) {
                stringBuilder.append(string.substring(0, n4));
                return n5;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_PORT.get(n5));
        }
        catch (NumberFormatException numberFormatException) {
            Debug.debugException(numberFormatException);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_PORT_NOT_INT.get(string), numberFormatException);
        }
    }

    private static String[] decodeAttributes(String string) throws LDAPException {
        int n = string.length();
        if (n == 0) {
            return DEFAULT_ATTRIBUTES;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            int n3 = string.indexOf(44, n2);
            if (n3 < 0) {
                string2 = string.substring(n2).trim();
                if (string2.length() == 0) {
                    if (arrayList.isEmpty()) {
                        return DEFAULT_ATTRIBUTES;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_ATTRLIST_ENDS_WITH_COMMA.get());
                }
                arrayList.add(string2);
                break;
            }
            string2 = string.substring(n2, n3).trim();
            if (string2.length() == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_ATTRLIST_EMPTY_ATTRIBUTE.get());
            }
            arrayList.add(string2);
            n2 = n3 + 1;
            if (n2 < n) continue;
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_ATTRLIST_ENDS_WITH_COMMA.get());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String percentDecode(String string) throws LDAPException {
        int n;
        int n2 = -1;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            if (string.charAt(n) != '%') continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            return string;
        }
        n = n2;
        StringBuilder stringBuilder = new StringBuilder(2 * n3);
        stringBuilder.append(string.substring(0, n2));
        while (n < n3) {
            char c;
            if ((c = string.charAt(n++)) == '%') {
                if (n >= n3) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_HEX_STRING_TOO_SHORT.get(string));
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(n3 - n);
                while (n < n3) {
                    byte by;
                    switch (string.charAt(n++)) {
                        case '0': {
                            by = 0;
                            break;
                        }
                        case '1': {
                            by = 16;
                            break;
                        }
                        case '2': {
                            by = 32;
                            break;
                        }
                        case '3': {
                            by = 48;
                            break;
                        }
                        case '4': {
                            by = 64;
                            break;
                        }
                        case '5': {
                            by = 80;
                            break;
                        }
                        case '6': {
                            by = 96;
                            break;
                        }
                        case '7': {
                            by = 112;
                            break;
                        }
                        case '8': {
                            by = -128;
                            break;
                        }
                        case '9': {
                            by = -112;
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            by = -96;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            by = -80;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            by = -64;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            by = -48;
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            by = -32;
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            by = -16;
                            break;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n - 1))));
                        }
                    }
                    if (n >= n3) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_HEX_STRING_TOO_SHORT.get(string));
                    }
                    switch (string.charAt(n++)) {
                        case '0': {
                            by = (byte)(by | 0);
                            break;
                        }
                        case '1': {
                            by = (byte)(by | 1);
                            break;
                        }
                        case '2': {
                            by = (byte)(by | 2);
                            break;
                        }
                        case '3': {
                            by = (byte)(by | 3);
                            break;
                        }
                        case '4': {
                            by = (byte)(by | 4);
                            break;
                        }
                        case '5': {
                            by = (byte)(by | 5);
                            break;
                        }
                        case '6': {
                            by = (byte)(by | 6);
                            break;
                        }
                        case '7': {
                            by = (byte)(by | 7);
                            break;
                        }
                        case '8': {
                            by = (byte)(by | 8);
                            break;
                        }
                        case '9': {
                            by = (byte)(by | 9);
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            by = (byte)(by | 0xA);
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            by = (byte)(by | 0xB);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            by = (byte)(by | 0xC);
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            by = (byte)(by | 0xD);
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            by = (byte)(by | 0xE);
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            by = (byte)(by | 0xF);
                            break;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_LDAPURL_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n - 1))));
                        }
                    }
                    byteBuffer.put(by);
                    if (n >= n3 || string.charAt(n) == '%') continue;
                    break;
                }
                byteBuffer.flip();
                byte[] byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray);
                stringBuilder.append(StaticUtils.toUTF8String(byArray));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void percentEncode(String string, StringBuilder stringBuilder) {
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ';': 
                case '=': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '~': {
                    stringBuilder.append(c);
                    continue block3;
                }
                default: {
                    byte[] byArray;
                    for (byte by : byArray = StaticUtils.getBytes(new String(new char[]{c}))) {
                        stringBuilder.append('%');
                        StaticUtils.toHex(by, stringBuilder);
                    }
                }
            }
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public boolean hostProvided() {
        return this.host != null;
    }

    public int getPort() {
        return this.port;
    }

    public boolean portProvided() {
        return this.portProvided;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public boolean baseDNProvided() {
        return this.baseDNProvided;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public boolean attributesProvided() {
        return this.attributesProvided;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public boolean scopeProvided() {
        return this.scopeProvided;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean filterProvided() {
        return this.filterProvided;
    }

    public SearchRequest toSearchRequest() {
        return new SearchRequest(this.baseDN.toString(), this.scope, this.filter, this.attributes);
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof LDAPURL)) {
            return false;
        }
        LDAPURL lDAPURL = (LDAPURL)object;
        return this.toNormalizedString().equals(lDAPURL.toNormalizedString());
    }

    public String toString() {
        return this.urlString;
    }

    public String toNormalizedString() {
        if (this.normalizedURLString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toNormalizedString(stringBuilder);
            this.normalizedURLString = stringBuilder.toString();
        }
        return this.normalizedURLString;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        stringBuilder.append(this.scheme);
        stringBuilder.append("://");
        if (this.host != null) {
            if (this.host.indexOf(58) >= 0) {
                stringBuilder.append('[');
                stringBuilder.append(StaticUtils.toLowerCase(this.host));
                stringBuilder.append(']');
            } else {
                stringBuilder.append(StaticUtils.toLowerCase(this.host));
            }
        }
        if (!this.scheme.equals("ldapi")) {
            stringBuilder.append(':');
            stringBuilder.append(this.port);
        }
        stringBuilder.append('/');
        LDAPURL.percentEncode(this.baseDN.toNormalizedString(), stringBuilder);
        stringBuilder.append('?');
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(StaticUtils.toLowerCase(this.attributes[i]));
        }
        stringBuilder.append('?');
        switch (this.scope.intValue()) {
            case 0: {
                stringBuilder.append("base");
                break;
            }
            case 1: {
                stringBuilder.append("one");
                break;
            }
            case 2: {
                stringBuilder.append("sub");
                break;
            }
            case 3: {
                stringBuilder.append("subordinates");
            }
        }
        stringBuilder.append('?');
        LDAPURL.percentEncode(this.filter.toNormalizedString(), stringBuilder);
    }
}

