/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModifyRequest
extends UpdatableLDAPRequest
implements ReadOnlyModifyRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = -4747622844001634758L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private final ArrayList<Modification> modifications;
    private int messageID = -1;
    private String dn;

    public ModifyRequest(String string, Modification modification) {
        super(null);
        Validator.ensureNotNull(string, modification);
        this.dn = string;
        this.modifications = new ArrayList(1);
        this.modifications.add(modification);
    }

    public ModifyRequest(String string, Modification ... modificationArray) {
        super(null);
        Validator.ensureNotNull(string, modificationArray);
        Validator.ensureFalse(modificationArray.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = string;
        this.modifications = new ArrayList(modificationArray.length);
        this.modifications.addAll(Arrays.asList(modificationArray));
    }

    public ModifyRequest(String string, List<Modification> list) {
        super(null);
        Validator.ensureNotNull(string, list);
        Validator.ensureFalse(list.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = string;
        this.modifications = new ArrayList<Modification>(list);
    }

    public ModifyRequest(DN dN, Modification modification) {
        super(null);
        Validator.ensureNotNull(dN, modification);
        this.dn = dN.toString();
        this.modifications = new ArrayList(1);
        this.modifications.add(modification);
    }

    public ModifyRequest(DN dN, Modification ... modificationArray) {
        super(null);
        Validator.ensureNotNull(dN, modificationArray);
        Validator.ensureFalse(modificationArray.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = dN.toString();
        this.modifications = new ArrayList(modificationArray.length);
        this.modifications.addAll(Arrays.asList(modificationArray));
    }

    public ModifyRequest(DN dN, List<Modification> list) {
        super(null);
        Validator.ensureNotNull(dN, list);
        Validator.ensureFalse(list.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = dN.toString();
        this.modifications = new ArrayList<Modification>(list);
    }

    public ModifyRequest(String string, Modification modification, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, modification);
        this.dn = string;
        this.modifications = new ArrayList(1);
        this.modifications.add(modification);
    }

    public ModifyRequest(String string, Modification[] modificationArray, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, modificationArray);
        Validator.ensureFalse(modificationArray.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = string;
        this.modifications = new ArrayList(modificationArray.length);
        this.modifications.addAll(Arrays.asList(modificationArray));
    }

    public ModifyRequest(String string, List<Modification> list, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, list);
        Validator.ensureFalse(list.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = string;
        this.modifications = new ArrayList<Modification>(list);
    }

    public ModifyRequest(DN dN, Modification modification, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, modification);
        this.dn = dN.toString();
        this.modifications = new ArrayList(1);
        this.modifications.add(modification);
    }

    public ModifyRequest(DN dN, Modification[] modificationArray, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, modificationArray);
        Validator.ensureFalse(modificationArray.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = dN.toString();
        this.modifications = new ArrayList(modificationArray.length);
        this.modifications.addAll(Arrays.asList(modificationArray));
    }

    public ModifyRequest(DN dN, List<Modification> list, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, list);
        Validator.ensureFalse(list.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = dN.toString();
        this.modifications = new ArrayList<Modification>(list);
    }

    public ModifyRequest(String ... stringArray) throws LDIFException {
        super(null);
        LDIFChangeRecord lDIFChangeRecord = LDIFReader.decodeChangeRecord(stringArray);
        if (!(lDIFChangeRecord instanceof LDIFModifyChangeRecord)) {
            throw new LDIFException(LDAPMessages.ERR_MODIFY_INVALID_LDIF.get(), 0L, false, stringArray, null);
        }
        LDIFModifyChangeRecord lDIFModifyChangeRecord = (LDIFModifyChangeRecord)lDIFChangeRecord;
        ModifyRequest modifyRequest = lDIFModifyChangeRecord.toModifyRequest();
        this.dn = modifyRequest.dn;
        this.modifications = modifyRequest.modifications;
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String string) {
        Validator.ensureNotNull(string);
        this.dn = string;
    }

    public void setDN(DN dN) {
        Validator.ensureNotNull(dN);
        this.dn = dN.toString();
    }

    @Override
    public List<Modification> getModifications() {
        return Collections.unmodifiableList(this.modifications);
    }

    public void addModification(Modification modification) {
        Validator.ensureNotNull(modification);
        this.modifications.add(modification);
    }

    public boolean removeModification(Modification modification) {
        Validator.ensureNotNull(modification);
        return this.modifications.remove(modification);
    }

    public void setModifications(Modification modification) {
        Validator.ensureNotNull(modification);
        this.modifications.clear();
        this.modifications.add(modification);
    }

    public void setModifications(Modification[] modificationArray) {
        Validator.ensureNotNull(modificationArray);
        Validator.ensureFalse(modificationArray.length == 0, "ModifyRequest.setModifications.mods must not be empty.");
        this.modifications.clear();
        this.modifications.addAll(Arrays.asList(modificationArray));
    }

    public void setModifications(List<Modification> list) {
        Validator.ensureNotNull(list);
        Validator.ensureFalse(list.isEmpty(), "ModifyRequest.setModifications.mods must not be empty.");
        this.modifications.clear();
        this.modifications.addAll(list);
    }

    @Override
    public byte getProtocolOpType() {
        return 102;
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)102);
        aSN1Buffer.addOctetString(this.dn);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        for (Modification modification : this.modifications) {
            modification.writeTo(aSN1Buffer);
        }
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] aSN1ElementArray = new ASN1Element[this.modifications.size()];
        for (int i = 0; i < aSN1ElementArray.length; ++i) {
            aSN1ElementArray[i] = this.modifications.get(i).encode();
        }
        ASN1Element[] aSN1ElementArray2 = new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1Sequence(aSN1ElementArray)};
        return new ASN1Sequence(102, aSN1ElementArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LDAPResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            boolean bl = lDAPConnection.getConnectionOptions().autoReconnect();
            return this.processSync(lDAPConnection, n, bl);
        }
        long l = System.nanoTime();
        this.processAsync(lDAPConnection, null);
        try {
            LDAPResponse lDAPResponse;
            try {
                long l2 = this.getResponseTimeoutMillis(lDAPConnection);
                lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_MODIFY_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            LDAPResult lDAPResult = this.handleResponse(lDAPConnection, lDAPResponse, l, n, false);
            return lDAPResult;
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection lDAPConnection, AsyncResultListener asyncResultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (asyncResultListener == null) {
            asyncRequestID = null;
            lDAPConnection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper asyncHelper = new AsyncHelper(lDAPConnection, OperationType.MODIFY, this.messageID, asyncResultListener, this.getIntermediateResponseListener());
            lDAPConnection.registerResponseAcceptor(this.messageID, asyncHelper);
            asyncRequestID = asyncHelper.getAsyncRequestID();
            long l = this.getResponseTimeoutMillis(lDAPConnection);
            if (l > 0L) {
                Timer timer = lDAPConnection.getTimer();
                AsyncTimeoutTimerTask asyncTimeoutTimerTask = new AsyncTimeoutTimerTask(asyncHelper);
                timer.schedule((TimerTask)asyncTimeoutTimerTask, l);
                asyncRequestID.setTimerTask(asyncTimeoutTimerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(this);
            lDAPConnection.getConnectionStatistics().incrementNumModifyRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            return asyncRequestID;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            throw lDAPException;
        }
    }

    private LDAPResult processSync(LDAPConnection lDAPConnection, int n, boolean bl) throws LDAPException {
        LDAPResponse lDAPResponse;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(lDAPConnection));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        long l = System.nanoTime();
        Debug.debugLDAPRequest(this);
        lDAPConnection.getConnectionStatistics().incrementNumModifyRequests();
        try {
            lDAPConnection.sendMessage(lDAPMessage);
        }
        catch (LDAPException lDAPException) {
            LDAPResult lDAPResult;
            Debug.debugException(lDAPException);
            if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                return lDAPResult;
            }
            throw lDAPException;
        }
        while (true) {
            try {
                lDAPResponse = lDAPConnection.readResponse(this.messageID);
            }
            catch (LDAPException lDAPException) {
                LDAPResult lDAPResult;
                Debug.debugException(lDAPException);
                if (lDAPException.getResultCode() == ResultCode.TIMEOUT && lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                    return lDAPResult;
                }
                throw lDAPException;
            }
            if (!(lDAPResponse instanceof IntermediateResponse)) break;
            IntermediateResponseListener intermediateResponseListener = this.getIntermediateResponseListener();
            if (intermediateResponseListener == null) continue;
            intermediateResponseListener.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l, n, bl);
    }

    private LDAPResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l, int n, boolean bl) throws LDAPException {
        LDAPResult lDAPResult;
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                lDAPConnection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_MODIFY_CLIENT_TIMEOUT.get(l2, this.messageID, this.dn, lDAPConnection.getHostPort()));
        }
        lDAPConnection.getConnectionStatistics().incrementNumModifyResponses(System.nanoTime() - l);
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            Serializable serializable;
            if (bl && (serializable = this.reconnectAndRetry(lDAPConnection, n, ResultCode.SERVER_DOWN)) != null) {
                return serializable;
            }
            serializable = (ConnectionClosedResponse)lDAPResponse;
            String string = ((ConnectionClosedResponse)serializable).getMessage();
            if (string == null) {
                throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        LDAPResult lDAPResult2 = (LDAPResult)lDAPResponse;
        if (lDAPResult2.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(lDAPConnection)) {
            if (n >= lDAPConnection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), lDAPResult2.getMatchedDN(), lDAPResult2.getReferralURLs(), lDAPResult2.getResponseControls());
            }
            return this.followReferral(lDAPResult2, lDAPConnection, n);
        }
        if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPResult2.getResultCode())) != null) {
            return lDAPResult;
        }
        return lDAPResult2;
    }

    private LDAPResult reconnectAndRetry(LDAPConnection lDAPConnection, int n, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    lDAPConnection.reconnect();
                    return this.processSync(lDAPConnection, n, false);
                }
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult lDAPResult, LDAPConnection lDAPConnection, int n) throws LDAPException {
        for (String string : lDAPResult.getReferralURLs()) {
            LDAPURL lDAPURL = new LDAPURL(string);
            String string2 = lDAPURL.getHost();
            if (string2 == null) continue;
            ModifyRequest modifyRequest = lDAPURL.baseDNProvided() ? new ModifyRequest(lDAPURL.getBaseDN(), this.modifications, this.getControls()) : this;
            LDAPConnection lDAPConnection2 = lDAPConnection.getReferralConnector().getReferralConnection(lDAPURL, lDAPConnection);
            try {
                LDAPResult lDAPResult2 = modifyRequest.process(lDAPConnection2, n + 1);
                lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                lDAPConnection2.close();
                return lDAPResult2;
            }
            catch (Throwable throwable) {
                try {
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
        }
        return lDAPResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.MODIFY;
    }

    @Override
    public ModifyRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public ModifyRequest duplicate(Control[] controlArray) {
        ModifyRequest modifyRequest = new ModifyRequest(this.dn, new ArrayList<Modification>(this.modifications), controlArray);
        if (this.followReferralsInternal() != null) {
            modifyRequest.setFollowReferrals(this.followReferralsInternal());
        }
        modifyRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return modifyRequest;
    }

    @Override
    public LDIFModifyChangeRecord toLDIFChangeRecord() {
        return new LDIFModifyChangeRecord(this);
    }

    @Override
    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    @Override
    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ModifyRequest(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', mods={");
        for (int i = 0; i < this.modifications.size(); ++i) {
            Modification modification = this.modifications.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            switch (modification.getModificationType().intValue()) {
                case 0: {
                    stringBuilder.append("ADD ");
                    break;
                }
                case 1: {
                    stringBuilder.append("DELETE ");
                    break;
                }
                case 2: {
                    stringBuilder.append("REPLACE ");
                    break;
                }
                case 3: {
                    stringBuilder.append("INCREMENT ");
                }
            }
            stringBuilder.append(modification.getAttributeName());
        }
        stringBuilder.append('}');
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(this.modifications.size() + 1);
        arrayList.add(ToCodeArgHelper.createString(this.dn, "Entry DN"));
        boolean bl2 = true;
        for (Modification modification : this.modifications) {
            String string2;
            if (bl2) {
                bl2 = false;
                string2 = "Modifications";
            } else {
                string2 = null;
            }
            arrayList.add(ToCodeArgHelper.createModification(modification, string2));
        }
        ToCodeHelper.generateMethodCall(list, n, "ModifyRequest", string + "Request", "new ModifyRequest", arrayList);
        for (Control control : this.getControls()) {
            ToCodeHelper.generateMethodCall(list, n, null, null, string + "Request.addControl", ToCodeArgHelper.createControl(control, null));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string3 = stringBuilder.toString();
            list.add("");
            list.add(string3 + "try");
            list.add(string3 + '{');
            list.add(string3 + "  LDAPResult " + string + "Result = connection.modify(" + string + "Request);");
            list.add(string3 + "  // The modify was processed successfully.");
            list.add(string3 + '}');
            list.add(string3 + "catch (LDAPException e)");
            list.add(string3 + '{');
            list.add(string3 + "  // The modify failed.  Maybe the following " + "will help explain why.");
            list.add(string3 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string3 + "  String message = e.getMessage();");
            list.add(string3 + "  String matchedDN = e.getMatchedDN();");
            list.add(string3 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string3 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string3 + '}');
        }
    }
}

