/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;

final class ParallelPoolCloserTask
implements Runnable {
    private final boolean unbind;
    private final LDAPConnection connection;

    ParallelPoolCloserTask(LDAPConnection lDAPConnection, boolean bl) {
        this.connection = lDAPConnection;
        this.unbind = bl;
    }

    public void run() {
        LDAPConnectionPoolStatistics lDAPConnectionPoolStatistics;
        AbstractConnectionPool abstractConnectionPool = this.connection.getConnectionPool();
        if (abstractConnectionPool != null && (lDAPConnectionPoolStatistics = abstractConnectionPool.getConnectionPoolStatistics()) != null) {
            lDAPConnectionPoolStatistics.incrementNumConnectionsClosedUnneeded();
        }
        this.connection.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
        if (this.unbind) {
            this.connection.terminate(null);
        } else {
            this.connection.setClosed();
        }
    }
}

