/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.Validator;
import javax.net.SocketFactory;

public final class RoundRobinServerSet
extends ServerSet {
    private final int[] ports;
    private final LDAPConnectionOptions connectionOptions;
    private final SocketFactory socketFactory;
    private final String[] addresses;
    private int nextSlot;

    public RoundRobinServerSet(String[] stringArray, int[] nArray) {
        this(stringArray, nArray, null, null);
    }

    public RoundRobinServerSet(String[] stringArray, int[] nArray, LDAPConnectionOptions lDAPConnectionOptions) {
        this(stringArray, nArray, null, lDAPConnectionOptions);
    }

    public RoundRobinServerSet(String[] stringArray, int[] nArray, SocketFactory socketFactory) {
        this(stringArray, nArray, socketFactory, null);
    }

    public RoundRobinServerSet(String[] stringArray, int[] nArray, SocketFactory socketFactory, LDAPConnectionOptions lDAPConnectionOptions) {
        Validator.ensureNotNull(stringArray, nArray);
        Validator.ensureTrue(stringArray.length > 0, "RoundRobinServerSet.addresses must not be empty.");
        Validator.ensureTrue(stringArray.length == nArray.length, "RoundRobinServerSet addresses and ports arrays must be the same size.");
        this.addresses = stringArray;
        this.ports = nArray;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = lDAPConnectionOptions == null ? new LDAPConnectionOptions() : lDAPConnectionOptions;
        this.nextSlot = 0;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    public synchronized LDAPConnection getConnection(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) throws LDAPException {
        int n = this.nextSlot++;
        if (this.nextSlot >= this.addresses.length) {
            this.nextSlot = 0;
        }
        try {
            LDAPConnection lDAPConnection = new LDAPConnection(this.socketFactory, this.connectionOptions, this.addresses[n], this.ports[n]);
            if (lDAPConnectionPoolHealthCheck != null) {
                try {
                    lDAPConnectionPoolHealthCheck.ensureNewConnectionValid(lDAPConnection);
                }
                catch (LDAPException lDAPException) {
                    lDAPConnection.close();
                    throw lDAPException;
                }
            }
            return lDAPConnection;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            LDAPException lDAPException2 = lDAPException;
            while (this.nextSlot != n) {
                ++this.nextSlot;
                if (this.nextSlot >= this.addresses.length) {
                    this.nextSlot = 0;
                }
                try {
                    int n2;
                    LDAPConnection lDAPConnection = new LDAPConnection(this.socketFactory, this.connectionOptions, this.addresses[n2], this.ports[n2]);
                    if (lDAPConnectionPoolHealthCheck != null) {
                        try {
                            lDAPConnectionPoolHealthCheck.ensureNewConnectionValid(lDAPConnection);
                        }
                        catch (LDAPException lDAPException3) {
                            lDAPConnection.close();
                            throw lDAPException3;
                        }
                    }
                    return lDAPConnection;
                }
                catch (LDAPException lDAPException4) {
                    Debug.debugException(lDAPException4);
                    lDAPException2 = lDAPException4;
                }
            }
            throw lDAPException2;
        }
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("RoundRobinServerSet(servers={");
        for (int i = 0; i < this.addresses.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.addresses[i]);
            stringBuilder.append(':');
            stringBuilder.append(this.ports[i]);
        }
        stringBuilder.append("})");
    }
}

