/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchHelper;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchRequest
extends UpdatableLDAPRequest
implements ReadOnlySearchRequest,
ResponseAcceptor,
ProtocolOp {
    public static final String ALL_USER_ATTRIBUTES = "*";
    public static final String ALL_OPERATIONAL_ATTRIBUTES = "+";
    public static final String NO_ATTRIBUTES = "1.1";
    public static final String[] REQUEST_ATTRS_DEFAULT = StaticUtils.NO_STRINGS;
    private static final long serialVersionUID = 1500219434086474893L;
    private String[] attributes;
    private boolean typesOnly;
    private DereferencePolicy derefPolicy;
    private int messageID = -1;
    private int sizeLimit;
    private int timeLimit;
    private Filter filter;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue(50);
    private final SearchResultListener searchResultListener;
    private SearchScope scope;
    private String baseDN;

    public SearchRequest(String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPException {
        this(null, null, string, searchScope, DereferencePolicy.NEVER, 0, 0, false, Filter.create(string2), stringArray);
    }

    public SearchRequest(String string, SearchScope searchScope, Filter filter, String ... stringArray) {
        this(null, null, string, searchScope, DereferencePolicy.NEVER, 0, 0, false, filter, stringArray);
    }

    public SearchRequest(SearchResultListener searchResultListener, String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPException {
        this(searchResultListener, null, string, searchScope, DereferencePolicy.NEVER, 0, 0, false, Filter.create(string2), stringArray);
    }

    public SearchRequest(SearchResultListener searchResultListener, String string, SearchScope searchScope, Filter filter, String ... stringArray) {
        this(searchResultListener, null, string, searchScope, DereferencePolicy.NEVER, 0, 0, false, filter, stringArray);
    }

    public SearchRequest(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPException {
        this(null, null, string, searchScope, dereferencePolicy, n, n2, bl, Filter.create(string2), stringArray);
    }

    public SearchRequest(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) {
        this(null, null, string, searchScope, dereferencePolicy, n, n2, bl, filter, stringArray);
    }

    public SearchRequest(SearchResultListener searchResultListener, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPException {
        this(searchResultListener, null, string, searchScope, dereferencePolicy, n, n2, bl, Filter.create(string2), stringArray);
    }

    public SearchRequest(SearchResultListener searchResultListener, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) {
        this(searchResultListener, null, string, searchScope, dereferencePolicy, n, n2, bl, filter, stringArray);
    }

    public SearchRequest(SearchResultListener searchResultListener, Control[] controlArray, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPException {
        this(searchResultListener, controlArray, string, searchScope, dereferencePolicy, n, n2, bl, Filter.create(string2), stringArray);
    }

    public SearchRequest(SearchResultListener searchResultListener, Control[] controlArray, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) {
        super(controlArray);
        Validator.ensureNotNull(string, filter);
        this.baseDN = string;
        this.scope = searchScope;
        this.derefPolicy = dereferencePolicy;
        this.typesOnly = bl;
        this.filter = filter;
        this.searchResultListener = searchResultListener;
        this.sizeLimit = n < 0 ? 0 : n;
        this.timeLimit = n2 < 0 ? 0 : n2;
        this.attributes = stringArray == null ? REQUEST_ATTRS_DEFAULT : stringArray;
    }

    @Override
    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String string) {
        Validator.ensureNotNull(string);
        this.baseDN = string;
    }

    public void setBaseDN(DN dN) {
        Validator.ensureNotNull(dN);
        this.baseDN = dN.toString();
    }

    @Override
    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope searchScope) {
        this.scope = searchScope;
    }

    @Override
    public DereferencePolicy getDereferencePolicy() {
        return this.derefPolicy;
    }

    public void setDerefPolicy(DereferencePolicy dereferencePolicy) {
        this.derefPolicy = dereferencePolicy;
    }

    @Override
    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int n) {
        this.sizeLimit = n < 0 ? 0 : n;
    }

    @Override
    public int getTimeLimitSeconds() {
        return this.timeLimit;
    }

    public void setTimeLimitSeconds(int n) {
        this.timeLimit = n < 0 ? 0 : n;
    }

    @Override
    public boolean typesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean bl) {
        this.typesOnly = bl;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(String string) throws LDAPException {
        Validator.ensureNotNull(string);
        this.filter = Filter.create(string);
    }

    public void setFilter(Filter filter) {
        Validator.ensureNotNull(filter);
        this.filter = filter;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    public List<String> getAttributeList() {
        return Collections.unmodifiableList(Arrays.asList(this.attributes));
    }

    public void setAttributes(String ... stringArray) {
        this.attributes = stringArray == null ? REQUEST_ATTRS_DEFAULT : stringArray;
    }

    public void setAttributes(List<String> list) {
        if (list == null) {
            this.attributes = REQUEST_ATTRS_DEFAULT;
        } else {
            this.attributes = new String[list.size()];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = list.get(i);
            }
        }
    }

    public SearchResultListener getSearchResultListener() {
        return this.searchResultListener;
    }

    @Override
    public byte getProtocolOpType() {
        return 99;
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)99);
        aSN1Buffer.addOctetString(this.baseDN);
        aSN1Buffer.addEnumerated(this.scope.intValue());
        aSN1Buffer.addEnumerated(this.derefPolicy.intValue());
        aSN1Buffer.addInteger(this.sizeLimit);
        aSN1Buffer.addInteger(this.timeLimit);
        aSN1Buffer.addBoolean(this.typesOnly);
        this.filter.writeTo(aSN1Buffer);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        for (String string : this.attributes) {
            aSN1Buffer.addOctetString(string);
        }
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] aSN1ElementArray = new ASN1Element[this.attributes.length];
        for (int i = 0; i < aSN1ElementArray.length; ++i) {
            aSN1ElementArray[i] = new ASN1OctetString(this.attributes[i]);
        }
        ASN1Element[] aSN1ElementArray2 = new ASN1Element[]{new ASN1OctetString(this.baseDN), new ASN1Enumerated(this.scope.intValue()), new ASN1Enumerated(this.derefPolicy.intValue()), new ASN1Integer(this.sizeLimit), new ASN1Integer(this.timeLimit), new ASN1Boolean(this.typesOnly), this.filter.encode(), new ASN1Sequence(aSN1ElementArray)};
        return new ASN1Sequence(99, aSN1ElementArray2);
    }

    @Override
    protected SearchResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            boolean bl = lDAPConnection.getConnectionOptions().autoReconnect();
            return this.processSync(lDAPConnection, n, bl);
        }
        long l = System.nanoTime();
        this.processAsync(lDAPConnection, null);
        try {
            ArrayList<SearchResultReference> arrayList;
            ArrayList<SearchResultEntry> arrayList2;
            if (this.searchResultListener == null) {
                arrayList2 = new ArrayList<SearchResultEntry>(5);
                arrayList = new ArrayList<SearchResultReference>(5);
            } else {
                arrayList2 = null;
                arrayList = null;
            }
            int n2 = 0;
            int n3 = 0;
            ResultCode resultCode = ResultCode.SUCCESS;
            long l2 = this.getResponseTimeoutMillis(lDAPConnection);
            while (true) {
                SearchResult searchResult;
                Object object;
                Serializable serializable;
                LDAPResponse lDAPResponse;
                try {
                    lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    Debug.debugException(interruptedException);
                    Thread.currentThread().interrupt();
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SEARCH_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
                }
                if (lDAPResponse == null) {
                    if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                        lDAPConnection.abandon(this.messageID, new Control[0]);
                    }
                    serializable = new SearchResult(this.messageID, ResultCode.TIMEOUT, LDAPMessages.ERR_SEARCH_CLIENT_TIMEOUT.get(l2, this.messageID, this.baseDN, this.scope.getName(), this.filter.toString(), lDAPConnection.getHostPort()), null, null, arrayList2, arrayList, n2, n3, null);
                    throw new LDAPSearchException((SearchResult)serializable);
                }
                if (lDAPResponse instanceof ConnectionClosedResponse) {
                    serializable = (ConnectionClosedResponse)lDAPResponse;
                    object = ((ConnectionClosedResponse)serializable).getMessage();
                    if (object == null) {
                        searchResult = new SearchResult(this.messageID, ((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()), null, null, arrayList2, arrayList, n2, n3, null);
                        throw new LDAPSearchException(searchResult);
                    }
                    searchResult = new SearchResult(this.messageID, ((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), object), null, null, arrayList2, arrayList, n2, n3, null);
                    throw new LDAPSearchException(searchResult);
                }
                if (lDAPResponse instanceof SearchResultEntry) {
                    serializable = (SearchResultEntry)lDAPResponse;
                    ++n2;
                    if (this.searchResultListener == null) {
                        arrayList2.add((SearchResultEntry)serializable);
                        continue;
                    }
                    this.searchResultListener.searchEntryReturned((SearchResultEntry)serializable);
                    continue;
                }
                if (lDAPResponse instanceof SearchResultReference) {
                    serializable = (SearchResultReference)lDAPResponse;
                    if (this.followReferrals(lDAPConnection)) {
                        object = this.followSearchReference(this.messageID, (SearchResultReference)serializable, lDAPConnection, n);
                        if (!((LDAPResult)object).getResultCode().equals(ResultCode.SUCCESS)) {
                            ++n3;
                            if (this.searchResultListener == null) {
                                arrayList.add((SearchResultReference)serializable);
                            } else {
                                this.searchResultListener.searchReferenceReturned((SearchResultReference)serializable);
                            }
                            if (!resultCode.equals(ResultCode.SUCCESS)) continue;
                            resultCode = ((LDAPResult)object).getResultCode();
                            continue;
                        }
                        if (!(object instanceof SearchResult)) continue;
                        searchResult = (SearchResult)object;
                        n2 += searchResult.getEntryCount();
                        if (this.searchResultListener != null) continue;
                        arrayList2.addAll(searchResult.getSearchEntries());
                        continue;
                    }
                    ++n3;
                    if (this.searchResultListener == null) {
                        arrayList.add((SearchResultReference)serializable);
                        continue;
                    }
                    this.searchResultListener.searchReferenceReturned((SearchResultReference)serializable);
                    continue;
                }
                lDAPConnection.getConnectionStatistics().incrementNumSearchResponses(n2, n3, System.nanoTime() - l);
                serializable = (SearchResult)lDAPResponse;
                ((SearchResult)serializable).setCounts(n2, arrayList2, n3, arrayList);
                if (((LDAPResult)serializable).getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(lDAPConnection)) {
                    if (n >= lDAPConnection.getConnectionOptions().getReferralHopLimit()) {
                        object = new SearchResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), ((LDAPResult)serializable).getMatchedDN(), ((LDAPResult)serializable).getReferralURLs(), arrayList2, arrayList, n2, n3, ((LDAPResult)serializable).getResponseControls());
                        return object;
                    }
                    serializable = this.followReferral((SearchResult)serializable, lDAPConnection, n);
                }
                if (((LDAPResult)serializable).getResultCode().equals(ResultCode.SUCCESS) && !resultCode.equals(ResultCode.SUCCESS)) {
                    object = new SearchResult(this.messageID, resultCode, ((LDAPResult)serializable).getDiagnosticMessage(), ((LDAPResult)serializable).getMatchedDN(), ((LDAPResult)serializable).getReferralURLs(), arrayList2, arrayList, n2, n3, ((LDAPResult)serializable).getResponseControls());
                    return object;
                }
                object = serializable;
                return object;
            }
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection lDAPConnection, AsyncSearchResultListener asyncSearchResultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (asyncSearchResultListener == null) {
            asyncRequestID = null;
            lDAPConnection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncSearchHelper asyncSearchHelper = new AsyncSearchHelper(lDAPConnection, this.messageID, asyncSearchResultListener, this.getIntermediateResponseListener());
            lDAPConnection.registerResponseAcceptor(this.messageID, asyncSearchHelper);
            asyncRequestID = asyncSearchHelper.getAsyncRequestID();
            long l = this.getResponseTimeoutMillis(lDAPConnection);
            if (l > 0L) {
                Timer timer = lDAPConnection.getTimer();
                AsyncTimeoutTimerTask asyncTimeoutTimerTask = new AsyncTimeoutTimerTask(asyncSearchHelper);
                timer.schedule((TimerTask)asyncTimeoutTimerTask, l);
                asyncRequestID.setTimerTask(asyncTimeoutTimerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(this);
            lDAPConnection.getConnectionStatistics().incrementNumSearchRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            return asyncRequestID;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            throw lDAPException;
        }
    }

    private SearchResult processSync(LDAPConnection lDAPConnection, int n, boolean bl) throws LDAPException {
        Serializable serializable;
        Object object;
        LDAPResponse lDAPResponse;
        ArrayList<SearchResultReference> arrayList;
        ArrayList<SearchResultEntry> arrayList2;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        long l = this.getResponseTimeoutMillis(lDAPConnection);
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)l);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        long l2 = System.nanoTime();
        Debug.debugLDAPRequest(this);
        lDAPConnection.getConnectionStatistics().incrementNumSearchRequests();
        try {
            lDAPConnection.sendMessage(lDAPMessage);
        }
        catch (LDAPException lDAPException) {
            SearchResult searchResult;
            Debug.debugException(lDAPException);
            if (bl && (searchResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode(), 0, 0)) != null) {
                return searchResult;
            }
            throw lDAPException;
        }
        if (this.searchResultListener == null) {
            arrayList2 = new ArrayList<SearchResultEntry>(5);
            arrayList = new ArrayList<SearchResultReference>(5);
        } else {
            arrayList2 = null;
            arrayList = null;
        }
        int n2 = 0;
        int n3 = 0;
        ResultCode resultCode = ResultCode.SUCCESS;
        while (true) {
            SearchResult searchResult;
            try {
                lDAPResponse = lDAPConnection.readResponse(this.messageID);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                if (lDAPException.getResultCode() == ResultCode.TIMEOUT && lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                if (bl && (object = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode(), n2, n3)) != null) {
                    return object;
                }
                throw lDAPException;
            }
            if (lDAPResponse == null) {
                if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SEARCH_CLIENT_TIMEOUT.get(l, this.messageID, this.baseDN, this.scope.getName(), this.filter.toString(), lDAPConnection.getHostPort()));
            }
            if (lDAPResponse instanceof ConnectionClosedResponse) {
                if (bl && (serializable = this.reconnectAndRetry(lDAPConnection, n, ResultCode.SERVER_DOWN, n2, n3)) != null) {
                    return serializable;
                }
                serializable = (ConnectionClosedResponse)lDAPResponse;
                object = ((ConnectionClosedResponse)serializable).getMessage();
                if (object == null) {
                    searchResult = new SearchResult(this.messageID, ((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()), null, null, arrayList2, arrayList, n2, n3, null);
                    throw new LDAPSearchException(searchResult);
                }
                searchResult = new SearchResult(this.messageID, ((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), object), null, null, arrayList2, arrayList, n2, n3, null);
                throw new LDAPSearchException(searchResult);
            }
            if (lDAPResponse instanceof IntermediateResponse) {
                serializable = this.getIntermediateResponseListener();
                if (serializable == null) continue;
                serializable.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
                continue;
            }
            if (lDAPResponse instanceof SearchResultEntry) {
                serializable = (SearchResultEntry)lDAPResponse;
                ++n2;
                if (this.searchResultListener == null) {
                    arrayList2.add((SearchResultEntry)serializable);
                    continue;
                }
                this.searchResultListener.searchEntryReturned((SearchResultEntry)serializable);
                continue;
            }
            if (!(lDAPResponse instanceof SearchResultReference)) break;
            serializable = (SearchResultReference)lDAPResponse;
            if (this.followReferrals(lDAPConnection)) {
                object = this.followSearchReference(this.messageID, (SearchResultReference)serializable, lDAPConnection, n);
                if (!((LDAPResult)object).getResultCode().equals(ResultCode.SUCCESS)) {
                    ++n3;
                    if (this.searchResultListener == null) {
                        arrayList.add((SearchResultReference)serializable);
                    } else {
                        this.searchResultListener.searchReferenceReturned((SearchResultReference)serializable);
                    }
                    if (!resultCode.equals(ResultCode.SUCCESS)) continue;
                    resultCode = ((LDAPResult)object).getResultCode();
                    continue;
                }
                if (!(object instanceof SearchResult)) continue;
                searchResult = (SearchResult)object;
                n2 += searchResult.getEntryCount();
                if (this.searchResultListener != null) continue;
                arrayList2.addAll(searchResult.getSearchEntries());
                continue;
            }
            ++n3;
            if (this.searchResultListener == null) {
                arrayList.add((SearchResultReference)serializable);
                continue;
            }
            this.searchResultListener.searchReferenceReturned((SearchResultReference)serializable);
        }
        serializable = (SearchResult)lDAPResponse;
        if (bl && (object = this.reconnectAndRetry(lDAPConnection, n, ((LDAPResult)serializable).getResultCode(), n2, n3)) != null) {
            return object;
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l2, n, n2, n3, arrayList2, arrayList, resultCode);
    }

    private SearchResult reconnectAndRetry(LDAPConnection lDAPConnection, int n, ResultCode resultCode, int n2, int n3) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    lDAPConnection.reconnect();
                    if (n2 != 0 || n3 != 0) break;
                    return this.processSync(lDAPConnection, n, false);
                }
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return null;
    }

    private SearchResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l, int n, int n2, int n3, List<SearchResultEntry> list, List<SearchResultReference> list2, ResultCode resultCode) throws LDAPException {
        lDAPConnection.getConnectionStatistics().incrementNumSearchResponses(n2, n3, System.nanoTime() - l);
        SearchResult searchResult = (SearchResult)lDAPResponse;
        searchResult.setCounts(n2, list, n3, list2);
        if (searchResult.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(lDAPConnection)) {
            if (n >= lDAPConnection.getConnectionOptions().getReferralHopLimit()) {
                return new SearchResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), searchResult.getMatchedDN(), searchResult.getReferralURLs(), list, list2, n2, n3, searchResult.getResponseControls());
            }
            searchResult = this.followReferral(searchResult, lDAPConnection, n);
        }
        if (searchResult.getResultCode().equals(ResultCode.SUCCESS) && !resultCode.equals(ResultCode.SUCCESS)) {
            return new SearchResult(this.messageID, resultCode, searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), searchResult.getReferralURLs(), list, list2, n2, n3, searchResult.getResponseControls());
        }
        return searchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followSearchReference(int n, SearchResultReference searchResultReference, LDAPConnection lDAPConnection, int n2) throws LDAPException {
        for (String string : searchResultReference.getReferralURLs()) {
            LDAPURL lDAPURL = new LDAPURL(string);
            String string2 = lDAPURL.getHost();
            if (string2 == null) continue;
            String string3 = lDAPURL.baseDNProvided() ? lDAPURL.getBaseDN().toString() : this.baseDN;
            SearchScope searchScope = lDAPURL.scopeProvided() ? lDAPURL.getScope() : this.scope;
            Filter filter = lDAPURL.filterProvided() ? lDAPURL.getFilter() : this.filter;
            SearchRequest searchRequest = new SearchRequest(this.searchResultListener, this.getControls(), string3, searchScope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, filter, this.attributes);
            LDAPConnection lDAPConnection2 = lDAPConnection.getReferralConnector().getReferralConnection(lDAPURL, lDAPConnection);
            try {
                SearchResult searchResult = searchRequest.process(lDAPConnection2, n2 + 1);
                lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                lDAPConnection2.close();
                return searchResult;
            }
            catch (Throwable throwable) {
                try {
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    if (!lDAPException.getResultCode().equals(ResultCode.REFERRAL_LIMIT_EXCEEDED)) continue;
                    throw lDAPException;
                }
            }
        }
        return new SearchResult(n, ResultCode.REFERRAL, null, null, searchResultReference.getReferralURLs(), 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult followReferral(SearchResult searchResult, LDAPConnection lDAPConnection, int n) throws LDAPException {
        for (String string : searchResult.getReferralURLs()) {
            LDAPURL lDAPURL = new LDAPURL(string);
            String string2 = lDAPURL.getHost();
            if (string2 == null) continue;
            String string3 = lDAPURL.baseDNProvided() ? lDAPURL.getBaseDN().toString() : this.baseDN;
            SearchScope searchScope = lDAPURL.scopeProvided() ? lDAPURL.getScope() : this.scope;
            Filter filter = lDAPURL.filterProvided() ? lDAPURL.getFilter() : this.filter;
            SearchRequest searchRequest = new SearchRequest(this.searchResultListener, this.getControls(), string3, searchScope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, filter, this.attributes);
            LDAPConnection lDAPConnection2 = lDAPConnection.getReferralConnector().getReferralConnection(lDAPURL, lDAPConnection);
            try {
                SearchResult searchResult2 = searchRequest.process(lDAPConnection2, n + 1);
                lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                lDAPConnection2.close();
                return searchResult2;
            }
            catch (Throwable throwable) {
                try {
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    if (!lDAPException.getResultCode().equals(ResultCode.REFERRAL_LIMIT_EXCEEDED)) continue;
                    throw lDAPException;
                }
            }
        }
        return searchResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    @Override
    public SearchRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public SearchRequest duplicate(Control[] controlArray) {
        SearchRequest searchRequest = new SearchRequest(this.searchResultListener, controlArray, this.baseDN, this.scope, this.derefPolicy, this.sizeLimit, this.timeLimit, this.typesOnly, this.filter, this.attributes);
        if (this.followReferralsInternal() != null) {
            searchRequest.setFollowReferrals(this.followReferralsInternal());
        }
        searchRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return searchRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("SearchRequest(baseDN='");
        stringBuilder.append(this.baseDN);
        stringBuilder.append("', scope=");
        stringBuilder.append(this.scope);
        stringBuilder.append(", deref=");
        stringBuilder.append(this.derefPolicy);
        stringBuilder.append(", sizeLimit=");
        stringBuilder.append(this.sizeLimit);
        stringBuilder.append(", timeLimit=");
        stringBuilder.append(this.timeLimit);
        stringBuilder.append(", filter='");
        stringBuilder.append(this.filter);
        stringBuilder.append("', attrs={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.attributes[i]);
        }
        stringBuilder.append('}');
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(10);
        arrayList.add(ToCodeArgHelper.createString(this.baseDN, "Base DN"));
        arrayList.add(ToCodeArgHelper.createScope(this.scope, "Scope"));
        arrayList.add(ToCodeArgHelper.createDerefPolicy(this.derefPolicy, "Alias Dereference Policy"));
        arrayList.add(ToCodeArgHelper.createInteger(this.sizeLimit, "Size Limit"));
        arrayList.add(ToCodeArgHelper.createInteger(this.timeLimit, "Time Limit"));
        arrayList.add(ToCodeArgHelper.createBoolean(this.typesOnly, "Types Only"));
        arrayList.add(ToCodeArgHelper.createFilter(this.filter, "Filter"));
        String string2 = "Requested Attributes";
        for (String object : this.attributes) {
            arrayList.add(ToCodeArgHelper.createString(object, string2));
            string2 = null;
        }
        ToCodeHelper.generateMethodCall(list, n, "SearchRequest", string + "Request", "new SearchRequest", arrayList);
        for (Control control : this.getControls()) {
            ToCodeHelper.generateMethodCall(list, n, null, null, string + "Request.addControl", ToCodeArgHelper.createControl(control, null));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string3 = stringBuilder.toString();
            list.add("");
            list.add(string3 + "SearchResult " + string + "Result;");
            list.add(string3 + "try");
            list.add(string3 + '{');
            list.add(string3 + "  " + string + "Result = connection.search(" + string + "Request);");
            list.add(string3 + "  // The search was processed successfully.");
            list.add(string3 + '}');
            list.add(string3 + "catch (LDAPSearchException e)");
            list.add(string3 + '{');
            list.add(string3 + "  // The search failed.  Maybe the following " + "will help explain why.");
            list.add(string3 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string3 + "  String message = e.getMessage();");
            list.add(string3 + "  String matchedDN = e.getMatchedDN();");
            list.add(string3 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string3 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add("");
            list.add(string3 + "  // Even though there was an error, we may " + "have gotten some results.");
            list.add(string3 + "  " + string + "Result = e.getSearchResult();");
            list.add(string3 + '}');
            list.add("");
            list.add(string3 + "// If there were results, then process them.");
            list.add(string3 + "for (SearchResultEntry e : " + string + "Result.getSearchEntries())");
            list.add(string3 + '{');
            list.add(string3 + "  // Do something with the entry.");
            list.add(string3 + '}');
        }
    }
}

