/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchResultEntry
extends ReadOnlyEntry
implements LDAPResponse {
    private static final long serialVersionUID = -290721544252526163L;
    private final Control[] controls;
    private final int messageID;

    public SearchResultEntry(String string, Attribute[] attributeArray, Control ... controlArray) {
        this(-1, string, null, attributeArray, controlArray);
    }

    public SearchResultEntry(int n, String string, Attribute[] attributeArray, Control ... controlArray) {
        this(n, string, null, attributeArray, controlArray);
    }

    public SearchResultEntry(int n, String string, Schema schema, Attribute[] attributeArray, Control ... controlArray) {
        super(string, schema, attributeArray);
        Validator.ensureNotNull(controlArray);
        this.messageID = n;
        this.controls = controlArray;
    }

    public SearchResultEntry(String string, Collection<Attribute> collection, Control ... controlArray) {
        this(-1, string, null, collection, controlArray);
    }

    public SearchResultEntry(int n, String string, Collection<Attribute> collection, Control ... controlArray) {
        this(n, string, null, collection, controlArray);
    }

    public SearchResultEntry(int n, String string, Schema schema, Collection<Attribute> collection, Control ... controlArray) {
        super(string, schema, collection);
        Validator.ensureNotNull(controlArray);
        this.messageID = n;
        this.controls = controlArray;
    }

    public SearchResultEntry(Entry entry, Control ... controlArray) {
        this(-1, entry, controlArray);
    }

    public SearchResultEntry(int n, Entry entry, Control ... controlArray) {
        super(entry);
        Validator.ensureNotNull(controlArray);
        this.messageID = n;
        this.controls = controlArray;
    }

    static SearchResultEntry readSearchEntryFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader, Schema schema) throws LDAPException {
        try {
            aSN1StreamReader.beginSequence();
            String string = aSN1StreamReader.readString();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(10);
            ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
            while (aSN1StreamReaderSequence2.hasMoreElements()) {
                arrayList.add(Attribute.readFrom(aSN1StreamReader, schema));
            }
            Control[] controlArray = NO_CONTROLS;
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                ArrayList<Control> arrayList2 = new ArrayList<Control>(5);
                ASN1StreamReaderSequence aSN1StreamReaderSequence3 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence3.hasMoreElements()) {
                    arrayList2.add(Control.readFrom(aSN1StreamReader));
                }
                controlArray = new Control[arrayList2.size()];
                arrayList2.toArray(controlArray);
            }
            return new SearchResultEntry(n, string, schema, arrayList, controlArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_SEARCH_ENTRY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public int getMessageID() {
        return this.messageID;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(String string) {
        for (Control control : this.controls) {
            if (!control.getOID().equals(string)) continue;
            return control;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        for (Control control : this.controls) {
            n += control.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SearchResultEntry)) {
            return false;
        }
        SearchResultEntry searchResultEntry = (SearchResultEntry)object;
        if (this.controls.length != searchResultEntry.controls.length) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (this.controls[i].equals(searchResultEntry.controls[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("SearchResultEntry(dn='");
        stringBuilder.append(this.getDN());
        stringBuilder.append('\'');
        if (this.messageID >= 0) {
            stringBuilder.append(", messageID=");
            stringBuilder.append(this.messageID);
        }
        stringBuilder.append(", attributes={");
        Iterator<Attribute> iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}, controls={");
        for (int i = 0; i < this.controls.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.controls[i].toString(stringBuilder);
        }
        stringBuilder.append("})");
    }
}

