/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;

public abstract class ServerSet {
    protected ServerSet() {
    }

    public abstract LDAPConnection getConnection() throws LDAPException;

    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        if (lDAPConnectionPoolHealthCheck != null) {
            try {
                lDAPConnectionPoolHealthCheck.ensureNewConnectionValid(lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                lDAPConnection.close();
                throw lDAPException;
            }
        }
        return lDAPConnection;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ServerSet(className=");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(')');
    }
}

