/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPExtendedOperationException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.Validator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public final class StartTLSPostConnectProcessor
implements PostConnectProcessor {
    private final SSLContext sslContext;
    private final SSLSocketFactory sslSocketFactory;

    public StartTLSPostConnectProcessor(SSLContext sSLContext) {
        Validator.ensureNotNull(sSLContext);
        this.sslContext = sSLContext;
        this.sslSocketFactory = null;
    }

    public StartTLSPostConnectProcessor(SSLSocketFactory sSLSocketFactory) {
        Validator.ensureNotNull(sSLSocketFactory);
        this.sslSocketFactory = sSLSocketFactory;
        this.sslContext = null;
    }

    public void processPreAuthenticatedConnection(LDAPConnection lDAPConnection) throws LDAPException {
        StartTLSExtendedRequest startTLSExtendedRequest = this.sslContext == null ? new StartTLSExtendedRequest(this.sslSocketFactory) : new StartTLSExtendedRequest(this.sslContext);
        LDAPConnectionOptions lDAPConnectionOptions = lDAPConnection.getConnectionOptions();
        startTLSExtendedRequest.setResponseTimeoutMillis(lDAPConnectionOptions.getConnectTimeoutMillis());
        ExtendedResult extendedResult = lDAPConnection.processExtendedOperation(startTLSExtendedRequest);
        if (!extendedResult.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPExtendedOperationException(extendedResult);
        }
    }

    public void processPostAuthenticatedConnection(LDAPConnection lDAPConnection) throws LDAPException {
    }
}

