/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeUsage;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeTypeDefinition
extends SchemaElement {
    private static final long serialVersionUID = -6688185196734362719L;
    private final AttributeUsage usage;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObsolete;
    private final boolean isSingleValued;
    private final Map<String, String[]> extensions;
    private final String attributeTypeString;
    private final String description;
    private final String equalityMatchingRule;
    private final String oid;
    private final String orderingMatchingRule;
    private final String substringMatchingRule;
    private final String superiorType;
    private final String syntaxOID;
    private final String[] names;

    public AttributeTypeDefinition(String string) throws LDAPException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        LinkedHashMap<String, String[]> linkedHashMap;
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        AttributeUsage attributeUsage;
        ArrayList<String> arrayList;
        block36: {
            String string8;
            Validator.ensureNotNull(string);
            this.attributeTypeString = string.trim();
            int n = this.attributeTypeString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_EMPTY.get());
            }
            if (this.attributeTypeString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_NO_OPENING_PAREN.get(this.attributeTypeString));
            }
            int n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            arrayList = new ArrayList<String>(1);
            attributeUsage = null;
            bl4 = null;
            bl3 = null;
            bl2 = null;
            bl = null;
            linkedHashMap = new LinkedHashMap<String, String[]>();
            string7 = null;
            string6 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            while (true) {
                Object object;
                String string9;
                int n3 = n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                while (n2 < n && this.attributeTypeString.charAt(n2) != ' ') {
                    ++n2;
                }
                string8 = this.attributeTypeString.substring(n3, n2);
                if (string8.length() > 1 && string8.endsWith(")")) {
                    string8 = string8.substring(0, string8.length() - 1);
                    --n2;
                }
                if ((string9 = StaticUtils.toLowerCase(string8)).equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_CLOSE_NOT_AT_END.get(this.attributeTypeString));
                    }
                    break block36;
                }
                if (string9.equals("name")) {
                    if (arrayList.isEmpty()) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        n2 = AttributeTypeDefinition.readQDStrings(this.attributeTypeString, n2, n, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "NAME"));
                }
                if (string9.equals("desc")) {
                    if (string7 == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readQDString(this.attributeTypeString, n2, n, stringBuilder);
                        string7 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "DESC"));
                }
                if (string9.equals("obsolete")) {
                    if (bl2 == null) {
                        bl2 = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "OBSOLETE"));
                }
                if (string9.equals("sup")) {
                    if (string3 == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
                        string3 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SUP"));
                }
                if (string9.equals("equality")) {
                    if (string6 == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
                        string6 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "EQUALITY"));
                }
                if (string9.equals("ordering")) {
                    if (string5 == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
                        string5 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "ORDERING"));
                }
                if (string9.equals("substr")) {
                    if (string4 == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
                        string4 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SUBSTR"));
                }
                if (string9.equals("syntax")) {
                    if (string2 == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SYNTAX"));
                }
                if (string9.equals("single-value")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "SINGLE-VALUE"));
                }
                if (string9.equals("collective")) {
                    if (bl4 == null) {
                        bl4 = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "COLLECTIVE"));
                }
                if (string9.equals("no-user-modification")) {
                    if (bl3 == null) {
                        bl3 = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "NO-USER-MODIFICATION"));
                }
                if (string9.equals("usage")) {
                    if (attributeUsage == null) {
                        n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeTypeDefinition.readOID(this.attributeTypeString, n2, n, stringBuilder);
                        object = StaticUtils.toLowerCase(stringBuilder.toString());
                        if (((String)object).equals("userapplications")) {
                            attributeUsage = AttributeUsage.USER_APPLICATIONS;
                            continue;
                        }
                        if (((String)object).equals("directoryoperation")) {
                            attributeUsage = AttributeUsage.DIRECTORY_OPERATION;
                            continue;
                        }
                        if (((String)object).equals("distributedoperation")) {
                            attributeUsage = AttributeUsage.DISTRIBUTED_OPERATION;
                            continue;
                        }
                        if (((String)object).equals("dsaoperation")) {
                            attributeUsage = AttributeUsage.DSA_OPERATION;
                            continue;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_INVALID_USAGE.get(this.attributeTypeString, object));
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_MULTIPLE_ELEMENTS.get(this.attributeTypeString, "USAGE"));
                }
                if (!string9.startsWith("x-")) break;
                n2 = AttributeTypeDefinition.skipSpaces(this.attributeTypeString, n2, n);
                object = new ArrayList<String>();
                n2 = AttributeTypeDefinition.readQDStrings(this.attributeTypeString, n2, n, object);
                String[] stringArray = new String[((ArrayList)object).size()];
                ((ArrayList)object).toArray(stringArray);
                if (linkedHashMap.containsKey(string8)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_DUP_EXT.get(this.attributeTypeString, string8));
                }
                linkedHashMap.put(string8, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRTYPE_DECODE_UNEXPECTED_TOKEN.get(this.attributeTypeString, string8));
        }
        this.description = string7;
        this.equalityMatchingRule = string6;
        this.orderingMatchingRule = string5;
        this.substringMatchingRule = string4;
        this.superiorType = string3;
        this.syntaxOID = string2;
        this.names = new String[arrayList.size()];
        arrayList.toArray(this.names);
        this.isObsolete = bl2 != null;
        this.isSingleValued = bl != null;
        this.isCollective = bl4 != null;
        this.isNoUserModification = bl3 != null;
        this.usage = attributeUsage == null ? AttributeUsage.USER_APPLICATIONS : attributeUsage;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public AttributeTypeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, Map<String, String[]> map) {
        String[] stringArray;
        if (string2 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        }
        this(string, stringArray, string3, false, null, string4, string5, string6, string7, bl, false, false, AttributeUsage.USER_APPLICATIONS, map);
    }

    public AttributeTypeDefinition(String string, String[] stringArray, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7, boolean bl2, boolean bl3, boolean bl4, AttributeUsage attributeUsage, Map<String, String[]> map) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.description = string2;
        this.isObsolete = bl;
        this.superiorType = string3;
        this.equalityMatchingRule = string4;
        this.orderingMatchingRule = string5;
        this.substringMatchingRule = string6;
        this.syntaxOID = string7;
        this.isSingleValued = bl2;
        this.isCollective = bl3;
        this.isNoUserModification = bl4;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.usage = attributeUsage == null ? AttributeUsage.USER_APPLICATIONS : attributeUsage;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.attributeTypeString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String stringArray : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(stringArray);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            AttributeTypeDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (this.superiorType != null) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorType);
        }
        if (this.equalityMatchingRule != null) {
            stringBuilder.append(" EQUALITY ");
            stringBuilder.append(this.equalityMatchingRule);
        }
        if (this.orderingMatchingRule != null) {
            stringBuilder.append(" ORDERING ");
            stringBuilder.append(this.orderingMatchingRule);
        }
        if (this.substringMatchingRule != null) {
            stringBuilder.append(" SUBSTR ");
            stringBuilder.append(this.substringMatchingRule);
        }
        if (this.syntaxOID != null) {
            stringBuilder.append(" SYNTAX ");
            stringBuilder.append(this.syntaxOID);
        }
        if (this.isSingleValued) {
            stringBuilder.append(" SINGLE-VALUE");
        }
        if (this.isCollective) {
            stringBuilder.append(" COLLECTIVE");
        }
        if (this.isNoUserModification) {
            stringBuilder.append(" NO-USER-MODIFICATION");
        }
        stringBuilder.append(" USAGE ");
        stringBuilder.append(this.usage.getName());
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                AttributeTypeDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                AttributeTypeDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getSuperiorType() {
        return this.superiorType;
    }

    public AttributeTypeDefinition getSuperiorType(Schema schema) {
        if (this.superiorType != null) {
            return schema.getAttributeType(this.superiorType);
        }
        return null;
    }

    public String getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public String getEqualityMatchingRule(Schema schema) {
        AttributeTypeDefinition attributeTypeDefinition;
        if (this.equalityMatchingRule == null && (attributeTypeDefinition = this.getSuperiorType(schema)) != null) {
            return attributeTypeDefinition.getEqualityMatchingRule(schema);
        }
        return this.equalityMatchingRule;
    }

    public String getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public String getOrderingMatchingRule(Schema schema) {
        AttributeTypeDefinition attributeTypeDefinition;
        if (this.orderingMatchingRule == null && (attributeTypeDefinition = this.getSuperiorType(schema)) != null) {
            return attributeTypeDefinition.getOrderingMatchingRule(schema);
        }
        return this.orderingMatchingRule;
    }

    public String getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    public String getSubstringMatchingRule(Schema schema) {
        AttributeTypeDefinition attributeTypeDefinition;
        if (this.substringMatchingRule == null && (attributeTypeDefinition = this.getSuperiorType(schema)) != null) {
            return attributeTypeDefinition.getSubstringMatchingRule(schema);
        }
        return this.substringMatchingRule;
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public String getSyntaxOID(Schema schema) {
        AttributeTypeDefinition attributeTypeDefinition;
        if (this.syntaxOID == null && (attributeTypeDefinition = this.getSuperiorType(schema)) != null) {
            return attributeTypeDefinition.getSyntaxOID(schema);
        }
        return this.syntaxOID;
    }

    public String getBaseSyntaxOID() {
        return AttributeTypeDefinition.getBaseSyntaxOID(this.syntaxOID);
    }

    public String getBaseSyntaxOID(Schema schema) {
        return AttributeTypeDefinition.getBaseSyntaxOID(this.getSyntaxOID(schema));
    }

    public static String getBaseSyntaxOID(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(123);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public int getSyntaxMinimumUpperBound() {
        return AttributeTypeDefinition.getSyntaxMinimumUpperBound(this.syntaxOID);
    }

    public int getSyntaxMinimumUpperBound(Schema schema) {
        return AttributeTypeDefinition.getSyntaxMinimumUpperBound(this.getSyntaxOID(schema));
    }

    public static int getSyntaxMinimumUpperBound(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.indexOf(123);
        if (n > 0 && string.endsWith("}")) {
            try {
                return Integer.parseInt(string.substring(n + 1, string.length() - 1));
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                return -1;
            }
        }
        return -1;
    }

    public boolean isSingleValued() {
        return this.isSingleValued;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        return this.isNoUserModification;
    }

    public AttributeUsage getUsage() {
        return this.usage;
    }

    public boolean isOperational() {
        return this.usage.isOperational();
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AttributeTypeDefinition)) {
            return false;
        }
        AttributeTypeDefinition attributeTypeDefinition = (AttributeTypeDefinition)object;
        return this.oid.equals(attributeTypeDefinition.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, attributeTypeDefinition.names) && StaticUtils.bothNullOrEqual((Object)this.usage, (Object)attributeTypeDefinition.usage) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, attributeTypeDefinition.description) && StaticUtils.bothNullOrEqualIgnoreCase(this.equalityMatchingRule, attributeTypeDefinition.equalityMatchingRule) && StaticUtils.bothNullOrEqualIgnoreCase(this.orderingMatchingRule, attributeTypeDefinition.orderingMatchingRule) && StaticUtils.bothNullOrEqualIgnoreCase(this.substringMatchingRule, attributeTypeDefinition.substringMatchingRule) && StaticUtils.bothNullOrEqualIgnoreCase(this.superiorType, attributeTypeDefinition.superiorType) && StaticUtils.bothNullOrEqualIgnoreCase(this.syntaxOID, attributeTypeDefinition.syntaxOID) && this.isCollective == attributeTypeDefinition.isCollective && this.isNoUserModification == attributeTypeDefinition.isNoUserModification && this.isObsolete == attributeTypeDefinition.isObsolete && this.isSingleValued == attributeTypeDefinition.isSingleValued && AttributeTypeDefinition.extensionsEqual(this.extensions, attributeTypeDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.attributeTypeString;
    }
}

