/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DITStructureRuleDefinition
extends SchemaElement {
    private static final int[] NO_INTS = new int[0];
    private static final long serialVersionUID = -3233223742542121140L;
    private final boolean isObsolete;
    private final int ruleID;
    private final int[] superiorRuleIDs;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String ditStructureRuleString;
    private final String nameFormID;
    private final String[] names;

    public DITStructureRuleDefinition(String string) throws LDAPException {
        int n;
        String string2;
        String string3;
        Boolean bl;
        LinkedHashMap<String, Object> linkedHashMap;
        ArrayList<String> arrayList;
        ArrayList<Integer> arrayList2;
        block25: {
            String string4;
            Validator.ensureNotNull(string);
            this.ditStructureRuleString = string.trim();
            int n2 = this.ditStructureRuleString.length();
            if (n2 == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_EMPTY.get());
            }
            if (this.ditStructureRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_NO_OPENING_PAREN.get(this.ditStructureRuleString));
            }
            int n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, 1, n2);
            StringBuilder stringBuilder = new StringBuilder();
            n3 = DITStructureRuleDefinition.readOID(this.ditStructureRuleString, n3, n2, stringBuilder);
            String string5 = stringBuilder.toString();
            try {
                this.ruleID = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.debugException(numberFormatException);
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_RULE_ID_NOT_INT.get(this.ditStructureRuleString), numberFormatException);
            }
            arrayList2 = new ArrayList<Integer>(1);
            arrayList = new ArrayList<String>(1);
            linkedHashMap = new LinkedHashMap<String, Object>();
            bl = null;
            string3 = null;
            string2 = null;
            block4: while (true) {
                Object object;
                ArrayList<String> arrayList3;
                String string6;
                n = n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, n3, n2);
                while (n3 < n2 && this.ditStructureRuleString.charAt(n3) != ' ') {
                    ++n3;
                }
                string4 = this.ditStructureRuleString.substring(n, n3);
                if (string4.length() > 1 && string4.endsWith(")")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    --n3;
                }
                if ((string6 = StaticUtils.toLowerCase(string4)).equals(")")) {
                    if (n3 < n2) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_CLOSE_NOT_AT_END.get(this.ditStructureRuleString));
                    }
                    break block25;
                }
                if (string6.equals("name")) {
                    if (arrayList.isEmpty()) {
                        n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, n3, n2);
                        n3 = DITStructureRuleDefinition.readQDStrings(this.ditStructureRuleString, n3, n2, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "NAME"));
                }
                if (string6.equals("desc")) {
                    if (string3 == null) {
                        n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, n3, n2);
                        stringBuilder = new StringBuilder();
                        n3 = DITStructureRuleDefinition.readQDString(this.ditStructureRuleString, n3, n2, stringBuilder);
                        string3 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "DESC"));
                }
                if (string6.equals("obsolete")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "OBSOLETE"));
                }
                if (string6.equals("form")) {
                    if (string2 == null) {
                        n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, n3, n2);
                        stringBuilder = new StringBuilder();
                        n3 = DITStructureRuleDefinition.readOID(this.ditStructureRuleString, n3, n2, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "FORM"));
                }
                if (string6.equals("sup")) {
                    if (arrayList2.isEmpty()) {
                        arrayList3 = new ArrayList<String>(1);
                        n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, n3, n2);
                        n3 = DITStructureRuleDefinition.readOIDs(this.ditStructureRuleString, n3, n2, arrayList3);
                        arrayList2.ensureCapacity(arrayList3.size());
                        object = arrayList3.iterator();
                        while (true) {
                            if (!object.hasNext()) continue block4;
                            String string7 = (String)object.next();
                            try {
                                arrayList2.add(Integer.parseInt(string7));
                            }
                            catch (NumberFormatException numberFormatException) {
                                Debug.debugException(numberFormatException);
                                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_SUP_ID_NOT_INT.get(this.ditStructureRuleString), numberFormatException);
                            }
                        }
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "SUP"));
                }
                if (!string6.startsWith("x-")) break;
                n3 = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, n3, n2);
                arrayList3 = new ArrayList();
                n3 = DITStructureRuleDefinition.readQDStrings(this.ditStructureRuleString, n3, n2, arrayList3);
                object = new String[arrayList3.size()];
                arrayList3.toArray((T[])object);
                if (linkedHashMap.containsKey(string4)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_DUP_EXT.get(this.ditStructureRuleString, string4));
                }
                linkedHashMap.put(string4, object);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_UNEXPECTED_TOKEN.get(this.ditStructureRuleString, string4));
        }
        this.description = string3;
        this.nameFormID = string2;
        if (this.nameFormID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_NO_FORM.get(this.ditStructureRuleString));
        }
        this.names = new String[arrayList.size()];
        arrayList.toArray(this.names);
        this.superiorRuleIDs = new int[arrayList2.size()];
        for (n = 0; n < this.superiorRuleIDs.length; ++n) {
            this.superiorRuleIDs[n] = (Integer)arrayList2.get(n);
        }
        this.isObsolete = bl != null;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public DITStructureRuleDefinition(int n, String string, String string2, String string3, Integer n2, Map<String, String[]> map) {
        int[] nArray;
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        if (n2 == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = n2;
        }
        this(n, stringArray, string2, false, string3, nArray, map);
    }

    public DITStructureRuleDefinition(int n, String[] stringArray, String string, boolean bl, String string2, int[] nArray, Map<String, String[]> map) {
        Validator.ensureNotNull(string2);
        this.ruleID = n;
        this.description = string;
        this.isObsolete = bl;
        this.nameFormID = string2;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.superiorRuleIDs = nArray == null ? NO_INTS : nArray;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.ditStructureRuleString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.ruleID);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String object : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(object);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            DITStructureRuleDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        stringBuilder.append(" FORM ");
        stringBuilder.append(this.nameFormID);
        if (this.superiorRuleIDs.length == 1) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorRuleIDs[0]);
        } else if (this.superiorRuleIDs.length > 1) {
            stringBuilder.append(" SUP (");
            for (Object stringArray : (Object)this.superiorRuleIDs) {
                stringBuilder.append(" $ ");
                stringBuilder.append((int)stringArray);
            }
            stringBuilder.append(" )");
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                DITStructureRuleDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                DITStructureRuleDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrRuleID() {
        if (this.names.length == 0) {
            return String.valueOf(this.ruleID);
        }
        return this.names[0];
    }

    public boolean hasNameOrRuleID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(String.valueOf(this.ruleID));
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getNameFormID() {
        return this.nameFormID;
    }

    public int[] getSuperiorRuleIDs() {
        return this.superiorRuleIDs;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.ruleID;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof DITStructureRuleDefinition)) {
            return false;
        }
        DITStructureRuleDefinition dITStructureRuleDefinition = (DITStructureRuleDefinition)object;
        if (this.ruleID == dITStructureRuleDefinition.ruleID && this.nameFormID.equalsIgnoreCase(dITStructureRuleDefinition.nameFormID) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, dITStructureRuleDefinition.names) && this.isObsolete == dITStructureRuleDefinition.isObsolete && DITStructureRuleDefinition.extensionsEqual(this.extensions, dITStructureRuleDefinition.extensions)) {
            if (this.superiorRuleIDs.length != dITStructureRuleDefinition.superiorRuleIDs.length) {
                return false;
            }
            HashSet<Integer> hashSet = new HashSet<Integer>(this.superiorRuleIDs.length);
            HashSet<Integer> hashSet2 = new HashSet<Integer>(this.superiorRuleIDs.length);
            for (int n : this.superiorRuleIDs) {
                hashSet.add(n);
            }
            for (int n : dITStructureRuleDefinition.superiorRuleIDs) {
                hashSet2.add(n);
            }
            return hashSet.equals(hashSet2);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ditStructureRuleString;
    }
}

