/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchingRuleDefinition
extends SchemaElement {
    private static final long serialVersionUID = 8214648655449007967L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String matchingRuleString;
    private final String oid;
    private final String syntaxOID;
    private final String[] names;

    public MatchingRuleDefinition(String string) throws LDAPException {
        LinkedHashMap<String, String[]> linkedHashMap;
        String string2;
        Boolean bl;
        String string3;
        ArrayList<String> arrayList;
        block17: {
            String string4;
            Validator.ensureNotNull(string);
            this.matchingRuleString = string.trim();
            int n = this.matchingRuleString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_EMPTY.get());
            }
            if (this.matchingRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_NO_OPENING_PAREN.get(this.matchingRuleString));
            }
            int n2 = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = MatchingRuleDefinition.readOID(this.matchingRuleString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            arrayList = new ArrayList<String>(1);
            string3 = null;
            bl = null;
            string2 = null;
            linkedHashMap = new LinkedHashMap<String, String[]>();
            while (true) {
                String string5;
                int n3 = n2 = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, n2, n);
                while (n2 < n && this.matchingRuleString.charAt(n2) != ' ') {
                    ++n2;
                }
                string4 = this.matchingRuleString.substring(n3, n2);
                if (string4.length() > 1 && string4.endsWith(")")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    --n2;
                }
                if ((string5 = StaticUtils.toLowerCase(string4)).equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_CLOSE_NOT_AT_END.get(this.matchingRuleString));
                    }
                    break block17;
                }
                if (string5.equals("name")) {
                    if (arrayList.isEmpty()) {
                        n2 = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, n2, n);
                        n2 = MatchingRuleDefinition.readQDStrings(this.matchingRuleString, n2, n, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "NAME"));
                }
                if (string5.equals("desc")) {
                    if (string3 == null) {
                        n2 = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = MatchingRuleDefinition.readQDString(this.matchingRuleString, n2, n, stringBuilder);
                        string3 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "DESC"));
                }
                if (string5.equals("obsolete")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "OBSOLETE"));
                }
                if (string5.equals("syntax")) {
                    if (string2 == null) {
                        n2 = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = MatchingRuleDefinition.readOID(this.matchingRuleString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "SYNTAX"));
                }
                if (!string5.startsWith("x-")) break;
                n2 = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, n2, n);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                n2 = MatchingRuleDefinition.readQDStrings(this.matchingRuleString, n2, n, arrayList2);
                String[] stringArray = new String[arrayList2.size()];
                arrayList2.toArray(stringArray);
                if (linkedHashMap.containsKey(string4)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_DUP_EXT.get(this.matchingRuleString, string4));
                }
                linkedHashMap.put(string4, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_UNEXPECTED_TOKEN.get(this.matchingRuleString, string4));
        }
        this.description = string3;
        this.syntaxOID = string2;
        if (this.syntaxOID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_NO_SYNTAX.get(this.matchingRuleString));
        }
        this.names = new String[arrayList.size()];
        arrayList.toArray(this.names);
        this.isObsolete = bl != null;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public MatchingRuleDefinition(String string, String string2, String string3, String string4, Map<String, String[]> map) {
        String[] stringArray;
        if (string2 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        }
        this(string, stringArray, string3, false, string4, map);
    }

    public MatchingRuleDefinition(String string, String[] stringArray, String string2, boolean bl, String string3, Map<String, String[]> map) {
        Validator.ensureNotNull(string, string3);
        this.oid = string;
        this.description = string2;
        this.isObsolete = bl;
        this.syntaxOID = string3;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.matchingRuleString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String stringArray : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(stringArray);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            MatchingRuleDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        stringBuilder.append(" SYNTAX ");
        stringBuilder.append(this.syntaxOID);
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                MatchingRuleDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                MatchingRuleDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatchingRuleDefinition)) {
            return false;
        }
        MatchingRuleDefinition matchingRuleDefinition = (MatchingRuleDefinition)object;
        return this.oid.equals(matchingRuleDefinition.oid) && this.syntaxOID.equals(matchingRuleDefinition.syntaxOID) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, matchingRuleDefinition.names) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, matchingRuleDefinition.description) && this.isObsolete == matchingRuleDefinition.isObsolete && MatchingRuleDefinition.extensionsEqual(this.extensions, matchingRuleDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.matchingRuleString;
    }
}

