/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFException
extends LDAPSDKException {
    private static final long serialVersionUID = 1665883395956836732L;
    private final boolean mayContinueReading;
    private final long lineNumber;
    private final List<String> dataLines;

    public LDIFException(String string, long l, boolean bl) {
        this(string, l, bl, (List<? extends CharSequence>)null, null);
    }

    public LDIFException(String string, long l, boolean bl, Throwable throwable) {
        this(string, l, bl, (List<? extends CharSequence>)null, throwable);
    }

    public LDIFException(String string, long l, boolean bl, CharSequence[] charSequenceArray, Throwable throwable) {
        this(string, l, bl, charSequenceArray == null ? null : Arrays.asList(charSequenceArray), throwable);
    }

    public LDIFException(String string, long l, boolean bl, List<? extends CharSequence> list, Throwable throwable) {
        super(string, throwable);
        Validator.ensureNotNull(string);
        this.lineNumber = l;
        this.mayContinueReading = bl;
        if (list == null) {
            this.dataLines = null;
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (CharSequence charSequence : list) {
                arrayList.add(((Object)charSequence).toString());
            }
            this.dataLines = Collections.unmodifiableList(arrayList);
        }
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public boolean mayContinueReading() {
        return this.mayContinueReading;
    }

    public List<String> getDataLines() {
        return this.dataLines;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        Object object;
        stringBuilder.append("LDIFException(lineNumber=");
        stringBuilder.append(this.lineNumber);
        stringBuilder.append(", mayContinueReading=");
        stringBuilder.append(this.mayContinueReading);
        stringBuilder.append(", message='");
        stringBuilder.append(this.getMessage());
        if (this.dataLines != null) {
            stringBuilder.append("', dataLines='");
            object = this.dataLines.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                stringBuilder.append((CharSequence)string);
                stringBuilder.append("{end-of-line}");
            }
        }
        if ((object = this.getCause()) == null) {
            stringBuilder.append("')");
        } else {
            stringBuilder.append("', cause=");
            StaticUtils.getStackTrace((Throwable)object, stringBuilder);
            stringBuilder.append(')');
        }
    }

    @Override
    public String getExceptionMessage() {
        return this.toString();
    }
}

