/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFModifyDNChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 5804442145450388071L;
    private final boolean deleteOldRDN;
    private volatile DN parsedNewSuperiorDN;
    private volatile RDN parsedNewRDN;
    private final String newRDN;
    private final String newSuperiorDN;

    public LDIFModifyDNChangeRecord(String string, String string2, boolean bl, String string3) {
        this(string, string2, bl, string3, null);
    }

    public LDIFModifyDNChangeRecord(String string, String string2, boolean bl, String string3, List<Control> list) {
        super(string, list);
        Validator.ensureNotNull(string2);
        this.newRDN = string2;
        this.deleteOldRDN = bl;
        this.newSuperiorDN = string3;
        this.parsedNewRDN = null;
        this.parsedNewSuperiorDN = null;
    }

    public LDIFModifyDNChangeRecord(ModifyDNRequest modifyDNRequest) {
        super(modifyDNRequest.getDN(), modifyDNRequest.getControlList());
        this.newRDN = modifyDNRequest.getNewRDN();
        this.deleteOldRDN = modifyDNRequest.deleteOldRDN();
        this.newSuperiorDN = modifyDNRequest.getNewSuperiorDN();
        this.parsedNewRDN = null;
        this.parsedNewSuperiorDN = null;
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public RDN getParsedNewRDN() throws LDAPException {
        if (this.parsedNewRDN == null) {
            this.parsedNewRDN = new RDN(this.newRDN);
        }
        return this.parsedNewRDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public DN getParsedNewSuperiorDN() throws LDAPException {
        if (this.parsedNewSuperiorDN == null && this.newSuperiorDN != null) {
            this.parsedNewSuperiorDN = new DN(this.newSuperiorDN);
        }
        return this.parsedNewSuperiorDN;
    }

    public DN getNewDN() throws LDAPException {
        if (this.newSuperiorDN == null) {
            DN dN = this.getParsedDN().getParent();
            if (dN == null) {
                return new DN(this.getParsedNewRDN());
            }
            return new DN(this.getParsedNewRDN(), dN);
        }
        return new DN(this.getParsedNewRDN(), this.getParsedNewSuperiorDN());
    }

    public ModifyDNRequest toModifyDNRequest() {
        return this.toModifyDNRequest(true);
    }

    public ModifyDNRequest toModifyDNRequest(boolean bl) {
        ModifyDNRequest modifyDNRequest = new ModifyDNRequest(this.getDN(), this.newRDN, this.deleteOldRDN, this.newSuperiorDN);
        if (bl) {
            modifyDNRequest.setControls(this.getControls());
        }
        return modifyDNRequest;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY_DN;
    }

    @Override
    public LDAPResult processChange(LDAPInterface lDAPInterface, boolean bl) throws LDAPException {
        return lDAPInterface.modifyDN(this.toModifyDNRequest(bl));
    }

    @Override
    public String[] toLDIF(int n) {
        List<String> list = new ArrayList<String>(10);
        LDIFModifyDNChangeRecord.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), list);
        for (Control control : this.getControls()) {
            LDIFModifyDNChangeRecord.encodeNameAndValue("control", LDIFModifyDNChangeRecord.encodeControlString(control), list);
        }
        list.add("changetype: moddn");
        LDIFModifyDNChangeRecord.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN), list);
        list.add("deleteoldrdn: " + (this.deleteOldRDN ? "1" : "0"));
        if (this.newSuperiorDN != null) {
            LDIFModifyDNChangeRecord.encodeNameAndValue("newsuperior", new ASN1OctetString(this.newSuperiorDN), list);
        }
        if (n > 2) {
            list = LDIFWriter.wrapLines(n, list);
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer byteStringBuffer, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        for (Control control : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFModifyDNChangeRecord.encodeControlString(control), byteStringBuffer, n);
            byteStringBuffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("moddn"), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        LDIFWriter.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        if (this.deleteOldRDN) {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("1"), byteStringBuffer, n);
        } else {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("0"), byteStringBuffer, n);
        }
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        if (this.newSuperiorDN != null) {
            LDIFWriter.encodeNameAndValue("newsuperior", new ASN1OctetString(this.newSuperiorDN), byteStringBuffer, n);
            byteStringBuffer.append(StaticUtils.EOL_BYTES);
        }
    }

    @Override
    public void toLDIFString(StringBuilder stringBuilder, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        for (Control control : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFModifyDNChangeRecord.encodeControlString(control), stringBuilder, n);
            stringBuilder.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("moddn"), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        LDIFWriter.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        if (this.deleteOldRDN) {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("1"), stringBuilder, n);
        } else {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("0"), stringBuilder, n);
        }
        stringBuilder.append(StaticUtils.EOL);
        if (this.newSuperiorDN != null) {
            LDIFWriter.encodeNameAndValue("newsuperior", new ASN1OctetString(this.newSuperiorDN), stringBuilder, n);
            stringBuilder.append(StaticUtils.EOL);
        }
    }

    @Override
    public int hashCode() {
        int n;
        block4: {
            try {
                n = this.getParsedDN().hashCode() + this.getParsedNewRDN().hashCode();
                if (this.newSuperiorDN != null) {
                    n += this.getParsedNewSuperiorDN().hashCode();
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                n = StaticUtils.toLowerCase(this.getDN()).hashCode() + StaticUtils.toLowerCase(this.newRDN).hashCode();
                if (this.newSuperiorDN == null) break block4;
                n += StaticUtils.toLowerCase(this.newSuperiorDN).hashCode();
            }
        }
        if (this.deleteOldRDN) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        LDIFModifyDNChangeRecord lDIFModifyDNChangeRecord;
        block19: {
            block18: {
                block17: {
                    HashSet<Control> hashSet;
                    if (object == null) {
                        return false;
                    }
                    if (object == this) {
                        return true;
                    }
                    if (!(object instanceof LDIFModifyDNChangeRecord)) {
                        return false;
                    }
                    lDIFModifyDNChangeRecord = (LDIFModifyDNChangeRecord)object;
                    HashSet<Control> hashSet2 = new HashSet<Control>(this.getControls());
                    if (!hashSet2.equals(hashSet = new HashSet<Control>(lDIFModifyDNChangeRecord.getControls()))) {
                        return false;
                    }
                    try {
                        if (!this.getParsedDN().equals(lDIFModifyDNChangeRecord.getParsedDN())) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        if (StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(lDIFModifyDNChangeRecord.getDN()))) break block17;
                        return false;
                    }
                }
                try {
                    if (!this.getParsedNewRDN().equals(lDIFModifyDNChangeRecord.getParsedNewRDN())) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    if (StaticUtils.toLowerCase(this.newRDN).equals(StaticUtils.toLowerCase(lDIFModifyDNChangeRecord.newRDN))) break block18;
                    return false;
                }
            }
            if (this.newSuperiorDN == null) {
                if (lDIFModifyDNChangeRecord.newSuperiorDN != null) {
                    return false;
                }
            } else {
                if (lDIFModifyDNChangeRecord.newSuperiorDN == null) {
                    return false;
                }
                try {
                    if (!this.getParsedNewSuperiorDN().equals(lDIFModifyDNChangeRecord.getParsedNewSuperiorDN())) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    if (StaticUtils.toLowerCase(this.newSuperiorDN).equals(StaticUtils.toLowerCase(lDIFModifyDNChangeRecord.newSuperiorDN))) break block19;
                    return false;
                }
            }
        }
        return this.deleteOldRDN == lDIFModifyDNChangeRecord.deleteOldRDN;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        List<Control> list;
        stringBuilder.append("LDIFModifyDNChangeRecord(dn='");
        stringBuilder.append(this.getDN());
        stringBuilder.append("', newRDN='");
        stringBuilder.append(this.newRDN);
        stringBuilder.append("', deleteOldRDN=");
        stringBuilder.append(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            stringBuilder.append(", newSuperiorDN='");
            stringBuilder.append(this.newSuperiorDN);
            stringBuilder.append('\'');
        }
        if (!(list = this.getControls()).isEmpty()) {
            stringBuilder.append(", controls={");
            Iterator<Control> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(stringBuilder);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

