/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.DuplicateValueBehavior;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFAttribute;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReaderChangeRecordTranslator;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.TrailingSpaceBehavior;
import com.unboundid.util.AggregateInputStream;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.AsynchronousParallelProcessor;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFReader
implements Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 131072;
    private static final int ASYNC_MIN_PER_PARSING_THREAD = 3;
    private static final int ASYNC_QUEUE_SIZE = 500;
    private static final Entry SKIP_ENTRY = new Entry("cn=skipped");
    private static final String DEFAULT_RELATIVE_BASE_PATH;
    private final BufferedReader reader;
    private volatile DuplicateValueBehavior duplicateValueBehavior;
    private long lineNumberCounter = 0L;
    private final LDIFReaderChangeRecordTranslator changeRecordTranslator;
    private final LDIFReaderEntryTranslator entryTranslator;
    private Schema schema;
    private volatile String relativeBasePath;
    private volatile TrailingSpaceBehavior trailingSpaceBehavior;
    private final boolean isAsync;
    private final AsynchronousParallelProcessor<UnparsedLDIFRecord, LDIFRecord> asyncParser;
    private final AtomicBoolean asyncParsingComplete;
    private final BlockingQueue<Result<UnparsedLDIFRecord, LDIFRecord>> asyncParsedRecords;

    public LDIFReader(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public LDIFReader(String string, int n) throws IOException {
        this(new FileInputStream(string), n);
    }

    public LDIFReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public LDIFReader(File file, int n) throws IOException {
        this(new FileInputStream(file), n);
    }

    public LDIFReader(File[] fileArray, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator) throws IOException {
        this(fileArray, n, lDIFReaderEntryTranslator, null);
    }

    public LDIFReader(File[] fileArray, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator, LDIFReaderChangeRecordTranslator lDIFReaderChangeRecordTranslator) throws IOException {
        this(fileArray, n, lDIFReaderEntryTranslator, lDIFReaderChangeRecordTranslator, "UTF-8");
    }

    public LDIFReader(File[] fileArray, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator, LDIFReaderChangeRecordTranslator lDIFReaderChangeRecordTranslator, String string) throws IOException {
        this(LDIFReader.createAggregateInputStream(fileArray), n, lDIFReaderEntryTranslator, lDIFReaderChangeRecordTranslator, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream createAggregateInputStream(File ... fileArray) throws IOException {
        if (fileArray.length == 0) {
            throw new IOException(LDIFMessages.ERR_READ_NO_LDIF_FILES.get());
        }
        if (fileArray.length == 1) {
            return new FileInputStream(fileArray[0]);
        }
        File file = File.createTempFile("ldif-reader-spacer", ".ldif");
        file.deleteOnExit();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        finally {
            bufferedWriter.close();
        }
        File[] fileArray2 = new File[fileArray.length * 2 - 1];
        fileArray2[0] = fileArray[0];
        int n = 1;
        for (int i = 1; i < fileArray.length; ++i) {
            fileArray2[n++] = file;
            fileArray2[n++] = fileArray[i];
        }
        return new AggregateInputStream(fileArray2);
    }

    public LDIFReader(InputStream inputStream) {
        this(inputStream, 0);
    }

    public LDIFReader(InputStream inputStream, int n) {
        this(new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")), 131072), n);
    }

    public LDIFReader(InputStream inputStream, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator) {
        this(inputStream, n, lDIFReaderEntryTranslator, null);
    }

    public LDIFReader(InputStream inputStream, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator, LDIFReaderChangeRecordTranslator lDIFReaderChangeRecordTranslator) {
        this(inputStream, n, lDIFReaderEntryTranslator, lDIFReaderChangeRecordTranslator, "UTF-8");
    }

    public LDIFReader(InputStream inputStream, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator, LDIFReaderChangeRecordTranslator lDIFReaderChangeRecordTranslator, String string) {
        this(new BufferedReader(new InputStreamReader(inputStream, Charset.forName(string)), 131072), n, lDIFReaderEntryTranslator, lDIFReaderChangeRecordTranslator);
    }

    public LDIFReader(BufferedReader bufferedReader) {
        this(bufferedReader, 0);
    }

    public LDIFReader(BufferedReader bufferedReader, int n) {
        this(bufferedReader, n, null);
    }

    public LDIFReader(BufferedReader bufferedReader, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator) {
        this(bufferedReader, n, lDIFReaderEntryTranslator, null);
    }

    public LDIFReader(BufferedReader bufferedReader, int n, LDIFReaderEntryTranslator lDIFReaderEntryTranslator, LDIFReaderChangeRecordTranslator lDIFReaderChangeRecordTranslator) {
        Validator.ensureNotNull(bufferedReader);
        Validator.ensureTrue(n >= 0, "LDIFReader.numParseThreads must not be negative.");
        this.reader = bufferedReader;
        this.entryTranslator = lDIFReaderEntryTranslator;
        this.changeRecordTranslator = lDIFReaderChangeRecordTranslator;
        this.duplicateValueBehavior = DuplicateValueBehavior.STRIP;
        this.trailingSpaceBehavior = TrailingSpaceBehavior.REJECT;
        this.relativeBasePath = DEFAULT_RELATIVE_BASE_PATH;
        if (n == 0) {
            this.isAsync = false;
            this.asyncParser = null;
            this.asyncParsingComplete = null;
            this.asyncParsedRecords = null;
        } else {
            this.isAsync = true;
            this.asyncParsingComplete = new AtomicBoolean(false);
            LDAPSDKThreadFactory lDAPSDKThreadFactory = new LDAPSDKThreadFactory("LDIFReader Worker", true, null);
            ParallelProcessor<UnparsedLDIFRecord, LDIFRecord> parallelProcessor = new ParallelProcessor<UnparsedLDIFRecord, LDIFRecord>(new RecordParser(), lDAPSDKThreadFactory, n, 3);
            ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(500);
            this.asyncParsedRecords = new ArrayBlockingQueue<Result<UnparsedLDIFRecord, LDIFRecord>>(1100);
            this.asyncParser = new AsynchronousParallelProcessor<UnparsedLDIFRecord, LDIFRecord>(arrayBlockingQueue, parallelProcessor, this.asyncParsedRecords);
            LineReaderThread lineReaderThread = new LineReaderThread();
            lineReaderThread.start();
        }
    }

    public static List<Entry> readEntries(String string) throws IOException, LDIFException {
        return LDIFReader.readEntries(new LDIFReader(string));
    }

    public static List<Entry> readEntries(File file) throws IOException, LDIFException {
        return LDIFReader.readEntries(new LDIFReader(file));
    }

    public static List<Entry> readEntries(InputStream inputStream) throws IOException, LDIFException {
        return LDIFReader.readEntries(new LDIFReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Entry> readEntries(LDIFReader lDIFReader) throws IOException, LDIFException {
        try {
            Serializable serializable;
            ArrayList<Entry> arrayList = new ArrayList<Entry>(10);
            while ((serializable = lDIFReader.readEntry()) != null) {
                arrayList.add((Entry)serializable);
            }
            serializable = arrayList;
            return serializable;
        }
        finally {
            lDIFReader.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.isAsync()) {
            this.asyncParsedRecords.clear();
        }
    }

    @Deprecated
    public boolean ignoreDuplicateValues() {
        return this.duplicateValueBehavior == DuplicateValueBehavior.STRIP;
    }

    @Deprecated
    public void setIgnoreDuplicateValues(boolean bl) {
        this.duplicateValueBehavior = bl ? DuplicateValueBehavior.STRIP : DuplicateValueBehavior.REJECT;
    }

    public DuplicateValueBehavior getDuplicateValueBehavior() {
        return this.duplicateValueBehavior;
    }

    public void setDuplicateValueBehavior(DuplicateValueBehavior duplicateValueBehavior) {
        this.duplicateValueBehavior = duplicateValueBehavior;
    }

    @Deprecated
    public boolean stripTrailingSpaces() {
        return this.trailingSpaceBehavior == TrailingSpaceBehavior.STRIP;
    }

    @Deprecated
    public void setStripTrailingSpaces(boolean bl) {
        this.trailingSpaceBehavior = bl ? TrailingSpaceBehavior.STRIP : TrailingSpaceBehavior.REJECT;
    }

    public TrailingSpaceBehavior getTrailingSpaceBehavior() {
        return this.trailingSpaceBehavior;
    }

    public void setTrailingSpaceBehavior(TrailingSpaceBehavior trailingSpaceBehavior) {
        this.trailingSpaceBehavior = trailingSpaceBehavior;
    }

    public String getRelativeBasePath() {
        return this.relativeBasePath;
    }

    public void setRelativeBasePath(String string) {
        this.setRelativeBasePath(new File(string));
    }

    public void setRelativeBasePath(File file) {
        String string = file.getAbsolutePath();
        this.relativeBasePath = string.endsWith(File.separator) ? string : string + File.separator;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public LDIFRecord readLDIFRecord() throws IOException, LDIFException {
        if (this.isAsync()) {
            return this.readLDIFRecordAsync();
        }
        return this.readLDIFRecordInternal();
    }

    public Entry readEntry() throws IOException, LDIFException {
        if (this.isAsync()) {
            return this.readEntryAsync();
        }
        return this.readEntryInternal();
    }

    public LDIFChangeRecord readChangeRecord() throws IOException, LDIFException {
        return this.readChangeRecord(false);
    }

    public LDIFChangeRecord readChangeRecord(boolean bl) throws IOException, LDIFException {
        if (this.isAsync()) {
            return this.readChangeRecordAsync(bl);
        }
        return this.readChangeRecordInternal(bl);
    }

    private LDIFRecord readLDIFRecordAsync() throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        LDIFRecord lDIFRecord = null;
        while (lDIFRecord == null) {
            result = this.readLDIFRecordResultAsync();
            if (result == null) {
                return null;
            }
            lDIFRecord = result.getOutput();
            if (lDIFRecord != SKIP_ENTRY) continue;
            lDIFRecord = null;
        }
        return lDIFRecord;
    }

    private Entry readEntryAsync() throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        LDIFRecord lDIFRecord = null;
        while (lDIFRecord == null) {
            result = this.readLDIFRecordResultAsync();
            if (result == null) {
                return null;
            }
            lDIFRecord = result.getOutput();
            if (lDIFRecord != SKIP_ENTRY) continue;
            lDIFRecord = null;
        }
        if (lDIFRecord instanceof Entry) {
            return (Entry)lDIFRecord;
        }
        if (lDIFRecord instanceof LDIFChangeRecord) {
            try {
                return ((LDIFChangeRecord)lDIFRecord).toEntry();
            }
            catch (LDIFException lDIFException) {
                Debug.debugException(lDIFException);
                long l = result.getInput().getFirstLineNumber();
                throw new LDIFException(lDIFException.getExceptionMessage(), l, true, lDIFException);
            }
        }
        throw new AssertionError((Object)"LDIFRecords must either be an Entry or an LDIFChangeRecord");
    }

    private LDIFChangeRecord readChangeRecordAsync(boolean bl) throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        LDIFRecord lDIFRecord = null;
        while (lDIFRecord == null) {
            result = this.readLDIFRecordResultAsync();
            if (result == null) {
                return null;
            }
            lDIFRecord = result.getOutput();
            if (lDIFRecord != SKIP_ENTRY) continue;
            lDIFRecord = null;
        }
        if (lDIFRecord instanceof LDIFChangeRecord) {
            return (LDIFChangeRecord)lDIFRecord;
        }
        if (lDIFRecord instanceof Entry) {
            if (bl) {
                return new LDIFAddChangeRecord((Entry)lDIFRecord);
            }
            long l = result.getInput().getFirstLineNumber();
            throw new LDIFException(LDIFMessages.ERR_READ_NOT_CHANGE_RECORD.get(l), l, true);
        }
        throw new AssertionError((Object)"LDIFRecords must either be an Entry or an LDIFChangeRecord");
    }

    private Result<UnparsedLDIFRecord, LDIFRecord> readLDIFRecordResultAsync() throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        if (this.asyncParsingComplete.get()) {
            result = (Result<UnparsedLDIFRecord, LDIFRecord>)this.asyncParsedRecords.poll();
        } else {
            try {
                while (result == null && !this.asyncParsingComplete.get()) {
                    result = this.asyncParsedRecords.poll(1L, TimeUnit.SECONDS);
                }
                if (result == null) {
                    result = (Result)this.asyncParsedRecords.poll();
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
                throw StaticUtils.createIOExceptionWithCause(null, interruptedException);
            }
        }
        if (result == null) {
            return null;
        }
        LDIFReader.rethrow(result.getFailureCause());
        UnparsedLDIFRecord unparsedLDIFRecord = (UnparsedLDIFRecord)result.getInput();
        if (unparsedLDIFRecord.isEOF()) {
            this.asyncParsingComplete.set(true);
            try {
                this.asyncParsedRecords.put(result);
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                Thread.currentThread().interrupt();
            }
            return null;
        }
        return result;
    }

    private boolean isAsync() {
        return this.isAsync;
    }

    static void rethrow(Throwable throwable) throws IOException, LDIFException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof LDIFException) {
            throw (LDIFException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw StaticUtils.createIOExceptionWithCause(null, throwable);
    }

    private LDIFRecord readLDIFRecordInternal() throws IOException, LDIFException {
        UnparsedLDIFRecord unparsedLDIFRecord = this.readUnparsedRecord();
        return LDIFReader.decodeRecord(unparsedLDIFRecord, this.relativeBasePath, this.schema);
    }

    private Entry readEntryInternal() throws IOException, LDIFException {
        Entry entry = null;
        while (entry == null) {
            UnparsedLDIFRecord unparsedLDIFRecord = this.readUnparsedRecord();
            if (unparsedLDIFRecord.isEOF()) {
                return null;
            }
            entry = LDIFReader.decodeEntry(unparsedLDIFRecord, this.relativeBasePath);
            Debug.debugLDIFRead(entry);
            if (this.entryTranslator == null) continue;
            entry = this.entryTranslator.translate(entry, unparsedLDIFRecord.getFirstLineNumber());
        }
        return entry;
    }

    private LDIFChangeRecord readChangeRecordInternal(boolean bl) throws IOException, LDIFException {
        LDIFChangeRecord lDIFChangeRecord = null;
        while (lDIFChangeRecord == null) {
            UnparsedLDIFRecord unparsedLDIFRecord = this.readUnparsedRecord();
            if (unparsedLDIFRecord.isEOF()) {
                return null;
            }
            lDIFChangeRecord = LDIFReader.decodeChangeRecord(unparsedLDIFRecord, this.relativeBasePath, bl, this.schema);
            Debug.debugLDIFRead(lDIFChangeRecord);
            if (this.changeRecordTranslator == null) continue;
            lDIFChangeRecord = this.changeRecordTranslator.translate(lDIFChangeRecord, unparsedLDIFRecord.getFirstLineNumber());
        }
        return lDIFChangeRecord;
    }

    private UnparsedLDIFRecord readUnparsedRecord() throws IOException, LDIFException {
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(20);
        boolean bl = false;
        long l = this.lineNumberCounter + 1L;
        while (true) {
            String string = this.reader.readLine();
            ++this.lineNumberCounter;
            if (string == null) {
                if (!arrayList.isEmpty()) break;
                return new UnparsedLDIFRecord(new ArrayList(0), this.duplicateValueBehavior, this.trailingSpaceBehavior, this.schema, -1L);
            }
            if (string.length() == 0) {
                bl = false;
                if (!arrayList.isEmpty()) break;
                ++l;
                continue;
            }
            if (string.charAt(0) == ' ') {
                if (bl) continue;
                if (arrayList.isEmpty()) {
                    throw new LDIFException(LDIFMessages.ERR_READ_UNEXPECTED_FIRST_SPACE.get(this.lineNumberCounter), this.lineNumberCounter, false);
                }
                ((StringBuilder)arrayList.get(arrayList.size() - 1)).append(string.substring(1));
                bl = false;
                continue;
            }
            if (string.charAt(0) == '#') {
                bl = true;
                continue;
            }
            if (arrayList.isEmpty() && string.startsWith("version:")) {
                bl = true;
                continue;
            }
            arrayList.add(new StringBuilder(string));
            bl = false;
        }
        return new UnparsedLDIFRecord(arrayList, this.duplicateValueBehavior, this.trailingSpaceBehavior, this.schema, l);
    }

    public static Entry decodeEntry(String ... stringArray) throws LDIFException {
        Entry entry = LDIFReader.decodeEntry(LDIFReader.prepareRecord(DuplicateValueBehavior.STRIP, TrailingSpaceBehavior.REJECT, null, stringArray), DEFAULT_RELATIVE_BASE_PATH);
        Debug.debugLDIFRead(entry);
        return entry;
    }

    public static Entry decodeEntry(boolean bl, Schema schema, String ... stringArray) throws LDIFException {
        return LDIFReader.decodeEntry(bl, TrailingSpaceBehavior.REJECT, schema, stringArray);
    }

    public static Entry decodeEntry(boolean bl, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, String ... stringArray) throws LDIFException {
        Entry entry = LDIFReader.decodeEntry(LDIFReader.prepareRecord(bl ? DuplicateValueBehavior.STRIP : DuplicateValueBehavior.REJECT, trailingSpaceBehavior, schema, stringArray), DEFAULT_RELATIVE_BASE_PATH);
        Debug.debugLDIFRead(entry);
        return entry;
    }

    public static LDIFChangeRecord decodeChangeRecord(String ... stringArray) throws LDIFException {
        return LDIFReader.decodeChangeRecord(false, stringArray);
    }

    public static LDIFChangeRecord decodeChangeRecord(boolean bl, String ... stringArray) throws LDIFException {
        LDIFChangeRecord lDIFChangeRecord = LDIFReader.decodeChangeRecord(LDIFReader.prepareRecord(DuplicateValueBehavior.STRIP, TrailingSpaceBehavior.REJECT, null, stringArray), DEFAULT_RELATIVE_BASE_PATH, bl, null);
        Debug.debugLDIFRead(lDIFChangeRecord);
        return lDIFChangeRecord;
    }

    public static LDIFChangeRecord decodeChangeRecord(boolean bl, Schema schema, boolean bl2, String ... stringArray) throws LDIFException {
        return LDIFReader.decodeChangeRecord(bl, TrailingSpaceBehavior.REJECT, schema, bl2, stringArray);
    }

    public static LDIFChangeRecord decodeChangeRecord(boolean bl, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, boolean bl2, String ... stringArray) throws LDIFException {
        LDIFChangeRecord lDIFChangeRecord = LDIFReader.decodeChangeRecord(LDIFReader.prepareRecord(bl ? DuplicateValueBehavior.STRIP : DuplicateValueBehavior.REJECT, trailingSpaceBehavior, schema, stringArray), DEFAULT_RELATIVE_BASE_PATH, bl2, null);
        Debug.debugLDIFRead(lDIFChangeRecord);
        return lDIFChangeRecord;
    }

    private static UnparsedLDIFRecord prepareRecord(DuplicateValueBehavior duplicateValueBehavior, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, String ... stringArray) throws LDIFException {
        Validator.ensureNotNull(stringArray);
        Validator.ensureFalse(stringArray.length == 0, "LDIFReader.prepareRecord.ldifLines must not be empty.");
        boolean bl = false;
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string.length() == 0 && (n = i + 1) < stringArray.length) {
                if (stringArray[n].length() > 0) {
                    throw new LDIFException(LDIFMessages.ERR_READ_UNEXPECTED_BLANK.get(i), (long)i, true, stringArray, null);
                }
                if (arrayList.isEmpty()) {
                    throw new LDIFException(LDIFMessages.ERR_READ_ONLY_BLANKS.get(), 0L, true, stringArray, null);
                }
                return new UnparsedLDIFRecord(arrayList, duplicateValueBehavior, trailingSpaceBehavior, schema, 0L);
            }
            if (string.charAt(0) == ' ') {
                if (i > 0) {
                    if (bl) continue;
                    ((StringBuilder)arrayList.get(arrayList.size() - 1)).append(string.substring(1));
                    continue;
                }
                throw new LDIFException(LDIFMessages.ERR_READ_UNEXPECTED_FIRST_SPACE_NO_NUMBER.get(), 0L, true, stringArray, null);
            }
            if (string.charAt(0) == '#') {
                bl = true;
                continue;
            }
            arrayList.add(new StringBuilder(string));
            bl = false;
        }
        if (arrayList.isEmpty()) {
            throw new LDIFException(LDIFMessages.ERR_READ_NO_DATA.get(), 0L, true, stringArray, null);
        }
        return new UnparsedLDIFRecord(arrayList, duplicateValueBehavior, trailingSpaceBehavior, schema, 0L);
    }

    private static LDIFRecord decodeRecord(UnparsedLDIFRecord unparsedLDIFRecord, String string, Schema schema) throws LDIFException {
        String string2;
        Exception exception = unparsedLDIFRecord.getFailureCause();
        if (exception != null) {
            if (exception instanceof LDIFException) {
                LDIFException lDIFException = (LDIFException)exception;
                throw new LDIFException(lDIFException.getMessage(), lDIFException.getLineNumber(), lDIFException.mayContinueReading(), lDIFException.getDataLines(), lDIFException.getCause());
            }
            throw new LDIFException(StaticUtils.getExceptionMessage(exception), -1L, true, exception);
        }
        if (unparsedLDIFRecord.isEOF()) {
            return null;
        }
        ArrayList arrayList = unparsedLDIFRecord.getLineList();
        if (unparsedLDIFRecord.getLineList() == null) {
            return null;
        }
        LDIFRecord lDIFRecord = arrayList.size() == 1 ? LDIFReader.decodeEntry(unparsedLDIFRecord, string) : ((string2 = StaticUtils.toLowerCase(((StringBuilder)arrayList.get(1)).toString())).startsWith("control:") || string2.startsWith("changetype:") ? LDIFReader.decodeChangeRecord(unparsedLDIFRecord, string, true, schema) : LDIFReader.decodeEntry(unparsedLDIFRecord, string));
        Debug.debugLDIFRead(lDIFRecord);
        return lDIFRecord;
    }

    private static Entry decodeEntry(UnparsedLDIFRecord unparsedLDIFRecord, String string) throws LDIFException {
        String string2;
        ArrayList arrayList = unparsedLDIFRecord.getLineList();
        long l = unparsedLDIFRecord.getFirstLineNumber();
        Iterator<StringBuilder> iterator = arrayList.iterator();
        StringBuilder stringBuilder = (StringBuilder)iterator.next();
        LDIFReader.handleTrailingSpaces(stringBuilder, null, l, unparsedLDIFRecord.getTrailingSpaceBehavior());
        int n = stringBuilder.indexOf(":");
        if (n > 0 && stringBuilder.substring(0, n).equalsIgnoreCase("version")) {
            stringBuilder = (StringBuilder)iterator.next();
            LDIFReader.handleTrailingSpaces(stringBuilder, null, l, unparsedLDIFRecord.getTrailingSpaceBehavior());
        }
        if ((n = stringBuilder.indexOf(":")) < 0 || !stringBuilder.substring(0, n).equalsIgnoreCase("dn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_DN_LINE_DOESNT_START_WITH_DN.get(l), l, true, arrayList, null);
        }
        int n2 = stringBuilder.length();
        if (n2 == n + 1) {
            string2 = "";
        } else if (stringBuilder.charAt(n + 1) == ':') {
            int n3;
            for (n3 = n + 2; n3 < n2 && stringBuilder.charAt(n3) == ' '; ++n3) {
            }
            try {
                byte[] byArray = Base64.decode(stringBuilder.substring(n3));
                string2 = new String(byArray, "UTF-8");
            }
            catch (ParseException parseException) {
                Debug.debugException(parseException);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_DN.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_DN.get(l, exception), l, true, arrayList, (Throwable)exception);
            }
        } else {
            int n4;
            for (n4 = n + 1; n4 < n2 && stringBuilder.charAt(n4) == ' '; ++n4) {
            }
            string2 = stringBuilder.substring(n4);
        }
        if (!iterator.hasNext()) {
            return new Entry(string2, unparsedLDIFRecord.getSchema());
        }
        return new Entry(string2, unparsedLDIFRecord.getSchema(), LDIFReader.parseAttributes(string2, unparsedLDIFRecord.getDuplicateValueBehavior(), unparsedLDIFRecord.getTrailingSpaceBehavior(), unparsedLDIFRecord.getSchema(), arrayList, iterator, string, l));
    }

    private static LDIFChangeRecord decodeChangeRecord(UnparsedLDIFRecord unparsedLDIFRecord, String string, boolean bl, Schema schema) throws LDIFException {
        String string2;
        Object object;
        int n;
        String string3;
        ArrayList arrayList = unparsedLDIFRecord.getLineList();
        long l = unparsedLDIFRecord.getFirstLineNumber();
        Iterator<StringBuilder> iterator = arrayList.iterator();
        StringBuilder stringBuilder = (StringBuilder)iterator.next();
        LDIFReader.handleTrailingSpaces(stringBuilder, null, l, unparsedLDIFRecord.getTrailingSpaceBehavior());
        int n2 = stringBuilder.indexOf(":");
        int n3 = 1;
        if (n2 > 0 && stringBuilder.substring(0, n2).equalsIgnoreCase("version")) {
            stringBuilder = (StringBuilder)iterator.next();
            ++n3;
            LDIFReader.handleTrailingSpaces(stringBuilder, null, l, unparsedLDIFRecord.getTrailingSpaceBehavior());
        }
        if ((n2 = stringBuilder.indexOf(":")) < 0 || !stringBuilder.substring(0, n2).equalsIgnoreCase("dn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_DN_LINE_DOESNT_START_WITH_DN.get(l), l, true, arrayList, null);
        }
        int n4 = stringBuilder.length();
        if (n4 == n2 + 1) {
            string3 = "";
        } else if (stringBuilder.charAt(n2 + 1) == ':') {
            for (n = n2 + 2; n < n4 && stringBuilder.charAt(n) == ' '; ++n) {
            }
            try {
                object = Base64.decode(stringBuilder.substring(n));
                string3 = new String((byte[])object, "UTF-8");
            }
            catch (ParseException parseException) {
                Debug.debugException(parseException);
                throw new LDIFException(LDIFMessages.ERR_READ_CR_CANNOT_BASE64_DECODE_DN.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDIFException(LDIFMessages.ERR_READ_CR_CANNOT_BASE64_DECODE_DN.get(l, exception), l, true, arrayList, (Throwable)exception);
            }
        } else {
            for (n = n2 + 1; n < n4 && stringBuilder.charAt(n) == ' '; ++n) {
            }
            string3 = stringBuilder.substring(n);
        }
        if (!iterator.hasNext()) {
            throw new LDIFException(LDIFMessages.ERR_READ_CR_TOO_SHORT.get(l), l, true, arrayList, null);
        }
        String string4 = null;
        object = null;
        while (true) {
            stringBuilder = (StringBuilder)iterator.next();
            LDIFReader.handleTrailingSpaces(stringBuilder, string3, l, unparsedLDIFRecord.getTrailingSpaceBehavior());
            n2 = stringBuilder.indexOf(":");
            if (n2 < 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_CR_SECOND_LINE_MISSING_COLON.get(l), l, true, arrayList, null);
            }
            string2 = StaticUtils.toLowerCase(stringBuilder.substring(0, n2));
            if (string2.equals("control")) {
                if (object == null) {
                    object = new ArrayList(5);
                }
            } else {
                if (string2.equals("changetype")) {
                    string4 = LDIFReader.decodeChangeType(stringBuilder, n2, l, arrayList);
                    break;
                }
                if (bl) {
                    string4 = "add";
                    iterator = arrayList.iterator();
                    for (int i = 0; i < n3; ++i) {
                        iterator.next();
                    }
                    break;
                }
                throw new LDIFException(LDIFMessages.ERR_READ_CR_CT_LINE_DOESNT_START_WITH_CONTROL_OR_CT.get(l), l, true, arrayList, null);
            }
            object.add(LDIFReader.decodeControl(stringBuilder, n2, l, arrayList, string));
            ++n3;
        }
        string2 = StaticUtils.toLowerCase(string4);
        if (string2.equals("add")) {
            if (iterator.hasNext()) {
                ArrayList<Attribute> arrayList2 = LDIFReader.parseAttributes(string3, unparsedLDIFRecord.getDuplicateValueBehavior(), unparsedLDIFRecord.getTrailingSpaceBehavior(), unparsedLDIFRecord.getSchema(), arrayList, iterator, string, l);
                Attribute[] attributeArray = new Attribute[arrayList2.size()];
                Iterator iterator2 = arrayList2.iterator();
                for (int i = 0; i < attributeArray.length; ++i) {
                    attributeArray[i] = (Attribute)iterator2.next();
                }
                return new LDIFAddChangeRecord(string3, attributeArray, (List<Control>)object);
            }
            throw new LDIFException(LDIFMessages.ERR_READ_CR_NO_ATTRIBUTES.get(l), l, true, arrayList, null);
        }
        if (string2.equals("delete")) {
            if (iterator.hasNext()) {
                throw new LDIFException(LDIFMessages.ERR_READ_CR_EXTRA_DELETE_DATA.get(l), l, true, arrayList, null);
            }
            return new LDIFDeleteChangeRecord(string3, (List<Control>)object);
        }
        if (string2.equals("modify")) {
            if (iterator.hasNext()) {
                Modification[] modificationArray = LDIFReader.parseModifications(string3, unparsedLDIFRecord.getTrailingSpaceBehavior(), arrayList, iterator, l, schema);
                return new LDIFModifyChangeRecord(string3, modificationArray, (List<Control>)object);
            }
            throw new LDIFException(LDIFMessages.ERR_READ_CR_NO_MODS.get(l), l, true, arrayList, null);
        }
        if (string2.equals("moddn") || string2.equals("modrdn")) {
            if (iterator.hasNext()) {
                return LDIFReader.parseModifyDNChangeRecord(arrayList, iterator, string3, (List<Control>)object, unparsedLDIFRecord.getTrailingSpaceBehavior(), l);
            }
            throw new LDIFException(LDIFMessages.ERR_READ_CR_NO_NEWRDN.get(l), l, true, arrayList, null);
        }
        throw new LDIFException(LDIFMessages.ERR_READ_CR_INVALID_CT.get(string4, l), l, true, arrayList, null);
    }

    private static Control decodeControl(StringBuilder stringBuilder, int n, long l, ArrayList<StringBuilder> arrayList, String string) throws LDIFException {
        ASN1OctetString aSN1OctetString;
        String string2;
        int c;
        int n2;
        String string3;
        int n3;
        int n4 = stringBuilder.length();
        if (n4 == n + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_NO_CONTROL_VALUE.get(l), l, true, arrayList, null);
        }
        if (stringBuilder.charAt(n + 1) == ':') {
            for (n3 = n + 2; n3 < n4 && stringBuilder.charAt(n3) == ' '; ++n3) {
            }
            try {
                byte[] byArray = Base64.decode(stringBuilder.substring(n3));
                string3 = new String(byArray, "UTF-8");
            }
            catch (ParseException parseException) {
                Debug.debugException(parseException);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CONTROL.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CONTROL.get(l, exception), l, true, arrayList, (Throwable)exception);
            }
        } else {
            for (n3 = n + 1; n3 < n4 && stringBuilder.charAt(n3) == ' '; ++n3) {
            }
            string3 = stringBuilder.substring(n3);
        }
        if (string3.length() == 0) {
            throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_NO_CONTROL_VALUE.get(l), l, true, arrayList, null);
        }
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        n4 = string3.length();
        for (n2 = 0; n2 < n4; ++n2) {
            c = string3.charAt(n2);
            if (c == 58) {
                string4 = string3.substring(0, n2++);
                bl2 = true;
                break;
            }
            if (c != 32) continue;
            string4 = string3.substring(0, n2++);
            bl = true;
            break;
        }
        if (string4 == null) {
            return new Control(string3, false);
        }
        if (bl) {
            while (string3.charAt(n2) == ' ') {
                ++n2;
            }
            int n5 = n2;
            while (n2 < n4) {
                char c2 = string3.charAt(n2);
                if (c2 == ':') {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if ((string2 = StaticUtils.toLowerCase(string3.substring(n5, n2))).equals("true")) {
                c = 1;
            } else if (string2.equals("false")) {
                c = 0;
            } else {
                throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_INVALID_CRITICALITY.get(string2, l), l, true, arrayList, null);
            }
            if (bl2) {
                ++n2;
            }
        } else {
            c = 0;
        }
        if (bl2) {
            switch (string3.charAt(n2)) {
                case ':': {
                    try {
                        if (string3.length() == n2 + 1) {
                            aSN1OctetString = new ASN1OctetString();
                            break;
                        }
                        if (string3.charAt(n2 + 1) == ' ') {
                            aSN1OctetString = new ASN1OctetString(Base64.decode(string3.substring(n2 + 2)));
                            break;
                        }
                        aSN1OctetString = new ASN1OctetString(Base64.decode(string3.substring(n2 + 1)));
                        break;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_CANNOT_BASE64_DECODE_VALUE.get(l, StaticUtils.getExceptionMessage(exception)), l, true, arrayList, (Throwable)exception);
                    }
                }
                case '<': {
                    try {
                        string2 = string3.charAt(n2 + 1) == ' ' ? string3.substring(n2 + 2) : string3.substring(n2 + 1);
                        aSN1OctetString = new ASN1OctetString(LDIFReader.retrieveURLBytes(string2, string, l));
                        break;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_CANNOT_RETRIEVE_VALUE_FROM_URL.get(l, StaticUtils.getExceptionMessage(exception)), l, true, arrayList, (Throwable)exception);
                    }
                }
                case ' ': {
                    aSN1OctetString = new ASN1OctetString(string3.substring(n2 + 1));
                    break;
                }
                default: {
                    aSN1OctetString = new ASN1OctetString(string3.substring(n2));
                    break;
                }
            }
        } else {
            aSN1OctetString = null;
        }
        return new Control(string4, c != 0, aSN1OctetString);
    }

    private static String decodeChangeType(StringBuilder stringBuilder, int n, long l, ArrayList<StringBuilder> arrayList) throws LDIFException {
        int n2;
        int n3 = stringBuilder.length();
        if (n3 == n + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_CT_LINE_NO_CT_VALUE.get(l), l, true, arrayList, null);
        }
        if (stringBuilder.charAt(n + 1) == ':') {
            int n4;
            for (n4 = n + 2; n4 < n3 && stringBuilder.charAt(n4) == ' '; ++n4) {
            }
            try {
                byte[] byArray = Base64.decode(stringBuilder.substring(n4));
                return new String(byArray, "UTF-8");
            }
            catch (ParseException parseException) {
                Debug.debugException(parseException);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CT.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CT.get(l, exception), l, true, arrayList, (Throwable)exception);
            }
        }
        for (n2 = n + 1; n2 < n3 && stringBuilder.charAt(n2) == ' '; ++n2) {
        }
        return stringBuilder.substring(n2);
    }

    private static ArrayList<Attribute> parseAttributes(String string, DuplicateValueBehavior duplicateValueBehavior, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, ArrayList<StringBuilder> arrayList, Iterator<StringBuilder> iterator, String string2, long l) throws LDIFException {
        Serializable serializable;
        LinkedHashMap<String, Serializable> linkedHashMap = new LinkedHashMap<String, Serializable>(arrayList.size());
        while (iterator.hasNext()) {
            Object object;
            int n;
            LDIFAttribute lDIFAttribute;
            Attribute attribute;
            serializable = iterator.next();
            LDIFReader.handleTrailingSpaces((StringBuilder)serializable, string, l, trailingSpaceBehavior);
            int n2 = ((StringBuilder)serializable).indexOf(":");
            if (n2 <= 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_NO_ATTR_COLON.get(l), l, true, arrayList, null);
            }
            Object object2 = ((StringBuilder)serializable).substring(0, n2);
            String string3 = StaticUtils.toLowerCase(object2);
            MatchingRule matchingRule = schema == null ? CaseIgnoreStringMatchingRule.getInstance() : MatchingRule.selectEqualityMatchingRule(object2, schema);
            Object v = linkedHashMap.get(string3);
            if (v == null) {
                attribute = null;
                lDIFAttribute = null;
            } else if (v instanceof Attribute) {
                attribute = (Attribute)v;
                lDIFAttribute = new LDIFAttribute(attribute.getName(), matchingRule, attribute.getRawValues()[0]);
                linkedHashMap.put(string3, lDIFAttribute);
            } else {
                attribute = null;
                lDIFAttribute = (LDIFAttribute)v;
            }
            int n3 = ((StringBuilder)serializable).length();
            if (n3 == n2 + 1) {
                if (v == null) {
                    attribute = new Attribute((String)object2, matchingRule, "");
                    linkedHashMap.put(string3, attribute);
                    continue;
                }
                try {
                    if (lDIFAttribute.addValue(new ASN1OctetString(), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                    throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(string, l, object2), l, true, arrayList, null);
                }
                catch (LDAPException lDAPException) {
                    throw new LDIFException(LDIFMessages.ERR_READ_VALUE_SYNTAX_VIOLATION.get(string, l, object2, StaticUtils.getExceptionMessage(lDAPException)), l, true, arrayList, (Throwable)lDAPException);
                }
            }
            if (((StringBuilder)serializable).charAt(n2 + 1) == ':') {
                for (n = n2 + 2; n < n3 && ((StringBuilder)serializable).charAt(n) == ' '; ++n) {
                }
                try {
                    object = Base64.decode(((StringBuilder)serializable).substring(n));
                    if (v == null) {
                        attribute = new Attribute((String)object2, matchingRule, (byte[])object);
                        linkedHashMap.put(string3, attribute);
                        continue;
                    }
                    try {
                        if (lDIFAttribute.addValue(new ASN1OctetString((byte[])object), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                        throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(string, l, object2), l, true, arrayList, null);
                    }
                    catch (LDAPException lDAPException) {
                        throw new LDIFException(LDIFMessages.ERR_READ_VALUE_SYNTAX_VIOLATION.get(string, l, object2, StaticUtils.getExceptionMessage(lDAPException)), l, true, arrayList, (Throwable)lDAPException);
                    }
                }
                catch (ParseException parseException) {
                    Debug.debugException(parseException);
                    throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_ATTR.get(object2, l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
                }
            }
            if (((StringBuilder)serializable).charAt(n2 + 1) == '<') {
                for (n = n2 + 2; n < n3 && ((StringBuilder)serializable).charAt(n) == ' '; ++n) {
                }
                String string4 = ((StringBuilder)serializable).substring(n);
                try {
                    object = LDIFReader.retrieveURLBytes(string4, string2, l);
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    throw new LDIFException(LDIFMessages.ERR_READ_URL_EXCEPTION.get(object2, string4, l, exception), l, true, arrayList, (Throwable)exception);
                }
                if (v == null) {
                    attribute = new Attribute((String)object2, matchingRule, (byte[])object);
                    linkedHashMap.put(string3, attribute);
                    continue;
                }
                try {
                    if (lDIFAttribute.addValue(new ASN1OctetString((byte[])object), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                    throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(string, l, object2), l, true, arrayList, null);
                }
                catch (LDIFException lDIFException) {
                    Debug.debugException(lDIFException);
                    throw lDIFException;
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    throw new LDIFException(LDIFMessages.ERR_READ_URL_EXCEPTION.get(object2, string4, l, exception), l, true, arrayList, (Throwable)exception);
                }
            }
            for (n = n2 + 1; n < n3 && ((StringBuilder)serializable).charAt(n) == ' '; ++n) {
            }
            object = ((StringBuilder)serializable).substring(n);
            if (v == null) {
                attribute = new Attribute((String)object2, matchingRule, (String)object);
                linkedHashMap.put(string3, attribute);
                continue;
            }
            try {
                if (lDIFAttribute.addValue(new ASN1OctetString((String)object), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(string, l, object2), l, true, arrayList, null);
            }
            catch (LDAPException lDAPException) {
                throw new LDIFException(LDIFMessages.ERR_READ_VALUE_SYNTAX_VIOLATION.get(string, l, object2, StaticUtils.getExceptionMessage(lDAPException)), l, true, arrayList, (Throwable)lDAPException);
            }
        }
        serializable = new ArrayList(linkedHashMap.size());
        for (Object object2 : linkedHashMap.values()) {
            if (object2 instanceof Attribute) {
                ((ArrayList)serializable).add((Attribute)object2);
                continue;
            }
            ((ArrayList)serializable).add(((LDIFAttribute)object2).toAttribute());
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] retrieveURLBytes(String string, String string2, long l) throws LDIFException, IOException {
        String string3;
        String string4 = StaticUtils.toLowerCase(string);
        if (string4.startsWith("file:/")) {
            int n;
            for (n = 6; n < string.length() && string.charAt(n) == '/'; ++n) {
            }
            string3 = string.substring(n - 1);
        } else if (string4.startsWith("file:")) {
            string3 = string2 + string.substring(5);
        } else {
            throw new LDIFException(LDIFMessages.ERR_READ_URL_INVALID_SCHEME.get(string), l, true);
        }
        File file = new File(string3);
        if (!file.exists()) {
            throw new LDIFException(LDIFMessages.ERR_READ_URL_NO_SUCH_FILE.get(string, file.getAbsolutePath()), l, true);
        }
        long l2 = file.length();
        if (l2 > 0xA00000L) {
            throw new LDIFException(LDIFMessages.ERR_READ_URL_FILE_TOO_LARGE.get(string, file.getAbsolutePath(), 0xA00000), l, true);
        }
        int n = (int)l2;
        byte[] byArray = new byte[(int)l2];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = fileInputStream.read(byArray, n2, n);
                if (n3 < 0) {
                    throw new LDIFException(LDIFMessages.ERR_READ_URL_FILE_SIZE_CHANGED.get(string, file.getAbsolutePath()), l, true);
                }
                n2 += n3;
                n -= n3;
            }
            if (fileInputStream.read() != -1) {
                throw new LDIFException(LDIFMessages.ERR_READ_URL_FILE_SIZE_CHANGED.get(string, file.getAbsolutePath()), l, true);
            }
        }
        finally {
            fileInputStream.close();
        }
        return byArray;
    }

    private static Modification[] parseModifications(String string, TrailingSpaceBehavior trailingSpaceBehavior, ArrayList<StringBuilder> arrayList, Iterator<StringBuilder> iterator, long l, Schema schema) throws LDIFException {
        Object object;
        ArrayList<Modification> arrayList2 = new ArrayList<Modification>(arrayList.size());
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            int n;
            ModificationType modificationType;
            object = iterator.next();
            LDIFReader.handleTrailingSpaces((StringBuilder)object, string, l, trailingSpaceBehavior);
            int n2 = ((StringBuilder)object).indexOf(":");
            if (n2 < 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_NO_MODTYPE.get(l), l, true, arrayList, null);
            }
            String string2 = StaticUtils.toLowerCase(((StringBuilder)object).substring(0, n2));
            if (string2.equals("add")) {
                modificationType = ModificationType.ADD;
            } else if (string2.equals("delete")) {
                modificationType = ModificationType.DELETE;
            } else if (string2.equals("replace")) {
                modificationType = ModificationType.REPLACE;
            } else if (string2.equals("increment")) {
                modificationType = ModificationType.INCREMENT;
            } else {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_INVALID_MODTYPE.get(string2, l), l, true, arrayList, null);
            }
            int n3 = ((StringBuilder)object).length();
            if (n3 == n2 + 1) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_NO_ATTR.get(l), l, true, arrayList, null);
            }
            if (((StringBuilder)object).charAt(n2 + 1) == ':') {
                for (n = n2 + 2; n < n3 && ((StringBuilder)object).charAt(n) == ' '; ++n) {
                }
                try {
                    object3 = Base64.decode(((StringBuilder)object).substring(n));
                    object2 = new String((byte[])object3, "UTF-8");
                }
                catch (ParseException parseException) {
                    Debug.debugException(parseException);
                    throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_CANNOT_BASE64_DECODE_ATTR.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_CANNOT_BASE64_DECODE_ATTR.get(l, exception), l, true, arrayList, (Throwable)exception);
                }
            } else {
                for (n = n2 + 1; n < n3 && ((StringBuilder)object).charAt(n) == ' '; ++n) {
                }
                object2 = ((StringBuilder)object).substring(n);
            }
            if (((String)object2).length() == 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_NO_ATTR.get(l), l, true, arrayList, null);
            }
            ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>(arrayList.size());
            while (iterator.hasNext()) {
                int n4;
                object = iterator.next();
                LDIFReader.handleTrailingSpaces((StringBuilder)object, string, l, trailingSpaceBehavior);
                if (((StringBuilder)object).toString().equals("-")) break;
                n2 = ((StringBuilder)object).indexOf(":");
                if (n2 < 0) {
                    throw new LDIFException(LDIFMessages.ERR_READ_NO_ATTR_COLON.get(l), l, true, arrayList, null);
                }
                if (!((StringBuilder)object).substring(0, n2).equalsIgnoreCase((String)object2)) {
                    Object object4;
                    Serializable serializable;
                    Object object5;
                    object3 = ((StringBuilder)object).substring(0, n2);
                    n4 = 0;
                    String string3 = Attribute.getBaseName((String)object2);
                    String string4 = Attribute.getBaseName((String)object3);
                    if (string4.equalsIgnoreCase(string3)) {
                        n4 = 1;
                    } else if (schema != null) {
                        object5 = schema.getAttributeType(string3);
                        serializable = schema.getAttributeType(string4);
                        if (object5 != null && serializable != null && ((AttributeTypeDefinition)object5).equals(serializable)) {
                            n4 = 1;
                        }
                    }
                    object5 = Attribute.getOptions((String)object2);
                    serializable = new HashSet(object5.size());
                    Object object6 = object5.iterator();
                    while (object6.hasNext()) {
                        object4 = (String)object6.next();
                        serializable.add(StaticUtils.toLowerCase((String)object4));
                    }
                    object6 = Attribute.getOptions((String)object3);
                    object4 = new HashSet(object6.size());
                    Iterator iterator2 = object6.iterator();
                    while (iterator2.hasNext()) {
                        String string5 = (String)iterator2.next();
                        object4.add(StaticUtils.toLowerCase(string5));
                    }
                    boolean bl = object4.equals(serializable);
                    if (n4 == 0 || !bl) {
                        if (arrayList3.isEmpty() && n4 != 0 && object4.remove("binary") && object4.equals(serializable)) {
                            object2 = object3;
                        } else {
                            throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_ATTR_MISMATCH.get(l, ((StringBuilder)object).substring(0, n2), object2), l, true, arrayList, null);
                        }
                    }
                }
                if ((n3 = ((StringBuilder)object).length()) == n2 + 1) {
                    object3 = new ASN1OctetString();
                } else if (((StringBuilder)object).charAt(n2 + 1) == ':') {
                    for (n4 = n2 + 2; n4 < n3 && ((StringBuilder)object).charAt(n4) == ' '; ++n4) {
                    }
                    try {
                        object3 = new ASN1OctetString(Base64.decode(((StringBuilder)object).substring(n4)));
                    }
                    catch (ParseException parseException) {
                        Debug.debugException(parseException);
                        throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_ATTR.get(object2, l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_ATTR.get(l, exception), l, true, arrayList, (Throwable)exception);
                    }
                } else {
                    for (n4 = n2 + 1; n4 < n3 && ((StringBuilder)object).charAt(n4) == ' '; ++n4) {
                    }
                    object3 = new ASN1OctetString(((StringBuilder)object).substring(n4));
                }
                arrayList3.add((byte[])object3);
            }
            object3 = new ASN1OctetString[arrayList3.size()];
            arrayList3.toArray((T[])object3);
            if (modificationType.intValue() == ModificationType.ADD.intValue() && ((byte[])object3).length == 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_NO_ADD_VALUES.get(object2, l), l, true, arrayList, null);
            }
            if (modificationType.intValue() == ModificationType.INCREMENT.intValue() && ((byte[])object3).length != 1) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_INVALID_INCR_VALUE_COUNT.get(l, object2), l, true, arrayList, null);
            }
            arrayList2.add(new Modification(modificationType, (String)object2, (ASN1OctetString[])object3));
        }
        object = new Modification[arrayList2.size()];
        arrayList2.toArray((T[])object);
        return object;
    }

    private static LDIFModifyDNChangeRecord parseModifyDNChangeRecord(ArrayList<StringBuilder> arrayList, Iterator<StringBuilder> iterator, String string, List<Control> list, TrailingSpaceBehavior trailingSpaceBehavior, long l) throws LDIFException {
        String string2;
        Object object;
        int n;
        String string3;
        int n2;
        StringBuilder stringBuilder = iterator.next();
        LDIFReader.handleTrailingSpaces(stringBuilder, string, l, trailingSpaceBehavior);
        int n3 = stringBuilder.indexOf(":");
        if (n3 < 0 || !stringBuilder.substring(0, n3).equalsIgnoreCase("newrdn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWRDN_COLON.get(l), l, true, arrayList, null);
        }
        int n4 = stringBuilder.length();
        if (n4 == n3 + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWRDN_VALUE.get(l), l, true, arrayList, null);
        }
        if (stringBuilder.charAt(n3 + 1) == ':') {
            for (n2 = n3 + 2; n2 < n4 && stringBuilder.charAt(n2) == ' '; ++n2) {
            }
            try {
                byte[] byArray = Base64.decode(stringBuilder.substring(n2));
                string3 = new String(byArray, "UTF-8");
            }
            catch (ParseException parseException) {
                Debug.debugException(parseException);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWRDN.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWRDN.get(l, exception), l, true, arrayList, (Throwable)exception);
            }
        } else {
            for (n2 = n3 + 1; n2 < n4 && stringBuilder.charAt(n2) == ' '; ++n2) {
            }
            string3 = stringBuilder.substring(n2);
        }
        if (string3.length() == 0) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWRDN_VALUE.get(l), l, true, arrayList, null);
        }
        if (!iterator.hasNext()) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_DELOLDRDN_COLON.get(l), l, true, arrayList, null);
        }
        stringBuilder = iterator.next();
        LDIFReader.handleTrailingSpaces(stringBuilder, string, l, trailingSpaceBehavior);
        n3 = stringBuilder.indexOf(":");
        if (n3 < 0 || !stringBuilder.substring(0, n3).equalsIgnoreCase("deleteoldrdn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_DELOLDRDN_COLON.get(l), l, true, arrayList, null);
        }
        n4 = stringBuilder.length();
        if (n4 == n3 + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_DELOLDRDN_VALUE.get(l), l, true, arrayList, null);
        }
        if (stringBuilder.charAt(n3 + 1) == ':') {
            for (n = n3 + 2; n < n4 && stringBuilder.charAt(n) == ' '; n += 1) {
            }
            try {
                object = Base64.decode(stringBuilder.substring(n));
                string2 = new String((byte[])object, "UTF-8");
            }
            catch (ParseException parseException) {
                Debug.debugException(parseException);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_DELOLDRDN.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_DELOLDRDN.get(l, exception), l, true, arrayList, (Throwable)exception);
            }
        } else {
            for (n = n3 + 1; n < n4 && stringBuilder.charAt(n) == ' '; n += 1) {
            }
            string2 = stringBuilder.substring(n);
        }
        if (string2.equals("0")) {
            n = 0;
        } else if (string2.equals("1")) {
            n = 1;
        } else if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no")) {
            n = 0;
        } else if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes")) {
            n = 0;
        } else {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_INVALID_DELOLDRDN.get(string2, l), l, true, arrayList, null);
        }
        if (iterator.hasNext()) {
            stringBuilder = iterator.next();
            LDIFReader.handleTrailingSpaces(stringBuilder, string, l, trailingSpaceBehavior);
            n3 = stringBuilder.indexOf(":");
            if (n3 < 0 || !stringBuilder.substring(0, n3).equalsIgnoreCase("newsuperior")) {
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWSUPERIOR_COLON.get(l), l, true, arrayList, null);
            }
            n4 = stringBuilder.length();
            if (n4 == n3 + 1) {
                object = "";
            } else if (stringBuilder.charAt(n3 + 1) == ':') {
                int n5;
                for (n5 = n3 + 2; n5 < n4 && stringBuilder.charAt(n5) == ' '; ++n5) {
                }
                try {
                    byte[] byArray = Base64.decode(stringBuilder.substring(n5));
                    object = new String(byArray, "UTF-8");
                }
                catch (ParseException parseException) {
                    Debug.debugException(parseException);
                    throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWSUPERIOR.get(l, parseException.getMessage()), l, true, arrayList, (Throwable)parseException);
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWSUPERIOR.get(l, exception), l, true, arrayList, (Throwable)exception);
                }
            } else {
                int n6;
                for (n6 = n3 + 1; n6 < n4 && stringBuilder.charAt(n6) == ' '; ++n6) {
                }
                object = stringBuilder.substring(n6);
            }
        } else {
            object = null;
        }
        if (iterator.hasNext()) {
            throw new LDIFException(LDIFMessages.ERR_READ_CR_EXTRA_MODDN_DATA.get(l), l, true, arrayList, null);
        }
        return new LDIFModifyDNChangeRecord(string, string3, n != 0, (String)object, list);
    }

    private static void handleTrailingSpaces(StringBuilder stringBuilder, String string, long l, TrailingSpaceBehavior trailingSpaceBehavior) throws LDIFException {
        int n;
        boolean bl = false;
        for (n = stringBuilder.length() - 1; n >= 0 && stringBuilder.charAt(n) == ' '; --n) {
            bl = true;
        }
        if (bl && stringBuilder.charAt(n) != ':') {
            switch (trailingSpaceBehavior) {
                case STRIP: {
                    stringBuilder.setLength(n + 1);
                    break;
                }
                case REJECT: {
                    if (string == null) {
                        throw new LDIFException(LDIFMessages.ERR_READ_ILLEGAL_TRAILING_SPACE_WITHOUT_DN.get(l, stringBuilder.toString()), l, true);
                    }
                    throw new LDIFException(LDIFMessages.ERR_READ_ILLEGAL_TRAILING_SPACE_WITH_DN.get(string, l, stringBuilder.toString()), l, true);
                }
            }
        }
    }

    static {
        String string = System.getProperty("user.dir");
        File file = string == null ? new File(".") : new File(string);
        String string2 = file.getAbsolutePath();
        DEFAULT_RELATIVE_BASE_PATH = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RecordParser
    implements Processor<UnparsedLDIFRecord, LDIFRecord> {
        private RecordParser() {
        }

        @Override
        public LDIFRecord process(UnparsedLDIFRecord unparsedLDIFRecord) throws LDIFException {
            LDIFRecord lDIFRecord = LDIFReader.decodeRecord(unparsedLDIFRecord, LDIFReader.this.relativeBasePath, LDIFReader.this.schema);
            if (lDIFRecord instanceof Entry && LDIFReader.this.entryTranslator != null && (lDIFRecord = LDIFReader.this.entryTranslator.translate((Entry)lDIFRecord, unparsedLDIFRecord.getFirstLineNumber())) == null) {
                lDIFRecord = SKIP_ENTRY;
            }
            if (lDIFRecord instanceof LDIFChangeRecord && LDIFReader.this.changeRecordTranslator != null && (lDIFRecord = LDIFReader.this.changeRecordTranslator.translate((LDIFChangeRecord)lDIFRecord, unparsedLDIFRecord.getFirstLineNumber())) == null) {
                lDIFRecord = SKIP_ENTRY;
            }
            return lDIFRecord;
        }
    }

    private final class LineReaderThread
    extends Thread {
        private LineReaderThread() {
            super("Asynchronous LDIF line reader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                boolean bl = false;
                while (!bl) {
                    UnparsedLDIFRecord unparsedLDIFRecord = null;
                    try {
                        unparsedLDIFRecord = LDIFReader.this.readUnparsedRecord();
                    }
                    catch (IOException iOException) {
                        Debug.debugException(iOException);
                        unparsedLDIFRecord = new UnparsedLDIFRecord(iOException);
                        bl = true;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        unparsedLDIFRecord = new UnparsedLDIFRecord(exception);
                    }
                    try {
                        LDIFReader.this.asyncParser.submit(unparsedLDIFRecord);
                    }
                    catch (InterruptedException interruptedException) {
                        Debug.debugException(interruptedException);
                        Thread.currentThread().interrupt();
                        bl = true;
                    }
                    if (unparsedLDIFRecord != null && !unparsedLDIFRecord.isEOF()) continue;
                    bl = true;
                }
                return;
            }
            finally {
                try {
                    LDIFReader.this.asyncParser.shutdown();
                }
                catch (InterruptedException interruptedException) {
                    Debug.debugException(interruptedException);
                    Thread.currentThread().interrupt();
                }
                finally {
                    LDIFReader.this.asyncParsingComplete.set(true);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnparsedLDIFRecord {
        private final ArrayList<StringBuilder> lineList;
        private final long firstLineNumber;
        private final Exception failureCause;
        private final boolean isEOF;
        private final DuplicateValueBehavior duplicateValueBehavior;
        private final Schema schema;
        private final TrailingSpaceBehavior trailingSpaceBehavior;

        private UnparsedLDIFRecord(ArrayList<StringBuilder> arrayList, DuplicateValueBehavior duplicateValueBehavior, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, long l) {
            this.lineList = arrayList;
            this.firstLineNumber = l;
            this.duplicateValueBehavior = duplicateValueBehavior;
            this.trailingSpaceBehavior = trailingSpaceBehavior;
            this.schema = schema;
            this.failureCause = null;
            this.isEOF = l < 0L || arrayList != null && arrayList.isEmpty();
        }

        private UnparsedLDIFRecord(Exception exception) {
            this.failureCause = exception;
            this.lineList = null;
            this.firstLineNumber = 0L;
            this.duplicateValueBehavior = DuplicateValueBehavior.REJECT;
            this.trailingSpaceBehavior = TrailingSpaceBehavior.REJECT;
            this.schema = null;
            this.isEOF = false;
        }

        private ArrayList<StringBuilder> getLineList() {
            return this.lineList;
        }

        private DuplicateValueBehavior getDuplicateValueBehavior() {
            return this.duplicateValueBehavior;
        }

        private TrailingSpaceBehavior getTrailingSpaceBehavior() {
            return this.trailingSpaceBehavior;
        }

        private Schema getSchema() {
            return this.schema;
        }

        private long getFirstLineNumber() {
            return this.firstLineNumber;
        }

        private boolean isEOF() {
            return this.isEOF;
        }

        private Exception getFailureCause() {
            return this.failureCause;
        }
    }
}

