/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriterChangeRecordTranslator;
import com.unboundid.ldif.LDIFWriterEntryTranslator;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFWriter
implements Closeable {
    private static volatile boolean commentAboutBase64EncodedValues = false;
    private static final byte[] VERSION_1_HEADER_BYTES = StaticUtils.getBytes("version: 1" + StaticUtils.EOL);
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final BufferedOutputStream writer;
    private final ByteStringBuffer buffer;
    private final LDIFWriterChangeRecordTranslator changeRecordTranslator;
    private final LDIFWriterEntryTranslator entryTranslator;
    private int wrapColumn = 0;
    private int wrapColumnMinusTwo = -2;
    private final ParallelProcessor<LDIFRecord, ByteStringBuffer> toLdifBytesInvoker;

    public LDIFWriter(String string) throws IOException {
        this(new FileOutputStream(string));
    }

    public LDIFWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public LDIFWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public LDIFWriter(OutputStream outputStream, int n) {
        this(outputStream, n, null);
    }

    public LDIFWriter(OutputStream outputStream, int n, LDIFWriterEntryTranslator lDIFWriterEntryTranslator) {
        this(outputStream, n, lDIFWriterEntryTranslator, null);
    }

    public LDIFWriter(OutputStream outputStream, int n, final LDIFWriterEntryTranslator lDIFWriterEntryTranslator, final LDIFWriterChangeRecordTranslator lDIFWriterChangeRecordTranslator) {
        Validator.ensureNotNull(outputStream);
        Validator.ensureTrue(n >= 0, "LDIFWriter.parallelThreads must not be negative.");
        this.entryTranslator = lDIFWriterEntryTranslator;
        this.changeRecordTranslator = lDIFWriterChangeRecordTranslator;
        this.buffer = new ByteStringBuffer();
        this.writer = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 131072);
        if (n == 0) {
            this.toLdifBytesInvoker = null;
        } else {
            LDAPSDKThreadFactory lDAPSDKThreadFactory = new LDAPSDKThreadFactory("LDIFWriter Worker", true, null);
            this.toLdifBytesInvoker = new ParallelProcessor<LDIFRecord, ByteStringBuffer>(new Processor<LDIFRecord, ByteStringBuffer>(){

                @Override
                public ByteStringBuffer process(LDIFRecord lDIFRecord) throws IOException {
                    LDIFRecord lDIFRecord2;
                    if (lDIFWriterEntryTranslator != null && lDIFRecord instanceof Entry) {
                        lDIFRecord2 = lDIFWriterEntryTranslator.translateEntryToWrite((Entry)lDIFRecord);
                        if (lDIFRecord2 == null) {
                            return null;
                        }
                    } else if (lDIFWriterChangeRecordTranslator != null && lDIFRecord instanceof LDIFChangeRecord) {
                        lDIFRecord2 = lDIFWriterChangeRecordTranslator.translateChangeRecordToWrite((LDIFChangeRecord)lDIFRecord);
                        if (lDIFRecord2 == null) {
                            return null;
                        }
                    } else {
                        lDIFRecord2 = lDIFRecord;
                    }
                    ByteStringBuffer byteStringBuffer = new ByteStringBuffer(200);
                    lDIFRecord2.toLDIF(byteStringBuffer, LDIFWriter.this.wrapColumn);
                    return byteStringBuffer;
                }
            }, lDAPSDKThreadFactory, n, 5);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.toLdifBytesInvoker != null) {
                try {
                    this.toLdifBytesInvoker.shutdown();
                }
                catch (InterruptedException interruptedException) {
                    Debug.debugException(interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.writer.close();
        }
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int n) {
        this.wrapColumn = n;
        this.wrapColumnMinusTwo = n - 2;
    }

    public static boolean commentAboutBase64EncodedValues() {
        return commentAboutBase64EncodedValues;
    }

    public static void setCommentAboutBase64EncodedValues(boolean bl) {
        commentAboutBase64EncodedValues = bl;
    }

    public void writeVersionHeader() throws IOException {
        this.writer.write(VERSION_1_HEADER_BYTES);
    }

    public void writeEntry(Entry entry) throws IOException {
        this.writeEntry(entry, null);
    }

    public void writeEntry(Entry entry, String string) throws IOException {
        Entry entry2;
        Validator.ensureNotNull(entry);
        if (this.entryTranslator == null) {
            entry2 = entry;
        } else {
            entry2 = this.entryTranslator.translateEntryToWrite(entry);
            if (entry2 == null) {
                return;
            }
        }
        if (string != null) {
            this.writeComment(string, false, false);
        }
        Debug.debugLDIFWrite(entry2);
        this.writeLDIF(entry2);
    }

    public void writeChangeRecord(LDIFChangeRecord lDIFChangeRecord) throws IOException {
        this.writeChangeRecord(lDIFChangeRecord, null);
    }

    public void writeChangeRecord(LDIFChangeRecord lDIFChangeRecord, String string) throws IOException {
        LDIFChangeRecord lDIFChangeRecord2;
        Validator.ensureNotNull(lDIFChangeRecord);
        if (this.changeRecordTranslator == null) {
            lDIFChangeRecord2 = lDIFChangeRecord;
        } else {
            lDIFChangeRecord2 = this.changeRecordTranslator.translateChangeRecordToWrite(lDIFChangeRecord);
            if (lDIFChangeRecord2 == null) {
                return;
            }
        }
        if (string != null) {
            this.writeComment(string, false, false);
        }
        Debug.debugLDIFWrite(lDIFChangeRecord2);
        this.writeLDIF(lDIFChangeRecord2);
    }

    public void writeLDIFRecord(LDIFRecord lDIFRecord) throws IOException {
        this.writeLDIFRecord(lDIFRecord, null);
    }

    public void writeLDIFRecord(LDIFRecord lDIFRecord, String string) throws IOException {
        LDIFRecord lDIFRecord2;
        Validator.ensureNotNull(lDIFRecord);
        if (this.entryTranslator != null && lDIFRecord instanceof Entry) {
            lDIFRecord2 = this.entryTranslator.translateEntryToWrite((Entry)lDIFRecord);
            if (lDIFRecord2 == null) {
                return;
            }
        } else if (this.changeRecordTranslator != null && lDIFRecord instanceof LDIFChangeRecord) {
            lDIFRecord2 = this.changeRecordTranslator.translateChangeRecordToWrite((LDIFChangeRecord)lDIFRecord);
            if (lDIFRecord2 == null) {
                return;
            }
        } else {
            lDIFRecord2 = lDIFRecord;
        }
        Debug.debugLDIFWrite(lDIFRecord2);
        if (string != null) {
            this.writeComment(string, false, false);
        }
        this.writeLDIF(lDIFRecord2);
    }

    public void writeLDIFRecords(List<? extends LDIFRecord> list) throws IOException, InterruptedException {
        if (this.toLdifBytesInvoker == null) {
            for (LDIFRecord lDIFRecord : list) {
                this.writeLDIFRecord(lDIFRecord);
            }
        } else {
            ArrayList<Result<? extends LDIFRecord, ByteStringBuffer>> arrayList = this.toLdifBytesInvoker.processAll(list);
            for (Result result : arrayList) {
                LDIFWriter.rethrow(result.getFailureCause());
                ByteStringBuffer byteStringBuffer = (ByteStringBuffer)result.getOutput();
                if (byteStringBuffer == null) continue;
                byteStringBuffer.write(this.writer);
                this.writer.write(StaticUtils.EOL_BYTES);
            }
        }
    }

    public void writeComment(String string, boolean bl, boolean bl2) throws IOException {
        Validator.ensureNotNull(string);
        if (bl) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
        if (string.indexOf(10) < 0) {
            this.writeSingleLineComment(string);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\r?\\n")) {
                this.writeSingleLineComment(string2);
            }
        }
        if (bl2) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
    }

    private void writeSingleLineComment(String string) throws IOException {
        int n = this.wrapColumn <= 0 ? StaticUtils.TERMINAL_WIDTH_COLUMNS - 3 : this.wrapColumnMinusTwo;
        this.buffer.clear();
        int n2 = string.length();
        if (n2 <= n) {
            this.buffer.append("# ");
            this.buffer.append(string);
            this.buffer.append(StaticUtils.EOL_BYTES);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                if (n2 - n3 <= n) {
                    this.buffer.append("# ");
                    this.buffer.append(string.substring(n3));
                    this.buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                boolean bl = false;
                for (n5 = n4 = n3 + n; n5 > n3; --n5) {
                    if (string.charAt(n5) != ' ') continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (n5 = n4 + 1; n5 < n2; ++n5) {
                        if (string.charAt(n5) != ' ') continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.buffer.append("# ");
                        this.buffer.append(string.substring(n3));
                        this.buffer.append(StaticUtils.EOL_BYTES);
                        break;
                    }
                }
                this.buffer.append("# ");
                this.buffer.append(string.substring(n3, n5));
                this.buffer.append(StaticUtils.EOL_BYTES);
                for (n3 = n5 + 1; n3 < n2 && string.charAt(n3) == ' '; ++n3) {
                }
            }
        }
        this.buffer.write(this.writer);
    }

    private void writeLDIF(LDIFRecord lDIFRecord) throws IOException {
        this.buffer.clear();
        lDIFRecord.toLDIF(this.buffer, this.wrapColumn);
        this.buffer.append(StaticUtils.EOL_BYTES);
        this.buffer.write(this.writer);
    }

    public static List<String> wrapLines(int n, String ... stringArray) {
        return LDIFWriter.wrapLines(n, Arrays.asList(stringArray));
    }

    public static List<String> wrapLines(int n, List<String> list) {
        if (n <= 2) {
            return new ArrayList<String>(list);
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        block0: for (String string : list) {
            int n2 = string.length();
            if (n2 <= n) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(string.substring(0, n));
            for (int i = n; i < n2; i += n - 1) {
                if (n2 - i + 1 <= n) {
                    arrayList.add(' ' + string.substring(i));
                    continue block0;
                }
                arrayList.add(' ' + string.substring(i, i + n - 1));
            }
        }
        return arrayList;
    }

    public static String encodeNameAndValue(String string, ASN1OctetString aSN1OctetString) {
        StringBuilder stringBuilder = new StringBuilder();
        LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder);
        return stringBuilder.toString();
    }

    public static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, StringBuilder stringBuilder) {
        LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, StringBuilder stringBuilder, int n) {
        int n2;
        boolean bl;
        byte[] byArray;
        int n3;
        block31: {
            int n4;
            block30: {
                int n5;
                block29: {
                    int n6;
                    block28: {
                        int n7;
                        block27: {
                            block25: {
                                String string2;
                                block26: {
                                    n3 = stringBuilder.length();
                                    byArray = aSN1OctetString.getValue();
                                    bl = false;
                                    try {
                                        stringBuilder.append(string);
                                        stringBuilder.append(':');
                                        int n8 = byArray.length;
                                        if (n8 == 0) {
                                            int n9;
                                            stringBuilder.append(' ');
                                            Object var10_8 = null;
                                            if (n <= 2 || (n9 = stringBuilder.length() - n3) <= n) break block25;
                                            string2 = StaticUtils.EOL + ' ';
                                            stringBuilder.insert(n3 + n, string2);
                                            break block26;
                                        }
                                        switch (byArray[0]) {
                                            case 32: 
                                            case 58: 
                                            case 60: {
                                                stringBuilder.append(": ");
                                                Base64.encode(byArray, stringBuilder);
                                                bl = true;
                                                break block27;
                                            }
                                            default: {
                                                if (byArray[n8 - 1] == 32) {
                                                    stringBuilder.append(": ");
                                                    Base64.encode(byArray, stringBuilder);
                                                    bl = true;
                                                    break block28;
                                                }
                                                int n10 = 0;
                                                while (n10 < n8) {
                                                    if ((byArray[n10] & 0x7F) != (byArray[n10] & 0xFF)) {
                                                        stringBuilder.append(": ");
                                                        Base64.encode(byArray, stringBuilder);
                                                        bl = true;
                                                        break block29;
                                                    }
                                                    switch (byArray[n10]) {
                                                        case 0: 
                                                        case 10: 
                                                        case 13: {
                                                            stringBuilder.append(": ");
                                                            Base64.encode(byArray, stringBuilder);
                                                            bl = true;
                                                            break block30;
                                                        }
                                                        default: {
                                                            ++n10;
                                                            break;
                                                        }
                                                    }
                                                }
                                                stringBuilder.append(' ');
                                                stringBuilder.append(aSN1OctetString.stringValue());
                                                break;
                                            }
                                        }
                                        break block31;
                                    }
                                    catch (Throwable throwable) {
                                        int n11;
                                        Object var10_14 = null;
                                        if (n > 2 && (n11 = stringBuilder.length() - n3) > n) {
                                            String string3 = StaticUtils.EOL + ' ';
                                            stringBuilder.insert(n3 + n, string3);
                                            for (int i = n3 + 2 * n + string3.length() - 1; i < stringBuilder.length(); i += n - 1 + string3.length()) {
                                                stringBuilder.insert(i, string3);
                                            }
                                        }
                                        if (!bl) throw throwable;
                                        if (!commentAboutBase64EncodedValues) throw throwable;
                                        LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
                                        throw throwable;
                                    }
                                }
                                for (int i = n3 + 2 * n + string2.length() - 1; i < stringBuilder.length(); i += n - 1 + string2.length()) {
                                    stringBuilder.insert(i, string2);
                                }
                            }
                            if (!bl) return;
                            if (!commentAboutBase64EncodedValues) return;
                            LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
                            return;
                        }
                        Object var10_9 = null;
                        if (n > 2 && (n7 = stringBuilder.length() - n3) > n) {
                            String string4 = StaticUtils.EOL + ' ';
                            stringBuilder.insert(n3 + n, string4);
                            for (int i = n3 + 2 * n + string4.length() - 1; i < stringBuilder.length(); i += n - 1 + string4.length()) {
                                stringBuilder.insert(i, string4);
                            }
                        }
                        if (!bl) return;
                        if (!commentAboutBase64EncodedValues) return;
                        LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
                        return;
                    }
                    Object var10_10 = null;
                    if (n > 2 && (n6 = stringBuilder.length() - n3) > n) {
                        String string5 = StaticUtils.EOL + ' ';
                        stringBuilder.insert(n3 + n, string5);
                        for (int i = n3 + 2 * n + string5.length() - 1; i < stringBuilder.length(); i += n - 1 + string5.length()) {
                            stringBuilder.insert(i, string5);
                        }
                    }
                    if (!bl) return;
                    if (!commentAboutBase64EncodedValues) return;
                    LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
                    return;
                }
                Object var10_11 = null;
                if (n > 2 && (n5 = stringBuilder.length() - n3) > n) {
                    String string6 = StaticUtils.EOL + ' ';
                    stringBuilder.insert(n3 + n, string6);
                    for (int i = n3 + 2 * n + string6.length() - 1; i < stringBuilder.length(); i += n - 1 + string6.length()) {
                        stringBuilder.insert(i, string6);
                    }
                }
                if (!bl) return;
                if (!commentAboutBase64EncodedValues) return;
                LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
                return;
            }
            Object var10_12 = null;
            if (n > 2 && (n4 = stringBuilder.length() - n3) > n) {
                String string7 = StaticUtils.EOL + ' ';
                stringBuilder.insert(n3 + n, string7);
                for (int i = n3 + 2 * n + string7.length() - 1; i < stringBuilder.length(); i += n - 1 + string7.length()) {
                    stringBuilder.insert(i, string7);
                }
            }
            if (!bl) return;
            if (!commentAboutBase64EncodedValues) return;
            LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
            return;
        }
        Object var10_13 = null;
        if (n > 2 && (n2 = stringBuilder.length() - n3) > n) {
            String string8 = StaticUtils.EOL + ' ';
            stringBuilder.insert(n3 + n, string8);
            for (int i = n3 + 2 * n + string8.length() - 1; i < stringBuilder.length(); i += n - 1 + string8.length()) {
                stringBuilder.insert(i, string8);
            }
        }
        if (!bl) return;
        if (!commentAboutBase64EncodedValues) return;
        LDIFWriter.writeBase64DecodedValueComment(byArray, stringBuilder, n);
    }

    private static void writeBase64DecodedValueComment(byte[] byArray, StringBuilder stringBuilder, int n) {
        if (commentAboutBase64EncodedValues) {
            int n2 = n <= 5 ? StaticUtils.TERMINAL_WIDTH_COLUMNS - 3 : n - 2;
            int n3 = n2 - 1;
            boolean bl = true;
            String string = "Non-base64-encoded representation of the above value: " + LDIFWriter.getEscapedValue(byArray);
            for (String string2 : StaticUtils.wrapLine(string, n2, n3)) {
                stringBuilder.append(StaticUtils.EOL);
                stringBuilder.append("# ");
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, ByteStringBuffer byteStringBuffer, int n) {
        boolean bl;
        block7: {
            int n2 = byteStringBuffer.length();
            bl = false;
            try {
                int n3;
                byteStringBuffer.append(string);
                bl = LDIFWriter.encodeValue(aSN1OctetString, byteStringBuffer);
                Object var7_6 = null;
                if (n <= 2 || (n3 = byteStringBuffer.length() - n2) <= n) break block7;
            }
            catch (Throwable throwable) {
                int n4;
                Object var7_7 = null;
                if (n > 2 && (n4 = byteStringBuffer.length() - n2) > n) {
                    byte[] byArray = new byte[StaticUtils.EOL_BYTES.length + 1];
                    System.arraycopy(StaticUtils.EOL_BYTES, 0, byArray, 0, StaticUtils.EOL_BYTES.length);
                    byArray[StaticUtils.EOL_BYTES.length] = 32;
                    byteStringBuffer.insert(n2 + n, byArray);
                    for (int i = n2 + 2 * n + byArray.length - 1; i < byteStringBuffer.length(); i += n - 1 + byArray.length) {
                        byteStringBuffer.insert(i, byArray);
                    }
                }
                if (bl && commentAboutBase64EncodedValues) {
                    LDIFWriter.writeBase64DecodedValueComment(aSN1OctetString.getValue(), byteStringBuffer, n);
                }
                throw throwable;
            }
            byte[] byArray = new byte[StaticUtils.EOL_BYTES.length + 1];
            System.arraycopy(StaticUtils.EOL_BYTES, 0, byArray, 0, StaticUtils.EOL_BYTES.length);
            byArray[StaticUtils.EOL_BYTES.length] = 32;
            byteStringBuffer.insert(n2 + n, byArray);
            for (int i = n2 + 2 * n + byArray.length - 1; i < byteStringBuffer.length(); i += n - 1 + byArray.length) {
                byteStringBuffer.insert(i, byArray);
            }
        }
        if (bl && commentAboutBase64EncodedValues) {
            LDIFWriter.writeBase64DecodedValueComment(aSN1OctetString.getValue(), byteStringBuffer, n);
        }
    }

    static boolean encodeValue(ASN1OctetString aSN1OctetString, ByteStringBuffer byteStringBuffer) {
        byteStringBuffer.append(':');
        byte[] byArray = aSN1OctetString.getValue();
        int n = byArray.length;
        if (n == 0) {
            byteStringBuffer.append(' ');
            return false;
        }
        switch (byArray[0]) {
            case 32: 
            case 58: 
            case 60: {
                byteStringBuffer.append(':');
                byteStringBuffer.append(' ');
                Base64.encode(byArray, byteStringBuffer);
                return true;
            }
        }
        if (byArray[n - 1] == 32) {
            byteStringBuffer.append(':');
            byteStringBuffer.append(' ');
            Base64.encode(byArray, byteStringBuffer);
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0x7F) != (byArray[i] & 0xFF)) {
                byteStringBuffer.append(':');
                byteStringBuffer.append(' ');
                Base64.encode(byArray, byteStringBuffer);
                return true;
            }
            switch (byArray[i]) {
                case 0: 
                case 10: 
                case 13: {
                    byteStringBuffer.append(':');
                    byteStringBuffer.append(' ');
                    Base64.encode(byArray, byteStringBuffer);
                    return true;
                }
            }
        }
        byteStringBuffer.append(' ');
        byteStringBuffer.append(byArray);
        return false;
    }

    private static void writeBase64DecodedValueComment(byte[] byArray, ByteStringBuffer byteStringBuffer, int n) {
        if (commentAboutBase64EncodedValues) {
            int n2 = n <= 5 ? StaticUtils.TERMINAL_WIDTH_COLUMNS - 3 : n - 2;
            int n3 = n2 - 1;
            boolean bl = true;
            String string = "Non-base64-encoded representation of the above value: " + LDIFWriter.getEscapedValue(byArray);
            for (String string2 : StaticUtils.wrapLine(string, n2, n3)) {
                byteStringBuffer.append(StaticUtils.EOL);
                byteStringBuffer.append("# ");
                if (bl) {
                    bl = false;
                } else {
                    byteStringBuffer.append(' ');
                }
                byteStringBuffer.append(string2);
            }
        }
    }

    private static String getEscapedValue(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        block8: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 10: {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case 32: {
                    if (i == 0) {
                        stringBuilder.append("\\ ");
                        continue block8;
                    }
                    if (i == byArray.length - 1) {
                        stringBuilder.append("\\20");
                        continue block8;
                    }
                    stringBuilder.append(' ');
                    continue block8;
                }
                case 60: {
                    if (i == 0) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append('<');
                    continue block8;
                }
                case 58: {
                    if (i == 0) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(':');
                    continue block8;
                }
                default: {
                    if (by >= 33 && by <= 126) {
                        stringBuilder.append((char)by);
                        continue block8;
                    }
                    stringBuilder.append("\\");
                    StaticUtils.toHex(by, stringBuilder);
                }
            }
        }
        return stringBuilder.toString();
    }

    static void rethrow(Throwable throwable) throws IOException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw StaticUtils.createIOExceptionWithCause(null, throwable);
    }
}

