/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.IOException;
import java.text.ParseException;

public final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] BASE64URL_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();

    private Base64() {
    }

    public static String encode(String string) {
        Validator.ensureNotNull(string);
        return Base64.encode(StaticUtils.getBytes(string));
    }

    public static String encode(byte[] byArray) {
        Validator.ensureNotNull(byArray);
        StringBuilder stringBuilder = new StringBuilder(4 * byArray.length / 3 + 1);
        Base64.encode(BASE64_ALPHABET, byArray, 0, byArray.length, stringBuilder, "=");
        return stringBuilder.toString();
    }

    public static void encode(String string, StringBuilder stringBuilder) {
        Validator.ensureNotNull(string);
        Base64.encode(StaticUtils.getBytes(string), stringBuilder);
    }

    public static void encode(String string, ByteStringBuffer byteStringBuffer) {
        Validator.ensureNotNull(string);
        Base64.encode(StaticUtils.getBytes(string), byteStringBuffer);
    }

    public static void encode(byte[] byArray, StringBuilder stringBuilder) {
        Base64.encode(BASE64_ALPHABET, byArray, 0, byArray.length, stringBuilder, "=");
    }

    public static void encode(byte[] byArray, int n, int n2, StringBuilder stringBuilder) {
        Base64.encode(BASE64_ALPHABET, byArray, n, n2, stringBuilder, "=");
    }

    public static void encode(byte[] byArray, ByteStringBuffer byteStringBuffer) {
        Base64.encode(BASE64_ALPHABET, byArray, 0, byArray.length, byteStringBuffer, "=");
    }

    public static void encode(byte[] byArray, int n, int n2, ByteStringBuffer byteStringBuffer) {
        Base64.encode(BASE64_ALPHABET, byArray, n, n2, byteStringBuffer, "=");
    }

    public static String urlEncode(String string, boolean bl) {
        return Base64.urlEncode(StaticUtils.getBytes(string), bl);
    }

    public static void urlEncode(String string, StringBuilder stringBuilder, boolean bl) {
        byte[] byArray = StaticUtils.getBytes(string);
        Base64.encode(BASE64_ALPHABET, byArray, 0, byArray.length, stringBuilder, bl ? "%3d" : null);
    }

    public static void urlEncode(String string, ByteStringBuffer byteStringBuffer, boolean bl) {
        byte[] byArray = StaticUtils.getBytes(string);
        Base64.encode(BASE64_ALPHABET, byArray, 0, byArray.length, byteStringBuffer, bl ? "%3d" : null);
    }

    public static String urlEncode(byte[] byArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(4 * byArray.length / 3 + 6);
        Base64.encode(BASE64URL_ALPHABET, byArray, 0, byArray.length, stringBuilder, bl ? "%3d" : null);
        return stringBuilder.toString();
    }

    public static void urlEncode(byte[] byArray, int n, int n2, StringBuilder stringBuilder, boolean bl) {
        Base64.encode(BASE64URL_ALPHABET, byArray, n, n2, stringBuilder, bl ? "%3d" : null);
    }

    public static void urlEncode(byte[] byArray, int n, int n2, ByteStringBuffer byteStringBuffer, boolean bl) {
        Base64.encode(BASE64URL_ALPHABET, byArray, n, n2, byteStringBuffer, bl ? "%3d" : null);
    }

    private static void encode(char[] cArray, byte[] byArray, int n, int n2, Appendable appendable, String string) {
        Validator.ensureNotNull(byArray);
        Validator.ensureTrue(byArray.length >= n);
        Validator.ensureTrue(byArray.length >= n + n2);
        if (n2 == 0) {
            return;
        }
        try {
            int n3;
            int n4 = n;
            for (n3 = 0; n3 < n2 / 3; ++n3) {
                int n5 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                appendable.append(cArray[n5 >> 18 & 0x3F]);
                appendable.append(cArray[n5 >> 12 & 0x3F]);
                appendable.append(cArray[n5 >> 6 & 0x3F]);
                appendable.append(cArray[n5 & 0x3F]);
            }
            switch (n + n2 - n4) {
                case 1: {
                    n3 = (byArray[n4] & 0xFF) << 16;
                    appendable.append(cArray[n3 >> 18 & 0x3F]);
                    appendable.append(cArray[n3 >> 12 & 0x3F]);
                    if (string != null) {
                        appendable.append(string);
                        appendable.append(string);
                    }
                    return;
                }
                case 2: {
                    n3 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4] & 0xFF) << 8;
                    appendable.append(cArray[n3 >> 18 & 0x3F]);
                    appendable.append(cArray[n3 >> 12 & 0x3F]);
                    appendable.append(cArray[n3 >> 6 & 0x3F]);
                    if (string != null) {
                        appendable.append(string);
                    }
                    return;
                }
            }
        }
        catch (IOException iOException) {
            Debug.debugException(iOException);
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public static byte[] decode(String string) throws ParseException {
        Validator.ensureNotNull(string);
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        if (n % 4 != 0) {
            throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_INVALID_LENGTH.get(), n);
        }
        int n2 = 3 * (n / 4);
        if (string.charAt(n - 2) == '=') {
            n2 -= 2;
        } else if (string.charAt(n - 1) == '=') {
            --n2;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            int n5 = 0;
            block72: for (int i = 0; i < 4; ++i) {
                n5 <<= 6;
                switch (string.charAt(n3++)) {
                    case 'A': {
                        n5 |= 0;
                        continue block72;
                    }
                    case 'B': {
                        n5 |= 1;
                        continue block72;
                    }
                    case 'C': {
                        n5 |= 2;
                        continue block72;
                    }
                    case 'D': {
                        n5 |= 3;
                        continue block72;
                    }
                    case 'E': {
                        n5 |= 4;
                        continue block72;
                    }
                    case 'F': {
                        n5 |= 5;
                        continue block72;
                    }
                    case 'G': {
                        n5 |= 6;
                        continue block72;
                    }
                    case 'H': {
                        n5 |= 7;
                        continue block72;
                    }
                    case 'I': {
                        n5 |= 8;
                        continue block72;
                    }
                    case 'J': {
                        n5 |= 9;
                        continue block72;
                    }
                    case 'K': {
                        n5 |= 0xA;
                        continue block72;
                    }
                    case 'L': {
                        n5 |= 0xB;
                        continue block72;
                    }
                    case 'M': {
                        n5 |= 0xC;
                        continue block72;
                    }
                    case 'N': {
                        n5 |= 0xD;
                        continue block72;
                    }
                    case 'O': {
                        n5 |= 0xE;
                        continue block72;
                    }
                    case 'P': {
                        n5 |= 0xF;
                        continue block72;
                    }
                    case 'Q': {
                        n5 |= 0x10;
                        continue block72;
                    }
                    case 'R': {
                        n5 |= 0x11;
                        continue block72;
                    }
                    case 'S': {
                        n5 |= 0x12;
                        continue block72;
                    }
                    case 'T': {
                        n5 |= 0x13;
                        continue block72;
                    }
                    case 'U': {
                        n5 |= 0x14;
                        continue block72;
                    }
                    case 'V': {
                        n5 |= 0x15;
                        continue block72;
                    }
                    case 'W': {
                        n5 |= 0x16;
                        continue block72;
                    }
                    case 'X': {
                        n5 |= 0x17;
                        continue block72;
                    }
                    case 'Y': {
                        n5 |= 0x18;
                        continue block72;
                    }
                    case 'Z': {
                        n5 |= 0x19;
                        continue block72;
                    }
                    case 'a': {
                        n5 |= 0x1A;
                        continue block72;
                    }
                    case 'b': {
                        n5 |= 0x1B;
                        continue block72;
                    }
                    case 'c': {
                        n5 |= 0x1C;
                        continue block72;
                    }
                    case 'd': {
                        n5 |= 0x1D;
                        continue block72;
                    }
                    case 'e': {
                        n5 |= 0x1E;
                        continue block72;
                    }
                    case 'f': {
                        n5 |= 0x1F;
                        continue block72;
                    }
                    case 'g': {
                        n5 |= 0x20;
                        continue block72;
                    }
                    case 'h': {
                        n5 |= 0x21;
                        continue block72;
                    }
                    case 'i': {
                        n5 |= 0x22;
                        continue block72;
                    }
                    case 'j': {
                        n5 |= 0x23;
                        continue block72;
                    }
                    case 'k': {
                        n5 |= 0x24;
                        continue block72;
                    }
                    case 'l': {
                        n5 |= 0x25;
                        continue block72;
                    }
                    case 'm': {
                        n5 |= 0x26;
                        continue block72;
                    }
                    case 'n': {
                        n5 |= 0x27;
                        continue block72;
                    }
                    case 'o': {
                        n5 |= 0x28;
                        continue block72;
                    }
                    case 'p': {
                        n5 |= 0x29;
                        continue block72;
                    }
                    case 'q': {
                        n5 |= 0x2A;
                        continue block72;
                    }
                    case 'r': {
                        n5 |= 0x2B;
                        continue block72;
                    }
                    case 's': {
                        n5 |= 0x2C;
                        continue block72;
                    }
                    case 't': {
                        n5 |= 0x2D;
                        continue block72;
                    }
                    case 'u': {
                        n5 |= 0x2E;
                        continue block72;
                    }
                    case 'v': {
                        n5 |= 0x2F;
                        continue block72;
                    }
                    case 'w': {
                        n5 |= 0x30;
                        continue block72;
                    }
                    case 'x': {
                        n5 |= 0x31;
                        continue block72;
                    }
                    case 'y': {
                        n5 |= 0x32;
                        continue block72;
                    }
                    case 'z': {
                        n5 |= 0x33;
                        continue block72;
                    }
                    case '0': {
                        n5 |= 0x34;
                        continue block72;
                    }
                    case '1': {
                        n5 |= 0x35;
                        continue block72;
                    }
                    case '2': {
                        n5 |= 0x36;
                        continue block72;
                    }
                    case '3': {
                        n5 |= 0x37;
                        continue block72;
                    }
                    case '4': {
                        n5 |= 0x38;
                        continue block72;
                    }
                    case '5': {
                        n5 |= 0x39;
                        continue block72;
                    }
                    case '6': {
                        n5 |= 0x3A;
                        continue block72;
                    }
                    case '7': {
                        n5 |= 0x3B;
                        continue block72;
                    }
                    case '8': {
                        n5 |= 0x3C;
                        continue block72;
                    }
                    case '9': {
                        n5 |= 0x3D;
                        continue block72;
                    }
                    case '+': {
                        n5 |= 0x3E;
                        continue block72;
                    }
                    case '/': {
                        n5 |= 0x3F;
                        continue block72;
                    }
                    case '=': {
                        switch (n - n3) {
                            case 0: {
                                byArray[n4++] = (byte)((n5 >>= 8) >> 8 & 0xFF);
                                byArray[n4] = (byte)(n5 & 0xFF);
                                return byArray;
                            }
                            case 1: {
                                byArray[n4] = (byte)((n5 >>= 10) & 0xFF);
                                return byArray;
                            }
                        }
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_EQUAL.get(n3 - 1), n3 - 1);
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_CHAR.get(Character.valueOf(string.charAt(n3 - 1))), n3 - 1);
                    }
                }
            }
            byArray[n4++] = (byte)(n5 >> 16 & 0xFF);
            byArray[n4++] = (byte)(n5 >> 8 & 0xFF);
            byArray[n4++] = (byte)(n5 & 0xFF);
        }
        return byArray;
    }

    public static String decodeToString(String string) throws ParseException {
        Validator.ensureNotNull(string);
        byte[] byArray = Base64.decode(string);
        return StaticUtils.toUTF8String(byArray);
    }

    public static byte[] urlDecode(String string) throws ParseException {
        Validator.ensureNotNull(string);
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        int n2 = 0;
        ByteStringBuffer byteStringBuffer = new ByteStringBuffer(n);
        block71: while (n2 < n) {
            int n3 = 0;
            block72: for (int i = 0; i < 4; ++i) {
                int n4;
                if (n2 >= n) {
                    n4 = 61;
                    ++n2;
                } else {
                    n4 = string.charAt(n2++);
                }
                n3 <<= 6;
                switch (n4) {
                    case 65: {
                        n3 |= 0;
                        continue block72;
                    }
                    case 66: {
                        n3 |= 1;
                        continue block72;
                    }
                    case 67: {
                        n3 |= 2;
                        continue block72;
                    }
                    case 68: {
                        n3 |= 3;
                        continue block72;
                    }
                    case 69: {
                        n3 |= 4;
                        continue block72;
                    }
                    case 70: {
                        n3 |= 5;
                        continue block72;
                    }
                    case 71: {
                        n3 |= 6;
                        continue block72;
                    }
                    case 72: {
                        n3 |= 7;
                        continue block72;
                    }
                    case 73: {
                        n3 |= 8;
                        continue block72;
                    }
                    case 74: {
                        n3 |= 9;
                        continue block72;
                    }
                    case 75: {
                        n3 |= 0xA;
                        continue block72;
                    }
                    case 76: {
                        n3 |= 0xB;
                        continue block72;
                    }
                    case 77: {
                        n3 |= 0xC;
                        continue block72;
                    }
                    case 78: {
                        n3 |= 0xD;
                        continue block72;
                    }
                    case 79: {
                        n3 |= 0xE;
                        continue block72;
                    }
                    case 80: {
                        n3 |= 0xF;
                        continue block72;
                    }
                    case 81: {
                        n3 |= 0x10;
                        continue block72;
                    }
                    case 82: {
                        n3 |= 0x11;
                        continue block72;
                    }
                    case 83: {
                        n3 |= 0x12;
                        continue block72;
                    }
                    case 84: {
                        n3 |= 0x13;
                        continue block72;
                    }
                    case 85: {
                        n3 |= 0x14;
                        continue block72;
                    }
                    case 86: {
                        n3 |= 0x15;
                        continue block72;
                    }
                    case 87: {
                        n3 |= 0x16;
                        continue block72;
                    }
                    case 88: {
                        n3 |= 0x17;
                        continue block72;
                    }
                    case 89: {
                        n3 |= 0x18;
                        continue block72;
                    }
                    case 90: {
                        n3 |= 0x19;
                        continue block72;
                    }
                    case 97: {
                        n3 |= 0x1A;
                        continue block72;
                    }
                    case 98: {
                        n3 |= 0x1B;
                        continue block72;
                    }
                    case 99: {
                        n3 |= 0x1C;
                        continue block72;
                    }
                    case 100: {
                        n3 |= 0x1D;
                        continue block72;
                    }
                    case 101: {
                        n3 |= 0x1E;
                        continue block72;
                    }
                    case 102: {
                        n3 |= 0x1F;
                        continue block72;
                    }
                    case 103: {
                        n3 |= 0x20;
                        continue block72;
                    }
                    case 104: {
                        n3 |= 0x21;
                        continue block72;
                    }
                    case 105: {
                        n3 |= 0x22;
                        continue block72;
                    }
                    case 106: {
                        n3 |= 0x23;
                        continue block72;
                    }
                    case 107: {
                        n3 |= 0x24;
                        continue block72;
                    }
                    case 108: {
                        n3 |= 0x25;
                        continue block72;
                    }
                    case 109: {
                        n3 |= 0x26;
                        continue block72;
                    }
                    case 110: {
                        n3 |= 0x27;
                        continue block72;
                    }
                    case 111: {
                        n3 |= 0x28;
                        continue block72;
                    }
                    case 112: {
                        n3 |= 0x29;
                        continue block72;
                    }
                    case 113: {
                        n3 |= 0x2A;
                        continue block72;
                    }
                    case 114: {
                        n3 |= 0x2B;
                        continue block72;
                    }
                    case 115: {
                        n3 |= 0x2C;
                        continue block72;
                    }
                    case 116: {
                        n3 |= 0x2D;
                        continue block72;
                    }
                    case 117: {
                        n3 |= 0x2E;
                        continue block72;
                    }
                    case 118: {
                        n3 |= 0x2F;
                        continue block72;
                    }
                    case 119: {
                        n3 |= 0x30;
                        continue block72;
                    }
                    case 120: {
                        n3 |= 0x31;
                        continue block72;
                    }
                    case 121: {
                        n3 |= 0x32;
                        continue block72;
                    }
                    case 122: {
                        n3 |= 0x33;
                        continue block72;
                    }
                    case 48: {
                        n3 |= 0x34;
                        continue block72;
                    }
                    case 49: {
                        n3 |= 0x35;
                        continue block72;
                    }
                    case 50: {
                        n3 |= 0x36;
                        continue block72;
                    }
                    case 51: {
                        n3 |= 0x37;
                        continue block72;
                    }
                    case 52: {
                        n3 |= 0x38;
                        continue block72;
                    }
                    case 53: {
                        n3 |= 0x39;
                        continue block72;
                    }
                    case 54: {
                        n3 |= 0x3A;
                        continue block72;
                    }
                    case 55: {
                        n3 |= 0x3B;
                        continue block72;
                    }
                    case 56: {
                        n3 |= 0x3C;
                        continue block72;
                    }
                    case 57: {
                        n3 |= 0x3D;
                        continue block72;
                    }
                    case 45: {
                        n3 |= 0x3E;
                        continue block72;
                    }
                    case 95: {
                        n3 |= 0x3F;
                        continue block72;
                    }
                    case 37: 
                    case 61: {
                        switch ((n2 - 1) % 4) {
                            case 2: {
                                byteStringBuffer.append((byte)((n3 >>= 10) & 0xFF));
                                break block71;
                            }
                            case 3: {
                                byteStringBuffer.append((byte)((n3 >>= 8) >> 8 & 0xFF));
                                byteStringBuffer.append((byte)(n3 & 0xFF));
                                break block71;
                            }
                            default: {
                                throw new ParseException(UtilityMessages.ERR_BASE64_URLDECODE_INVALID_LENGTH.get(), n2 - 1);
                            }
                        }
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_CHAR.get(Character.valueOf(string.charAt(n2 - 1))), n2 - 1);
                    }
                }
            }
            byteStringBuffer.append((byte)(n3 >> 16 & 0xFF));
            byteStringBuffer.append((byte)(n3 >> 8 & 0xFF));
            byteStringBuffer.append((byte)(n3 & 0xFF));
        }
        return byteStringBuffer.toByteArray();
    }

    public static String urlDecodeToString(String string) throws ParseException {
        Validator.ensureNotNull(string);
        byte[] byArray = Base64.urlDecode(string);
        return StaticUtils.toUTF8String(byArray);
    }
}

