/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum UtilityMessages {
    ERR_AGGREGATE_INPUT_STREAM_MARK_NOT_SUPPORTED("The aggregate input stream does not support the use of mark and reset functionality."),
    ERR_ARG_STRING_DANGLING_BACKSLASH("The provided string cannot be parsed as an argument list because it ends with a backslash that was not immediately preceded by another backslash.  The backslash character will be considered an escape to indicate that the next character should be included as-is with no interpretation."),
    ERR_ARG_STRING_UNMATCHED_QUOTE("The provided string cannot be parsed as an argument list because it has an unmatched quote starting at or near position {0}."),
    ERR_BASE64_DECODE_INVALID_LENGTH("A base64-encoded string must have a length that is a multiple of 4 bytes."),
    ERR_BASE64_DECODE_UNEXPECTED_CHAR("Invalid character ''{0}'' encountered."),
    ERR_BASE64_DECODE_UNEXPECTED_EQUAL("Unexpected equal sign found at position {0,number,0}."),
    ERR_BASE64_URLDECODE_INVALID_LENGTH("The provided string did not have a valid length for base64url-encoded data."),
    ERR_BS_BUFFER_ARRAY_NULL("The provided array is null."),
    ERR_BS_BUFFER_BUFFER_NULL("The provided buffer is null."),
    ERR_BS_BUFFER_BYTE_STRING_NULL("The provided byte string is null."),
    ERR_BS_BUFFER_CAPACITY_NEGATIVE("The provided capacity {0,number,0} is negative."),
    ERR_BS_BUFFER_CHAR_SEQUENCE_NULL("The provided character sequence is null."),
    ERR_BS_BUFFER_LENGTH_NEGATIVE("The provided length {0,number,0} is negative."),
    ERR_BS_BUFFER_OFFSET_NEGATIVE("The provided offset {0,number,0} is negative."),
    ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE("The provided offset {0,number,0} plus the provided length {1,number,0} is greater than the size of the provided array ({2,number,0})."),
    ERR_BS_BUFFER_POS_NEGATIVE("The provided position {0,number,0} is negative."),
    ERR_BS_BUFFER_POS_TOO_LARGE("The provided position {0,number,0} is greater than the length of the buffer ({1,number,0})."),
    ERR_DECODE_UUID_INVALID_LENGTH("Unable to decode bytes ''{0}'' as a valid UUID because the length of the provided content was not exactly 128 bits."),
    ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH("Unable to parse the provided timestamp ''{0}'' because it had an invalid number of characters before the sub-second and/or time zone portion."),
    ERR_GENTIME_DECODE_CANNOT_PARSE_TZ("Unable to parse time zone information from the provided timestamp ''{0}''."),
    ERR_NO_EXCEPTION("No Exception"),
    ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE("{0}.  Thread stack trace:  {1}"),
    ERR_VALIDATOR_FALSE_CHECK_FAILURE("A result of true was found for a condition which the LDAP SDK requires to be false.  Thread stack trace {0}"),
    ERR_VALIDATOR_NULL_CHECK_FAILURE("A null object was provided where a non-null object is required (non-null index {0,number,0}).  Thread stack trace:  {1}"),
    ERR_VALIDATOR_TRUE_CHECK_FAILURE("A result of false was found for a condition which the LDAP SDK requires to be true.  Thread stack trace {0}"),
    INFO_NUM_DAYS_PLURAL("{0,number,0} days"),
    INFO_NUM_DAYS_SINGULAR("{0,number,0} day"),
    INFO_NUM_HOURS_PLURAL("{0,number,0} hours"),
    INFO_NUM_HOURS_SINGULAR("{0,number,0} hour"),
    INFO_NUM_MINUTES_PLURAL("{0,number,0} minutes"),
    INFO_NUM_MINUTES_SINGULAR("{0,number,0} minute"),
    INFO_NUM_SECONDS_PLURAL("{0,number,0} seconds"),
    INFO_NUM_SECONDS_SINGULAR("{0,number,0} second"),
    INFO_NUM_SECONDS_WITH_DECIMAL("{0} seconds");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<UtilityMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<UtilityMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private UtilityMessages(String string2) {
        this.defaultText = string2;
    }

    public String get() {
        String string = MESSAGE_STRINGS.get((Object)this);
        if (string == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                string = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception exception) {
                string = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... objectArray) {
        MessageFormat messageFormat = MESSAGES.get((Object)this);
        if (messageFormat == null) {
            if (RESOURCE_BUNDLE == null) {
                messageFormat = new MessageFormat(this.defaultText);
            } else {
                try {
                    messageFormat = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception exception) {
                    messageFormat = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, messageFormat);
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(objectArray);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("unboundid-ldapsdk-util");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = resourceBundle;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

