/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeakHashSet<T>
implements Set<T> {
    private final WeakHashMap<T, WeakReference<T>> m;

    public WeakHashSet() {
        this.m = new WeakHashMap(16);
    }

    public WeakHashSet(int n) {
        this.m = new WeakHashMap(n);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.m.keySet().containsAll(collection);
    }

    public T get(T t) {
        WeakReference<T> weakReference = this.m.get(t);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    @Override
    public boolean add(T t) {
        if (this.m.containsKey(t)) {
            return false;
        }
        this.m.put(t, new WeakReference<T>(t));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (T t : collection) {
            if (this.m.containsKey(t)) continue;
            this.m.put(t, new WeakReference<T>(t));
            bl = true;
        }
        return bl;
    }

    public T addAndGet(T t) {
        Object t2;
        WeakReference<T> weakReference = this.m.get(t);
        if (weakReference != null && (t2 = weakReference.get()) != null) {
            return t2;
        }
        this.m.put(t, new WeakReference<T>(t));
        return t;
    }

    @Override
    public boolean remove(Object object) {
        return this.m.remove(object) != null;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            WeakReference<T> weakReference = this.m.remove(obj);
            if (weakReference == null) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<Map.Entry<T, WeakReference<T>>> iterator = this.m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, WeakReference<T>> entry = iterator.next();
            if (collection.contains(entry.getKey())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        return this.m.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m.keySet().toArray();
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        return this.m.keySet().toArray(EArray);
    }

    @Override
    public int hashCode() {
        return ((Object)this.m.keySet()).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Set && ((Object)this.m.keySet()).equals(object);
    }

    public String toString() {
        return this.m.keySet().toString();
    }
}

