/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.parallel;

import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class ParallelProcessor<I, O> {
    private final Processor<I, O> processor;
    private final List<Thread> workers;
    private final int minPerThread;
    private final Semaphore workerSemaphore = new Semaphore(0);
    private final AtomicReference<List<? extends I>> inputItems = new AtomicReference();
    private final AtomicReference<List<Result<I, O>>> outputItems = new AtomicReference();
    private final AtomicInteger nextToProcess = new AtomicInteger();
    private volatile CountDownLatch processingCompleteSignal;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public ParallelProcessor(Processor<I, O> processor, int n, int n2) {
        this(processor, null, n, n2);
    }

    public ParallelProcessor(Processor<I, O> processor, ThreadFactory threadFactory, int n, int n2) {
        Validator.ensureNotNull(processor);
        Validator.ensureTrue(n >= 1, "ParallelProcessor.totalThreads must be at least 1.");
        Validator.ensureTrue(n <= 1000, "ParallelProcessor.totalThreads must not be greater than 1000.");
        Validator.ensureTrue(n2 >= 1, "ParallelProcessor.minPerThread must be at least 1.");
        this.processor = processor;
        this.minPerThread = n2;
        ThreadFactory threadFactory2 = threadFactory == null ? new LDAPSDKThreadFactory("ParallelProcessor-Worker", true) : threadFactory;
        int n3 = n - 1;
        ArrayList<Thread> arrayList = new ArrayList<Thread>(n3);
        for (int i = 0; i < n3; ++i) {
            Thread thread = threadFactory2.newThread(new Worker());
            arrayList.add(thread);
            thread.start();
        }
        this.workers = arrayList;
    }

    public synchronized ArrayList<Result<I, O>> processAll(List<? extends I> list) throws InterruptedException, IllegalStateException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("cannot call processAll() after shutdown()");
        }
        Validator.ensureNotNull(list);
        int n = Math.min(list.size() / this.minPerThread - 1, this.workers.size());
        if (n <= 0) {
            ArrayList<Result<I, O>> arrayList = new ArrayList<Result<I, O>>(list.size());
            for (I i : list) {
                arrayList.add(this.process(i));
            }
            return arrayList;
        }
        this.processingCompleteSignal = new CountDownLatch(n);
        this.inputItems.set(list);
        ArrayList<Result<I, O>> arrayList = new ArrayList<Result<I, O>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(null);
        }
        this.outputItems.set(arrayList);
        this.nextToProcess.set(0);
        this.workerSemaphore.release(n);
        this.processInParallel();
        this.processingCompleteSignal.await();
        return arrayList;
    }

    public synchronized void shutdown() throws InterruptedException {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.workerSemaphore.release(this.workers.size());
        for (Thread thread : this.workers) {
            thread.join();
        }
    }

    private void processInParallel() {
        try {
            int n;
            List<I> list = this.inputItems.get();
            List<Result<I, O>> list2 = this.outputItems.get();
            int n2 = list.size();
            while ((n = this.nextToProcess.getAndIncrement()) < n2) {
                I i = list.get(n);
                list2.set(n, this.process(i));
            }
        }
        catch (Throwable throwable) {
            Debug.debugException(throwable);
        }
    }

    private ProcessResult process(I i) {
        Object var2_2 = null;
        Throwable throwable = null;
        try {
            var2_2 = this.processor.process(i);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        return new ProcessResult(i, var2_2, throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProcessResult
    implements Result<I, O> {
        private final I inputItem;
        private final O outputItem;
        private final Throwable failureCause;

        private ProcessResult(I i, O o, Throwable throwable) {
            this.inputItem = i;
            this.outputItem = o;
            this.failureCause = throwable;
        }

        @Override
        public I getInput() {
            return this.inputItem;
        }

        @Override
        public O getOutput() {
            return this.outputItem;
        }

        @Override
        public Throwable getFailureCause() {
            return this.failureCause;
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    ParallelProcessor.this.workerSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    Debug.debugException(interruptedException);
                    Thread.currentThread().interrupt();
                }
                if (ParallelProcessor.this.shutdown.get()) {
                    return;
                }
                try {
                    ParallelProcessor.this.processInParallel();
                    continue;
                }
                finally {
                    ParallelProcessor.this.processingCompleteSignal.countDown();
                    continue;
                }
                break;
            }
        }
    }
}

