/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public final class PKCS11KeyManager
extends WrapperKeyManager {
    private static final String PKCS11_KEY_STORE_TYPE = "PKCS11";

    public PKCS11KeyManager(char[] cArray, String string) throws KeyStoreException {
        super(PKCS11KeyManager.getKeyManagers(cArray), string);
    }

    private static KeyManager[] getKeyManagers(char[] cArray) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(PKCS11_KEY_STORE_TYPE);
        try {
            keyStore.load(null, cArray);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_ACCESS.get(String.valueOf(exception)), exception);
        }
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_GET_KEY_MANAGERS.get(String.valueOf(exception)), exception);
        }
    }
}

