/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
final class SetEnabledProtocolsSSLServerSocketFactory
extends SSLServerSocketFactory {
    private final Set<String> protocols;
    private final SSLServerSocketFactory delegateFactory;

    SetEnabledProtocolsSSLServerSocketFactory(SSLServerSocketFactory sSLServerSocketFactory, String string) {
        this.delegateFactory = sSLServerSocketFactory;
        this.protocols = string.equalsIgnoreCase("TLSv1.2") ? new HashSet<String>(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1")) : (string.equalsIgnoreCase("TLSv1.1") ? new HashSet<String>(Arrays.asList("TLSv1.1", "TLSv1")) : (string.equalsIgnoreCase("TLSv1") ? new HashSet<String>(Collections.singletonList("TLSv1")) : Collections.emptySet()));
    }

    SetEnabledProtocolsSSLServerSocketFactory(SSLServerSocketFactory sSLServerSocketFactory, Set<String> set) {
        this.delegateFactory = sSLServerSocketFactory;
        this.protocols = set;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket();
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(n);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(n, n2);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(n, n2, inetAddress);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegateFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegateFactory.getSupportedCipherSuites();
    }
}

