/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.SetEnabledProtocolsSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
final class SetEnabledProtocolsSSLSocketFactory
extends SSLSocketFactory {
    private final Set<String> protocols;
    private final SSLSocketFactory delegateFactory;

    SetEnabledProtocolsSSLSocketFactory(SSLSocketFactory sSLSocketFactory, String string) {
        this.delegateFactory = sSLSocketFactory;
        this.protocols = string.equalsIgnoreCase("TLSv1.2") ? new HashSet<String>(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1")) : (string.equalsIgnoreCase("TLSv1.1") ? new HashSet<String>(Arrays.asList("TLSv1.1", "TLSv1")) : (string.equalsIgnoreCase("TLSv1") ? new HashSet<String>(Collections.singletonList("TLSv1")) : Collections.emptySet()));
    }

    SetEnabledProtocolsSSLSocketFactory(SSLSocketFactory sSLSocketFactory, Set<String> set) {
        this.delegateFactory = sSLSocketFactory;
        this.protocols = set;
    }

    @Override
    public Socket createSocket() throws IOException {
        return new SetEnabledProtocolsSocket(this.delegateFactory.createSocket(), this.protocols);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        Socket socket = this.delegateFactory.createSocket(string, n);
        SSLUtil.applyEnabledSSLProtocols(socket, this.protocols);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        Socket socket = this.delegateFactory.createSocket(string, n, inetAddress, n2);
        SSLUtil.applyEnabledSSLProtocols(socket, this.protocols);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.delegateFactory.createSocket(inetAddress, n);
        SSLUtil.applyEnabledSSLProtocols(socket, this.protocols);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.delegateFactory.createSocket(inetAddress, n, inetAddress2, n2);
        SSLUtil.applyEnabledSSLProtocols(socket, this.protocols);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        Socket socket2 = this.delegateFactory.createSocket(socket, string, n, bl);
        SSLUtil.applyEnabledSSLProtocols(socket2, this.protocols);
        return socket2;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegateFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegateFactory.getSupportedCipherSuites();
    }
}

